# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_executor_by_id.sql
import dataclasses
import datetime
from typing import Any, List, Optional
import uuid

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_EXECUTOR_BY_ID = """-- name: get_executor_by_id \\:one
SELECT 
    e.id,
    e.name,
    e.worker_name,
    e.queue_pattern,
    e.queues,
    e.started,
    e.stopped,
    e.last_heartbeat,
    e.stats,
    CASE
        WHEN e.stopped IS NOT NULL THEN 'SHUTDOWN'
        WHEN (EXTRACT(EPOCH FROM (CURRENT_TIMESTAMP - e.last_heartbeat)) * 1000) > (20 * 1000) THEN 'LOST'
        WHEN (EXTRACT(EPOCH FROM (CURRENT_TIMESTAMP - e.last_heartbeat)) * 1000) <= (20 * 1000) THEN 'RUNNING'
        ELSE 'UNKNOWN'
    END AS status
FROM public.hyrex_executor e
WHERE e.id = :p1
"""


@dataclasses.dataclass()
class GetExecutorByIdParams:
    id: uuid.UUID


@dataclasses.dataclass()
class GetExecutorByIdRow:
    id: uuid.UUID
    name: str
    worker_name: str
    queue_pattern: str
    queues: List[str]
    started: Optional[datetime.datetime]
    stopped: Optional[datetime.datetime]
    last_heartbeat: Optional[datetime.datetime]
    stats: Optional[Any]
    status: str


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_executor_by_id(self, arg: GetExecutorByIdParams) -> Optional[GetExecutorByIdRow]:
        row = self._conn.execute(sqlalchemy.text(GET_EXECUTOR_BY_ID), {"p1": arg.id}).first()
        if row is None:
            return None
        return GetExecutorByIdRow(
            id=row[0],
            name=row[1],
            worker_name=row[2],
            queue_pattern=row[3],
            queues=row[4],
            started=row[5],
            stopped=row[6],
            last_heartbeat=row[7],
            stats=row[8],
            status=row[9],
        )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_executor_by_id(self, arg: GetExecutorByIdParams) -> Optional[GetExecutorByIdRow]:
        row = (await self._conn.execute(sqlalchemy.text(GET_EXECUTOR_BY_ID), {"p1": arg.id})).first()
        if row is None:
            return None
        return GetExecutorByIdRow(
            id=row[0],
            name=row[1],
            worker_name=row[2],
            queue_pattern=row[3],
            queues=row[4],
            started=row[5],
            stopped=row[6],
            last_heartbeat=row[7],
            stats=row[8],
            status=row[9],
        )
