# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_workflow_run_by_id.sql
import dataclasses
from typing import Optional
import uuid

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_WORKFLOW_RUN_BY_ID = """-- name: get_workflow_run_by_id \\:one
SELECT 
    id,
    parent_id,
    workflow_name,
    args,
    queue,
    timeout_seconds,
    status,
    scheduled_start,
    queued,
    started,
    finished,
    last_heartbeat,
    idempotency_key
FROM hyrex_workflow_run
WHERE id = :p1
"""


@dataclasses.dataclass()
class GetWorkflowRunByIdParams:
    id: uuid.UUID


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_workflow_run_by_id(self, arg: GetWorkflowRunByIdParams) -> Optional[models.HyrexWorkflowRun]:
        row = self._conn.execute(sqlalchemy.text(GET_WORKFLOW_RUN_BY_ID), {"p1": arg.id}).first()
        if row is None:
            return None
        return models.HyrexWorkflowRun(
            id=row[0],
            parent_id=row[1],
            workflow_name=row[2],
            args=row[3],
            queue=row[4],
            timeout_seconds=row[5],
            status=row[6],
            scheduled_start=row[7],
            queued=row[8],
            started=row[9],
            finished=row[10],
            last_heartbeat=row[11],
            idempotency_key=row[12],
        )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_workflow_run_by_id(self, arg: GetWorkflowRunByIdParams) -> Optional[models.HyrexWorkflowRun]:
        row = (await self._conn.execute(sqlalchemy.text(GET_WORKFLOW_RUN_BY_ID), {"p1": arg.id})).first()
        if row is None:
            return None
        return models.HyrexWorkflowRun(
            id=row[0],
            parent_id=row[1],
            workflow_name=row[2],
            args=row[3],
            queue=row[4],
            timeout_seconds=row[5],
            status=row[6],
            scheduled_start=row[7],
            queued=row[8],
            started=row[9],
            finished=row[10],
            last_heartbeat=row[11],
            idempotency_key=row[12],
        )
