# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: kv_list_keys_paginated.sql
import dataclasses
from typing import AsyncIterator, Iterator

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


LIST_KEYS_PAGINATED = """-- name: list_keys_paginated \\:many
SELECT key, value, created_at 
FROM hyrex_kv 
ORDER BY created_at DESC
LIMIT :p1
OFFSET :p2
"""


@dataclasses.dataclass()
class ListKeysPaginatedParams:
    limit: int
    offset: int


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def list_keys_paginated(self, arg: ListKeysPaginatedParams) -> Iterator[models.HyrexKv]:
        result = self._conn.execute(sqlalchemy.text(LIST_KEYS_PAGINATED), {"p1": arg.limit, "p2": arg.offset})
        for row in result:
            yield models.HyrexKv(
                key=row[0],
                value=row[1],
                created_at=row[2],
            )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def list_keys_paginated(self, arg: ListKeysPaginatedParams) -> AsyncIterator[models.HyrexKv]:
        result = await self._conn.stream(sqlalchemy.text(LIST_KEYS_PAGINATED), {"p1": arg.limit, "p2": arg.offset})
        async for row in result:
            yield models.HyrexKv(
                key=row[0],
                value=row[1],
                created_at=row[2],
            )
