# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: set_executor_to_lost_if_no_heartbeat.sql
import dataclasses

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


SET_EXECUTOR_TO_LOST_IF_NO_HEARTBEAT = """-- name: set_executor_to_lost_if_no_heartbeat \\:exec
WITH lost_executors AS (
    UPDATE hyrex_executor
        SET status = 'LOST'\\:\\:executor_status
        WHERE status = 'RUNNING'\\:\\:executor_status
            AND (
                  last_heartbeat IS NULL
                      OR last_heartbeat < (NOW() - INTERVAL '5 minutes')
                  )
        RETURNING id, last_heartbeat
)
INSERT INTO hyrex_system_logs (
    id,
    timestamp,
    event_name,
    event_body
)
SELECT
    gen_random_uuid(),
    NOW(),
    'EXECUTOR_LOST',
    json_build_object(
            'executor_id', id,
            'last_heartbeat', last_heartbeat,
            'reason', CASE
                          WHEN last_heartbeat IS NULL THEN 'No heartbeat recorded'
                          ELSE 'Heartbeat timeout exceeded 5 minutes'
                END
    )
FROM lost_executors
"""


@dataclasses.dataclass()
class SetExecutorToLostIfNoHeartbeatParams:

    pass

class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def set_executor_to_lost_if_no_heartbeat(self, arg: SetExecutorToLostIfNoHeartbeatParams) -> None:
        self._conn.execute(sqlalchemy.text(SET_EXECUTOR_TO_LOST_IF_NO_HEARTBEAT))


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def set_executor_to_lost_if_no_heartbeat(self, arg: SetExecutorToLostIfNoHeartbeatParams) -> None:
        await self._conn.execute(sqlalchemy.text(SET_EXECUTOR_TO_LOST_IF_NO_HEARTBEAT))
