# mem8 Workspace Configuration

## Project Information
- Workspace: mem8
- Shared memory enabled: Yes
- Templates: use cookiecutter for *-template directories
- Git repository: mem8\n- Current branch: main\n

## Two main Roots
- claude-dot-md-template - these have agents, commands and other claude code artifacts - they are cookiecutter artifacts and tools for this concern
- shared-thoughts-template - these have the new thoughts constructs that are a main focus of implementations for this project see the current implementation for the latest notes on how to extend this.

## Memory Management
- Use `mem8 sync` to synchronize with shared memory
- Use `mem8 status` to check workspace status
- Use `mem8 search` to find content across memory

## Shared Thoughts
Access team thoughts via: @thoughts/shared/



# AI Memory Integration

This project uses mem8 for memory management across repositories.

## Available Repositories
- mem8: C:\Users\vaski\projects\mem8\thoughts
- agent-spy: No thoughts found
- agent-zero: No thoughts found
- agenticinsights.com: No thoughts found
- mem8: C:\Users\vaski\projects\mem8\thoughts
- claude-code-docs: No thoughts found
- codebase-context-site: No thoughts found
- codebase-context-spec: No thoughts found
- continuous-image-gen: No thoughts found
- dotcontext: No thoughts found
- fbotsimple: No thoughts found
- killerapp: No thoughts found
- learn-semver: No thoughts found
- ocr: No thoughts found
- ai-prompts: No thoughts found
- vm-sdk-js: No thoughts found
- vmms: No thoughts found
- orchestr8: No thoughts found
- pipecat: No thoughts found
- pipecat-examples: No thoughts found
- pipecat-flows: No thoughts found
- resume-generator: No thoughts found
- UI-TARS-desktop: No thoughts found
- vaskin-context: No thoughts found
- voice-ui-kit: No thoughts found
- voicefuse-mvp: No thoughts found

## Memory Commands
- `/setup-memory` - Configure AI memory for this project
- `/browse-memories` - Search and explore thoughts across repositories
- `mem8 search "query"` - Full-text search across all memories
- `mem8 quick-start --web` - Launch visual memory browser
- `mem8 dashboard` - Open web interface

## Shared Thoughts Location
Shared thoughts: `C:\Users\vaski\mem8-shared`

## Workflow Integration  
- Research documents: `thoughts/shared/research/`
- Implementation plans: `thoughts/shared/plans/` 
- PR discussions: `thoughts/shared/prs/`
- User notes: `thoughts/killerapp/`

## Quick Start
Run `mem8 quick-start --web` to set up mem8 and launch the visual interface.
