from juriscraper.OpinionSiteLinear import OpinionSiteLinear
from juriscraper.lib.string_utils import convert_date_string


class Site(OpinionSiteLinear):
    def __init__(self, *args, **kwargs):
        super(Site, self).__init__(*args, **kwargs)
        self.court_id = self.__module__
        self.url = 'http://nvcourts.gov/Supreme/Decisions/Unpublished_Orders/'
        self.status = 'Published'

    def _process_html(self):
        table_row_path = '//table[@id="ctl00_ContentPlaceHolderContent_UnpublishedOrders_GridView1"]//tr[position()>1]'
        for row in self.html.xpath(table_row_path):
            url = row.xpath('.//td[3]//a/@href')

            # skip rows with malformed html
            if not url:
                continue

            date_string = row.xpath('.//td[3]')

            self.cases.append({
                'date': convert_date_string(date_string[0].text_content()),
                'docket': row.xpath('.//td[1]')[0].text_content(),
                'name': row.xpath('.//td[2]')[0].text_content().title(),
                'url': url[0],
            })
