#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# MIT License
#
# Copyright (c) 2020 Louis Richard
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so.

"""__init__.py
@author: Louis Richard"""

# @Louis Richard
from .ts_time import ts_time
from .ts_scalar import ts_scalar
from .ts_vec_xyz import ts_vec_xyz
from .ts_tensor_xyz import ts_tensor_xyz
from .ts_skymap import ts_skymap
from .ts_append import ts_append
from .dist_append import dist_append
from .start import start
from .end import end
from .iso2unix import iso2unix
from .extend_tint import extend_tint
from .dot import dot
from .cross import cross
from .trace import trace
from .norm import norm
from .normalize import normalize
from .calc_dt import calc_dt
from .calc_fs import calc_fs
from .avg_4sc import avg_4sc
from .gradient import gradient
from .integrate import integrate
from .time_clip import time_clip
from .resample import resample
from .t_eval import t_eval
from .filt import filt
from .medfilt import medfilt
from .movmean import movmean
from .wavelet import wavelet
from .mva import mva
from .vht import vht
from .new_xyz import new_xyz
from .dec_par_perp import dec_par_perp
from .convert_fac import convert_fac
from .edb import edb
from .e_vxb import e_vxb
from .plasma_calc import plasma_calc
from .dynamic_press import dynamic_press
from .pres_anis import pres_anis
from .calc_sqrtq import calc_sqrtq
from .median_bins import median_bins
from .mean_bins import mean_bins
from .histogram import histogram
from .histogram2d import histogram2d
from .wavepolarize_means import wavepolarize_means
from .psd import *
from .c_4_k import c_4_k
from .c_4_grad import c_4_grad
from .c_4_j import c_4_j
from .c_4_v import c_4_v
from .ebsp import ebsp
from .date_str import date_str
from .find_closest import find_closest
from .cart2sph_ts import cart2sph_ts
from .corr_deriv import corr_deriv
from .eb_nrf import eb_nrf
from .lowpass import lowpass
from .mean import mean
from .poynting_flux import poynting_flux
from .remove_repeated_points import remove_repeated_points
from .solid_angle import solid_angle
from .wave_fft import wave_fft
from .pvi import pvi
from .pvi_4sc import pvi_4sc
from .pid_4sc import pid_4sc
from .calc_dng import calc_dng
from .calc_ag import calc_ag
from .calc_agyro import calc_agyro
from .datetime_to_tt2000 import datetime_to_tt2000
from .cotrans import cotrans
from .sph2cart import sph2cart
from .gse2gsm import gse2gsm
from .mf import mf
from .waverage import waverage
from .l_shell import l_shell
from .optimize_nbins_1d import optimize_nbins_1d
from .optimize_nbins_2d import optimize_nbins_2d
from .magnetosphere import magnetosphere
from .iso86012timevec import iso86012timevec
from .timevec2iso8601 import timevec2iso8601
from .iso86012datetime64 import iso86012datetime64
from .datetime642iso8601 import datetime642iso8601
from .unix2datetime64 import unix2datetime64
from .datetime642unix import datetime642unix
from .ttns2datetime64 import ttns2datetime64
from .datetime642ttns import datetime642ttns
from .iso86012datetime import iso86012datetime
from .cart2sph import cart2sph
from .iplasma_calc import iplasma_calc
from .match_phibe_dir import match_phibe_dir
from .match_phibe_v import match_phibe_v
from .get_omni_data import get_omni_data
