# Generated by Django 4.2.25 on 2025-10-28 13:14

# Django
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("aapayout", "0002_fleetparticipant_excluded_from_payout_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="ESIFleetImport",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "esi_fleet_id",
                    models.BigIntegerField(help_text="ESI Fleet ID from EVE client"),
                ),
                (
                    "imported_at",
                    models.DateTimeField(auto_now_add=True, help_text="When the import was performed"),
                ),
                (
                    "characters_found",
                    models.IntegerField(default=0, help_text="Total characters in ESI fleet"),
                ),
                (
                    "characters_added",
                    models.IntegerField(default=0, help_text="New participants added"),
                ),
                (
                    "characters_skipped",
                    models.IntegerField(default=0, help_text="Already in fleet, skipped"),
                ),
                (
                    "unique_players",
                    models.IntegerField(default=0, help_text="Unique players after deduplication"),
                ),
                (
                    "raw_data",
                    models.JSONField(
                        blank=True,
                        help_text="Raw ESI fleet data for debugging",
                        null=True,
                    ),
                ),
                (
                    "fleet",
                    models.ForeignKey(
                        help_text="Fleet this import belongs to",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="esi_imports",
                        to="aapayout.fleet",
                    ),
                ),
                (
                    "imported_by",
                    models.ForeignKey(
                        blank=True,
                        help_text="User who initiated the import",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-imported_at"],
                "indexes": [
                    models.Index(
                        fields=["fleet", "-imported_at"],
                        name="aapayout_es_fleet_i_4924ef_idx",
                    ),
                    models.Index(fields=["esi_fleet_id"], name="aapayout_es_esi_fle_36af59_idx"),
                ],
            },
        ),
    ]
