# MLExplainer

<p align="left">
    <img alt="PyPI" src="https://img.shields.io/pypi/v/mlexplainer">
    <img alt="PyPI - Python Version" src="https://img.shields.io/pypi/pyversions/mlexplainer">
    <img alt="License" src="https://img.shields.io/github/license/zachariebuisson1/mlexplainer">
</p>

Advanced Machine Learning package dedicated to model interpretability, with a primary focus on leveraging Shapley values for explaining complex predictive models.

# ReadTheDocs

Check out the package documentation on [ReadTheDocs](https://mlexplainer.readthedocs.io/en/latest/index.html)!

# Demo

Check out the demo on [Streamlit](https://mlexplainer.streamlit.app/)

# Install

**MLExplainer** can be installed from [PyPI](https://pypi.org/project/mlexplainer/):

<pre>
pip install mlexplainer
</pre>

# Why MLExplainer ?

**MlExplainer** is a tool designed to tackle a major challenge in advanced Machine Learning for tabular data.

Indeed, advanced Machine Learning models - such as Boosting algorithms - are often perceived as black boxes. 
Today, our goal is to provide a way to demystify these models by leveraging mathematical concepts, making it possible to clearly explain how they work to any audience.

Key Features :

* **SHAP Integration**: Built-in support for SHAP explainers with optimized workflows
* **Multiple Classification Types**: Support for binary and multilabel classification tasks
* **Automatic Feature Detection**: Intelligent categorization of numerical, categorical, and string features
* **Rich Visualizations**: Integrated plotting for feature-target relationships and SHAP value distributions
* **Validation Tools**: Built-in interpretation consistency validation
* **Modern Architecture**: Clean, extensible design with proper abstractions

# About

If you encounter any issues with the code or have suggestions for improvement, feel free to open an issue or contact me.