# -*- coding: utf-8 -*-

"""
    mundiapi.controllers.subscriptions_controller

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from .base_controller import BaseController
from ..api_helper import APIHelper
from ..configuration import Configuration
from ..http.auth.basic_auth import BasicAuth
from ..models.get_subscription_response import GetSubscriptionResponse
from ..models.get_subscription_item_response import GetSubscriptionItemResponse
from ..models.get_usage_response import GetUsageResponse
from ..models.get_discount_response import GetDiscountResponse
from ..models.list_subscriptions_response import ListSubscriptionsResponse
from ..models.list_usages_response import ListUsagesResponse

class SubscriptionsController(BaseController):

    """A Controller to access Endpoints in the mundiapi API."""


    def update_subscription_billing_date(self,
                                         subscription_id,
                                         request):
        """Does a PATCH request to /subscriptions/{subscription_id}/billing-date.

        Updates the billing date from a subscription

        Args:
            subscription_id (string): The subscription id
            request (UpdateSubscriptionBillingDateRequest): Request for
                updating the subscription billing date

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/billing-date'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def update_subscription_card(self,
                                 subscription_id,
                                 request):
        """Does a PATCH request to /subscriptions/{subscription_id}/card.

        Updates the credit card from a subscription

        Args:
            subscription_id (string): Subscription id
            request (UpdateSubscriptionCardRequest): Request for updating a
                card

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/card'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def update_subscription_item(self,
                                 subscription_id,
                                 item_id,
                                 body):
        """Does a PUT request to /subscriptions/{subscription_id}/items/{item_id}.

        Updates a subscription item

        Args:
            subscription_id (string): Subscription Id
            item_id (string): Item id
            body (UpdateSubscriptionItemRequest): Request for updating a
                subscription item

        Returns:
            GetSubscriptionItemResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items/{item_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionItemResponse.from_dictionary)

    def create_usage(self,
                     subscription_id,
                     item_id,
                     body):
        """Does a POST request to /subscriptions/{subscription_id}/items/{item_id}/usages.

        Creates a usage

        Args:
            subscription_id (string): Subscription Id
            item_id (string): Item id
            body (CreateUsageRequest): Request for creating a usage

        Returns:
            GetUsageResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items/{item_id}/usages'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetUsageResponse.from_dictionary)

    def get_subscription(self,
                         subscription_id):
        """Does a GET request to /subscriptions/{subscription_id}.

        Gets a subscription

        Args:
            subscription_id (string): Subscription id

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def update_subscription_payment_method(self,
                                           subscription_id,
                                           request):
        """Does a PATCH request to /subscriptions/{subscription_id}/payment-method.

        Updates the payment method from a subscription

        Args:
            subscription_id (string): Subscription id
            request (UpdateSubscriptionPaymentMethodRequest): Request for
                updating the paymentmethod from a subscription

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/payment-method'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def create_subscription(self,
                            body):
        """Does a POST request to /subscriptions.

        Creates a new subscription

        Args:
            body (CreateSubscriptionRequest): Request for creating a
                subscription

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions'
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def create_subscription_item(self,
                                 subscription_id,
                                 request):
        """Does a POST request to /subscriptions/{subscription_id}/items.

        Creates a new Subscription item

        Args:
            subscription_id (string): Subscription id
            request (CreateSubscriptionItemRequest): Request for creating a
                subscription item

        Returns:
            GetSubscriptionItemResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionItemResponse.from_dictionary)

    def create_discount(self,
                        subscription_id,
                        request):
        """Does a POST request to /subscriptions/{subscription_id}/discounts.

        Creates a discount

        Args:
            subscription_id (string): Subscription id
            request (CreateDiscountRequest): Request for creating a discount

        Returns:
            GetDiscountResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/discounts'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetDiscountResponse.from_dictionary)

    def get_subscription_item(self,
                              subscription_id,
                              item_id):
        """Does a GET request to /subscriptions/{subscription_id}/items/{item_id}.

        Get Subscription Item

        Args:
            subscription_id (string): Subscription Id
            item_id (string): Item id

        Returns:
            GetSubscriptionItemResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items/{item_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionItemResponse.from_dictionary)

    def get_subscription_items(self,
                               subscription_id,
                               status,
                               description):
        """Does a GET request to /subscriptions/{subscription_id}/items.

        Get Subscription Itens

        Args:
            subscription_id (string): Subscription Id
            status (string): Status
            description (string): Description

        Returns:
            ListSubscriptionsResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_parameters = {
            'status': status,
            'description': description
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListSubscriptionsResponse.from_dictionary)

    def update_subscription_affiliation_id(self,
                                           subscription_id,
                                           request):
        """Does a PATCH request to /subscriptions/{subscription_id}/gateway-affiliation-id.

        TODO: type endpoint description here.

        Args:
            subscription_id (string): TODO: type description here. Example: 
            request (UpdateSubscriptionAffiliationIdRequest): Request for
                updating a subscription affiliation id

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/gateway-affiliation-id'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def create_an_usage(self,
                        subscription_id,
                        item_id):
        """Does a POST request to /subscriptions/{subscription_id}/items/{item_id}/usages.

        Create Usage

        Args:
            subscription_id (string): Subscription id
            item_id (string): Item id

        Returns:
            GetUsageResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items/{item_id}/usages'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetUsageResponse.from_dictionary)

    def get_subscriptions(self,
                          page=None,
                          size=None,
                          code=None,
                          billing_type=None,
                          customer_id=None,
                          plan_id=None,
                          card_id=None,
                          status=None,
                          next_billing_since=None,
                          next_billing_until=None,
                          created_since=None,
                          created_until=None):
        """Does a GET request to /subscriptions.

        Gets all subscriptions

        Args:
            page (int, optional): Page number
            size (int, optional): Page size
            code (string, optional): Filter for subscription's code
            billing_type (string, optional): Filter for subscription's billing
                type
            customer_id (string, optional): Filter for subscription's customer
                id
            plan_id (string, optional): Filter for subscription's plan id
            card_id (string, optional): Filter for subscription's card id
            status (string, optional): Filter for subscription's status
            next_billing_since (datetime, optional): Filter for subscription's
                next billing date start range
            next_billing_until (datetime, optional): Filter for subscription's
                next billing date end range
            created_since (datetime, optional): Filter for subscription's
                creation date start range
            created_until (datetime, optional): Filter for subscriptions
                creation date end range

        Returns:
            ListSubscriptionsResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions'
        _query_parameters = {
            'page': page,
            'size': size,
            'code': code,
            'billing_type': billing_type,
            'customer_id': customer_id,
            'plan_id': plan_id,
            'card_id': card_id,
            'status': status,
            'next_billing_since': APIHelper.RFC3339DateTime(next_billing_since),
            'next_billing_until': APIHelper.RFC3339DateTime(next_billing_until),
            'created_since': APIHelper.RFC3339DateTime(created_since),
            'created_until': APIHelper.RFC3339DateTime(created_until)
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListSubscriptionsResponse.from_dictionary)

    def update_subscription_metadata(self,
                                     subscription_id,
                                     request):
        """Does a PATCH request to /Subscriptions/{subscription_id}/metadata.

        Updates the metadata from a subscription

        Args:
            subscription_id (string): The subscription id
            request (UpdateMetadataRequest): Request for updating the
                subscrption metadata

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/Subscriptions/{subscription_id}/metadata'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def delete_subscription_item(self,
                                 subscription_id,
                                 subscription_item_id):
        """Does a DELETE request to /subscriptions/{subscription_id}/items/{subscription_item_id}.

        Deletes a subscription item

        Args:
            subscription_id (string): Subscription id
            subscription_item_id (string): Subscription item id

        Returns:
            GetSubscriptionItemResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items/{subscription_item_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'subscription_item_id': subscription_item_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionItemResponse.from_dictionary)

    def delete_usage(self,
                     subscription_id,
                     item_id,
                     usage_id):
        """Does a DELETE request to /subscriptions/{subscription_id}/items/{item_id}/usages/{usage_id}.

        Deletes a usage

        Args:
            subscription_id (string): The subscription id
            item_id (string): The subscription item id
            usage_id (string): The usage id

        Returns:
            GetUsageResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items/{item_id}/usages/{usage_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'item_id': item_id,
            'usage_id': usage_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetUsageResponse.from_dictionary)

    def get_usages(self,
                   subscription_id,
                   item_id,
                   page=None,
                   size=None):
        """Does a GET request to /subscriptions/{subscription_id}/items/{item_id}/usages.

        Lists all usages from a subscription item

        Args:
            subscription_id (string): The subscription id
            item_id (string): The subscription item id
            page (int, optional): Page number
            size (int, optional): Page size

        Returns:
            ListUsagesResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items/{item_id}/usages'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_parameters = {
            'page': page,
            'size': size
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListUsagesResponse.from_dictionary)

    def delete_discount(self,
                        subscription_id,
                        discount_id):
        """Does a DELETE request to /subscriptions/{subscription_id}/discounts/{discount_id}.

        Deletes a discount

        Args:
            subscription_id (string): Subscription id
            discount_id (string): Discount Id

        Returns:
            GetDiscountResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/discounts/{discount_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'discount_id': discount_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetDiscountResponse.from_dictionary)

    def cancel_subscription(self,
                            subscription_id,
                            request=None):
        """Does a DELETE request to /subscriptions/{subscription_id}.

        Cancels a subscription

        Args:
            subscription_id (string): Subscription id
            request (CreateCancelSubscriptionRequest, optional): Request for
                cancelling a subscription

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)
