# -*- coding: utf-8 -*-

"""
    mundiapi.models.create_checkout_payment_request

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io )
"""
import mundiapi.models.create_checkout_card_payment_request
import mundiapi.models.create_checkout_boleto_payment_request

class CreateCheckoutPaymentRequest(object):

    """Implementation of the 'CreateCheckoutPaymentRequest' model.

    Checkout payment request

    Attributes:
        accepted_payment_methods (list of string): Accepted Payment Methods
        success_url (string): Success url
        default_payment_method (string): Default payment method
        gateway_affiliation_id (string): Gateway Affiliation Id
        credit_card (CreateCheckoutCardPaymentRequest): Card payment request
        boleto (CreateCheckoutBoletoPaymentRequest): Boleto payment request

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "accepted_payment_methods" : "accepted_payment_methods",
        "success_url" : "success_url",
        "default_payment_method" : "default_payment_method",
        "gateway_affiliation_id" : "gateway_affiliation_id",
        "credit_card" : "credit_card",
        "boleto" : "boleto"
    }

    def __init__(self,
                 accepted_payment_methods=None,
                 success_url=None,
                 default_payment_method=None,
                 gateway_affiliation_id=None,
                 credit_card=None,
                 boleto=None):
        """Constructor for the CreateCheckoutPaymentRequest class"""

        # Initialize members of the class
        self.accepted_payment_methods = accepted_payment_methods
        self.success_url = success_url
        self.default_payment_method = default_payment_method
        self.gateway_affiliation_id = gateway_affiliation_id
        self.credit_card = credit_card
        self.boleto = boleto


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        accepted_payment_methods = dictionary.get("accepted_payment_methods")
        success_url = dictionary.get("success_url")
        default_payment_method = dictionary.get("default_payment_method")
        gateway_affiliation_id = dictionary.get("gateway_affiliation_id")
        credit_card = mundiapi.models.create_checkout_card_payment_request.CreateCheckoutCardPaymentRequest.from_dictionary(dictionary.get("credit_card")) if dictionary.get("credit_card") else None
        boleto = mundiapi.models.create_checkout_boleto_payment_request.CreateCheckoutBoletoPaymentRequest.from_dictionary(dictionary.get("boleto")) if dictionary.get("boleto") else None

        # Return an object of this model
        return cls(accepted_payment_methods,
                   success_url,
                   default_payment_method,
                   gateway_affiliation_id,
                   credit_card,
                   boleto)


