# -*- coding: utf-8 -*-

"""
    mundiapi.models.get_anticipation_response

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io )
"""
from mundiapi.api_helper import APIHelper
import mundiapi.models.get_recipient_response

class GetAnticipationResponse(object):

    """Implementation of the 'GetAnticipationResponse' model.

    Anticipation

    Attributes:
        id (string): Id
        requested_amount (int): Requested amount
        approved_amount (int): Approved amount
        recipient (GetRecipientResponse): Recipient
        pgid (string): Anticipation id on the gateway
        created_at (datetime): Creation date
        updated_at (datetime): Last update date
        payment_date (datetime): Payment date
        status (string): Status
        timeframe (string): Timeframe

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id" : "id",
        "requested_amount" : "requested_amount",
        "approved_amount" : "approved_amount",
        "recipient" : "recipient",
        "pgid" : "pgid",
        "created_at" : "created_at",
        "updated_at" : "updated_at",
        "payment_date" : "payment_date",
        "status" : "status",
        "timeframe" : "timeframe"
    }

    def __init__(self,
                 id=None,
                 requested_amount=None,
                 approved_amount=None,
                 recipient=None,
                 pgid=None,
                 created_at=None,
                 updated_at=None,
                 payment_date=None,
                 status=None,
                 timeframe=None):
        """Constructor for the GetAnticipationResponse class"""

        # Initialize members of the class
        self.id = id
        self.requested_amount = requested_amount
        self.approved_amount = approved_amount
        self.recipient = recipient
        self.pgid = pgid
        self.created_at = APIHelper.RFC3339DateTime(created_at) if created_at else None
        self.updated_at = APIHelper.RFC3339DateTime(updated_at) if updated_at else None
        self.payment_date = APIHelper.RFC3339DateTime(payment_date) if payment_date else None
        self.status = status
        self.timeframe = timeframe


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id")
        requested_amount = dictionary.get("requested_amount")
        approved_amount = dictionary.get("approved_amount")
        recipient = mundiapi.models.get_recipient_response.GetRecipientResponse.from_dictionary(dictionary.get("recipient")) if dictionary.get("recipient") else None
        pgid = dictionary.get("pgid")
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        updated_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("updated_at")).datetime if dictionary.get("updated_at") else None
        payment_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("payment_date")).datetime if dictionary.get("payment_date") else None
        status = dictionary.get("status")
        timeframe = dictionary.get("timeframe")

        # Return an object of this model
        return cls(id,
                   requested_amount,
                   approved_amount,
                   recipient,
                   pgid,
                   created_at,
                   updated_at,
                   payment_date,
                   status,
                   timeframe)


