# -*- coding: utf-8 -*-

"""
    mundiapi.models.get_usage_response

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io )
"""
from mundiapi.api_helper import APIHelper
import mundiapi.models.get_subscription_item_response

class GetUsageResponse(object):

    """Implementation of the 'GetUsageResponse' model.

    Response object for getting a usage

    Attributes:
        id (string): Id
        quantity (int): Quantity
        description (string): Description
        used_at (datetime): Used at
        created_at (datetime): Creation date
        status (string): Status
        subscription_item (GetSubscriptionItemResponse): Subscription item
        deleted_at (datetime): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id" : "id",
        "quantity" : "quantity",
        "description" : "description",
        "used_at" : "used_at",
        "created_at" : "created_at",
        "status" : "status",
        "subscription_item" : "subscription_item",
        "deleted_at" : "deleted_at"
    }

    def __init__(self,
                 id=None,
                 quantity=None,
                 description=None,
                 used_at=None,
                 created_at=None,
                 status=None,
                 subscription_item=None,
                 deleted_at=None):
        """Constructor for the GetUsageResponse class"""

        # Initialize members of the class
        self.id = id
        self.quantity = quantity
        self.description = description
        self.used_at = APIHelper.RFC3339DateTime(used_at) if used_at else None
        self.created_at = APIHelper.RFC3339DateTime(created_at) if created_at else None
        self.status = status
        self.subscription_item = subscription_item
        self.deleted_at = APIHelper.RFC3339DateTime(deleted_at) if deleted_at else None


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id")
        quantity = dictionary.get("quantity")
        description = dictionary.get("description")
        used_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("used_at")).datetime if dictionary.get("used_at") else None
        created_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("created_at")).datetime if dictionary.get("created_at") else None
        status = dictionary.get("status")
        subscription_item = mundiapi.models.get_subscription_item_response.GetSubscriptionItemResponse.from_dictionary(dictionary.get("subscription_item")) if dictionary.get("subscription_item") else None
        deleted_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("deleted_at")).datetime if dictionary.get("deleted_at") else None

        # Return an object of this model
        return cls(id,
                   quantity,
                   description,
                   used_at,
                   created_at,
                   status,
                   subscription_item,
                   deleted_at)


