# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List


class CdsFileShareLinkModel(TeaModel):
    def __init__(
        self,
        access_count: int = None,
        create_time: str = None,
        creator: str = None,
        description: str = None,
        disable_download: bool = None,
        disable_preview: bool = None,
        disable_save: bool = None,
        download_count: int = None,
        download_limit: int = None,
        drive_id: str = None,
        expiration: str = None,
        expired: bool = None,
        file_ids: str = None,
        modifiy_time: str = None,
        preview_count: int = None,
        preview_limit: int = None,
        report_count: int = None,
        save_count: int = None,
        save_limit: int = None,
        share_id: str = None,
        share_link: str = None,
        share_name: str = None,
        share_pwd: str = None,
        status: str = None,
        video_preview_count: int = None,
    ):
        self.access_count = access_count
        self.create_time = create_time
        self.creator = creator
        self.description = description
        self.disable_download = disable_download
        self.disable_preview = disable_preview
        self.disable_save = disable_save
        self.download_count = download_count
        self.download_limit = download_limit
        self.drive_id = drive_id
        self.expiration = expiration
        self.expired = expired
        self.file_ids = file_ids
        self.modifiy_time = modifiy_time
        self.preview_count = preview_count
        self.preview_limit = preview_limit
        self.report_count = report_count
        self.save_count = save_count
        self.save_limit = save_limit
        self.share_id = share_id
        self.share_link = share_link
        self.share_name = share_name
        self.share_pwd = share_pwd
        self.status = status
        self.video_preview_count = video_preview_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_count is not None:
            result['AccessCount'] = self.access_count
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.description is not None:
            result['Description'] = self.description
        if self.disable_download is not None:
            result['DisableDownload'] = self.disable_download
        if self.disable_preview is not None:
            result['DisablePreview'] = self.disable_preview
        if self.disable_save is not None:
            result['DisableSave'] = self.disable_save
        if self.download_count is not None:
            result['DownloadCount'] = self.download_count
        if self.download_limit is not None:
            result['DownloadLimit'] = self.download_limit
        if self.drive_id is not None:
            result['DriveId'] = self.drive_id
        if self.expiration is not None:
            result['Expiration'] = self.expiration
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.file_ids is not None:
            result['FileIds'] = self.file_ids
        if self.modifiy_time is not None:
            result['ModifiyTime'] = self.modifiy_time
        if self.preview_count is not None:
            result['PreviewCount'] = self.preview_count
        if self.preview_limit is not None:
            result['PreviewLimit'] = self.preview_limit
        if self.report_count is not None:
            result['ReportCount'] = self.report_count
        if self.save_count is not None:
            result['SaveCount'] = self.save_count
        if self.save_limit is not None:
            result['SaveLimit'] = self.save_limit
        if self.share_id is not None:
            result['ShareId'] = self.share_id
        if self.share_link is not None:
            result['ShareLink'] = self.share_link
        if self.share_name is not None:
            result['ShareName'] = self.share_name
        if self.share_pwd is not None:
            result['SharePwd'] = self.share_pwd
        if self.status is not None:
            result['Status'] = self.status
        if self.video_preview_count is not None:
            result['VideoPreviewCount'] = self.video_preview_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessCount') is not None:
            self.access_count = m.get('AccessCount')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisableDownload') is not None:
            self.disable_download = m.get('DisableDownload')
        if m.get('DisablePreview') is not None:
            self.disable_preview = m.get('DisablePreview')
        if m.get('DisableSave') is not None:
            self.disable_save = m.get('DisableSave')
        if m.get('DownloadCount') is not None:
            self.download_count = m.get('DownloadCount')
        if m.get('DownloadLimit') is not None:
            self.download_limit = m.get('DownloadLimit')
        if m.get('DriveId') is not None:
            self.drive_id = m.get('DriveId')
        if m.get('Expiration') is not None:
            self.expiration = m.get('Expiration')
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('FileIds') is not None:
            self.file_ids = m.get('FileIds')
        if m.get('ModifiyTime') is not None:
            self.modifiy_time = m.get('ModifiyTime')
        if m.get('PreviewCount') is not None:
            self.preview_count = m.get('PreviewCount')
        if m.get('PreviewLimit') is not None:
            self.preview_limit = m.get('PreviewLimit')
        if m.get('ReportCount') is not None:
            self.report_count = m.get('ReportCount')
        if m.get('SaveCount') is not None:
            self.save_count = m.get('SaveCount')
        if m.get('SaveLimit') is not None:
            self.save_limit = m.get('SaveLimit')
        if m.get('ShareId') is not None:
            self.share_id = m.get('ShareId')
        if m.get('ShareLink') is not None:
            self.share_link = m.get('ShareLink')
        if m.get('ShareName') is not None:
            self.share_name = m.get('ShareName')
        if m.get('SharePwd') is not None:
            self.share_pwd = m.get('SharePwd')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VideoPreviewCount') is not None:
            self.video_preview_count = m.get('VideoPreviewCount')
        return self


class FilePermissionMemberCdsIdentity(TeaModel):
    def __init__(
        self,
        id: str = None,
        type: str = None,
    ):
        self.id = id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class FilePermissionMember(TeaModel):
    def __init__(
        self,
        cds_identity: FilePermissionMemberCdsIdentity = None,
        disinherit_sub_group: bool = None,
        expire_time: int = None,
        role_id: str = None,
    ):
        self.cds_identity = cds_identity
        self.disinherit_sub_group = disinherit_sub_group
        self.expire_time = expire_time
        self.role_id = role_id

    def validate(self):
        if self.cds_identity:
            self.cds_identity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_identity is not None:
            result['CdsIdentity'] = self.cds_identity.to_map()
        if self.disinherit_sub_group is not None:
            result['DisinheritSubGroup'] = self.disinherit_sub_group
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsIdentity') is not None:
            temp_model = FilePermissionMemberCdsIdentity()
            self.cds_identity = temp_model.from_map(m['CdsIdentity'])
        if m.get('DisinheritSubGroup') is not None:
            self.disinherit_sub_group = m.get('DisinheritSubGroup')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class ActivateOfficeSiteRequest(TeaModel):
    def __init__(
        self,
        office_site_id: str = None,
        region_id: str = None,
    ):
        self.office_site_id = office_site_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ActivateOfficeSiteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ActivateOfficeSiteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ActivateOfficeSiteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ActivateOfficeSiteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDevicesRequest(TeaModel):
    def __init__(
        self,
        client_type: int = None,
        device_ids: List[str] = None,
        region_id: str = None,
    ):
        # The type of the Alibaba Cloud Workspace client that runs on the device.
        # 
        # *   1: the hardware client
        # *   2: the software client
        self.client_type = client_type
        # The list of devices.
        self.device_ids = device_ids
        # The ID of the region.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.device_ids is not None:
            result['DeviceIds'] = self.device_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('DeviceIds') is not None:
            self.device_ids = m.get('DeviceIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddDevicesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDevicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddFilePermissionRequestMemberListCdsIdentity(TeaModel):
    def __init__(
        self,
        id: str = None,
        type: str = None,
    ):
        # The ID of the user.
        self.id = id
        # The type of the user.
        # 
        # Valid values:
        # 
        # *   <!-- -->
        # 
        #     IT_Group
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     IT_User
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddFilePermissionRequestMemberList(TeaModel):
    def __init__(
        self,
        cds_identity: AddFilePermissionRequestMemberListCdsIdentity = None,
        disinherit_sub_group: bool = None,
        expire_time: int = None,
        role_id: str = None,
    ):
        # The user of the cloud disk.
        self.cds_identity = cds_identity
        # Specifies whether the users of the child group can inherit the folder permissions.
        self.disinherit_sub_group = disinherit_sub_group
        # The time when the authorization expires. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC. The value never expires. You can specify a value that is predefined by the system for this parameter. Example: 4775500800000.
        self.expire_time = expire_time
        # The ID of the role to which you want to attach the folder permissions. To configure the folder permissions: you can specify a role or create custom operation permissions. You can use RoleId to specify a role. RoleId is mutually exclusive with ActionList. If you specify both of them, the value of RoleId takes precedence.
        # 
        # Valid values:
        # 
        # *   <!-- -->
        # 
        #     SystemFileEditorWithoutShareLink
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     SystemFileUploaderAndDownloaderWithShareLink
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     SystemFileDownloader
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     SystemFileEditorWithoutDelete
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     SystemFileOwner
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     SystemFileDownloaderWithShareLink
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     SystemFileUploaderAndViewer
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     SystemFileViewer
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     SystemFileEditor
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     SystemFileUploaderWithShareLink
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     SystemFileUploader
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     SystemFileUploaderAndDownloader
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   <!-- -->
        # 
        #     SystemFileMetaViewer
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.role_id = role_id

    def validate(self):
        if self.cds_identity:
            self.cds_identity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_identity is not None:
            result['CdsIdentity'] = self.cds_identity.to_map()
        if self.disinherit_sub_group is not None:
            result['DisinheritSubGroup'] = self.disinherit_sub_group
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsIdentity') is not None:
            temp_model = AddFilePermissionRequestMemberListCdsIdentity()
            self.cds_identity = temp_model.from_map(m['CdsIdentity'])
        if m.get('DisinheritSubGroup') is not None:
            self.disinherit_sub_group = m.get('DisinheritSubGroup')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        return self


class AddFilePermissionRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: str = None,
        file_id: str = None,
        member_list: List[AddFilePermissionRequestMemberList] = None,
        region_id: str = None,
    ):
        # The ID of the cloud disk whose folder you want to share.
        self.cds_id = cds_id
        # The ID of the end user who uses the cloud disk of the folder.
        self.end_user_id = end_user_id
        # The ID of the file.
        self.file_id = file_id
        # The members who are granted the folder permissions.
        self.member_list = member_list
        # The region ID of the folder. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        if self.member_list:
            for k in self.member_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        result['MemberList'] = []
        if self.member_list is not None:
            for k in self.member_list:
                result['MemberList'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        self.member_list = []
        if m.get('MemberList') is not None:
            for k in m.get('MemberList'):
                temp_model = AddFilePermissionRequestMemberList()
                self.member_list.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddFilePermissionShrinkRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: str = None,
        file_id: str = None,
        member_list_shrink: str = None,
        region_id: str = None,
    ):
        # The ID of the cloud disk whose folder you want to share.
        self.cds_id = cds_id
        # The ID of the end user who uses the cloud disk of the folder.
        self.end_user_id = end_user_id
        # The ID of the file.
        self.file_id = file_id
        # The members who are granted the folder permissions.
        self.member_list_shrink = member_list_shrink
        # The region ID of the folder. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.member_list_shrink is not None:
            result['MemberList'] = self.member_list_shrink
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('MemberList') is not None:
            self.member_list_shrink = m.get('MemberList')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddFilePermissionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddFilePermissionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddFilePermissionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddFilePermissionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddUserToDesktopGroupRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        desktop_group_id: str = None,
        desktop_group_ids: List[str] = None,
        end_user_ids: List[str] = None,
        region_id: str = None,
    ):
        self.client_token = client_token
        self.desktop_group_id = desktop_group_id
        self.desktop_group_ids = desktop_group_ids
        self.end_user_ids = end_user_ids
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_group_ids is not None:
            result['DesktopGroupIds'] = self.desktop_group_ids
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopGroupIds') is not None:
            self.desktop_group_ids = m.get('DesktopGroupIds')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddUserToDesktopGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddUserToDesktopGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddUserToDesktopGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddUserToDesktopGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        desktop_id: List[str] = None,
        policy_id: str = None,
        region_id: str = None,
    ):
        # The IDs of cloud desktops. You can specify 1 to 20 cloud desktops.
        self.desktop_id = desktop_id
        # The ID of the automatic snapshot policy.
        self.policy_id = policy_id
        # The ID of the region. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ApplyAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApplyAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyCoordinatePrivilegeRequest(TeaModel):
    def __init__(
        self,
        co_id: str = None,
        end_user_id: str = None,
        region_id: str = None,
        user_type: str = None,
        uuid: str = None,
    ):
        self.co_id = co_id
        self.end_user_id = end_user_id
        self.region_id = region_id
        self.user_type = user_type
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.co_id is not None:
            result['CoId'] = self.co_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.user_type is not None:
            result['UserType'] = self.user_type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoId') is not None:
            self.co_id = m.get('CoId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class ApplyCoordinatePrivilegeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApplyCoordinatePrivilegeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyCoordinatePrivilegeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyCoordinatePrivilegeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyCoordinationForMonitoringRequestResourceCandidates(TeaModel):
    def __init__(
        self,
        owner_ali_uid: int = None,
        owner_end_user_id: str = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_properties: str = None,
        resource_region_id: str = None,
        resource_type: str = None,
    ):
        self.owner_ali_uid = owner_ali_uid
        self.owner_end_user_id = owner_end_user_id
        self.resource_id = resource_id
        self.resource_name = resource_name
        self.resource_properties = resource_properties
        self.resource_region_id = resource_region_id
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_ali_uid is not None:
            result['OwnerAliUid'] = self.owner_ali_uid
        if self.owner_end_user_id is not None:
            result['OwnerEndUserId'] = self.owner_end_user_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_properties is not None:
            result['ResourceProperties'] = self.resource_properties
        if self.resource_region_id is not None:
            result['ResourceRegionId'] = self.resource_region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAliUid') is not None:
            self.owner_ali_uid = m.get('OwnerAliUid')
        if m.get('OwnerEndUserId') is not None:
            self.owner_end_user_id = m.get('OwnerEndUserId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceProperties') is not None:
            self.resource_properties = m.get('ResourceProperties')
        if m.get('ResourceRegionId') is not None:
            self.resource_region_id = m.get('ResourceRegionId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class ApplyCoordinationForMonitoringRequest(TeaModel):
    def __init__(
        self,
        coordinate_policy_type: str = None,
        end_user_id: str = None,
        initiator_type: str = None,
        region_id: str = None,
        resource_candidates: List[ApplyCoordinationForMonitoringRequestResourceCandidates] = None,
        uuid: str = None,
    ):
        self.coordinate_policy_type = coordinate_policy_type
        self.end_user_id = end_user_id
        self.initiator_type = initiator_type
        self.region_id = region_id
        self.resource_candidates = resource_candidates
        self.uuid = uuid

    def validate(self):
        if self.resource_candidates:
            for k in self.resource_candidates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.coordinate_policy_type is not None:
            result['CoordinatePolicyType'] = self.coordinate_policy_type
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.initiator_type is not None:
            result['InitiatorType'] = self.initiator_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['ResourceCandidates'] = []
        if self.resource_candidates is not None:
            for k in self.resource_candidates:
                result['ResourceCandidates'].append(k.to_map() if k else None)
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoordinatePolicyType') is not None:
            self.coordinate_policy_type = m.get('CoordinatePolicyType')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('InitiatorType') is not None:
            self.initiator_type = m.get('InitiatorType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.resource_candidates = []
        if m.get('ResourceCandidates') is not None:
            for k in m.get('ResourceCandidates'):
                temp_model = ApplyCoordinationForMonitoringRequestResourceCandidates()
                self.resource_candidates.append(temp_model.from_map(k))
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class ApplyCoordinationForMonitoringResponseBodyCoordinateFlowModels(TeaModel):
    def __init__(
        self,
        co_id: str = None,
        coordinate_status: str = None,
        coordinate_ticket: str = None,
        initiator_type: str = None,
        owner_user_id: str = None,
        resource_id: str = None,
        resource_name: str = None,
    ):
        self.co_id = co_id
        self.coordinate_status = coordinate_status
        self.coordinate_ticket = coordinate_ticket
        self.initiator_type = initiator_type
        self.owner_user_id = owner_user_id
        self.resource_id = resource_id
        self.resource_name = resource_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.co_id is not None:
            result['CoId'] = self.co_id
        if self.coordinate_status is not None:
            result['CoordinateStatus'] = self.coordinate_status
        if self.coordinate_ticket is not None:
            result['CoordinateTicket'] = self.coordinate_ticket
        if self.initiator_type is not None:
            result['InitiatorType'] = self.initiator_type
        if self.owner_user_id is not None:
            result['OwnerUserId'] = self.owner_user_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoId') is not None:
            self.co_id = m.get('CoId')
        if m.get('CoordinateStatus') is not None:
            self.coordinate_status = m.get('CoordinateStatus')
        if m.get('CoordinateTicket') is not None:
            self.coordinate_ticket = m.get('CoordinateTicket')
        if m.get('InitiatorType') is not None:
            self.initiator_type = m.get('InitiatorType')
        if m.get('OwnerUserId') is not None:
            self.owner_user_id = m.get('OwnerUserId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        return self


class ApplyCoordinationForMonitoringResponseBody(TeaModel):
    def __init__(
        self,
        coordinate_flow_models: List[ApplyCoordinationForMonitoringResponseBodyCoordinateFlowModels] = None,
        request_id: str = None,
    ):
        self.coordinate_flow_models = coordinate_flow_models
        self.request_id = request_id

    def validate(self):
        if self.coordinate_flow_models:
            for k in self.coordinate_flow_models:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CoordinateFlowModels'] = []
        if self.coordinate_flow_models is not None:
            for k in self.coordinate_flow_models:
                result['CoordinateFlowModels'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.coordinate_flow_models = []
        if m.get('CoordinateFlowModels') is not None:
            for k in m.get('CoordinateFlowModels'):
                temp_model = ApplyCoordinationForMonitoringResponseBodyCoordinateFlowModels()
                self.coordinate_flow_models.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApplyCoordinationForMonitoringResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyCoordinationForMonitoringResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyCoordinationForMonitoringResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApproveFotaUpdateRequest(TeaModel):
    def __init__(
        self,
        app_version: str = None,
        desktop_id: str = None,
        region_id: str = None,
    ):
        self.app_version = app_version
        self.desktop_id = desktop_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ApproveFotaUpdateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApproveFotaUpdateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApproveFotaUpdateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApproveFotaUpdateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateNetworkPackageRequest(TeaModel):
    def __init__(
        self,
        network_package_id: str = None,
        office_site_id: str = None,
        region_id: str = None,
    ):
        self.network_package_id = network_package_id
        self.office_site_id = office_site_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_package_id is not None:
            result['NetworkPackageId'] = self.network_package_id
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkPackageId') is not None:
            self.network_package_id = m.get('NetworkPackageId')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AssociateNetworkPackageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateNetworkPackageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AssociateNetworkPackageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssociateNetworkPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachCenRequest(TeaModel):
    def __init__(
        self,
        cen_id: str = None,
        cen_owner_id: int = None,
        office_site_id: str = None,
        region_id: str = None,
        verify_code: str = None,
    ):
        # The ID of the request.
        self.cen_id = cen_id
        # The operation that you want to perform. Set the value to **AttachCen**.
        self.cen_owner_id = cen_owner_id
        self.office_site_id = office_site_id
        # The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the SendVerifyCode operation to obtain the verification code.
        self.region_id = region_id
        # The ID of the workspace.
        self.verify_code = verify_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_owner_id is not None:
            result['CenOwnerId'] = self.cen_owner_id
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.verify_code is not None:
            result['VerifyCode'] = self.verify_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenOwnerId') is not None:
            self.cen_owner_id = m.get('CenOwnerId')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VerifyCode') is not None:
            self.verify_code = m.get('VerifyCode')
        return self


class AttachCenResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachCenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachCenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachCenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachEndUserRequest(TeaModel):
    def __init__(
        self,
        ad_domain: str = None,
        client_type: int = None,
        device_id: str = None,
        directory_id: str = None,
        end_user_id: str = None,
        region_id: str = None,
        user_type: str = None,
    ):
        # The address of the Active Directory (AD) workspace.
        self.ad_domain = ad_domain
        # The type of the Alibaba Cloud Workspace client that runs on the device.
        # 
        # *   1: the hardware client
        # *   2: the software client
        self.client_type = client_type
        # The ID of the device.
        self.device_id = device_id
        # The ID of the workspace.
        self.directory_id = directory_id
        # The ID of the user.
        self.end_user_id = end_user_id
        # The ID of the region.
        self.region_id = region_id
        # The account type of the user.
        # 
        # *   SIMPLE: the convenience user
        # *   AD: the AD user
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_domain is not None:
            result['AdDomain'] = self.ad_domain
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdDomain') is not None:
            self.ad_domain = m.get('AdDomain')
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class AttachEndUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachEndUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachEndUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachEndUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        desktop_id: List[str] = None,
        policy_id: str = None,
        region_id: str = None,
    ):
        # The IDs of the cloud desktops. Valid values of N: 1 to 50. You cannot leave this parameter empty. The value can be up to 64 characters in length and cannot start with acs: or aliyun. It cannot contain [http:// or https://.](http://https://。)
        self.desktop_id = desktop_id
        # The ID of the automatic snapshot policy.
        self.policy_id = policy_id
        # The region ID of the automatic snapshot policy. You can call the [DescribeRegions](~~25609~~) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CancelAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelCdsFileShareLinkRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        share_id: str = None,
    ):
        # The ID of the cloud disk.
        self.cds_id = cds_id
        # The ID of the file sharing task.
        self.share_id = share_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.share_id is not None:
            result['ShareId'] = self.share_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('ShareId') is not None:
            self.share_id = m.get('ShareId')
        return self


class CancelCdsFileShareLinkResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The operation result. The value success indicates that the operation is successful. If the operation failed, an error message is returned.
        self.code = code
        # The data information.
        self.data = data
        # The error message that is returned if the request failed. This parameter is not returned if the value of Code is `success`.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   **true**: The request is successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelCdsFileShareLinkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelCdsFileShareLinkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelCdsFileShareLinkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelCoordinationForMonitoringRequest(TeaModel):
    def __init__(
        self,
        co_ids: List[str] = None,
        end_user_id: str = None,
        region_id: str = None,
        user_type: str = None,
    ):
        self.co_ids = co_ids
        self.end_user_id = end_user_id
        self.region_id = region_id
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.co_ids is not None:
            result['CoIds'] = self.co_ids
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoIds') is not None:
            self.co_ids = m.get('CoIds')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class CancelCoordinationForMonitoringResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelCoordinationForMonitoringResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelCoordinationForMonitoringResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelCoordinationForMonitoringResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelCopyImageRequest(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        region_id: str = None,
    ):
        self.image_id = image_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CancelCopyImageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelCopyImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelCopyImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelCopyImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClonePolicyGroupRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        policy_group_id: str = None,
        region_id: str = None,
    ):
        self.name = name
        self.policy_group_id = policy_group_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ClonePolicyGroupResponseBody(TeaModel):
    def __init__(
        self,
        policy_group_id: str = None,
        request_id: str = None,
    ):
        self.policy_group_id = policy_group_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ClonePolicyGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ClonePolicyGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ClonePolicyGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CompleteCdsFileRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: str = None,
        file_id: str = None,
        region_id: str = None,
        upload_id: str = None,
    ):
        # The ID of the cloud disk.
        self.cds_id = cds_id
        # The name of the end user.
        self.end_user_id = end_user_id
        # The file ID. An ID is the unique identifier of a file.
        self.file_id = file_id
        # The region ID. You can call the DescribeRegions operation to query the most recent region list.
        self.region_id = region_id
        # The ID of the file uploading task.
        self.upload_id = upload_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.upload_id is not None:
            result['UploadId'] = self.upload_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UploadId') is not None:
            self.upload_id = m.get('UploadId')
        return self


class CompleteCdsFileResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CompleteCdsFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CompleteCdsFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CompleteCdsFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfigADConnectorTrustRequest(TeaModel):
    def __init__(
        self,
        office_site_id: str = None,
        rds_license_domain: bool = None,
        region_id: str = None,
        trust_key: str = None,
    ):
        # The ID of the AD workspace.
        self.office_site_id = office_site_id
        self.rds_license_domain = rds_license_domain
        # The region ID.
        self.region_id = region_id
        # The trust password. You can specify the password when you configure a trust relationship between the AD domain and the ecd.acs domain.
        self.trust_key = trust_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.rds_license_domain is not None:
            result['RdsLicenseDomain'] = self.rds_license_domain
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.trust_key is not None:
            result['TrustKey'] = self.trust_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RdsLicenseDomain') is not None:
            self.rds_license_domain = m.get('RdsLicenseDomain')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TrustKey') is not None:
            self.trust_key = m.get('TrustKey')
        return self


class ConfigADConnectorTrustResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConfigADConnectorTrustResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ConfigADConnectorTrustResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfigADConnectorTrustResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfigADConnectorUserRequest(TeaModel):
    def __init__(
        self,
        domain_password: str = None,
        domain_user_name: str = None,
        ouname: str = None,
        office_site_id: str = None,
        region_id: str = None,
    ):
        # The password of the AD user that has the permissions to join computers to domains.
        self.domain_password = domain_password
        # The username of the AD user that has the permissions to join computers to domains.
        # 
        # After the username is configured, the cloud desktops in the same AD workspace are joined to the specified OU.
        self.domain_user_name = domain_user_name
        # The name of the OU in the AD domain. You can call the [ListUserAdOrganizationUnits](~~311259~~) to obtain the OU name.
        self.ouname = ouname
        # The ID of the AD workspace.
        self.office_site_id = office_site_id
        # The ID of the region.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_password is not None:
            result['DomainPassword'] = self.domain_password
        if self.domain_user_name is not None:
            result['DomainUserName'] = self.domain_user_name
        if self.ouname is not None:
            result['OUName'] = self.ouname
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainPassword') is not None:
            self.domain_password = m.get('DomainPassword')
        if m.get('DomainUserName') is not None:
            self.domain_user_name = m.get('DomainUserName')
        if m.get('OUName') is not None:
            self.ouname = m.get('OUName')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ConfigADConnectorUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConfigADConnectorUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ConfigADConnectorUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfigADConnectorUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyCdsFileRequest(TeaModel):
    def __init__(
        self,
        auto_rename: bool = None,
        cds_id: str = None,
        end_user_id: str = None,
        file_id: str = None,
        file_receiver_id: str = None,
        file_receiver_type: str = None,
        parent_folder_id: str = None,
        region_id: str = None,
    ):
        # Specifies whether to automatically rename the file if a file that has the same name exists in the folder to which you want to copy the file. Default value: false.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.auto_rename = auto_rename
        # The ID of the cloud disk.
        self.cds_id = cds_id
        # The user ID that you want to use to access the cloud disk.
        self.end_user_id = end_user_id
        # The file ID. You can call the CreateCdsFile operation to query the file ID.
        self.file_id = file_id
        # 目标复制文件所在的个人空间ID（即UserId，您可以在DescribeCloudDriveUsers接口返回的报文中获取。）或者目标复制文件所在的团队空间ID（即GroupId，您可以在DescribeCloudDriveGroups接口返回的报文中获取。）
        # > FileReceiverId和FileReceiverType都为空时，默认复制到文件所在的个人空间。
        # >
        self.file_receiver_id = file_receiver_id
        # 文件所属的空间类型。
        self.file_receiver_type = file_receiver_type
        # The ID of the parent folder of the folder to which you want to copy the file. If you want to copy the file to the root directory, set this parameter to root.
        self.parent_folder_id = parent_folder_id
        # The region ID. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_rename is not None:
            result['AutoRename'] = self.auto_rename
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.file_receiver_id is not None:
            result['FileReceiverId'] = self.file_receiver_id
        if self.file_receiver_type is not None:
            result['FileReceiverType'] = self.file_receiver_type
        if self.parent_folder_id is not None:
            result['ParentFolderId'] = self.parent_folder_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoRename') is not None:
            self.auto_rename = m.get('AutoRename')
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('FileReceiverId') is not None:
            self.file_receiver_id = m.get('FileReceiverId')
        if m.get('FileReceiverType') is not None:
            self.file_receiver_type = m.get('FileReceiverType')
        if m.get('ParentFolderId') is not None:
            self.parent_folder_id = m.get('ParentFolderId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CopyCdsFileResponseBodyCopyCdsFileModel(TeaModel):
    def __init__(
        self,
        async_task_id: str = None,
        file_id: str = None,
    ):
        # The ID of the asynchronous task. This parameter is not returned if you copy a file. This parameter is returned if you copy a folder in the backend in an asynchronous manner. You can call the GetAsyncTask operation to obtain the ID and details of an asynchronous task.
        self.async_task_id = async_task_id
        # The ID of the copied file or folder.
        self.file_id = file_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_task_id is not None:
            result['AsyncTaskId'] = self.async_task_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsyncTaskId') is not None:
            self.async_task_id = m.get('AsyncTaskId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class CopyCdsFileResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        copy_cds_file_model: CopyCdsFileResponseBodyCopyCdsFileModel = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The operation result. The value success indicates that the operation is successful. If the operation failed, an error message is returned.
        self.code = code
        # The details about the file copying.
        self.copy_cds_file_model = copy_cds_file_model
        # The error message that is returned. This parameter is not returned if the value of Code is success.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.success = success

    def validate(self):
        if self.copy_cds_file_model:
            self.copy_cds_file_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.copy_cds_file_model is not None:
            result['CopyCdsFileModel'] = self.copy_cds_file_model.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CopyCdsFileModel') is not None:
            temp_model = CopyCdsFileResponseBodyCopyCdsFileModel()
            self.copy_cds_file_model = temp_model.from_map(m['CopyCdsFileModel'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CopyCdsFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CopyCdsFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyCdsFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyImageRequest(TeaModel):
    def __init__(
        self,
        destination_description: str = None,
        destination_image_name: str = None,
        destination_region_id: str = None,
        image_id: str = None,
        region_id: str = None,
    ):
        self.destination_description = destination_description
        self.destination_image_name = destination_image_name
        self.destination_region_id = destination_region_id
        self.image_id = image_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_description is not None:
            result['DestinationDescription'] = self.destination_description
        if self.destination_image_name is not None:
            result['DestinationImageName'] = self.destination_image_name
        if self.destination_region_id is not None:
            result['DestinationRegionId'] = self.destination_region_id
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationDescription') is not None:
            self.destination_description = m.get('DestinationDescription')
        if m.get('DestinationImageName') is not None:
            self.destination_image_name = m.get('DestinationImageName')
        if m.get('DestinationRegionId') is not None:
            self.destination_region_id = m.get('DestinationRegionId')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CopyImageResponseBody(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        request_id: str = None,
    ):
        self.image_id = image_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CopyImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateADConnectorDirectoryRequest(TeaModel):
    def __init__(
        self,
        desktop_access_type: str = None,
        directory_name: str = None,
        dns_address: List[str] = None,
        domain_name: str = None,
        domain_password: str = None,
        domain_user_name: str = None,
        enable_admin_access: bool = None,
        mfa_enabled: bool = None,
        region_id: str = None,
        specification: int = None,
        sub_domain_dns_address: List[str] = None,
        sub_domain_name: str = None,
        v_switch_id: List[str] = None,
    ):
        # The AD trust password.
        self.desktop_access_type = desktop_access_type
        # The ID of the region. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.directory_name = directory_name
        # The fully qualified domain name (FQDN) of the enterprise AD system. The value must contain the hostname and the domain name. You can register each FQDN only once.
        self.dns_address = dns_address
        # The IP address of the DNS server of the enterprise AD system.
        self.domain_name = domain_name
        # Specifies whether to grant the permissions of the local administrator to the regular user of the cloud desktop.
        self.domain_password = domain_password
        # The name of the AD directory. The name must be 2 to 255 characters in length, and can contain letters, digits, colons (:), underscores (\_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        self.domain_user_name = domain_user_name
        # The DNS address of the enterprise AD subdomain.\
        # If you specify the `SubDomainName` parameter but you do not specify this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
        self.enable_admin_access = enable_admin_access
        # The information that is returned.
        self.mfa_enabled = mfa_enabled
        # The ID of the AD directory.
        self.region_id = region_id
        # The password of the domain administrator. The password can be up to 64 characters in length.
        self.specification = specification
        # Details of the vSwitch IDs. You can specify only one vSwitch ID.
        self.sub_domain_dns_address = sub_domain_dns_address
        # The FQDN of the enterprise AD subdomain. The value must contain the hostname and the subdomain name.
        self.sub_domain_name = sub_domain_name
        # The username of the domain administrator. The username can be up to 64 characters in length.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_access_type is not None:
            result['DesktopAccessType'] = self.desktop_access_type
        if self.directory_name is not None:
            result['DirectoryName'] = self.directory_name
        if self.dns_address is not None:
            result['DnsAddress'] = self.dns_address
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_password is not None:
            result['DomainPassword'] = self.domain_password
        if self.domain_user_name is not None:
            result['DomainUserName'] = self.domain_user_name
        if self.enable_admin_access is not None:
            result['EnableAdminAccess'] = self.enable_admin_access
        if self.mfa_enabled is not None:
            result['MfaEnabled'] = self.mfa_enabled
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.sub_domain_dns_address is not None:
            result['SubDomainDnsAddress'] = self.sub_domain_dns_address
        if self.sub_domain_name is not None:
            result['SubDomainName'] = self.sub_domain_name
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopAccessType') is not None:
            self.desktop_access_type = m.get('DesktopAccessType')
        if m.get('DirectoryName') is not None:
            self.directory_name = m.get('DirectoryName')
        if m.get('DnsAddress') is not None:
            self.dns_address = m.get('DnsAddress')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainPassword') is not None:
            self.domain_password = m.get('DomainPassword')
        if m.get('DomainUserName') is not None:
            self.domain_user_name = m.get('DomainUserName')
        if m.get('EnableAdminAccess') is not None:
            self.enable_admin_access = m.get('EnableAdminAccess')
        if m.get('MfaEnabled') is not None:
            self.mfa_enabled = m.get('MfaEnabled')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('SubDomainDnsAddress') is not None:
            self.sub_domain_dns_address = m.get('SubDomainDnsAddress')
        if m.get('SubDomainName') is not None:
            self.sub_domain_name = m.get('SubDomainName')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateADConnectorDirectoryResponseBodyAdConnectors(TeaModel):
    def __init__(
        self,
        address: str = None,
    ):
        self.address = address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        return self


class CreateADConnectorDirectoryResponseBody(TeaModel):
    def __init__(
        self,
        ad_connectors: List[CreateADConnectorDirectoryResponseBodyAdConnectors] = None,
        directory_id: str = None,
        request_id: str = None,
        trust_password: str = None,
    ):
        self.ad_connectors = ad_connectors
        # CreateADConnectorDirectory
        self.directory_id = directory_id
        # Creates an Active Directory (AD) directory.
        self.request_id = request_id
        # The DNS address of the enterprise AD subdomain.
        self.trust_password = trust_password

    def validate(self):
        if self.ad_connectors:
            for k in self.ad_connectors:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AdConnectors'] = []
        if self.ad_connectors is not None:
            for k in self.ad_connectors:
                result['AdConnectors'].append(k.to_map() if k else None)
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.trust_password is not None:
            result['TrustPassword'] = self.trust_password
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ad_connectors = []
        if m.get('AdConnectors') is not None:
            for k in m.get('AdConnectors'):
                temp_model = CreateADConnectorDirectoryResponseBodyAdConnectors()
                self.ad_connectors.append(temp_model.from_map(k))
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TrustPassword') is not None:
            self.trust_password = m.get('TrustPassword')
        return self


class CreateADConnectorDirectoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateADConnectorDirectoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateADConnectorDirectoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateADConnectorOfficeSiteRequest(TeaModel):
    def __init__(
        self,
        ad_hostname: str = None,
        bandwidth: int = None,
        cen_id: str = None,
        cen_owner_id: int = None,
        cidr_block: str = None,
        desktop_access_type: str = None,
        dns_address: List[str] = None,
        domain_name: str = None,
        domain_password: str = None,
        domain_user_name: str = None,
        enable_admin_access: bool = None,
        enable_internet_access: bool = None,
        mfa_enabled: bool = None,
        office_site_name: str = None,
        protocol_type: str = None,
        region_id: str = None,
        specification: int = None,
        sub_domain_dns_address: List[str] = None,
        sub_domain_name: str = None,
        verify_code: str = None,
    ):
        # The hostname of the domain controller. The hostname must comply with the naming conventions for Windows hosts.
        self.ad_hostname = ad_hostname
        # The maximum public bandwidth of the Internet access package. Valid values: 0 to 200.\
        # If you do not specify this parameter or you set this parameter to 0, Internet access is disabled.
        self.bandwidth = bandwidth
        # The ID of the CEN instance.
        self.cen_id = cen_id
        # The ID of the Alibaba Cloud account to which the Cloud Enterprise Network (CEN) instance belongs.
        # 
        # *   If you do not specify CenId or the CEN instance that is specified by CenId belongs to the current Alibaba Cloud account, leave this parameter empty.
        # *   If you specify CenId and the CEN instance that is specified by CenId belongs to another Alibaba Cloud account, enter the ID of the Alibaba Cloud account.
        self.cen_owner_id = cen_owner_id
        # The IPv4 CIDR block in the secure office network of the workspace. The IPv4 CIDR block that the system uses to create a virtual private cloud (VPC) for the workspace. We recommend that you set the IPv4 CIDR block to 10.0.0.0/12, 172.16.0.0/12, 192.168.0.0/16, or a subnet of these CIDR blocks. If you set the IPv4 CIDR block to 10.0.0.0/12 or 172.16.0.0/12, the mask is 1224 bits in length. If you set the IPv4 CIDR block to 192.168.0.0/16, the mask is 1624 bits in length.
        self.cidr_block = cidr_block
        # The connection method that is used to connect clients to cloud desktops. Valid values:
        # 
        # *   Internet: connects clients to cloud desktops only over the Internet.
        # *   VPC: connects clients to cloud desktops only over a VPC.
        # *   Any: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method based on your business requirements when you connect to your cloud desktop from a client.
        # 
        # Default value: Internet
        # 
        # > VPC connections are established by using Alibaba Cloud PrivateLink. You can use PrivateLink free of charge. If you set this parameter to VPC or Any, PrivateLink is automatically activated.
        self.desktop_access_type = desktop_access_type
        # The IP address of the DNS server of the enterprise AD system. You can specify only one IP address.
        self.dns_address = dns_address
        # The domain name of the enterprise AD system. You can register each domain name only once.
        self.domain_name = domain_name
        # The password of the domain administrator. The password can be up to 64 characters in length.
        self.domain_password = domain_password
        # The username of the domain administrator. The username can be up to 64 characters in length.
        # 
        # > Specify the username by using sAMAccountName instead of userPrincipalName.
        self.domain_user_name = domain_user_name
        # Specifies whether to grant the permissions of the local administrator to end users of the cloud desktops that belong to the workspace. Default value: `true`
        self.enable_admin_access = enable_admin_access
        # Specifies whether to enable Internet access.
        self.enable_internet_access = enable_internet_access
        # Specifies whether to enable multi-factor authentication (MFA).
        self.mfa_enabled = mfa_enabled
        # The name of the workspace. The name must be 2 to 255 characters in length. The name must start with a letter but cannot start with `http://` or `https://`. The name can contain letters, digits, colons (:), underscores (\_), and hyphens (-).\
        # Default value: null
        self.office_site_name = office_site_name
        # The type of the protocol. Set the value to ASP.
        self.protocol_type = protocol_type
        # The region ID of the workspace.
        self.region_id = region_id
        # The type of the AD connector.
        # 
        # *   1: General
        # *   2: Advanced
        self.specification = specification
        # The DNS address of the enterprise AD subdomain. If you specify `SubDomainName` but do not specify this parameter, the DNS address of the subdomain is the same as the DNS address of the parent domain.
        self.sub_domain_dns_address = sub_domain_dns_address
        # The domain name of the enterprise AD subdomain.
        self.sub_domain_name = sub_domain_name
        # The verification code. If the CEN instance that is specified by CenId belongs to another Alibaba Cloud account, you must call the SendVerifyCode operation to obtain the verification code.
        self.verify_code = verify_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_hostname is not None:
            result['AdHostname'] = self.ad_hostname
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_owner_id is not None:
            result['CenOwnerId'] = self.cen_owner_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.desktop_access_type is not None:
            result['DesktopAccessType'] = self.desktop_access_type
        if self.dns_address is not None:
            result['DnsAddress'] = self.dns_address
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_password is not None:
            result['DomainPassword'] = self.domain_password
        if self.domain_user_name is not None:
            result['DomainUserName'] = self.domain_user_name
        if self.enable_admin_access is not None:
            result['EnableAdminAccess'] = self.enable_admin_access
        if self.enable_internet_access is not None:
            result['EnableInternetAccess'] = self.enable_internet_access
        if self.mfa_enabled is not None:
            result['MfaEnabled'] = self.mfa_enabled
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.sub_domain_dns_address is not None:
            result['SubDomainDnsAddress'] = self.sub_domain_dns_address
        if self.sub_domain_name is not None:
            result['SubDomainName'] = self.sub_domain_name
        if self.verify_code is not None:
            result['VerifyCode'] = self.verify_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdHostname') is not None:
            self.ad_hostname = m.get('AdHostname')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenOwnerId') is not None:
            self.cen_owner_id = m.get('CenOwnerId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('DesktopAccessType') is not None:
            self.desktop_access_type = m.get('DesktopAccessType')
        if m.get('DnsAddress') is not None:
            self.dns_address = m.get('DnsAddress')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainPassword') is not None:
            self.domain_password = m.get('DomainPassword')
        if m.get('DomainUserName') is not None:
            self.domain_user_name = m.get('DomainUserName')
        if m.get('EnableAdminAccess') is not None:
            self.enable_admin_access = m.get('EnableAdminAccess')
        if m.get('EnableInternetAccess') is not None:
            self.enable_internet_access = m.get('EnableInternetAccess')
        if m.get('MfaEnabled') is not None:
            self.mfa_enabled = m.get('MfaEnabled')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('SubDomainDnsAddress') is not None:
            self.sub_domain_dns_address = m.get('SubDomainDnsAddress')
        if m.get('SubDomainName') is not None:
            self.sub_domain_name = m.get('SubDomainName')
        if m.get('VerifyCode') is not None:
            self.verify_code = m.get('VerifyCode')
        return self


class CreateADConnectorOfficeSiteResponseBody(TeaModel):
    def __init__(
        self,
        office_site_id: str = None,
        request_id: str = None,
    ):
        # The ID of the workspace.
        self.office_site_id = office_site_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateADConnectorOfficeSiteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateADConnectorOfficeSiteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateADConnectorOfficeSiteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAndBindNasFileSystemRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        desktop_group_id: str = None,
        encrypt_type: int = None,
        end_user_ids: List[str] = None,
        file_system_name: str = None,
        office_site_id: str = None,
        region_id: str = None,
        storage_type: str = None,
    ):
        self.description = description
        self.desktop_group_id = desktop_group_id
        self.encrypt_type = encrypt_type
        self.end_user_ids = end_user_ids
        self.file_system_name = file_system_name
        self.office_site_id = office_site_id
        self.region_id = region_id
        self.storage_type = storage_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.encrypt_type is not None:
            result['EncryptType'] = self.encrypt_type
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.file_system_name is not None:
            result['FileSystemName'] = self.file_system_name
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('EncryptType') is not None:
            self.encrypt_type = m.get('EncryptType')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('FileSystemName') is not None:
            self.file_system_name = m.get('FileSystemName')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class CreateAndBindNasFileSystemResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAndBindNasFileSystemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAndBindNasFileSystemResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAndBindNasFileSystemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        cron_expression: str = None,
        policy_name: str = None,
        region_id: str = None,
        retention_days: int = None,
    ):
        # The CRON expression for periodic scheduling.
        self.cron_expression = cron_expression
        # The name of the automatic snapshot policy.
        self.policy_name = policy_name
        # The ID of the region where the automatic snapshot policy is created. You can call the [DescribeRegions](~~25609~~) operation to query the most recent region list.
        self.region_id = region_id
        # The retention period of automatic snapshots. Unit: days. Valid values:
        # 
        # *   \-1: Automatic snapshots are retained until they are deleted.
        # *   1 to 65536: Automatic snapshots are retained for the specified number of days.
        self.retention_days = retention_days

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.retention_days is not None:
            result['RetentionDays'] = self.retention_days
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RetentionDays') is not None:
            self.retention_days = m.get('RetentionDays')
        return self


class CreateAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        policy_id: str = None,
        request_id: str = None,
    ):
        # The ID of the automatic snapshot policy.
        self.policy_id = policy_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBundleRequest(TeaModel):
    def __init__(
        self,
        bundle_name: str = None,
        description: str = None,
        desktop_type: str = None,
        image_id: str = None,
        language: str = None,
        region_id: str = None,
        root_disk_performance_level: str = None,
        root_disk_size_gib: int = None,
        user_disk_performance_level: str = None,
        user_disk_size_gib: List[int] = None,
    ):
        # The name of the desktop template.
        self.bundle_name = bundle_name
        # The description of the desktop template.
        self.description = description
        # The language of the OS. This parameter is available only for system images. Valid values:
        # 
        # *   zh-CN: Simplified Chinese
        # *   zh-HK: Traditional Chinese (Hong Kong)
        # *   en-US: English
        # *   ja-JP: Japanese
        self.desktop_type = desktop_type
        # The type of the cloud desktop. You can call the DescribeBundles operation to query the cloud desktop templates and obtain the supported desktop type from the value of the DesktopType parameter.
        # 
        # >  You can select GPU-accelerated desktop types only when you use GPU-accelerated images.
        self.image_id = image_id
        # The performance level (PL) of the system disk. If the cloud desktop type is Graphics or High Frequency, you can set the PL of the system disk. Valid values:
        # 
        # *   PL0
        # *   PL1
        # *   PL2
        # *   PL3
        # 
        # For more information about the differences between disks at different PLs, see [Enhanced SSDs](~~122389~~).
        self.language = language
        # The size of data disk N. You can configure only one data disk. Unit: GiB.
        # 
        # The value of this parameter must be consistent with the data disk size supported by the cloud desktop type. For more information, see [Cloud desktop types](~~188609~~).
        # 
        # >  The value of the UserDiskSizeGib parameter in the template must be greater than that of the DataDiskSize parameter in the image.
        self.region_id = region_id
        # The size of the system disk. Unit: GiB.
        # 
        # The value of this parameter must be consistent with the system disk size supported by the cloud desktop type. For more information, see [Cloud desktop types](~~188609~~).
        self.root_disk_performance_level = root_disk_performance_level
        # The operation that you want to perform. Set the value to **CreateBundle**.
        self.root_disk_size_gib = root_disk_size_gib
        # The ID of the request.
        self.user_disk_performance_level = user_disk_performance_level
        self.user_disk_size_gib = user_disk_size_gib

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_name is not None:
            result['BundleName'] = self.bundle_name
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.language is not None:
            result['Language'] = self.language
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.root_disk_performance_level is not None:
            result['RootDiskPerformanceLevel'] = self.root_disk_performance_level
        if self.root_disk_size_gib is not None:
            result['RootDiskSizeGib'] = self.root_disk_size_gib
        if self.user_disk_performance_level is not None:
            result['UserDiskPerformanceLevel'] = self.user_disk_performance_level
        if self.user_disk_size_gib is not None:
            result['UserDiskSizeGib'] = self.user_disk_size_gib
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleName') is not None:
            self.bundle_name = m.get('BundleName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RootDiskPerformanceLevel') is not None:
            self.root_disk_performance_level = m.get('RootDiskPerformanceLevel')
        if m.get('RootDiskSizeGib') is not None:
            self.root_disk_size_gib = m.get('RootDiskSizeGib')
        if m.get('UserDiskPerformanceLevel') is not None:
            self.user_disk_performance_level = m.get('UserDiskPerformanceLevel')
        if m.get('UserDiskSizeGib') is not None:
            self.user_disk_size_gib = m.get('UserDiskSizeGib')
        return self


class CreateBundleResponseBody(TeaModel):
    def __init__(
        self,
        bundle_id: str = None,
        request_id: str = None,
    ):
        self.bundle_id = bundle_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBundleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateBundleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBundleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCdsFileRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        conflict_policy: str = None,
        end_user_id: str = None,
        file_hash: str = None,
        file_length: int = None,
        file_name: str = None,
        file_type: str = None,
        parent_file_id: str = None,
        region_id: str = None,
    ):
        # The ID of the cloud disk.
        self.cds_id = cds_id
        # The policy that is used when the file that you want to upload has the same name as an existing file in the cloud disk.
        # 
        # Valid values:
        # 
        # *   refuse
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     denies creating the file
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   auto_rename
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     automatically renames the file
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   ignore
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     allows the file to use the same name as the existing file in the cloud disk
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   over_write
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     overwrites the existing file in the cloud disk
        # 
        #     <!-- -->
        # 
        #     .
        self.conflict_policy = conflict_policy
        # The user ID.
        self.end_user_id = end_user_id
        # The hash value of the SHA1 algorithm that is used by the file.
        self.file_hash = file_hash
        # The file size. Unit: bytes.
        self.file_length = file_length
        # The file name.
        self.file_name = file_name
        # The file type.
        # 
        # Valid values:
        # 
        # *   file
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   folder
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.file_type = file_type
        # The ID of the parent folder.
        self.parent_file_id = parent_file_id
        # The region ID.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.conflict_policy is not None:
            result['ConflictPolicy'] = self.conflict_policy
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.file_hash is not None:
            result['FileHash'] = self.file_hash
        if self.file_length is not None:
            result['FileLength'] = self.file_length
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.parent_file_id is not None:
            result['ParentFileId'] = self.parent_file_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('ConflictPolicy') is not None:
            self.conflict_policy = m.get('ConflictPolicy')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('FileHash') is not None:
            self.file_hash = m.get('FileHash')
        if m.get('FileLength') is not None:
            self.file_length = m.get('FileLength')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('ParentFileId') is not None:
            self.parent_file_id = m.get('ParentFileId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateCdsFileResponseBodyFileModel(TeaModel):
    def __init__(
        self,
        file_id: str = None,
        upload_id: str = None,
        upload_url: str = None,
    ):
        self.file_id = file_id
        self.upload_id = upload_id
        self.upload_url = upload_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.upload_id is not None:
            result['UploadId'] = self.upload_id
        if self.upload_url is not None:
            result['UploadUrl'] = self.upload_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('UploadId') is not None:
            self.upload_id = m.get('UploadId')
        if m.get('UploadUrl') is not None:
            self.upload_url = m.get('UploadUrl')
        return self


class CreateCdsFileResponseBody(TeaModel):
    def __init__(
        self,
        file_model: CreateCdsFileResponseBodyFileModel = None,
        request_id: str = None,
    ):
        self.file_model = file_model
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.file_model:
            self.file_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_model is not None:
            result['FileModel'] = self.file_model.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileModel') is not None:
            temp_model = CreateCdsFileResponseBodyFileModel()
            self.file_model = temp_model.from_map(m['FileModel'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCdsFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCdsFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCdsFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCdsFileShareLinkRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        description: str = None,
        disable_download: bool = None,
        disable_preview: bool = None,
        disable_save: bool = None,
        download_limit: int = None,
        end_user_id: str = None,
        expiration: str = None,
        file_ids: List[str] = None,
        preview_limit: int = None,
        save_limit: int = None,
        share_name: str = None,
        share_pwd: str = None,
    ):
        # The ID of the cloud disk.
        self.cds_id = cds_id
        # The description of the file sharing task. The description must be 0 to 1,024 characters in length.
        self.description = description
        # Specifies whether to prohibit the download of the files that are being shared.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     prohibits file download
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     allows file download
        # 
        #     <!-- -->
        # 
        #     .
        self.disable_download = disable_download
        # Specifies whether to prohibit the preview of the files that are being shared.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     prohibits file preview
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     allows file preview
        # 
        #     <!-- -->
        # 
        #     .
        self.disable_preview = disable_preview
        # Specifies whether to prohibit the dump of the files that are being shared.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     prohibits file dump
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     allows file dump
        # 
        #     <!-- -->
        # 
        #     .
        self.disable_save = disable_save
        # The limit on the number of times that the shared files can be downloaded. The value of this parameter must be equal to or greater than 0. The value 0 specifies that no limit is imposed on the number of times that the shared files can be downloaded.
        self.download_limit = download_limit
        # The ID of the end user.
        self.end_user_id = end_user_id
        # The time when the file sharing link expires. The value of this parameter follows the RFC 3339 standard. Example: "2020-06-28T11:33:00.000+08:00". If this parameter is set to "", the file sharing link never expires.
        self.expiration = expiration
        # The file IDs.
        self.file_ids = file_ids
        # The limit on the number of times that the shared files can be previewed. The value of this parameter must be equal to or greater than 0. The value 0 specifies that no limit is imposed on the number of times that the shared files can be previewed.
        self.preview_limit = preview_limit
        # The limit on the number of times that the shared files can be dumped. The value of this parameter must be equal to or greater than 0. The value 0 specifies that no limit is imposed on the number of times that the shared files can be dumped.
        self.save_limit = save_limit
        # The name of the file sharing task. If you leave this parameter empty, the file name that corresponds to the first ID in the file ID list is used. The name must be 0 to 128 characters in length.
        self.share_name = share_name
        # The length of the access code. Valid values: 6 to 8. Unit: bytes. If you leave this parameter empty or set it to null, no access code is required. If you use a token to share files, you do not need to configure this parameter. The access code can contain only visible ASCII characters.
        self.share_pwd = share_pwd

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.description is not None:
            result['Description'] = self.description
        if self.disable_download is not None:
            result['DisableDownload'] = self.disable_download
        if self.disable_preview is not None:
            result['DisablePreview'] = self.disable_preview
        if self.disable_save is not None:
            result['DisableSave'] = self.disable_save
        if self.download_limit is not None:
            result['DownloadLimit'] = self.download_limit
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.expiration is not None:
            result['Expiration'] = self.expiration
        if self.file_ids is not None:
            result['FileIds'] = self.file_ids
        if self.preview_limit is not None:
            result['PreviewLimit'] = self.preview_limit
        if self.save_limit is not None:
            result['SaveLimit'] = self.save_limit
        if self.share_name is not None:
            result['ShareName'] = self.share_name
        if self.share_pwd is not None:
            result['SharePwd'] = self.share_pwd
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisableDownload') is not None:
            self.disable_download = m.get('DisableDownload')
        if m.get('DisablePreview') is not None:
            self.disable_preview = m.get('DisablePreview')
        if m.get('DisableSave') is not None:
            self.disable_save = m.get('DisableSave')
        if m.get('DownloadLimit') is not None:
            self.download_limit = m.get('DownloadLimit')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('Expiration') is not None:
            self.expiration = m.get('Expiration')
        if m.get('FileIds') is not None:
            self.file_ids = m.get('FileIds')
        if m.get('PreviewLimit') is not None:
            self.preview_limit = m.get('PreviewLimit')
        if m.get('SaveLimit') is not None:
            self.save_limit = m.get('SaveLimit')
        if m.get('ShareName') is not None:
            self.share_name = m.get('ShareName')
        if m.get('SharePwd') is not None:
            self.share_pwd = m.get('SharePwd')
        return self


class CreateCdsFileShareLinkResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CdsFileShareLinkModel = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The operation result. The value success indicates that the operation is successful. If the operation failed, an error message is returned.
        self.code = code
        # The data information.
        self.data = data
        # The error message that is returned. This parameter is not returned if the value of Code is success.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request is successful.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CdsFileShareLinkModel()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateCdsFileShareLinkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCdsFileShareLinkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCdsFileShareLinkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCloudDriveUsersRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: List[str] = None,
        region_id: str = None,
        user_max_size: int = None,
    ):
        # The ID of the cloud disk.
        self.cds_id = cds_id
        # The IDs of the end users.
        self.end_user_id = end_user_id
        # The region ID.
        self.region_id = region_id
        # The maximum storage space of an end user. Unit: bytes.
        self.user_max_size = user_max_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.user_max_size is not None:
            result['UserMaxSize'] = self.user_max_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UserMaxSize') is not None:
            self.user_max_size = m.get('UserMaxSize')
        return self


class CreateCloudDriveUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCloudDriveUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCloudDriveUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCloudDriveUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDesktopGroupRequest(TeaModel):
    def __init__(
        self,
        all_classify_users: bool = None,
        allow_auto_setup: int = None,
        allow_buffer_count: int = None,
        auto_pay: bool = None,
        auto_renew: bool = None,
        bind_amount: int = None,
        bundle_id: str = None,
        buy_desktops_count: int = None,
        charge_type: str = None,
        classify: str = None,
        client_token: str = None,
        comments: str = None,
        connect_duration: int = None,
        default_init_desktop_count: int = None,
        desktop_group_name: str = None,
        directory_id: str = None,
        end_user_ids: List[str] = None,
        file_system_id: str = None,
        group_version: int = None,
        idle_disconnect_duration: int = None,
        keep_duration: int = None,
        load_policy: int = None,
        max_desktops_count: int = None,
        min_desktops_count: int = None,
        office_site_id: str = None,
        own_type: int = None,
        period: int = None,
        period_unit: str = None,
        policy_group_id: str = None,
        profile_follow_switch: bool = None,
        ratio_threshold: float = None,
        region_id: str = None,
        reset_type: int = None,
        scale_strategy_id: str = None,
        stop_duration: int = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
        vpc_id: str = None,
    ):
        # The end users whom you want to add to all types of desktop groups.
        self.all_classify_users = all_classify_users
        # Specifies whether to automatically create cloud desktops in the desktop group if you set the billing method to subscription. If you set the ChargeType parameter to PrePaid, this parameter is required.
        self.allow_auto_setup = allow_auto_setup
        # Specifies whether to reserve cloud desktops if you set the billing method to pay-as-you-go. If you set the ChargeType parameter to PostPaid, this parameter is required. Valid values: 0: does not allow the system to reserve cloud desktops. N: allows the system to reserve N cloud desktops. The variable N must be an integer that ranges from 1 to 100.
        self.allow_buffer_count = allow_buffer_count
        # Specifies whether to enable automatic payment.
        self.auto_pay = auto_pay
        # 是否自动续费。
        self.auto_renew = auto_renew
        # The number of sessions that are allowed per cloud desktop in a multi-session desktop group.
        self.bind_amount = bind_amount
        # The ID of the desktop template.
        self.bundle_id = bundle_id
        # The number of cloud desktops that you want to purchase. Valid values: 0 to 200.
        self.buy_desktops_count = buy_desktops_count
        # The billing method of the cloud desktops in the desktop group.
        self.charge_type = charge_type
        # The type of the desktop group.
        self.classify = classify
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see [How to ensure idempotence](~~25693~~).
        self.client_token = client_token
        # The remarks on the desktop group.
        self.comments = comments
        # The maximum period of time during which the session is connected. When the specified maximum period of time is reached, the session automatically disconnects. Unit: milliseconds. This parameter is required only for cloud desktops in the same desktop group.
        self.connect_duration = connect_duration
        # The default number of cloud desktops to create when you create the desktop group. Default value: 1.
        self.default_init_desktop_count = default_init_desktop_count
        # The name of the desktop group.
        self.desktop_group_name = desktop_group_name
        # The ID of the directory.
        self.directory_id = directory_id
        # The end users that can use the desktop group.
        self.end_user_ids = end_user_ids
        # The Apsara File Storage NAS (NAS) file system that is used after data roaming is enabled.
        self.file_system_id = file_system_id
        # 桌面组版本。
        self.group_version = group_version
        # The maximum period of time for which a session remains idle. If an end user performs no operations on a cloud desktop by using keyboards or mouses during a session, the session becomes idle. When the specified maximum period of time is reached, the session automatically disconnects. Unit: milliseconds. This parameter is required only for cloud desktops in the same desktop group.
        self.idle_disconnect_duration = idle_disconnect_duration
        # The retention period of the cloud desktop after the end user disconnects from the cloud desktop. Unit: milliseconds.
        self.keep_duration = keep_duration
        # The load balancing policy of the multi-session desktop group.
        self.load_policy = load_policy
        # The maximum number of cloud desktops that the desktop group can contain. Valid values: 0 to 200.
        self.max_desktops_count = max_desktops_count
        # The minimum number of cloud desktops that must be contained in the desktop group if you set the billing method to subscription. If you set the ChargeType parameter to PrePaid, this parameter is required. Valid values: 0 to the value of MaxDesktopsCount. Default value: 1.
        self.min_desktops_count = min_desktops_count
        # The ID of the workspace.
        self.office_site_id = office_site_id
        # The type of the desktop group.
        self.own_type = own_type
        # The subscription period of the cloud desktops in the desktop group. The unit is specified by the PeriodUnit parameter. The Period parameter takes effect only if you set the ChargeType parameter to PrePaid.
        # 
        # *   Valid values if you set the PeriodUnit parameter to Month:
        # 
        #     *   1
        #     *   2
        #     *   3
        #     *   6
        # 
        # *   Valid values if you set the PeriodUnit parameter to Year:
        # 
        #     *   1
        #     *   2
        #     *   3
        #     *   4
        #     *   5
        self.period = period
        # The unit of the subscription duration.
        self.period_unit = period_unit
        # The ID of the policy.
        self.policy_group_id = policy_group_id
        # Specifies whether to enable data roaming.
        self.profile_follow_switch = profile_follow_switch
        # The threshold for the ratio of connected sessions. This parameter is the condition that triggers auto scaling in a multi-session desktop group. `Ratio of connected sessions = Number of connected sessions/(Total number of cloud desktops × Maximum number of sessions allowed for each cloud desktop) × 100%`. When the specified threshold is reached, new cloud desktops are automatically created. When the specified threshold is not reached, idle cloud desktops are released.
        self.ratio_threshold = ratio_threshold
        # The ID of the region.
        self.region_id = region_id
        # Specifies which type of the disk to reset for cloud desktops in the desktop group.
        self.reset_type = reset_type
        # The ID of the scaling policy.
        # 
        # > This parameter is unavailable.
        self.scale_strategy_id = scale_strategy_id
        # The period of time before the idle cloud desktop is stopped. When the specified period of time is reached, the idle cloud desktop automatically stops. If an end user connects to a stopped cloud desktop, the cloud desktop automatically starts. Unit: milliseconds.
        self.stop_duration = stop_duration
        # Specifies whether to enable disk encryption.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that you want to use when disk encryption is enabled. You can call the [ListKeys](~~28951~~) operation to obtain a list of KMS keys.
        self.volume_encryption_key = volume_encryption_key
        # The ID of the virtual private cloud (VPC) in which you want to create the desktop group.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_classify_users is not None:
            result['AllClassifyUsers'] = self.all_classify_users
        if self.allow_auto_setup is not None:
            result['AllowAutoSetup'] = self.allow_auto_setup
        if self.allow_buffer_count is not None:
            result['AllowBufferCount'] = self.allow_buffer_count
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.bind_amount is not None:
            result['BindAmount'] = self.bind_amount
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.buy_desktops_count is not None:
            result['BuyDesktopsCount'] = self.buy_desktops_count
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.classify is not None:
            result['Classify'] = self.classify
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.comments is not None:
            result['Comments'] = self.comments
        if self.connect_duration is not None:
            result['ConnectDuration'] = self.connect_duration
        if self.default_init_desktop_count is not None:
            result['DefaultInitDesktopCount'] = self.default_init_desktop_count
        if self.desktop_group_name is not None:
            result['DesktopGroupName'] = self.desktop_group_name
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.group_version is not None:
            result['GroupVersion'] = self.group_version
        if self.idle_disconnect_duration is not None:
            result['IdleDisconnectDuration'] = self.idle_disconnect_duration
        if self.keep_duration is not None:
            result['KeepDuration'] = self.keep_duration
        if self.load_policy is not None:
            result['LoadPolicy'] = self.load_policy
        if self.max_desktops_count is not None:
            result['MaxDesktopsCount'] = self.max_desktops_count
        if self.min_desktops_count is not None:
            result['MinDesktopsCount'] = self.min_desktops_count
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.own_type is not None:
            result['OwnType'] = self.own_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.profile_follow_switch is not None:
            result['ProfileFollowSwitch'] = self.profile_follow_switch
        if self.ratio_threshold is not None:
            result['RatioThreshold'] = self.ratio_threshold
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.reset_type is not None:
            result['ResetType'] = self.reset_type
        if self.scale_strategy_id is not None:
            result['ScaleStrategyId'] = self.scale_strategy_id
        if self.stop_duration is not None:
            result['StopDuration'] = self.stop_duration
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllClassifyUsers') is not None:
            self.all_classify_users = m.get('AllClassifyUsers')
        if m.get('AllowAutoSetup') is not None:
            self.allow_auto_setup = m.get('AllowAutoSetup')
        if m.get('AllowBufferCount') is not None:
            self.allow_buffer_count = m.get('AllowBufferCount')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('BindAmount') is not None:
            self.bind_amount = m.get('BindAmount')
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('BuyDesktopsCount') is not None:
            self.buy_desktops_count = m.get('BuyDesktopsCount')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Classify') is not None:
            self.classify = m.get('Classify')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Comments') is not None:
            self.comments = m.get('Comments')
        if m.get('ConnectDuration') is not None:
            self.connect_duration = m.get('ConnectDuration')
        if m.get('DefaultInitDesktopCount') is not None:
            self.default_init_desktop_count = m.get('DefaultInitDesktopCount')
        if m.get('DesktopGroupName') is not None:
            self.desktop_group_name = m.get('DesktopGroupName')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('GroupVersion') is not None:
            self.group_version = m.get('GroupVersion')
        if m.get('IdleDisconnectDuration') is not None:
            self.idle_disconnect_duration = m.get('IdleDisconnectDuration')
        if m.get('KeepDuration') is not None:
            self.keep_duration = m.get('KeepDuration')
        if m.get('LoadPolicy') is not None:
            self.load_policy = m.get('LoadPolicy')
        if m.get('MaxDesktopsCount') is not None:
            self.max_desktops_count = m.get('MaxDesktopsCount')
        if m.get('MinDesktopsCount') is not None:
            self.min_desktops_count = m.get('MinDesktopsCount')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OwnType') is not None:
            self.own_type = m.get('OwnType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('ProfileFollowSwitch') is not None:
            self.profile_follow_switch = m.get('ProfileFollowSwitch')
        if m.get('RatioThreshold') is not None:
            self.ratio_threshold = m.get('RatioThreshold')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResetType') is not None:
            self.reset_type = m.get('ResetType')
        if m.get('ScaleStrategyId') is not None:
            self.scale_strategy_id = m.get('ScaleStrategyId')
        if m.get('StopDuration') is not None:
            self.stop_duration = m.get('StopDuration')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateDesktopGroupResponseBody(TeaModel):
    def __init__(
        self,
        desktop_group_id: str = None,
        order_ids: List[str] = None,
        request_id: str = None,
    ):
        # The ID of the desktop group.
        self.desktop_group_id = desktop_group_id
        # The IDs of the orders.
        self.order_ids = order_ids
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.order_ids is not None:
            result['OrderIds'] = self.order_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('OrderIds') is not None:
            self.order_ids = m.get('OrderIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDesktopGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDesktopGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDesktopGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDesktopsRequestBundleModels(TeaModel):
    def __init__(
        self,
        amount: int = None,
        bundle_id: str = None,
        desktop_name: str = None,
        end_user_ids: List[str] = None,
        hostname: str = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
    ):
        # The number of cloud desktops that you want to create. Valid values: 1 to 300. Default value: 0.
        self.amount = amount
        # The ID of the desktop template.
        self.bundle_id = bundle_id
        # The name of the cloud desktop.
        self.desktop_name = desktop_name
        # The users to whom you want to assign the cloud desktops.
        self.end_user_ids = end_user_ids
        # The hostname that you specify for the cloud desktop. You can only specify the hostname of a Windows cloud desktop in the workspace of the enterprise AD account type.
        # 
        # The hostname must meet the following requirements:
        # 
        # *   It must be 2 to 15 characters in length.
        # *   It can contain letters, digits, and hyphens (-). The hostname cannot start or end with a hyphen (-), contain consecutive hyphens (-), or contain only digits.
        # 
        # If you create multiple cloud desktops, you can use the`  name_prefix[begin_number,bits]name_suffix ` format to determine the hostnames of the cloud desktops. For example, if you set Hostname to ecd-\[1,4]-test, the hostname of the first cloud desktop is ecd-0001-test and the hostname of the second cloud desktop is ecd-0002-test. Other hostnames follow the same rule.
        # 
        # *   `name_prefix`: the prefix of the hostname.
        # *   `[begin_number,bits]`: the ordered numbers in the hostname. begin_number: the start number. Valid values: 0 to 999999. Default value: 0. bits: the digit. Valid values: 1 to 6. Default value: 6.
        # *   `name_suffix`: the suffix of the hostname.
        self.hostname = hostname
        # Specifies whether to enable disk encryption.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that you want to use when disk encryption is enabled. You can call the [ListKeys](~~28951~~) operation to obtain a list of KMS keys.
        self.volume_encryption_key = volume_encryption_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        return self


class CreateDesktopsRequestDesktopTimers(TeaModel):
    def __init__(
        self,
        allow_client_setting: bool = None,
        cron_expression: str = None,
        enforce: bool = None,
        interval: int = None,
        operation_type: str = None,
        reset_type: str = None,
        timer_type: str = None,
    ):
        self.allow_client_setting = allow_client_setting
        self.cron_expression = cron_expression
        self.enforce = enforce
        self.interval = interval
        self.operation_type = operation_type
        self.reset_type = reset_type
        self.timer_type = timer_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_client_setting is not None:
            result['AllowClientSetting'] = self.allow_client_setting
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.enforce is not None:
            result['Enforce'] = self.enforce
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.reset_type is not None:
            result['ResetType'] = self.reset_type
        if self.timer_type is not None:
            result['TimerType'] = self.timer_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowClientSetting') is not None:
            self.allow_client_setting = m.get('AllowClientSetting')
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('Enforce') is not None:
            self.enforce = m.get('Enforce')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        if m.get('ResetType') is not None:
            self.reset_type = m.get('ResetType')
        if m.get('TimerType') is not None:
            self.timer_type = m.get('TimerType')
        return self


class CreateDesktopsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag. You can specify 1 to 20 keys for a tag.
        self.key = key
        # The value of the tag. You can specify 1 to 20 values for a tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDesktopsRequestUserCommands(TeaModel):
    def __init__(
        self,
        content: str = None,
        content_encoding: str = None,
        content_type: str = None,
    ):
        # The content of the command.
        self.content = content
        # The encoding mode of the command content (CommandContent).
        self.content_encoding = content_encoding
        # The language type of the command.
        self.content_type = content_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentEncoding') is not None:
            self.content_encoding = m.get('ContentEncoding')
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        return self


class CreateDesktopsRequest(TeaModel):
    def __init__(
        self,
        amount: int = None,
        auto_pay: bool = None,
        auto_renew: bool = None,
        bundle_id: str = None,
        bundle_models: List[CreateDesktopsRequestBundleModels] = None,
        charge_type: str = None,
        desktop_name: str = None,
        desktop_name_suffix: bool = None,
        desktop_timers: List[CreateDesktopsRequestDesktopTimers] = None,
        directory_id: str = None,
        end_user_id: List[str] = None,
        group_id: str = None,
        hostname: str = None,
        office_site_id: str = None,
        period: int = None,
        period_unit: str = None,
        policy_group_id: str = None,
        promotion_id: str = None,
        region_id: str = None,
        tag: List[CreateDesktopsRequestTag] = None,
        user_assign_mode: str = None,
        user_commands: List[CreateDesktopsRequestUserCommands] = None,
        user_name: str = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
        vpc_id: str = None,
    ):
        # The number of cloud desktops that you want to create. Valid values: 1 to 300. Default value: 1.
        self.amount = amount
        # Specifies whether to enable automatic payment.
        self.auto_pay = auto_pay
        # Specifies whether to enable auto-renewal. This parameter takes effect only when the ChargeType parameter is set to PrePaid.````
        self.auto_renew = auto_renew
        # The ID of the desktop template.
        self.bundle_id = bundle_id
        # The desktop templates that you want to use.
        self.bundle_models = bundle_models
        # The billing method of the cloud desktop.
        self.charge_type = charge_type
        # The name of the cloud desktop. The name must meet the following requirements:
        # 
        # *   The name must be 1 to 64 characters in length.
        # *   The name can contain letters, digits, colons (:), underscores (\_), periods (.), and hyphens (-). It must start with a letter but cannot start with http:// or https://.
        self.desktop_name = desktop_name
        # Specifies whether to automatically add a suffix to the cloud desktop name when you create multiple cloud desktops at a time.
        self.desktop_name_suffix = desktop_name_suffix
        self.desktop_timers = desktop_timers
        # This parameter is not available.
        self.directory_id = directory_id
        # The IDs of the users that you want to authorize to use the cloud desktop. The cloud desktop is assigned to the users. You can specify IDs of 1 to 100 users.
        # 
        # *   Only one user can use the cloud desktop at a time.
        # *   If you do not specify the `EndUserId` parameter, the cloud desktop that you create is not assigned to users.
        self.end_user_id = end_user_id
        # The ID of the desktop group.
        self.group_id = group_id
        # The hostname that you specify for the cloud desktop. You can specify only the hostname of a Windows cloud desktop in the workspace of the enterprise AD account type.
        # 
        # The hostname must meet the following requirements:
        # 
        # *   It must be 2 to 15 characters in length.
        # *   It can contain letters, digits, and hyphens (-). The hostname cannot start or end with a hyphen (-), contain consecutive hyphens (-), or contain only digits.
        # 
        # If you create multiple cloud desktops, you can use the`  name_prefix[begin_number,bits]name_suffix ` format to determine the hostnames of the cloud desktops. For example, if you set Hostname to ecd-\[1,4]-test, the hostname of the first cloud desktop is ecd-0001-test and the hostname of the second cloud desktop is ecd-0002-test. Other hostnames follow the same rule.
        # 
        # *   `name_prefix`: the prefix of the hostname.
        # *   `[begin_number,bits]`: the ordered numbers in the hostname. begin_number: the start number. Valid values: 0 to 999999. Default value: 0. bits: the digit. Valid values: 1 to 6. Default value: 6.
        # *   `name_suffix`: the suffix of the hostname.
        self.hostname = hostname
        # The ID of the workspace.
        self.office_site_id = office_site_id
        # The subscription duration of the cloud desktop that you want to create. The unit is specified by the `PeriodUnit` parameter. This parameter takes effect and is required only when the `ChargeType` parameter is set to `PrePaid`.
        # 
        # *   Valid values if the `PeriodUnit` parameter is set to `Month`:
        # 
        #     *   1
        #     *   2
        #     *   3
        #     *   6
        # 
        # *   Valid values if the `PeriodUnit` parameter is set to `Year`:
        # 
        #     *   1
        #     *   2
        #     *   3
        #     *   4
        #     *   5
        self.period = period
        # The unit of the subscription duration.
        self.period_unit = period_unit
        # The ID of the policy.
        self.policy_group_id = policy_group_id
        # The ID of the sales promotion.
        self.promotion_id = promotion_id
        # The region ID. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id
        # The tags that you want to add to the cloud desktop.
        self.tag = tag
        # The assignment mode of the cloud desktop.
        # 
        # > If you do not specify the `EndUserId` parameter, the cloud desktop that you create is not assigned to users.
        self.user_assign_mode = user_assign_mode
        # The custom command scripts of the user.
        self.user_commands = user_commands
        # This parameter is not available.
        self.user_name = user_name
        # Specifies whether to enable disk encryption.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that you want to use when disk encryption is enabled. You can call the [ListKeys](~~28951~~) operation to obtain a list of KMS keys.
        self.volume_encryption_key = volume_encryption_key
        # This parameter is not available.
        self.vpc_id = vpc_id

    def validate(self):
        if self.bundle_models:
            for k in self.bundle_models:
                if k:
                    k.validate()
        if self.desktop_timers:
            for k in self.desktop_timers:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.user_commands:
            for k in self.user_commands:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        result['BundleModels'] = []
        if self.bundle_models is not None:
            for k in self.bundle_models:
                result['BundleModels'].append(k.to_map() if k else None)
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.desktop_name_suffix is not None:
            result['DesktopNameSuffix'] = self.desktop_name_suffix
        result['DesktopTimers'] = []
        if self.desktop_timers is not None:
            for k in self.desktop_timers:
                result['DesktopTimers'].append(k.to_map() if k else None)
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.promotion_id is not None:
            result['PromotionId'] = self.promotion_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.user_assign_mode is not None:
            result['UserAssignMode'] = self.user_assign_mode
        result['UserCommands'] = []
        if self.user_commands is not None:
            for k in self.user_commands:
                result['UserCommands'].append(k.to_map() if k else None)
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        self.bundle_models = []
        if m.get('BundleModels') is not None:
            for k in m.get('BundleModels'):
                temp_model = CreateDesktopsRequestBundleModels()
                self.bundle_models.append(temp_model.from_map(k))
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DesktopNameSuffix') is not None:
            self.desktop_name_suffix = m.get('DesktopNameSuffix')
        self.desktop_timers = []
        if m.get('DesktopTimers') is not None:
            for k in m.get('DesktopTimers'):
                temp_model = CreateDesktopsRequestDesktopTimers()
                self.desktop_timers.append(temp_model.from_map(k))
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('PromotionId') is not None:
            self.promotion_id = m.get('PromotionId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDesktopsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('UserAssignMode') is not None:
            self.user_assign_mode = m.get('UserAssignMode')
        self.user_commands = []
        if m.get('UserCommands') is not None:
            for k in m.get('UserCommands'):
                temp_model = CreateDesktopsRequestUserCommands()
                self.user_commands.append(temp_model.from_map(k))
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateDesktopsResponseBody(TeaModel):
    def __init__(
        self,
        desktop_id: List[str] = None,
        order_id: str = None,
        request_id: str = None,
    ):
        # If multiple cloud desktops are created in a call, the IDs of the cloud desktops are returned.
        self.desktop_id = desktop_id
        # The ID of the order.
        # 
        # > This parameter is returned only when you set the ChargeType parameter to PrePaid.
        self.order_id = order_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDesktopsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDesktopsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDesktopsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiskEncryptionServiceRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateDiskEncryptionServiceResponseBody(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.order_id = order_id
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDiskEncryptionServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDiskEncryptionServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDiskEncryptionServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImageRequest(TeaModel):
    def __init__(
        self,
        auto_clean_userdata: bool = None,
        description: str = None,
        desktop_id: str = None,
        disk_type: str = None,
        image_name: str = None,
        image_resource_type: str = None,
        region_id: str = None,
        snapshot_id: str = None,
        snapshot_ids: List[str] = None,
    ):
        self.auto_clean_userdata = auto_clean_userdata
        self.description = description
        self.desktop_id = desktop_id
        self.disk_type = disk_type
        self.image_name = image_name
        self.image_resource_type = image_resource_type
        self.region_id = region_id
        self.snapshot_id = snapshot_id
        self.snapshot_ids = snapshot_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_clean_userdata is not None:
            result['AutoCleanUserdata'] = self.auto_clean_userdata
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.image_resource_type is not None:
            result['ImageResourceType'] = self.image_resource_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.snapshot_ids is not None:
            result['SnapshotIds'] = self.snapshot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoCleanUserdata') is not None:
            self.auto_clean_userdata = m.get('AutoCleanUserdata')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ImageResourceType') is not None:
            self.image_resource_type = m.get('ImageResourceType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('SnapshotIds') is not None:
            self.snapshot_ids = m.get('SnapshotIds')
        return self


class CreateImageResponseBody(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        request_id: str = None,
    ):
        self.image_id = image_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNASFileSystemRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        encrypt_type: str = None,
        name: str = None,
        office_site_id: str = None,
        region_id: str = None,
        storage_type: str = None,
    ):
        self.description = description
        self.encrypt_type = encrypt_type
        self.name = name
        self.office_site_id = office_site_id
        self.region_id = region_id
        self.storage_type = storage_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.encrypt_type is not None:
            result['EncryptType'] = self.encrypt_type
        if self.name is not None:
            result['Name'] = self.name
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EncryptType') is not None:
            self.encrypt_type = m.get('EncryptType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class CreateNASFileSystemResponseBody(TeaModel):
    def __init__(
        self,
        file_system_id: str = None,
        file_system_name: str = None,
        mount_target_domain: str = None,
        office_site_id: str = None,
        request_id: str = None,
    ):
        self.file_system_id = file_system_id
        self.file_system_name = file_system_name
        self.mount_target_domain = mount_target_domain
        self.office_site_id = office_site_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.file_system_name is not None:
            result['FileSystemName'] = self.file_system_name
        if self.mount_target_domain is not None:
            result['MountTargetDomain'] = self.mount_target_domain
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('FileSystemName') is not None:
            self.file_system_name = m.get('FileSystemName')
        if m.get('MountTargetDomain') is not None:
            self.mount_target_domain = m.get('MountTargetDomain')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNASFileSystemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNASFileSystemResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNASFileSystemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkPackageRequest(TeaModel):
    def __init__(
        self,
        auto_pay: bool = None,
        auto_renew: bool = None,
        bandwidth: int = None,
        internet_charge_type: str = None,
        office_site_id: str = None,
        pay_type: str = None,
        period: int = None,
        period_unit: str = None,
        promotion_id: str = None,
        region_id: str = None,
    ):
        # Specifies whether to enable automatic payment.
        self.auto_pay = auto_pay
        # Specifies whether to enable auto-renewal.
        self.auto_renew = auto_renew
        # The maximum public bandwidth. Unit: Mbit/s.\
        # Valid values for the pay-by-data-transfer type (PayByTraffic): 10 to 200. Valid values for the pay-by-bandwith type (PayByBandwidth): 10 to 1000.
        self.bandwidth = bandwidth
        # The metering method of the pay-as-you-go Internet access package. Valid values: PayByTraffic: pay-by-data-transfer. PayByBandwidth: pay-by-bandwidth. Default value: PayByTraffic.
        self.internet_charge_type = internet_charge_type
        # The ID of the workspace.
        self.office_site_id = office_site_id
        # The billing method of the Internet access package.
        self.pay_type = pay_type
        # The duration of the Internet access package.
        self.period = period
        # The unit of duration that you want to use for the Internet access package.
        self.period_unit = period_unit
        # The ID of the sales promotion.
        self.promotion_id = promotion_id
        # The ID of the region.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.promotion_id is not None:
            result['PromotionId'] = self.promotion_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PromotionId') is not None:
            self.promotion_id = m.get('PromotionId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateNetworkPackageResponseBody(TeaModel):
    def __init__(
        self,
        network_package_id: str = None,
        order_id: str = None,
        request_id: str = None,
    ):
        # The ID of the Internet access package.
        self.network_package_id = network_package_id
        # The ID of the bill.
        self.order_id = order_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_package_id is not None:
            result['NetworkPackageId'] = self.network_package_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkPackageId') is not None:
            self.network_package_id = m.get('NetworkPackageId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNetworkPackageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNetworkPackageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNetworkPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePolicyGroupRequestAuthorizeAccessPolicyRule(TeaModel):
    def __init__(
        self,
        cidr_ip: str = None,
        description: str = None,
    ):
        # The IPv4 CIDR block that you want to access from the client. The value is an IPv4 CIDR block.
        self.cidr_ip = cidr_ip
        # The description of the client IP address whitelist.
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_ip is not None:
            result['CidrIp'] = self.cidr_ip
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrIp') is not None:
            self.cidr_ip = m.get('CidrIp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreatePolicyGroupRequestAuthorizeSecurityPolicyRule(TeaModel):
    def __init__(
        self,
        cidr_ip: str = None,
        description: str = None,
        ip_protocol: str = None,
        policy: str = None,
        port_range: str = None,
        priority: str = None,
        type: str = None,
    ):
        # The IPv4 CIDR block of the security group rule.
        self.cidr_ip = cidr_ip
        # The description of the security group rule.
        self.description = description
        # The protocol type of the security group rule.
        # 
        # Valid values:
        # 
        # *   TCP
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   UDP
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ALL: all protocols
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   GRE
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ICMP: ICMP (IPv4)
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.ip_protocol = ip_protocol
        # The authorization policy of the security group rule.
        # 
        # Valid values:
        # 
        # *   drop: denies all access requests
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     If no denied messages are returned, the requests timed out or failed.
        # 
        #     <!-- -->
        # 
        # *   accept: accepts all access requests
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     This value is the default value.
        # 
        #     <!-- -->
        self.policy = policy
        # The port range of the security group rule. The value range of this parameter varies based on the value of the IpProtocol parameter.
        # 
        # *   If you set the IpProtocol parameter to TCP or UDP, the value range is 1 to 65535. Separate the start port number and the end port number with a forward slash (/). Example: 1/200.
        # *   If you set the IpProtocol parameter to ICMP, the start port number and the end port number are -1/-1.
        # *   If you set the IpProtocol parameter to GRE, the start port number and the end port number are -1/-1.
        # *   If you set the IpProtocol parameter to ALL, the start port number and the end port number are -1/-1.
        # 
        # For more information about the common ports of applications, see [Common ports](~~40724~~).
        self.port_range = port_range
        # The priority of the security group rule. A smaller value specifies a higher priority.\
        # Valid values: 1 to 60.\
        # Default value: 1.
        self.priority = priority
        # The direction of the security group rule.
        # 
        # Valid values:
        # 
        # *   outflow: outbound
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   inflow: inbound
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_ip is not None:
            result['CidrIp'] = self.cidr_ip
        if self.description is not None:
            result['Description'] = self.description
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrIp') is not None:
            self.cidr_ip = m.get('CidrIp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreatePolicyGroupRequestClientType(TeaModel):
    def __init__(
        self,
        client_type: str = None,
        status: str = None,
    ):
        # The type of the client.
        # 
        # > By default, if you do not specify the ClientType parameter, all types of clients can be used to connect to cloud desktops.
        # 
        # Valid values:
        # 
        # *   html5: web clients
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   android: Android clients
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   linux: Alibaba Cloud Workspace clients
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ios: iOS clients
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   windows: Windows clients
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   macos: macOS clients
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.client_type = client_type
        # Specifies whether a specific client type can be used to connect to the cloud desktop.
        # 
        # > By default, if you do not specify the ClientType parameter, all types of clients can be used to connect to cloud desktops.
        # 
        # Valid values:
        # 
        # *   OFF: Clients of the specified type cannot be used to connect to cloud desktops.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   ON: Clients of the specified type can be used to connect to cloud desktops.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreatePolicyGroupRequestDomainResolveRule(TeaModel):
    def __init__(
        self,
        description: str = None,
        domain: str = None,
        policy: str = None,
    ):
        self.description = description
        self.domain = domain
        self.policy = policy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.policy is not None:
            result['Policy'] = self.policy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        return self


class CreatePolicyGroupRequestUsbSupplyRedirectRule(TeaModel):
    def __init__(
        self,
        description: str = None,
        device_class: str = None,
        device_subclass: str = None,
        product_id: str = None,
        usb_redirect_type: int = None,
        usb_rule_type: int = None,
        vendor_id: str = None,
    ):
        # The description of the rule.
        self.description = description
        # The class of the device. If you set the `usbRuleType` parameter to 1, you must specify this parameter. For more information, see [Defined Class Codes](https://www.usb.org/defined-class-codes).
        self.device_class = device_class
        # The subclass of the device. If you set the `usbRuleType` parameter to 1, you must specify this parameter. For more information, see [Defined Class Codes](https://www.usb.org/defined-class-codes).
        self.device_subclass = device_subclass
        # The ID of the service.
        self.product_id = product_id
        # The type of USB redirection.
        # 
        # Valid values:
        # 
        # *   1: allows USB redirection
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   2: forbids USB redirection
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.usb_redirect_type = usb_redirect_type
        # The type of the USB redirection rule.
        # 
        # Valid values:
        # 
        # *   1: by device class
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   2: by device vendor
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.usb_rule_type = usb_rule_type
        # The ID of the vendor. For more information, see [Valid USB Vendor IDs (VIDs)](https://www.usb.org/sites/default/files/vendor_ids032322.pdf\_1.pdf).
        self.vendor_id = vendor_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.device_class is not None:
            result['DeviceClass'] = self.device_class
        if self.device_subclass is not None:
            result['DeviceSubclass'] = self.device_subclass
        if self.product_id is not None:
            result['ProductId'] = self.product_id
        if self.usb_redirect_type is not None:
            result['UsbRedirectType'] = self.usb_redirect_type
        if self.usb_rule_type is not None:
            result['UsbRuleType'] = self.usb_rule_type
        if self.vendor_id is not None:
            result['VendorId'] = self.vendor_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceClass') is not None:
            self.device_class = m.get('DeviceClass')
        if m.get('DeviceSubclass') is not None:
            self.device_subclass = m.get('DeviceSubclass')
        if m.get('ProductId') is not None:
            self.product_id = m.get('ProductId')
        if m.get('UsbRedirectType') is not None:
            self.usb_redirect_type = m.get('UsbRedirectType')
        if m.get('UsbRuleType') is not None:
            self.usb_rule_type = m.get('UsbRuleType')
        if m.get('VendorId') is not None:
            self.vendor_id = m.get('VendorId')
        return self


class CreatePolicyGroupRequest(TeaModel):
    def __init__(
        self,
        app_content_protection: str = None,
        authorize_access_policy_rule: List[CreatePolicyGroupRequestAuthorizeAccessPolicyRule] = None,
        authorize_security_policy_rule: List[CreatePolicyGroupRequestAuthorizeSecurityPolicyRule] = None,
        camera_redirect: str = None,
        client_type: List[CreatePolicyGroupRequestClientType] = None,
        clipboard: str = None,
        domain_list: str = None,
        domain_resolve_rule: List[CreatePolicyGroupRequestDomainResolveRule] = None,
        domain_resolve_rule_type: str = None,
        end_user_apply_admin_coordinate: str = None,
        end_user_group_coordinate: str = None,
        gpu_acceleration: str = None,
        html_5access: str = None,
        html_5file_transfer: str = None,
        internet_communication_protocol: str = None,
        local_drive: str = None,
        name: str = None,
        net_redirect: str = None,
        preempt_login: str = None,
        preempt_login_user: List[str] = None,
        printer_redirection: str = None,
        record_content: str = None,
        record_content_expires: int = None,
        recording: str = None,
        recording_audio: str = None,
        recording_duration: int = None,
        recording_end_time: str = None,
        recording_expires: int = None,
        recording_fps: int = None,
        recording_start_time: str = None,
        region_id: str = None,
        remote_coordinate: str = None,
        scope: str = None,
        scope_value: List[str] = None,
        usb_redirect: str = None,
        usb_supply_redirect_rule: List[CreatePolicyGroupRequestUsbSupplyRedirectRule] = None,
        video_redirect: str = None,
        visual_quality: str = None,
        watermark: str = None,
        watermark_color: int = None,
        watermark_degree: float = None,
        watermark_font_size: int = None,
        watermark_font_style: str = None,
        watermark_row_amount: int = None,
        watermark_transparency: str = None,
        watermark_transparency_value: int = None,
        watermark_type: str = None,
    ):
        # Specifies whether to enable the anti-screenshot feature.
        # 
        # Valid values:
        # 
        # *   off: Anti-screenshot is disabled. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: Anti-screenshot is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.app_content_protection = app_content_protection
        # The client IP address whitelists. Only the client IP addresses in whitelists can access the cloud desktop.
        self.authorize_access_policy_rule = authorize_access_policy_rule
        # The security group rules.
        self.authorize_security_policy_rule = authorize_security_policy_rule
        # Specifies whether to enable the webcam redirection feature.
        # 
        # Valid values:
        # 
        # *   off: Webcam redirection is disabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: Webcam redirection is enabled. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.camera_redirect = camera_redirect
        # The logon methods. You can use this parameter to determine which clients can be used to connect to the cloud desktop.
        self.client_type = client_type
        # The permissions on the clipboard.
        # 
        # Valid values:
        # 
        # *   read: specifies one-way transfer
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     You can copy data from your local computer to the cloud desktop, but cannot copy data from the cloud desktop to your local computer.
        # 
        #     <!-- -->
        # 
        # *   readwrite: specifies two-way transfer
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     You can copy data between your local computer and the cloud desktop.
        # 
        #     <!-- -->
        # 
        # *   off: disables both one-way and two-way transfer
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     You cannot copy data between your local computer and the cloud desktop. This value is the default value.
        # 
        #     <!-- -->
        self.clipboard = clipboard
        # Access control for domain names. The wildcard character (\*) is supported for domain names. Separate multiple domain names with commas (,). Valid values:
        # 
        # *   off
        # *   on
        self.domain_list = domain_list
        self.domain_resolve_rule = domain_resolve_rule
        self.domain_resolve_rule_type = domain_resolve_rule_type
        # Specifies whether to allow end users to seek assistance from the administrator. Valid values: ON OFF
        self.end_user_apply_admin_coordinate = end_user_apply_admin_coordinate
        # The switch for collaboration between end users. Valid values: ON OFF
        self.end_user_group_coordinate = end_user_group_coordinate
        # Specifies whether to enable the image display quality feature for the Graphics cloud desktop. If you have high requirements for desktop performance and user experience, we recommend that you enable this feature. For example, you can enable this feature in professional design scenarios.
        # 
        # Valid values:
        # 
        # *   off
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.gpu_acceleration = gpu_acceleration
        # The policy for HTML5 client access.
        # 
        # > We recommend that you use the ClientType parameter to manage the type of Alibaba Cloud Workspace clients for desktop connection.
        # 
        # Valid values:
        # 
        # *   off: HTML5 client access is disabled. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: HTML5 client access is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.html_5access = html_5access
        # The file transfer policy for HTML5 clients.
        # 
        # Valid values:
        # 
        # *   all: Files can be uploaded and downloaded between your computer and HTML5 clients.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   download: Files on HTML5 clients can be downloaded to your computer.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   upload: Files on your computer can be uploaded to HTML5 clients.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   off: File transfer between HTML5 clients and your computer is disabled. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.html_5file_transfer = html_5file_transfer
        # The protocol that you want to use for network communication. Valid values: -TCP: Only TCP is allowed. -BOTH: Automatic switch between TCP and UDP is allowed. Default value: TCP.
        self.internet_communication_protocol = internet_communication_protocol
        # The permissions on local disk mapping.
        # 
        # Valid values:
        # 
        # *   read: read-only
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     The disks on your local computer are mapped to the cloud desktop. You can only read (copy) files on the local computer.
        # 
        #     <!-- -->
        # 
        # *   readwrite: read and write
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     The disks on your local computer are mapped to the cloud desktop. You can read (copy) and modify files on your local computer.
        # 
        #     <!-- -->
        # 
        # *   off:
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     The disks on your local computer are not mapped to the cloud desktop. This value is the default value.
        # 
        #     <!-- -->
        self.local_drive = local_drive
        # The name of the policy.
        self.name = name
        # Specifies whether to enable the network redirection feature.
        # 
        # Valid values:
        # 
        # *   off: Network redirection is disabled. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: Network redirection is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.net_redirect = net_redirect
        # Specifies whether to allow user preemption.
        # 
        # > To improve user experience and ensure data security, multiple end users cannot connect to the same cloud desktop at the same time. The default value of this parameter is `off`, and the value cannot be changed.
        self.preempt_login = preempt_login
        # The names of the users that are allowed to connect to the same cloud desktop at the same time. You can specify up to five usernames.
        # 
        # > To improve user experience and ensure data security, we recommend that you disable the user preemption feature.
        self.preempt_login_user = preempt_login_user
        # The policy for printer redirection.
        # 
        # Valid values:
        # 
        # *   off: Printer redirection is disabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: Printer redirection is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.printer_redirection = printer_redirection
        # Specifies whether to enable the custom screen recording feature.
        # 
        # Valid values:
        # 
        # *   off: Custom screen recording is disabled. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: Custom screen recording is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.record_content = record_content
        # The duration in which the custom screen recording is valid. Default value: 30. Unit: days.
        self.record_content_expires = record_content_expires
        # Specifies whether to enable screen recording.
        # 
        # Valid values:
        # 
        # *   ALLTIME: All operations that are performed by end users on cloud desktops are recorded. The recording starts immediately when end users connect to cloud desktops and ends when the end users disconnect from the cloud desktops.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PERIOD: The operations that are performed by end users on cloud desktops during a specified period of time are recorded. You must set the start time and end time for the recording period.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   OFF: Screen recording is disabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.recording = recording
        # Specifies whether to record audio data during the screen recording. Valid values:
        # 
        # *   on: records audio and video data
        # *   off: records only video data
        self.recording_audio = recording_audio
        # The duration from the time when the screen recording starts to the time when the screen recording stops. If you specify the Recording parameter, you must also specify the RecordingDuration parameter. When the specified duration ends, a recording file is generated.
        self.recording_duration = recording_duration
        # The time when the screen recording stops. Specify the value in the HH:MM:SS format. The value of this parameter is valid only if you set the Recording parameter to PERIOD.
        self.recording_end_time = recording_end_time
        # The duration in which the screen recording is valid. Unit: days.
        self.recording_expires = recording_expires
        # The frame rate of screen recording.
        # 
        # Valid values:
        # 
        # *   2
        # 
        # *   5
        # 
        # *  10
        # 
        # *   15
        self.recording_fps = recording_fps
        # The time when screen recording starts. Specify the value in the HH:MM:SS format. The value of this parameter is valid only if you set the Recording parameter to PERIOD.
        self.recording_start_time = recording_start_time
        # The ID of the region.
        self.region_id = region_id
        # The permission to control the keyboard and the mouse during remote assistance.
        # 
        # Valid values:
        # 
        # *   \-\
        # 
        #     <!-- -->
        # 
        #     optionalControl
        # 
        #     <!-- -->
        # 
        #     : By default, this feature is disabled. You can enable it by applying permissions.
        # 
        #     <!-- -->
        # 
        # *   fullControl: The permission is granted.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   disableControl: The permission is revoked.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.remote_coordinate = remote_coordinate
        # The effective scope of the policy. Valid values:
        # 
        # *   GLOBAL: The policy takes effect globally.
        # *   IP: The policy takes effect for specified IP addresses.
        self.scope = scope
        # The effective CIDR block ranges. If you set the Scope parameter to IP, you must specify this parameter.
        self.scope_value = scope_value
        # Specifies whether to enable USB redirection.
        # 
        # Valid values:
        # 
        # *   off: USB redirection is disabled. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: USB redirection is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.usb_redirect = usb_redirect
        # The USB redirection rules.
        self.usb_supply_redirect_rule = usb_supply_redirect_rule
        # Specifies whether to enable the multimedia redirection feature. Valid values:
        # 
        # *   on: Multimedia redirection is enabled.
        # *   off: Multimedia redirection is disabled.
        self.video_redirect = video_redirect
        # The policy for image display quality.
        # 
        # Valid values:
        # 
        # *   high
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   low
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   lossless
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   medium: adaptive. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.visual_quality = visual_quality
        # Specifies whether to enable watermarking.
        # 
        # Valid values:
        # 
        # *   off: Watermarking is disabled. This value is the default value.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: Watermarking is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.watermark = watermark
        # The font color of the watermark. Valid values: 0 to 16777215.
        self.watermark_color = watermark_color
        # The inclination angle of the watermark. Valid values: -10 to -30.
        self.watermark_degree = watermark_degree
        # The font size of the watermark. Valid values: 10 to 20.
        self.watermark_font_size = watermark_font_size
        # The font style of the watermark. Valid values:
        # 
        # *   plain
        # *   bold
        self.watermark_font_style = watermark_font_style
        # The number of watermark rows. This parameter is now invalid.
        self.watermark_row_amount = watermark_row_amount
        # The transparency of the watermark.
        # 
        # Valid values:
        # 
        # *   LIGHT
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DARK
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   MIDDLE
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.watermark_transparency = watermark_transparency
        # The transparency of the watermark. A larger value specifies that the watermark is less transparent. Valid values: 10 to 100.
        self.watermark_transparency_value = watermark_transparency_value
        # The type of the watermark. You can specify multiple types of watermarks at the same time. Separate multiple watermark types with commas (,).
        # 
        # Valid values:
        # 
        # *   EndUserId: The ID of the end user is displayed.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   HostName: The rightmost 15 characters of the cloud desktop ID are displayed.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.watermark_type = watermark_type

    def validate(self):
        if self.authorize_access_policy_rule:
            for k in self.authorize_access_policy_rule:
                if k:
                    k.validate()
        if self.authorize_security_policy_rule:
            for k in self.authorize_security_policy_rule:
                if k:
                    k.validate()
        if self.client_type:
            for k in self.client_type:
                if k:
                    k.validate()
        if self.domain_resolve_rule:
            for k in self.domain_resolve_rule:
                if k:
                    k.validate()
        if self.usb_supply_redirect_rule:
            for k in self.usb_supply_redirect_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_content_protection is not None:
            result['AppContentProtection'] = self.app_content_protection
        result['AuthorizeAccessPolicyRule'] = []
        if self.authorize_access_policy_rule is not None:
            for k in self.authorize_access_policy_rule:
                result['AuthorizeAccessPolicyRule'].append(k.to_map() if k else None)
        result['AuthorizeSecurityPolicyRule'] = []
        if self.authorize_security_policy_rule is not None:
            for k in self.authorize_security_policy_rule:
                result['AuthorizeSecurityPolicyRule'].append(k.to_map() if k else None)
        if self.camera_redirect is not None:
            result['CameraRedirect'] = self.camera_redirect
        result['ClientType'] = []
        if self.client_type is not None:
            for k in self.client_type:
                result['ClientType'].append(k.to_map() if k else None)
        if self.clipboard is not None:
            result['Clipboard'] = self.clipboard
        if self.domain_list is not None:
            result['DomainList'] = self.domain_list
        result['DomainResolveRule'] = []
        if self.domain_resolve_rule is not None:
            for k in self.domain_resolve_rule:
                result['DomainResolveRule'].append(k.to_map() if k else None)
        if self.domain_resolve_rule_type is not None:
            result['DomainResolveRuleType'] = self.domain_resolve_rule_type
        if self.end_user_apply_admin_coordinate is not None:
            result['EndUserApplyAdminCoordinate'] = self.end_user_apply_admin_coordinate
        if self.end_user_group_coordinate is not None:
            result['EndUserGroupCoordinate'] = self.end_user_group_coordinate
        if self.gpu_acceleration is not None:
            result['GpuAcceleration'] = self.gpu_acceleration
        if self.html_5access is not None:
            result['Html5Access'] = self.html_5access
        if self.html_5file_transfer is not None:
            result['Html5FileTransfer'] = self.html_5file_transfer
        if self.internet_communication_protocol is not None:
            result['InternetCommunicationProtocol'] = self.internet_communication_protocol
        if self.local_drive is not None:
            result['LocalDrive'] = self.local_drive
        if self.name is not None:
            result['Name'] = self.name
        if self.net_redirect is not None:
            result['NetRedirect'] = self.net_redirect
        if self.preempt_login is not None:
            result['PreemptLogin'] = self.preempt_login
        if self.preempt_login_user is not None:
            result['PreemptLoginUser'] = self.preempt_login_user
        if self.printer_redirection is not None:
            result['PrinterRedirection'] = self.printer_redirection
        if self.record_content is not None:
            result['RecordContent'] = self.record_content
        if self.record_content_expires is not None:
            result['RecordContentExpires'] = self.record_content_expires
        if self.recording is not None:
            result['Recording'] = self.recording
        if self.recording_audio is not None:
            result['RecordingAudio'] = self.recording_audio
        if self.recording_duration is not None:
            result['RecordingDuration'] = self.recording_duration
        if self.recording_end_time is not None:
            result['RecordingEndTime'] = self.recording_end_time
        if self.recording_expires is not None:
            result['RecordingExpires'] = self.recording_expires
        if self.recording_fps is not None:
            result['RecordingFps'] = self.recording_fps
        if self.recording_start_time is not None:
            result['RecordingStartTime'] = self.recording_start_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.remote_coordinate is not None:
            result['RemoteCoordinate'] = self.remote_coordinate
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.scope_value is not None:
            result['ScopeValue'] = self.scope_value
        if self.usb_redirect is not None:
            result['UsbRedirect'] = self.usb_redirect
        result['UsbSupplyRedirectRule'] = []
        if self.usb_supply_redirect_rule is not None:
            for k in self.usb_supply_redirect_rule:
                result['UsbSupplyRedirectRule'].append(k.to_map() if k else None)
        if self.video_redirect is not None:
            result['VideoRedirect'] = self.video_redirect
        if self.visual_quality is not None:
            result['VisualQuality'] = self.visual_quality
        if self.watermark is not None:
            result['Watermark'] = self.watermark
        if self.watermark_color is not None:
            result['WatermarkColor'] = self.watermark_color
        if self.watermark_degree is not None:
            result['WatermarkDegree'] = self.watermark_degree
        if self.watermark_font_size is not None:
            result['WatermarkFontSize'] = self.watermark_font_size
        if self.watermark_font_style is not None:
            result['WatermarkFontStyle'] = self.watermark_font_style
        if self.watermark_row_amount is not None:
            result['WatermarkRowAmount'] = self.watermark_row_amount
        if self.watermark_transparency is not None:
            result['WatermarkTransparency'] = self.watermark_transparency
        if self.watermark_transparency_value is not None:
            result['WatermarkTransparencyValue'] = self.watermark_transparency_value
        if self.watermark_type is not None:
            result['WatermarkType'] = self.watermark_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppContentProtection') is not None:
            self.app_content_protection = m.get('AppContentProtection')
        self.authorize_access_policy_rule = []
        if m.get('AuthorizeAccessPolicyRule') is not None:
            for k in m.get('AuthorizeAccessPolicyRule'):
                temp_model = CreatePolicyGroupRequestAuthorizeAccessPolicyRule()
                self.authorize_access_policy_rule.append(temp_model.from_map(k))
        self.authorize_security_policy_rule = []
        if m.get('AuthorizeSecurityPolicyRule') is not None:
            for k in m.get('AuthorizeSecurityPolicyRule'):
                temp_model = CreatePolicyGroupRequestAuthorizeSecurityPolicyRule()
                self.authorize_security_policy_rule.append(temp_model.from_map(k))
        if m.get('CameraRedirect') is not None:
            self.camera_redirect = m.get('CameraRedirect')
        self.client_type = []
        if m.get('ClientType') is not None:
            for k in m.get('ClientType'):
                temp_model = CreatePolicyGroupRequestClientType()
                self.client_type.append(temp_model.from_map(k))
        if m.get('Clipboard') is not None:
            self.clipboard = m.get('Clipboard')
        if m.get('DomainList') is not None:
            self.domain_list = m.get('DomainList')
        self.domain_resolve_rule = []
        if m.get('DomainResolveRule') is not None:
            for k in m.get('DomainResolveRule'):
                temp_model = CreatePolicyGroupRequestDomainResolveRule()
                self.domain_resolve_rule.append(temp_model.from_map(k))
        if m.get('DomainResolveRuleType') is not None:
            self.domain_resolve_rule_type = m.get('DomainResolveRuleType')
        if m.get('EndUserApplyAdminCoordinate') is not None:
            self.end_user_apply_admin_coordinate = m.get('EndUserApplyAdminCoordinate')
        if m.get('EndUserGroupCoordinate') is not None:
            self.end_user_group_coordinate = m.get('EndUserGroupCoordinate')
        if m.get('GpuAcceleration') is not None:
            self.gpu_acceleration = m.get('GpuAcceleration')
        if m.get('Html5Access') is not None:
            self.html_5access = m.get('Html5Access')
        if m.get('Html5FileTransfer') is not None:
            self.html_5file_transfer = m.get('Html5FileTransfer')
        if m.get('InternetCommunicationProtocol') is not None:
            self.internet_communication_protocol = m.get('InternetCommunicationProtocol')
        if m.get('LocalDrive') is not None:
            self.local_drive = m.get('LocalDrive')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetRedirect') is not None:
            self.net_redirect = m.get('NetRedirect')
        if m.get('PreemptLogin') is not None:
            self.preempt_login = m.get('PreemptLogin')
        if m.get('PreemptLoginUser') is not None:
            self.preempt_login_user = m.get('PreemptLoginUser')
        if m.get('PrinterRedirection') is not None:
            self.printer_redirection = m.get('PrinterRedirection')
        if m.get('RecordContent') is not None:
            self.record_content = m.get('RecordContent')
        if m.get('RecordContentExpires') is not None:
            self.record_content_expires = m.get('RecordContentExpires')
        if m.get('Recording') is not None:
            self.recording = m.get('Recording')
        if m.get('RecordingAudio') is not None:
            self.recording_audio = m.get('RecordingAudio')
        if m.get('RecordingDuration') is not None:
            self.recording_duration = m.get('RecordingDuration')
        if m.get('RecordingEndTime') is not None:
            self.recording_end_time = m.get('RecordingEndTime')
        if m.get('RecordingExpires') is not None:
            self.recording_expires = m.get('RecordingExpires')
        if m.get('RecordingFps') is not None:
            self.recording_fps = m.get('RecordingFps')
        if m.get('RecordingStartTime') is not None:
            self.recording_start_time = m.get('RecordingStartTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RemoteCoordinate') is not None:
            self.remote_coordinate = m.get('RemoteCoordinate')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('ScopeValue') is not None:
            self.scope_value = m.get('ScopeValue')
        if m.get('UsbRedirect') is not None:
            self.usb_redirect = m.get('UsbRedirect')
        self.usb_supply_redirect_rule = []
        if m.get('UsbSupplyRedirectRule') is not None:
            for k in m.get('UsbSupplyRedirectRule'):
                temp_model = CreatePolicyGroupRequestUsbSupplyRedirectRule()
                self.usb_supply_redirect_rule.append(temp_model.from_map(k))
        if m.get('VideoRedirect') is not None:
            self.video_redirect = m.get('VideoRedirect')
        if m.get('VisualQuality') is not None:
            self.visual_quality = m.get('VisualQuality')
        if m.get('Watermark') is not None:
            self.watermark = m.get('Watermark')
        if m.get('WatermarkColor') is not None:
            self.watermark_color = m.get('WatermarkColor')
        if m.get('WatermarkDegree') is not None:
            self.watermark_degree = m.get('WatermarkDegree')
        if m.get('WatermarkFontSize') is not None:
            self.watermark_font_size = m.get('WatermarkFontSize')
        if m.get('WatermarkFontStyle') is not None:
            self.watermark_font_style = m.get('WatermarkFontStyle')
        if m.get('WatermarkRowAmount') is not None:
            self.watermark_row_amount = m.get('WatermarkRowAmount')
        if m.get('WatermarkTransparency') is not None:
            self.watermark_transparency = m.get('WatermarkTransparency')
        if m.get('WatermarkTransparencyValue') is not None:
            self.watermark_transparency_value = m.get('WatermarkTransparencyValue')
        if m.get('WatermarkType') is not None:
            self.watermark_type = m.get('WatermarkType')
        return self


class CreatePolicyGroupResponseBody(TeaModel):
    def __init__(
        self,
        policy_group_id: str = None,
        request_id: str = None,
    ):
        # The ID of the policy.
        self.policy_group_id = policy_group_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePolicyGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePolicyGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePolicyGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRAMDirectoryRequest(TeaModel):
    def __init__(
        self,
        desktop_access_type: str = None,
        directory_name: str = None,
        enable_admin_access: bool = None,
        enable_internet_access: bool = None,
        region_id: str = None,
        v_switch_id: List[str] = None,
    ):
        # The method that you use to connect clients to cloud desktops. Valid values:
        # 
        # *   Internet: connects clients to cloud desktops only over the Internet.
        # *   VPC: connects clients to cloud desktops only over a VPC.
        # *   Any: connects clients to cloud desktops over the Internet or a VPC. You can select a connection method when you connect clients to cloud desktops.
        # 
        # Default value: Internet.
        # 
        # 
        # > The VPC connection method is provided by Alibaba Cloud PrivateLink. You are not charged for PrivateLink. If you set this parameter to VPC or Any, PrivateLink is automatically activated.
        self.desktop_access_type = desktop_access_type
        # Specifies whether to grant the permissions of the local administrator to the desktop users. Default value: true.
        self.directory_name = directory_name
        # The operation that you want to perform. Set the value to CreateRAMDirectory.
        self.enable_admin_access = enable_admin_access
        # The ID of the request.
        self.enable_internet_access = enable_internet_access
        # Specifies whether to enable the Internet access feature.
        self.region_id = region_id
        # CreateRAMDirectory
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_access_type is not None:
            result['DesktopAccessType'] = self.desktop_access_type
        if self.directory_name is not None:
            result['DirectoryName'] = self.directory_name
        if self.enable_admin_access is not None:
            result['EnableAdminAccess'] = self.enable_admin_access
        if self.enable_internet_access is not None:
            result['EnableInternetAccess'] = self.enable_internet_access
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopAccessType') is not None:
            self.desktop_access_type = m.get('DesktopAccessType')
        if m.get('DirectoryName') is not None:
            self.directory_name = m.get('DirectoryName')
        if m.get('EnableAdminAccess') is not None:
            self.enable_admin_access = m.get('EnableAdminAccess')
        if m.get('EnableInternetAccess') is not None:
            self.enable_internet_access = m.get('EnableInternetAccess')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateRAMDirectoryResponseBody(TeaModel):
    def __init__(
        self,
        directory_id: str = None,
        request_id: str = None,
    ):
        self.directory_id = directory_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRAMDirectoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRAMDirectoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRAMDirectoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSimpleOfficeSiteRequest(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        cen_id: str = None,
        cen_owner_id: int = None,
        cidr_block: str = None,
        cloud_box_office_site: bool = None,
        desktop_access_type: str = None,
        enable_admin_access: bool = None,
        enable_internet_access: bool = None,
        need_verify_zero_device: bool = None,
        office_site_name: str = None,
        region_id: str = None,
        v_switch_id: List[str] = None,
        verify_code: str = None,
    ):
        # Specifies whether to enable trusted device verification.
        self.bandwidth = bandwidth
        # The ID of the Cloud Enterprise Network (CEN) instance.
        # 
        # > If you want to connect to your cloud desktops over a VPC, you can attach the network of the workspace to the CEN instance. The CEN instance is connected to the on-premises network over VPN Gateway or Express Connect.
        self.cen_id = cen_id
        # The name of the workspace. The name must be 2 to 255 characters in length. It must start with a letter and cannot start with `http://` or `https://`. The name can contain letters, digits, colons (:), underscores (\_), and hyphens (-).
        self.cen_owner_id = cen_owner_id
        # Specifies whether the workspace is a CloudBox-based workspace.
        self.cidr_block = cidr_block
        # Creates a workspace of the convenience account type.
        self.cloud_box_office_site = cloud_box_office_site
        # The ID of the workspace.
        self.desktop_access_type = desktop_access_type
        # The ID of the region. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.enable_admin_access = enable_admin_access
        # Specifies whether to grant the permissions of the local administrator to the regular user of the cloud desktop.
        self.enable_internet_access = enable_internet_access
        # The ID of the Alibaba Cloud account to which the Cloud Enterprise Network (CEN) instance belongs.
        # 
        # *   If you do not specify the CenId parameter, or the CEN instance that is specified by the CenId parameter belongs to the current Alibaba Cloud account, skip this parameter.
        # *   If you specify the CenId parameter and the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, enter the ID of the Alibaba Cloud account.
        self.need_verify_zero_device = need_verify_zero_device
        # The maximum public bandwidth. Value range: 10 to 200. Unit: Mbit/s. This parameter is available if you set `EnableInternetAccess` to `true`.
        self.office_site_name = office_site_name
        # The IPv4 CIDR block in the secure office network of the workspace. The IPv4 CIDR block that the system uses to create a virtual private cloud (VPC) for the workspace. We recommend that you set the IPv4 CIDR block to 10.0.0.0/12, 172.16.0.0/12, 192.168.0.0/16, or a subnet of these CIDR blocks. If you set the IPv4 CIDR block to 10.0.0.0/12 or 172.16.0.0/12, the mask is 1224 bits in length. If you set the IPv4 CIDR block to 192.168.0.0/16, the mask is 1624 bits in length.
        self.region_id = region_id
        # The ID of the request.
        self.v_switch_id = v_switch_id
        # The verification code. If the CEN instance that you specify for the CenId parameter belongs to another Alibaba Cloud account, you must call the [SendVerifyCode](~~335132~~) operation to obtain the verification code.
        self.verify_code = verify_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_owner_id is not None:
            result['CenOwnerId'] = self.cen_owner_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.cloud_box_office_site is not None:
            result['CloudBoxOfficeSite'] = self.cloud_box_office_site
        if self.desktop_access_type is not None:
            result['DesktopAccessType'] = self.desktop_access_type
        if self.enable_admin_access is not None:
            result['EnableAdminAccess'] = self.enable_admin_access
        if self.enable_internet_access is not None:
            result['EnableInternetAccess'] = self.enable_internet_access
        if self.need_verify_zero_device is not None:
            result['NeedVerifyZeroDevice'] = self.need_verify_zero_device
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.verify_code is not None:
            result['VerifyCode'] = self.verify_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenOwnerId') is not None:
            self.cen_owner_id = m.get('CenOwnerId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('CloudBoxOfficeSite') is not None:
            self.cloud_box_office_site = m.get('CloudBoxOfficeSite')
        if m.get('DesktopAccessType') is not None:
            self.desktop_access_type = m.get('DesktopAccessType')
        if m.get('EnableAdminAccess') is not None:
            self.enable_admin_access = m.get('EnableAdminAccess')
        if m.get('EnableInternetAccess') is not None:
            self.enable_internet_access = m.get('EnableInternetAccess')
        if m.get('NeedVerifyZeroDevice') is not None:
            self.need_verify_zero_device = m.get('NeedVerifyZeroDevice')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VerifyCode') is not None:
            self.verify_code = m.get('VerifyCode')
        return self


class CreateSimpleOfficeSiteResponseBody(TeaModel):
    def __init__(
        self,
        office_site_id: str = None,
        request_id: str = None,
    ):
        self.office_site_id = office_site_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSimpleOfficeSiteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSimpleOfficeSiteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSimpleOfficeSiteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSnapshotRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        desktop_id: str = None,
        region_id: str = None,
        snapshot_name: str = None,
        source_disk_type: str = None,
    ):
        # The description of the snapshot. The description can be up to 128 characters in length.
        self.description = description
        # The ID of the cloud desktop.
        self.desktop_id = desktop_id
        # The region ID.
        self.region_id = region_id
        # The name of the snapshot. The name must be 2 to 128 characters in length.\
        # The name cannot start with auto because snapshots whose names start with auto are recognized as automatic snapshots.
        self.snapshot_name = snapshot_name
        # The type of the disk for which to create a snapshot. Valid values:
        # 
        # *   system: system disk
        # *   data: data disk
        self.source_disk_type = source_disk_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snapshot_name is not None:
            result['SnapshotName'] = self.snapshot_name
        if self.source_disk_type is not None:
            result['SourceDiskType'] = self.source_disk_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnapshotName') is not None:
            self.snapshot_name = m.get('SnapshotName')
        if m.get('SourceDiskType') is not None:
            self.source_disk_type = m.get('SourceDiskType')
        return self


class CreateSnapshotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        snapshot_id: str = None,
    ):
        # The ID of the region.
        self.request_id = request_id
        # The ID of the snapshot.
        self.snapshot_id = snapshot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class CreateSnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSnapshotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        policy_id: List[str] = None,
        region_id: str = None,
    ):
        # The ID of the policy template that you want to manage.
        # 
        # > You can call the [ListDefensePolicies](~~195814~~) operation to query the IDs of all policy templates.
        self.policy_id = policy_id
        # The ID of the region where the automatic snapshot policy is created.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBundlesRequest(TeaModel):
    def __init__(
        self,
        bundle_id: List[str] = None,
        region_id: str = None,
    ):
        self.bundle_id = bundle_id
        # DeleteBundles
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteBundlesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBundlesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBundlesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBundlesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCdsFileRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: str = None,
        file_id: str = None,
        region_id: str = None,
    ):
        # The ID of the cloud disk.
        self.cds_id = cds_id
        # The ID of the end user who uses the cloud disk.
        self.end_user_id = end_user_id
        # The ID of the file. The ID is a unique identifier for the file.
        self.file_id = file_id
        # The region ID. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCdsFileResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The operation result. A value of success indicates that the operation is successful. If the operation failed, an error message is returned.
        self.code = code
        # Indicates whether the data is returned.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        # 
        # Valid values:
        # 
        # *   true
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   false
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCdsFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCdsFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCdsFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCloudDriveGroupsRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        group_id: List[str] = None,
        region_id: str = None,
    ):
        # The ID of the cloud disk in Cloud Drive Service.
        self.cds_id = cds_id
        # The IDs of the teams that you want to delete. You can delete multiple teams at a time.
        self.group_id = group_id
        # The region ID.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCloudDriveGroupsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The result of the operation. A value of success indicates that the operation is successful. If the operation failed, an error message is returned.
        self.code = code
        # The data information.
        self.data = data
        # The error message returned. This parameter is not returned if the value of Code is `success`.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true: The request is successful. false: The request fails.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCloudDriveGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCloudDriveGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCloudDriveGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCloudDriveUsersRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: List[str] = None,
        region_id: str = None,
    ):
        self.cds_id = cds_id
        self.end_user_id = end_user_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCloudDriveUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCloudDriveUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCloudDriveUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCloudDriveUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDesktopGroupRequest(TeaModel):
    def __init__(
        self,
        desktop_group_id: str = None,
        region_id: str = None,
    ):
        self.desktop_group_id = desktop_group_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDesktopGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDesktopGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDesktopGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDesktopGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDesktopsRequest(TeaModel):
    def __init__(
        self,
        desktop_id: List[str] = None,
        region_id: str = None,
    ):
        self.desktop_id = desktop_id
        # DeleteDesktops
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDesktopsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDesktopsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDesktopsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDesktopsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDevicesRequest(TeaModel):
    def __init__(
        self,
        client_type: int = None,
        device_ids: List[str] = None,
        force: int = None,
        region_id: str = None,
    ):
        # The type of the device.
        # 
        # *   1: the hardware client device
        # *   2: the software client device
        self.client_type = client_type
        # The list of universally unique identifiers (UUIDs) of devices.
        self.device_ids = device_ids
        # Specifies whether to forcefully delete the device.
        # 
        # *   1: forcefully deletes the device.
        # *   0: does not forcefully delete the device. (You cannot delete a device to which a user is bound.)
        self.force = force
        # The ID of the region.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.device_ids is not None:
            result['DeviceIds'] = self.device_ids
        if self.force is not None:
            result['Force'] = self.force
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('DeviceIds') is not None:
            self.device_ids = m.get('DeviceIds')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDevicesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDevicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDirectoriesRequest(TeaModel):
    def __init__(
        self,
        directory_id: List[str] = None,
        region_id: str = None,
    ):
        self.directory_id = directory_id
        # The operation that you want to perform. Set the value to DeleteDirectories.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDirectoriesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDirectoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDirectoriesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDirectoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEduRoomRequest(TeaModel):
    def __init__(
        self,
        edu_room_id: str = None,
        region_id: str = None,
    ):
        self.edu_room_id = edu_room_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.edu_room_id is not None:
            result['EduRoomId'] = self.edu_room_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EduRoomId') is not None:
            self.edu_room_id = m.get('EduRoomId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteEduRoomResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEduRoomResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEduRoomResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEduRoomResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImagesRequest(TeaModel):
    def __init__(
        self,
        delete_cascaded_bundle: bool = None,
        image_id: List[str] = None,
        region_id: str = None,
    ):
        self.delete_cascaded_bundle = delete_cascaded_bundle
        self.image_id = image_id
        # The operation that you want to perform. Set the value to DeleteImages.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_cascaded_bundle is not None:
            result['DeleteCascadedBundle'] = self.delete_cascaded_bundle
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeleteCascadedBundle') is not None:
            self.delete_cascaded_bundle = m.get('DeleteCascadedBundle')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteImagesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteImagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteImagesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteImagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNASFileSystemsRequest(TeaModel):
    def __init__(
        self,
        file_system_id: List[str] = None,
        region_id: str = None,
    ):
        # The IDs of the NAS file systems that you want to delete.
        self.file_system_id = file_system_id
        # The region ID of the NAS file system that you want to delete.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteNASFileSystemsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNASFileSystemsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNASFileSystemsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNASFileSystemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkPackagesRequest(TeaModel):
    def __init__(
        self,
        network_package_id: List[str] = None,
        region_id: str = None,
    ):
        self.network_package_id = network_package_id
        # DeleteNetworkPackages
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_package_id is not None:
            result['NetworkPackageId'] = self.network_package_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkPackageId') is not None:
            self.network_package_id = m.get('NetworkPackageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteNetworkPackagesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkPackagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNetworkPackagesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNetworkPackagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOfficeSitesRequest(TeaModel):
    def __init__(
        self,
        office_site_id: List[str] = None,
        region_id: str = None,
    ):
        # The ID of the workspace that you want to delete. You can specify 1 to 100 IDs of workspaces.
        self.office_site_id = office_site_id
        # The region ID of the workspace that you want to delete. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteOfficeSitesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteOfficeSitesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteOfficeSitesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOfficeSitesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePolicyGroupsRequest(TeaModel):
    def __init__(
        self,
        policy_group_id: List[str] = None,
        region_id: str = None,
    ):
        self.policy_group_id = policy_group_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeletePolicyGroupsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePolicyGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePolicyGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePolicyGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnapshotRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        snapshot_id: List[str] = None,
    ):
        # The ID of the region.
        self.region_id = region_id
        # The IDs of the snapshots. You can specify 1 to 100 IDs of snapshots.
        self.snapshot_id = snapshot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class DeleteSnapshotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSnapshotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVirtualMFADeviceRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        serial_number: str = None,
    ):
        # The serial number of the virtual MFA device, which is a unique identifier.
        # 
        # You can call the [DescribeVirtualMFADevices](~~206210~~) operation to query the serial number of the virtual MFA device bound to AD users.
        self.region_id = region_id
        self.serial_number = serial_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        return self


class DeleteVirtualMFADeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVirtualMFADeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVirtualMFADeviceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVirtualMFADeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAclEntriesRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
        source_id: str = None,
        source_type: str = None,
    ):
        self.max_results = max_results
        self.next_token = next_token
        self.region_id = region_id
        self.source_id = source_id
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class DescribeAclEntriesResponseBodyAclEntries(TeaModel):
    def __init__(
        self,
        policy: str = None,
        source_id: str = None,
        source_type: str = None,
    ):
        self.policy = policy
        self.source_id = source_id
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class DescribeAclEntriesResponseBody(TeaModel):
    def __init__(
        self,
        acl_entries: List[DescribeAclEntriesResponseBodyAclEntries] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.acl_entries = acl_entries
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.acl_entries:
            for k in self.acl_entries:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AclEntries'] = []
        if self.acl_entries is not None:
            for k in self.acl_entries:
                result['AclEntries'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.acl_entries = []
        if m.get('AclEntries') is not None:
            for k in m.get('AclEntries'):
                temp_model = DescribeAclEntriesResponseBodyAclEntries()
                self.acl_entries.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAclEntriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAclEntriesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAclEntriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventStackInfoRequest(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        event_name: str = None,
        lang: str = None,
        region_id: str = None,
        unique_info: str = None,
    ):
        # The ID of the request.
        self.desktop_id = desktop_id
        # The operation that you want to perform. Set the value to DescribeAlarmEventStackInfo.
        self.event_name = event_name
        # The natural language of the request and response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.lang = lang
        # The ID of the alert event.
        self.region_id = region_id
        # The stack information of the alert details.
        self.unique_info = unique_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        return self


class DescribeAlarmEventStackInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        stack_info: str = None,
    ):
        self.request_id = request_id
        self.stack_info = stack_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stack_info is not None:
            result['StackInfo'] = self.stack_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StackInfo') is not None:
            self.stack_info = m.get('StackInfo')
        return self


class DescribeAlarmEventStackInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlarmEventStackInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventStackInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoSnapshotPolicyRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        policy_id: str = None,
        policy_name: str = None,
        region_id: str = None,
    ):
        # The number of entries to return on each page.
        # 
        # *   Maximum value: 100
        # *   Default value: 20
        self.max_results = max_results
        # The token that determines the start point of the next query. If this parameter is left empty, all results are returned.
        self.next_token = next_token
        # The ID of the automatic snapshot policy.
        self.policy_id = policy_id
        # The name of the automatic snapshot policy.
        self.policy_name = policy_name
        # The ID of the region. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeAutoSnapshotPolicyResponseBodyAutoSnapshotPolicies(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        cron_expression: str = None,
        desktop_num: int = None,
        policy_id: str = None,
        policy_name: str = None,
        region_id: str = None,
        retention_days: str = None,
        status: str = None,
        time_points: str = None,
    ):
        # The time when the automatic snapshot policy was created. The time follows the [ISO 8601](~~25696~~) standard in the yyyy-mm-ddthh:mm:ssz format. The time is displayed in UTC.
        self.creation_time = creation_time
        # The CRON expression that is used to create the snapshot.
        self.cron_expression = cron_expression
        # The number of cloud desktops that are associated with the automatic snapshot policy.
        self.desktop_num = desktop_num
        # The ID of the automatic snapshot policy.
        self.policy_id = policy_id
        # The name of the automatic snapshot policy.
        self.policy_name = policy_name
        # The ID of the region where the automatic snapshot policy resides.
        self.region_id = region_id
        # The retention period of the automatic snapshot. Unit: days. Valid values:
        # 
        # *   \-1: The snapshot is permanently retained.
        # *   1 to 65536: The automatic snapshot is retained for the specified number of days.
        self.retention_days = retention_days
        # The state of the automatic snapshot policy. Valid values:
        # 
        # *   Normal: The automatic snapshot policy is normal.
        # *   Expire: The automatic snapshot policy cannot be used because your account has an overdue payment.
        self.status = status
        # The points in time at which automatic snapshots are created.
        # 
        # The time is displayed in UTC+8. Unit: hours. Valid values are 0 to 23, which correspond to the 24 points in time on the hour from 00:00:00 to 23:00:00. 1 indicates 01:00:00. Multiple points in time can be specified.
        # 
        # The parameter value is a JSON array that contains up to 24 points in time separated by commas (,). Example: `["0", "1", ... "23"]`.
        self.time_points = time_points

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.desktop_num is not None:
            result['DesktopNum'] = self.desktop_num
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.retention_days is not None:
            result['RetentionDays'] = self.retention_days
        if self.status is not None:
            result['Status'] = self.status
        if self.time_points is not None:
            result['TimePoints'] = self.time_points
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('DesktopNum') is not None:
            self.desktop_num = m.get('DesktopNum')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RetentionDays') is not None:
            self.retention_days = m.get('RetentionDays')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TimePoints') is not None:
            self.time_points = m.get('TimePoints')
        return self


class DescribeAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(
        self,
        auto_snapshot_policies: List[DescribeAutoSnapshotPolicyResponseBodyAutoSnapshotPolicies] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # Details of the automatic snapshot policies.
        self.auto_snapshot_policies = auto_snapshot_policies
        # The token that is used to start the next query. If this parameter is empty, all results haven been returned.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.auto_snapshot_policies:
            for k in self.auto_snapshot_policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AutoSnapshotPolicies'] = []
        if self.auto_snapshot_policies is not None:
            for k in self.auto_snapshot_policies:
                result['AutoSnapshotPolicies'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.auto_snapshot_policies = []
        if m.get('AutoSnapshotPolicies') is not None:
            for k in m.get('AutoSnapshotPolicies'):
                temp_model = DescribeAutoSnapshotPolicyResponseBodyAutoSnapshotPolicies()
                self.auto_snapshot_policies.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAutoSnapshotPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAutoSnapshotPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBundlesRequest(TeaModel):
    def __init__(
        self,
        bundle_id: List[str] = None,
        bundle_type: str = None,
        check_stock: bool = None,
        cpu_count: int = None,
        desktop_type_family: str = None,
        fota_channel: str = None,
        from_desktop_group: bool = None,
        gpu_count: float = None,
        image_id: List[str] = None,
        max_results: int = None,
        memory_size: int = None,
        next_token: str = None,
        os_type: str = None,
        protocol_type: str = None,
        region_id: str = None,
        scope: str = None,
        selected_bundle: bool = None,
        session_type: str = None,
        support_multi_session: bool = None,
        volume_encryption_enabled: bool = None,
    ):
        self.bundle_id = bundle_id
        self.bundle_type = bundle_type
        self.check_stock = check_stock
        self.cpu_count = cpu_count
        self.desktop_type_family = desktop_type_family
        self.fota_channel = fota_channel
        self.from_desktop_group = from_desktop_group
        self.gpu_count = gpu_count
        self.image_id = image_id
        self.max_results = max_results
        self.memory_size = memory_size
        self.next_token = next_token
        self.os_type = os_type
        self.protocol_type = protocol_type
        self.region_id = region_id
        self.scope = scope
        self.selected_bundle = selected_bundle
        self.session_type = session_type
        self.support_multi_session = support_multi_session
        self.volume_encryption_enabled = volume_encryption_enabled

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.bundle_type is not None:
            result['BundleType'] = self.bundle_type
        if self.check_stock is not None:
            result['CheckStock'] = self.check_stock
        if self.cpu_count is not None:
            result['CpuCount'] = self.cpu_count
        if self.desktop_type_family is not None:
            result['DesktopTypeFamily'] = self.desktop_type_family
        if self.fota_channel is not None:
            result['FotaChannel'] = self.fota_channel
        if self.from_desktop_group is not None:
            result['FromDesktopGroup'] = self.from_desktop_group
        if self.gpu_count is not None:
            result['GpuCount'] = self.gpu_count
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.memory_size is not None:
            result['MemorySize'] = self.memory_size
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.selected_bundle is not None:
            result['SelectedBundle'] = self.selected_bundle
        if self.session_type is not None:
            result['SessionType'] = self.session_type
        if self.support_multi_session is not None:
            result['SupportMultiSession'] = self.support_multi_session
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('BundleType') is not None:
            self.bundle_type = m.get('BundleType')
        if m.get('CheckStock') is not None:
            self.check_stock = m.get('CheckStock')
        if m.get('CpuCount') is not None:
            self.cpu_count = m.get('CpuCount')
        if m.get('DesktopTypeFamily') is not None:
            self.desktop_type_family = m.get('DesktopTypeFamily')
        if m.get('FotaChannel') is not None:
            self.fota_channel = m.get('FotaChannel')
        if m.get('FromDesktopGroup') is not None:
            self.from_desktop_group = m.get('FromDesktopGroup')
        if m.get('GpuCount') is not None:
            self.gpu_count = m.get('GpuCount')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('MemorySize') is not None:
            self.memory_size = m.get('MemorySize')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('SelectedBundle') is not None:
            self.selected_bundle = m.get('SelectedBundle')
        if m.get('SessionType') is not None:
            self.session_type = m.get('SessionType')
        if m.get('SupportMultiSession') is not None:
            self.support_multi_session = m.get('SupportMultiSession')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        return self


class DescribeBundlesResponseBodyBundlesDesktopTypeAttribute(TeaModel):
    def __init__(
        self,
        cpu_count: int = None,
        gpu_count: float = None,
        gpu_spec: str = None,
        memory_size: int = None,
    ):
        self.cpu_count = cpu_count
        self.gpu_count = gpu_count
        self.gpu_spec = gpu_spec
        self.memory_size = memory_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_count is not None:
            result['CpuCount'] = self.cpu_count
        if self.gpu_count is not None:
            result['GpuCount'] = self.gpu_count
        if self.gpu_spec is not None:
            result['GpuSpec'] = self.gpu_spec
        if self.memory_size is not None:
            result['MemorySize'] = self.memory_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CpuCount') is not None:
            self.cpu_count = m.get('CpuCount')
        if m.get('GpuCount') is not None:
            self.gpu_count = m.get('GpuCount')
        if m.get('GpuSpec') is not None:
            self.gpu_spec = m.get('GpuSpec')
        if m.get('MemorySize') is not None:
            self.memory_size = m.get('MemorySize')
        return self


class DescribeBundlesResponseBodyBundlesDisks(TeaModel):
    def __init__(
        self,
        disk_performance_level: str = None,
        disk_size: int = None,
        disk_type: str = None,
    ):
        self.disk_performance_level = disk_performance_level
        self.disk_size = disk_size
        self.disk_type = disk_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_performance_level is not None:
            result['DiskPerformanceLevel'] = self.disk_performance_level
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskPerformanceLevel') is not None:
            self.disk_performance_level = m.get('DiskPerformanceLevel')
        if m.get('DiskSize') is not None:
            self.disk_size = m.get('DiskSize')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        return self


class DescribeBundlesResponseBodyBundles(TeaModel):
    def __init__(
        self,
        bundle_id: str = None,
        bundle_name: str = None,
        bundle_type: str = None,
        creation_time: str = None,
        description: str = None,
        desktop_type: str = None,
        desktop_type_attribute: DescribeBundlesResponseBodyBundlesDesktopTypeAttribute = None,
        desktop_type_family: str = None,
        disks: List[DescribeBundlesResponseBodyBundlesDisks] = None,
        image_id: str = None,
        image_name: str = None,
        image_status: str = None,
        language: str = None,
        os_type: str = None,
        platform: str = None,
        protocol_type: str = None,
        session_type: str = None,
        stock_state: str = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
    ):
        self.bundle_id = bundle_id
        self.bundle_name = bundle_name
        self.bundle_type = bundle_type
        self.creation_time = creation_time
        self.description = description
        self.desktop_type = desktop_type
        self.desktop_type_attribute = desktop_type_attribute
        self.desktop_type_family = desktop_type_family
        self.disks = disks
        self.image_id = image_id
        self.image_name = image_name
        self.image_status = image_status
        self.language = language
        self.os_type = os_type
        self.platform = platform
        self.protocol_type = protocol_type
        self.session_type = session_type
        self.stock_state = stock_state
        self.volume_encryption_enabled = volume_encryption_enabled
        self.volume_encryption_key = volume_encryption_key

    def validate(self):
        if self.desktop_type_attribute:
            self.desktop_type_attribute.validate()
        if self.disks:
            for k in self.disks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.bundle_name is not None:
            result['BundleName'] = self.bundle_name
        if self.bundle_type is not None:
            result['BundleType'] = self.bundle_type
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.desktop_type_attribute is not None:
            result['DesktopTypeAttribute'] = self.desktop_type_attribute.to_map()
        if self.desktop_type_family is not None:
            result['DesktopTypeFamily'] = self.desktop_type_family
        result['Disks'] = []
        if self.disks is not None:
            for k in self.disks:
                result['Disks'].append(k.to_map() if k else None)
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.image_status is not None:
            result['ImageStatus'] = self.image_status
        if self.language is not None:
            result['Language'] = self.language
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.session_type is not None:
            result['SessionType'] = self.session_type
        if self.stock_state is not None:
            result['StockState'] = self.stock_state
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('BundleName') is not None:
            self.bundle_name = m.get('BundleName')
        if m.get('BundleType') is not None:
            self.bundle_type = m.get('BundleType')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('DesktopTypeAttribute') is not None:
            temp_model = DescribeBundlesResponseBodyBundlesDesktopTypeAttribute()
            self.desktop_type_attribute = temp_model.from_map(m['DesktopTypeAttribute'])
        if m.get('DesktopTypeFamily') is not None:
            self.desktop_type_family = m.get('DesktopTypeFamily')
        self.disks = []
        if m.get('Disks') is not None:
            for k in m.get('Disks'):
                temp_model = DescribeBundlesResponseBodyBundlesDisks()
                self.disks.append(temp_model.from_map(k))
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ImageStatus') is not None:
            self.image_status = m.get('ImageStatus')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('SessionType') is not None:
            self.session_type = m.get('SessionType')
        if m.get('StockState') is not None:
            self.stock_state = m.get('StockState')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        return self


class DescribeBundlesResponseBody(TeaModel):
    def __init__(
        self,
        bundles: List[DescribeBundlesResponseBodyBundles] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.bundles = bundles
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.bundles:
            for k in self.bundles:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Bundles'] = []
        if self.bundles is not None:
            for k in self.bundles:
                result['Bundles'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bundles = []
        if m.get('Bundles') is not None:
            for k in m.get('Bundles'):
                temp_model = DescribeBundlesResponseBodyBundles()
                self.bundles.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBundlesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBundlesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBundlesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCdsFileShareLinksRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        creators: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        share_id: str = None,
        share_name: str = None,
        status: str = None,
    ):
        # The ID of the cloud disk.
        self.cds_id = cds_id
        # The users that create the file sharing links.
        self.creators = creators
        # The maximum number of resources to return. Valid values: 1 to 100. Default value: 100. The number of returned resources must be less than or equal to the specified number.
        self.max_results = max_results
        # Specifies the marker after which the returned list begins. If this parameter is not specified, all results are returned. Default value: null.
        self.next_token = next_token
        # The ID of the file sharing link.
        self.share_id = share_id
        # The sharing name for fuzzy search.
        self.share_name = share_name
        # The file sharing status. Valid values: ● disabled: canceled ● enabled: valid
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.creators is not None:
            result['Creators'] = self.creators
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.share_id is not None:
            result['ShareId'] = self.share_id
        if self.share_name is not None:
            result['ShareName'] = self.share_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('Creators') is not None:
            self.creators = m.get('Creators')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ShareId') is not None:
            self.share_id = m.get('ShareId')
        if m.get('ShareName') is not None:
            self.share_name = m.get('ShareName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCdsFileShareLinksResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[CdsFileShareLinkModel] = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The operation result. A value of success indicates that the operation is successful. If the operation failed, an error message is returned.
        self.code = code
        # The data information.
        self.data = data
        # The error message that is returned. This parameter is not returned if the value of Code is `success`.
        self.message = message
        # A pagination token. It can be used in the next request to retrieve a new page of results. If NextToken is empty, no next page exists.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = CdsFileShareLinkModel()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCdsFileShareLinksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCdsFileShareLinksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCdsFileShareLinksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCensRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
    ):
        # Details about CEN instances.
        self.page_number = page_number
        # The number of the page to return.
        # 
        # Default value: 1.
        self.page_size = page_size
        # The ID of the bandwidth plan that is associated with the CEN instance.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCensResponseBodyCensPackageIds(TeaModel):
    def __init__(
        self,
        package_id: str = None,
    ):
        self.package_id = package_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.package_id is not None:
            result['PackageId'] = self.package_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PackageId') is not None:
            self.package_id = m.get('PackageId')
        return self


class DescribeCensResponseBodyCensTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # DescribeCens
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCensResponseBodyCens(TeaModel):
    def __init__(
        self,
        cen_id: str = None,
        creation_time: str = None,
        description: str = None,
        ipv_6level: str = None,
        name: str = None,
        package_ids: List[DescribeCensResponseBodyCensPackageIds] = None,
        protection_level: str = None,
        status: str = None,
        tags: List[DescribeCensResponseBodyCensTags] = None,
    ):
        # The number of entries returned per page.
        self.cen_id = cen_id
        # The tag value of the CEN instance.
        self.creation_time = creation_time
        # The tag key of the CEN instance.
        self.description = description
        # Indicates whether IPv6 is supported. Valid value: DISABLED. This value indicates that IPv6 is not supported.
        # 
        # >  IPv6 is not supported.
        self.ipv_6level = ipv_6level
        # The ID of the request.
        self.name = name
        self.package_ids = package_ids
        # The name of the CEN instance.
        self.protection_level = protection_level
        # The ID of the region.
        self.status = status
        # The ID of the CEN instance.
        self.tags = tags

    def validate(self):
        if self.package_ids:
            for k in self.package_ids:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.ipv_6level is not None:
            result['Ipv6Level'] = self.ipv_6level
        if self.name is not None:
            result['Name'] = self.name
        result['PackageIds'] = []
        if self.package_ids is not None:
            for k in self.package_ids:
                result['PackageIds'].append(k.to_map() if k else None)
        if self.protection_level is not None:
            result['ProtectionLevel'] = self.protection_level
        if self.status is not None:
            result['Status'] = self.status
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Ipv6Level') is not None:
            self.ipv_6level = m.get('Ipv6Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.package_ids = []
        if m.get('PackageIds') is not None:
            for k in m.get('PackageIds'):
                temp_model = DescribeCensResponseBodyCensPackageIds()
                self.package_ids.append(temp_model.from_map(k))
        if m.get('ProtectionLevel') is not None:
            self.protection_level = m.get('ProtectionLevel')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeCensResponseBodyCensTags()
                self.tags.append(temp_model.from_map(k))
        return self


class DescribeCensResponseBody(TeaModel):
    def __init__(
        self,
        cens: List[DescribeCensResponseBodyCens] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The level of CIDR block overlapping. Valid value: REDUCED. This value indicates that the CIDR blocks can overlap with each other but must not be the same.
        self.cens = cens
        # The status of the CEN instance. Valid values:
        # 
        # *   Creating: The CEN instance is being created.
        # *   Active: The CEN instance is running.
        # *   Deleting: The CEN instance is being deleted.
        self.page_number = page_number
        # The description of the CEN instance.
        self.page_size = page_size
        # The operation that you want to perform. Set the value to DescribeCens.
        self.request_id = request_id
        # The IDs of the bandwidth plans that are associated with the CEN instance.
        self.total_count = total_count

    def validate(self):
        if self.cens:
            for k in self.cens:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Cens'] = []
        if self.cens is not None:
            for k in self.cens:
                result['Cens'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cens = []
        if m.get('Cens') is not None:
            for k in m.get('Cens'):
                temp_model = DescribeCensResponseBodyCens()
                self.cens.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCensResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCensResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCensResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClientEventsRequest(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        desktop_ip: str = None,
        desktop_name: str = None,
        directory_id: str = None,
        end_time: str = None,
        end_user_id: str = None,
        event_type: str = None,
        event_types: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        office_site_id: str = None,
        office_site_name: str = None,
        region_id: str = None,
        start_time: str = None,
    ):
        # The ID of the Alibaba Cloud account with which the event is associated.
        self.desktop_id = desktop_id
        # The account type of the workspace. Valid values:
        # 
        # *   SIMPLE: convenience account
        # *   AD_CONNECTOR: enterprise AD account
        self.desktop_ip = desktop_ip
        # The types of event.
        self.desktop_name = desktop_name
        # The ID of the desktop group.
        self.directory_id = directory_id
        # The ID of the region where the cloud desktop resides.
        self.end_time = end_time
        # The ID of the directory to which the cloud desktop belongs.
        self.end_user_id = end_user_id
        # The ID of the workspace to which the cloud desktop belongs. If you do not specify a value for this parameter, events of all workspaces in the specified region are queried.
        self.event_type = event_type
        # Details about the events.
        self.event_types = event_types
        # The status of the event. This parameter is returned if you set the EventType parameter to DESKTOP_DISCONNECT or GET_CONNECTION_TICKET. Valid values:
        # 
        # *   200\. The value indicates that the request is successful.
        # *   An error message. The value indicates that the request failed. Example: FailedToGetConnectionTicket.
        self.max_results = max_results
        # The IP address of the client.
        self.next_token = next_token
        # The ID of the workspace to which the cloud desktop belongs.
        self.office_site_id = office_site_id
        # The OS that the client runs.
        self.office_site_name = office_site_name
        # The number of bytes that are received.
        self.region_id = region_id
        # The IP address of the cloud desktop.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_ip is not None:
            result['DesktopIp'] = self.desktop_ip
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.event_types is not None:
            result['EventTypes'] = self.event_types
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopIp') is not None:
            self.desktop_ip = m.get('DesktopIp')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('EventTypes') is not None:
            self.event_types = m.get('EventTypes')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeClientEventsResponseBodyEvents(TeaModel):
    def __init__(
        self,
        ali_uid: str = None,
        bytes_received: str = None,
        bytes_send: str = None,
        client_ip: str = None,
        client_os: str = None,
        client_version: str = None,
        desktop_group_id: str = None,
        desktop_group_name: str = None,
        desktop_id: str = None,
        desktop_ip: str = None,
        desktop_name: str = None,
        directory_id: str = None,
        directory_type: str = None,
        end_user_id: str = None,
        event_id: str = None,
        event_time: str = None,
        event_type: str = None,
        office_site_id: str = None,
        office_site_name: str = None,
        office_site_type: str = None,
        region_id: str = None,
        status: str = None,
    ):
        # The name of the cloud desktop.
        self.ali_uid = ali_uid
        # The name of the cloud desktop.
        self.bytes_received = bytes_received
        # The information about the regular user that connects to the cloud desktop from the EDS client. The information can be the RAM user ID or Active Directory (AD) username. If you do not specify a value for this parameter, events of all regular users in the specified region are queried.
        self.bytes_send = bytes_send
        # The IP address of the cloud desktop. If you do not specify a value for this parameter, events of all cloud desktops in the specified region are queried.
        self.client_ip = client_ip
        # The ID of the cloud desktop.
        self.client_os = client_os
        # DescribeClientEvents
        self.client_version = client_version
        self.desktop_group_id = desktop_group_id
        self.desktop_group_name = desktop_group_name
        # The name of the desktop group.
        self.desktop_id = desktop_id
        # The name of the workspace.
        self.desktop_ip = desktop_ip
        self.desktop_name = desktop_name
        # The type of the event.
        self.directory_id = directory_id
        # The type of event.
        self.directory_type = directory_type
        # The end of the time range to query. Specify the time in the [ISO 8601](~~25696~~) standard in the YYYY-MM-DDThh:mm:ssZ format. The time must be in UTC.
        # 
        # If you do not specify a value for this parameter, the current time is used.
        self.end_user_id = end_user_id
        # The type of event that you want to query. Valid values:
        # 
        # *   DESKTOP_CONNECT: The desktop session is established.
        # *   DESKTOP_DISCONNECT: The desktop session is disconnected.
        # *   DESKTOP_REBOOT: The cloud desktop is restarted.
        # *   CLIENT_AD_LOGIN: The AD user logs on to the client.
        # *   GET_CONNECTION_TICKET: The request to connect to the cloud desktop is sent.
        # *   DESKTOP_START: The cloud desktop is started.
        # *   DESKTOP_STOP: The cloud desktop is stopped.
        # 
        # If you do not specify a value for this parameter, events of all types are queried.
        self.event_id = event_id
        # The beginning of the time range to query. Specify the time in the [ISO 8601](~~25696~~) standard in the YYYY-MM-DDThh:mm:ssZ format. The time must be in UTC.
        # 
        # If you do not specify a value for this parameter, all events that occurred before the point in time that you specify for `EndTime` are queried.
        self.event_time = event_time
        # The query token. Set the value to the NextToken value that is returned from the last call to the DescribeClientEvents operation.
        self.event_type = event_type
        # The ID of the event.
        self.office_site_id = office_site_id
        self.office_site_name = office_site_name
        # The ID of the request.
        self.office_site_type = office_site_type
        # The ID of the cloud desktop. If you do not specify a value for this parameter, events of all cloud desktops in the specified region are queried.
        self.region_id = region_id
        # The number of bytes that are sent.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.bytes_received is not None:
            result['BytesReceived'] = self.bytes_received
        if self.bytes_send is not None:
            result['BytesSend'] = self.bytes_send
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.client_os is not None:
            result['ClientOS'] = self.client_os
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_group_name is not None:
            result['DesktopGroupName'] = self.desktop_group_name
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_ip is not None:
            result['DesktopIp'] = self.desktop_ip
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.directory_type is not None:
            result['DirectoryType'] = self.directory_type
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.office_site_type is not None:
            result['OfficeSiteType'] = self.office_site_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('BytesReceived') is not None:
            self.bytes_received = m.get('BytesReceived')
        if m.get('BytesSend') is not None:
            self.bytes_send = m.get('BytesSend')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('ClientOS') is not None:
            self.client_os = m.get('ClientOS')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopGroupName') is not None:
            self.desktop_group_name = m.get('DesktopGroupName')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopIp') is not None:
            self.desktop_ip = m.get('DesktopIp')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('DirectoryType') is not None:
            self.directory_type = m.get('DirectoryType')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OfficeSiteType') is not None:
            self.office_site_type = m.get('OfficeSiteType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeClientEventsResponseBody(TeaModel):
    def __init__(
        self,
        events: List[DescribeClientEventsResponseBodyEvents] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # The information about the regular user that connects to the cloud desktop from the EDS client. The information can be the RAM user ID or AD username.
        self.events = events
        # The ID of the region.
        self.next_token = next_token
        # The type of the directory.
        self.request_id = request_id

    def validate(self):
        if self.events:
            for k in self.events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Events'] = []
        if self.events is not None:
            for k in self.events:
                result['Events'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.events = []
        if m.get('Events') is not None:
            for k in m.get('Events'):
                temp_model = DescribeClientEventsResponseBodyEvents()
                self.events.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClientEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeClientEventsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClientEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudDriveGroupsRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        directory_id: str = None,
        directory_name: str = None,
        drive_status: str = None,
        drive_type: str = None,
        group_id: List[str] = None,
        group_name: str = None,
        group_type: str = None,
        max_results: int = None,
        next_token: str = None,
        parent_group_id: str = None,
        region_id: str = None,
    ):
        # The ID of the cloud disk in Cloud Drive Service.
        self.cds_id = cds_id
        # The workspace ID.
        self.directory_id = directory_id
        # The workspace name.
        self.directory_name = directory_name
        # The team space status. Valid values:
        # 
        # *   enabled
        # *   disabled
        # 
        # Default value: enabled.
        self.drive_status = drive_status
        # Specifies whether the space is increased.
        # 
        # *   binding: increased
        # *   unbound: not increased
        # 
        # Default value: null. The default value indicates that all spaces are queried.
        self.drive_type = drive_type
        # The team ID.
        self.group_id = group_id
        # The team name for fuzzy search.
        self.group_name = group_name
        # The team type.
        # 
        # *   org: organizational structure
        # *   directory: workspace
        # 
        # Default value: null. The default value indicates that all types of teams are queried.
        self.group_type = group_type
        # The number of entries to return on each page.
        # 
        # *   Valid values: 1 to 100
        # *   Default value: 20
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results.
        self.next_token = next_token
        # The ID of the parent node. If a parent node ID is specified, the subnodes are queried. If you set the value of this parameter to root, the root node is queried.
        # 
        # Default value: null. The default value indicates that all nodes are queried.
        self.parent_group_id = parent_group_id
        # The region ID.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.directory_name is not None:
            result['DirectoryName'] = self.directory_name
        if self.drive_status is not None:
            result['DriveStatus'] = self.drive_status
        if self.drive_type is not None:
            result['DriveType'] = self.drive_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.parent_group_id is not None:
            result['ParentGroupId'] = self.parent_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('DirectoryName') is not None:
            self.directory_name = m.get('DirectoryName')
        if m.get('DriveStatus') is not None:
            self.drive_status = m.get('DriveStatus')
        if m.get('DriveType') is not None:
            self.drive_type = m.get('DriveType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ParentGroupId') is not None:
            self.parent_group_id = m.get('ParentGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCloudDriveGroupsResponseBodyCloudDriveGroups(TeaModel):
    def __init__(
        self,
        admin_user_ids: str = None,
        create_time: str = None,
        directory_id: str = None,
        drive_id: str = None,
        group_id: str = None,
        group_name: str = None,
        org_id: str = None,
        status: str = None,
        total_size: int = None,
        used_size: str = None,
    ):
        self.admin_user_ids = admin_user_ids
        # The time when the team space was created.
        self.create_time = create_time
        # The workspace ID.
        self.directory_id = directory_id
        # The team space ID.
        self.drive_id = drive_id
        # The team ID.
        self.group_id = group_id
        # The name of the team space.
        self.group_name = group_name
        self.org_id = org_id
        # The team space status. Valid values:
        # 
        # *   enabled
        # *   disabled
        # 
        # Default value: enabled.
        self.status = status
        # The total capacity of the team space.
        self.total_size = total_size
        # The capacity of the used space. Unit: bytes.
        self.used_size = used_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.admin_user_ids is not None:
            result['AdminUserIds'] = self.admin_user_ids
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.drive_id is not None:
            result['DriveId'] = self.drive_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.org_id is not None:
            result['OrgId'] = self.org_id
        if self.status is not None:
            result['Status'] = self.status
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        if self.used_size is not None:
            result['UsedSize'] = self.used_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdminUserIds') is not None:
            self.admin_user_ids = m.get('AdminUserIds')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('DriveId') is not None:
            self.drive_id = m.get('DriveId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('OrgId') is not None:
            self.org_id = m.get('OrgId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        if m.get('UsedSize') is not None:
            self.used_size = m.get('UsedSize')
        return self


class DescribeCloudDriveGroupsResponseBody(TeaModel):
    def __init__(
        self,
        cloud_drive_groups: List[DescribeCloudDriveGroupsResponseBodyCloudDriveGroups] = None,
        count: int = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The list of team spaces.
        self.cloud_drive_groups = cloud_drive_groups
        # The total number of entries returned.
        self.count = count
        # The returned value of NextToken is a pagination token, which can be used in the next request to retrieve a new page of results.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.cloud_drive_groups:
            for k in self.cloud_drive_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CloudDriveGroups'] = []
        if self.cloud_drive_groups is not None:
            for k in self.cloud_drive_groups:
                result['CloudDriveGroups'].append(k.to_map() if k else None)
        if self.count is not None:
            result['Count'] = self.count
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cloud_drive_groups = []
        if m.get('CloudDriveGroups') is not None:
            for k in m.get('CloudDriveGroups'):
                temp_model = DescribeCloudDriveGroupsResponseBodyCloudDriveGroups()
                self.cloud_drive_groups.append(temp_model.from_map(k))
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCloudDriveGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudDriveGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudDriveGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudDrivePermissionsRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        region_id: str = None,
    ):
        self.cds_id = cds_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCloudDrivePermissionsResponseBodyCloudDrivePermissionModels(TeaModel):
    def __init__(
        self,
        end_users: List[str] = None,
        permission: str = None,
    ):
        self.end_users = end_users
        self.permission = permission

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_users is not None:
            result['EndUsers'] = self.end_users
        if self.permission is not None:
            result['Permission'] = self.permission
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndUsers') is not None:
            self.end_users = m.get('EndUsers')
        if m.get('Permission') is not None:
            self.permission = m.get('Permission')
        return self


class DescribeCloudDrivePermissionsResponseBody(TeaModel):
    def __init__(
        self,
        cloud_drive_permission_models: List[DescribeCloudDrivePermissionsResponseBodyCloudDrivePermissionModels] = None,
        request_id: str = None,
    ):
        self.cloud_drive_permission_models = cloud_drive_permission_models
        self.request_id = request_id

    def validate(self):
        if self.cloud_drive_permission_models:
            for k in self.cloud_drive_permission_models:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CloudDrivePermissionModels'] = []
        if self.cloud_drive_permission_models is not None:
            for k in self.cloud_drive_permission_models:
                result['CloudDrivePermissionModels'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cloud_drive_permission_models = []
        if m.get('CloudDrivePermissionModels') is not None:
            for k in m.get('CloudDrivePermissionModels'):
                temp_model = DescribeCloudDrivePermissionsResponseBodyCloudDrivePermissionModels()
                self.cloud_drive_permission_models.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCloudDrivePermissionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudDrivePermissionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudDrivePermissionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudDriveUsersRequest(TeaModel):
    def __init__(
        self,
        cds_id: str = None,
        end_user_id: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
    ):
        self.cds_id = cds_id
        self.end_user_id = end_user_id
        self.max_results = max_results
        self.next_token = next_token
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cds_id is not None:
            result['CdsId'] = self.cds_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CdsId') is not None:
            self.cds_id = m.get('CdsId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCloudDriveUsersResponseBodyCloudDriveUsers(TeaModel):
    def __init__(
        self,
        drive_id: str = None,
        end_user_id: str = None,
        status: str = None,
        total_size: int = None,
        used_size: int = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.drive_id = drive_id
        self.end_user_id = end_user_id
        self.status = status
        self.total_size = total_size
        self.used_size = used_size
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drive_id is not None:
            result['DriveId'] = self.drive_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.status is not None:
            result['Status'] = self.status
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        if self.used_size is not None:
            result['UsedSize'] = self.used_size
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriveId') is not None:
            self.drive_id = m.get('DriveId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        if m.get('UsedSize') is not None:
            self.used_size = m.get('UsedSize')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeCloudDriveUsersResponseBody(TeaModel):
    def __init__(
        self,
        cloud_drive_users: List[DescribeCloudDriveUsersResponseBodyCloudDriveUsers] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.cloud_drive_users = cloud_drive_users
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.cloud_drive_users:
            for k in self.cloud_drive_users:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CloudDriveUsers'] = []
        if self.cloud_drive_users is not None:
            for k in self.cloud_drive_users:
                result['CloudDriveUsers'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cloud_drive_users = []
        if m.get('CloudDriveUsers') is not None:
            for k in m.get('CloudDriveUsers'):
                temp_model = DescribeCloudDriveUsersResponseBodyCloudDriveUsers()
                self.cloud_drive_users.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCloudDriveUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudDriveUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudDriveUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomizedListHeadersRequest(TeaModel):
    def __init__(
        self,
        lang_type: str = None,
        list_type: str = None,
        region_id: str = None,
    ):
        self.lang_type = lang_type
        self.list_type = list_type
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang_type is not None:
            result['LangType'] = self.lang_type
        if self.list_type is not None:
            result['ListType'] = self.list_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LangType') is not None:
            self.lang_type = m.get('LangType')
        if m.get('ListType') is not None:
            self.list_type = m.get('ListType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCustomizedListHeadersResponseBodyHeaders(TeaModel):
    def __init__(
        self,
        display_type: str = None,
        header_key: str = None,
        header_name: str = None,
    ):
        self.display_type = display_type
        self.header_key = header_key
        self.header_name = header_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_type is not None:
            result['DisplayType'] = self.display_type
        if self.header_key is not None:
            result['HeaderKey'] = self.header_key
        if self.header_name is not None:
            result['HeaderName'] = self.header_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayType') is not None:
            self.display_type = m.get('DisplayType')
        if m.get('HeaderKey') is not None:
            self.header_key = m.get('HeaderKey')
        if m.get('HeaderName') is not None:
            self.header_name = m.get('HeaderName')
        return self


class DescribeCustomizedListHeadersResponseBody(TeaModel):
    def __init__(
        self,
        headers: List[DescribeCustomizedListHeadersResponseBodyHeaders] = None,
        request_id: str = None,
    ):
        self.headers = headers
        self.request_id = request_id

    def validate(self):
        if self.headers:
            for k in self.headers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Headers'] = []
        if self.headers is not None:
            for k in self.headers:
                result['Headers'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.headers = []
        if m.get('Headers') is not None:
            for k in m.get('Headers'):
                temp_model = DescribeCustomizedListHeadersResponseBodyHeaders()
                self.headers.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCustomizedListHeadersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomizedListHeadersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomizedListHeadersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopGroupsRequest(TeaModel):
    def __init__(
        self,
        bundle_id: List[str] = None,
        desktop_group_id: str = None,
        desktop_group_name: str = None,
        end_user_ids: List[str] = None,
        excluded_end_user_ids: List[str] = None,
        image_id: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        office_site_id: str = None,
        own_type: int = None,
        period: int = None,
        period_unit: str = None,
        policy_group_id: str = None,
        protocol_type: str = None,
        region_id: str = None,
        status: int = None,
    ):
        self.bundle_id = bundle_id
        # The desktop group ID.
        self.desktop_group_id = desktop_group_id
        # The name of the desktop group that you want to query. Fuzzy search is supported.
        self.desktop_group_name = desktop_group_name
        # The authorized users.
        self.end_user_ids = end_user_ids
        # The authorized users that you want to exclude.
        self.excluded_end_user_ids = excluded_end_user_ids
        self.image_id = image_id
        # The number of entries to return on each page. Valid values: 1 to 100. Default value: 10.
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. If the NextToken parameter is empty, no next page exists.
        self.next_token = next_token
        # The workspace ID of the desktop group that you want to query.
        self.office_site_id = office_site_id
        # The desktop group type.
        # 
        # Valid values:
        # 
        # *   0
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     personal desktop group
        # 
        #     <!-- -->
        # 
        # *   1
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     shared desktop group (multi-session)
        # 
        #     <!-- -->
        self.own_type = own_type
        # The validity period of the desktop group. The unit is specified by the PeriodUnit parameter.
        self.period = period
        # The unit of the duration.
        # 
        # Valid values:
        # 
        # *   Month
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Year
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Day
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.period_unit = period_unit
        # The ID of the policy with which the desktop group is associated.
        self.policy_group_id = policy_group_id
        # The protocol. Valid values:
        # 
        # *   ASP
        # *   HDX
        self.protocol_type = protocol_type
        # The region ID.
        self.region_id = region_id
        # The payment status of the desktop group.
        # 
        # Valid values:
        # 
        # *   0
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     unpaid
        # 
        #     <!-- -->
        # 
        # *   1
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     paid
        # 
        #     <!-- -->
        # 
        # *   2
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     overdue or expired
        # 
        #     <!-- -->
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_group_name is not None:
            result['DesktopGroupName'] = self.desktop_group_name
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.excluded_end_user_ids is not None:
            result['ExcludedEndUserIds'] = self.excluded_end_user_ids
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.own_type is not None:
            result['OwnType'] = self.own_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopGroupName') is not None:
            self.desktop_group_name = m.get('DesktopGroupName')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('ExcludedEndUserIds') is not None:
            self.excluded_end_user_ids = m.get('ExcludedEndUserIds')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OwnType') is not None:
            self.own_type = m.get('OwnType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDesktopGroupsResponseBodyDesktopGroupsCountPerStatus(TeaModel):
    def __init__(
        self,
        count: int = None,
        status: str = None,
    ):
        self.count = count
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDesktopGroupsResponseBodyDesktopGroups(TeaModel):
    def __init__(
        self,
        bind_amount: int = None,
        buy_desktops_count: int = None,
        comments: str = None,
        connect_duration: int = None,
        count_per_status: List[DescribeDesktopGroupsResponseBodyDesktopGroupsCountPerStatus] = None,
        cpu: int = None,
        create_time: str = None,
        creator: str = None,
        data_disk_category: str = None,
        data_disk_size: str = None,
        desktop_count: int = None,
        desktop_group_id: str = None,
        desktop_group_name: str = None,
        desktop_type: str = None,
        end_user_count: int = None,
        expired_time: str = None,
        gpu_count: float = None,
        gpu_driver_version: str = None,
        gpu_spec: str = None,
        idle_disconnect_duration: int = None,
        image_id: str = None,
        keep_duration: int = None,
        load_policy: int = None,
        max_desktops_count: int = None,
        memory: int = None,
        min_desktops_count: int = None,
        office_site_id: str = None,
        office_site_name: str = None,
        office_site_type: str = None,
        os_type: str = None,
        own_bundle_id: str = None,
        own_bundle_name: str = None,
        own_type: int = None,
        pay_type: str = None,
        policy_group_id: str = None,
        policy_group_name: str = None,
        protocol_type: str = None,
        ratio_threshold: float = None,
        reset_type: int = None,
        status: int = None,
        stop_duration: int = None,
        subnet_id: str = None,
        system_disk_category: str = None,
        system_disk_size: int = None,
        version: int = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
    ):
        # The number of sessions that are allowed for each cloud desktop in the multi-session desktop group.
        self.bind_amount = bind_amount
        # The number of purchased cloud desktops. Valid values: 0 to 200.
        self.buy_desktops_count = buy_desktops_count
        # The remarks.
        self.comments = comments
        # The maximum period of time during which the session is connected. When the specified maximum period of time is reached, the session is automatically disconnected. Unit: milliseconds. This parameter is required only for cloud desktops of the same desktop group.
        self.connect_duration = connect_duration
        self.count_per_status = count_per_status
        # The number of vCPUs.
        self.cpu = cpu
        # The time when the desktop group was created.
        self.create_time = create_time
        # The ID of the Alibaba Cloud account that is used to create the desktop group.
        self.creator = creator
        # The category of the data disk.
        # 
        # Valid values:
        # 
        # *   cloud_efficiency
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     ultra disk
        # 
        #     <!-- -->
        # 
        # *   cloud_ssd
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     standard SSD
        # 
        #     <!-- -->
        # 
        # *   cloud_essd
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     ehhanced SSD (ESSD)
        # 
        #     <!-- -->
        self.data_disk_category = data_disk_category
        # The size of the data disk. Unit: GiB.
        self.data_disk_size = data_disk_size
        self.desktop_count = desktop_count
        # The desktop group ID.
        self.desktop_group_id = desktop_group_id
        # The desktop group name.
        self.desktop_group_name = desktop_group_name
        self.desktop_type = desktop_type
        # The number of users that are authorized to use the desktop group.
        self.end_user_count = end_user_count
        # The time when the subscription cloud desktop expires.
        self.expired_time = expired_time
        # The number of GPUs.
        self.gpu_count = gpu_count
        self.gpu_driver_version = gpu_driver_version
        # The GPU memory.
        self.gpu_spec = gpu_spec
        # The maximum period of time during which the session is idle. When a session is idle, no inputs of keyboards or mouses are detected. When the specified maximum period of time is reached, the session is automatically disconnected. Unit: milliseconds. This parameter is required only for cloud desktops of the same desktop group.
        self.idle_disconnect_duration = idle_disconnect_duration
        # The image ID.
        self.image_id = image_id
        # The keep-alive duration of the cloud desktop after the end user disconnects from the cloud desktop. Unit: milliseconds.
        self.keep_duration = keep_duration
        # The load balancing policy of the multi-session desktop group.
        # 
        # Valid values:
        # 
        # *   0
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     depth first
        # 
        #     <!-- -->
        # 
        # *   1
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     breadth first
        # 
        #     <!-- -->
        self.load_policy = load_policy
        # The maximum number of cloud desktops that the desktop group can contain.
        self.max_desktops_count = max_desktops_count
        # The memory size. Unit: MiB.
        self.memory = memory
        # The minimum number of cloud desktops that the desktop group must contain.
        self.min_desktops_count = min_desktops_count
        # The workspace ID.
        self.office_site_id = office_site_id
        # The workspace name.
        self.office_site_name = office_site_name
        # The account type of the workspace.
        # 
        # Valid values:
        # 
        # *   PERSONAL
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     personal account type
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   SIMPLE
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     convenience account type
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   AD_CONNECTOR:
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     workspace of the enterprise AD account type
        # 
        #     <!-- -->
        # 
        # *   RAM
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     Resource Access Management (RAM) account type
        # 
        #     <!-- -->
        # 
        #     .
        self.office_site_type = office_site_type
        # The OS. Valid values:
        # 
        # *   Windows
        # *   Linux
        self.os_type = os_type
        # The desktop template ID.
        self.own_bundle_id = own_bundle_id
        # The desktop template name.
        self.own_bundle_name = own_bundle_name
        # The desktop group type.
        # 
        # Valid values:
        # 
        # *   0
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     personal desktop group
        # 
        #     <!-- -->
        # 
        # *   1
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     shared desktop group (multi-session)
        # 
        #     <!-- -->
        self.own_type = own_type
        # The billing method of the desktop group.
        # 
        # Valid values:
        # 
        # *   PostPaid
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     pay-as-you-go
        # 
        #     <!-- -->
        # 
        # *   PrePaid
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     subscription
        # 
        #     <!-- -->
        self.pay_type = pay_type
        # The policy ID.
        self.policy_group_id = policy_group_id
        # The policy name.
        self.policy_group_name = policy_group_name
        # The protocol. Valid values:
        # 
        # *   ASP
        # *   HDX
        self.protocol_type = protocol_type
        # The threshold for the ratio of connected sessions. This parameter is the condition that triggers auto scaling in a multi-session desktop group. `Ratio of connected sessions = Number of connected sessions/(Total number of cloud desktops × Maximum number of sessions allowed for each cloud desktop) × 100%`. When the specified threshold is reached, new cloud desktops are automatically created. When the specified threshold is not reached, idle cloud desktops are released.
        self.ratio_threshold = ratio_threshold
        # Indicates which type of disk that is used by cloud desktops in the desktop group is reset.
        # 
        # Valid values:
        # 
        # *   0
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     No disks are reset.
        # 
        #     <!-- -->
        # 
        # *   1
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     Only the system disk is reset.
        # 
        #     <!-- -->
        # 
        # *   2
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     Only the data disk is reset.
        # 
        #     <!-- -->
        # 
        # *   3
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     Both the system disk and data disk are reset.
        # 
        #     <!-- -->
        self.reset_type = reset_type
        # The payment status of the desktop group.
        # 
        # Valid values:
        # 
        # *   0
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     unpaid
        # 
        #     <!-- -->
        # 
        # *   1
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     paid
        # 
        #     <!-- -->
        # 
        # *   2
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     overdue or expired
        # 
        #     <!-- -->
        self.status = status
        # The period of time before the idle cloud desktop enters the Stopped state. When the specified period of time is reached, the idle cloud desktop automatically enters the Stopped state. If an end user connects to a cloud desktop that is in the Stopped state, the cloud desktop automatically starts. Unit: milliseconds.
        self.stop_duration = stop_duration
        self.subnet_id = subnet_id
        # The category of the system disk.
        # 
        # Valid values:
        # 
        # *   cloud_efficiency
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     ultra disk
        # 
        #     <!-- -->
        # 
        # *   cloud_ssd
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     standard SSD
        # 
        #     <!-- -->
        # 
        # *   cloud_essd
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     ESSD
        # 
        #     <!-- -->
        self.system_disk_category = system_disk_category
        # The size of the system disk. Unit: GiB.
        self.system_disk_size = system_disk_size
        # The version number of the desktop group.
        self.version = version
        # Indicates whether disk encryption is enabled.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key for disk encryption.
        self.volume_encryption_key = volume_encryption_key

    def validate(self):
        if self.count_per_status:
            for k in self.count_per_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_amount is not None:
            result['BindAmount'] = self.bind_amount
        if self.buy_desktops_count is not None:
            result['BuyDesktopsCount'] = self.buy_desktops_count
        if self.comments is not None:
            result['Comments'] = self.comments
        if self.connect_duration is not None:
            result['ConnectDuration'] = self.connect_duration
        result['CountPerStatus'] = []
        if self.count_per_status is not None:
            for k in self.count_per_status:
                result['CountPerStatus'].append(k.to_map() if k else None)
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.desktop_count is not None:
            result['DesktopCount'] = self.desktop_count
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_group_name is not None:
            result['DesktopGroupName'] = self.desktop_group_name
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.end_user_count is not None:
            result['EndUserCount'] = self.end_user_count
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.gpu_count is not None:
            result['GpuCount'] = self.gpu_count
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        if self.gpu_spec is not None:
            result['GpuSpec'] = self.gpu_spec
        if self.idle_disconnect_duration is not None:
            result['IdleDisconnectDuration'] = self.idle_disconnect_duration
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.keep_duration is not None:
            result['KeepDuration'] = self.keep_duration
        if self.load_policy is not None:
            result['LoadPolicy'] = self.load_policy
        if self.max_desktops_count is not None:
            result['MaxDesktopsCount'] = self.max_desktops_count
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.min_desktops_count is not None:
            result['MinDesktopsCount'] = self.min_desktops_count
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.office_site_type is not None:
            result['OfficeSiteType'] = self.office_site_type
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.own_bundle_id is not None:
            result['OwnBundleId'] = self.own_bundle_id
        if self.own_bundle_name is not None:
            result['OwnBundleName'] = self.own_bundle_name
        if self.own_type is not None:
            result['OwnType'] = self.own_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.policy_group_name is not None:
            result['PolicyGroupName'] = self.policy_group_name
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.ratio_threshold is not None:
            result['RatioThreshold'] = self.ratio_threshold
        if self.reset_type is not None:
            result['ResetType'] = self.reset_type
        if self.status is not None:
            result['Status'] = self.status
        if self.stop_duration is not None:
            result['StopDuration'] = self.stop_duration
        if self.subnet_id is not None:
            result['SubnetId'] = self.subnet_id
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        if self.version is not None:
            result['Version'] = self.version
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindAmount') is not None:
            self.bind_amount = m.get('BindAmount')
        if m.get('BuyDesktopsCount') is not None:
            self.buy_desktops_count = m.get('BuyDesktopsCount')
        if m.get('Comments') is not None:
            self.comments = m.get('Comments')
        if m.get('ConnectDuration') is not None:
            self.connect_duration = m.get('ConnectDuration')
        self.count_per_status = []
        if m.get('CountPerStatus') is not None:
            for k in m.get('CountPerStatus'):
                temp_model = DescribeDesktopGroupsResponseBodyDesktopGroupsCountPerStatus()
                self.count_per_status.append(temp_model.from_map(k))
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('DesktopCount') is not None:
            self.desktop_count = m.get('DesktopCount')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopGroupName') is not None:
            self.desktop_group_name = m.get('DesktopGroupName')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('EndUserCount') is not None:
            self.end_user_count = m.get('EndUserCount')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('GpuCount') is not None:
            self.gpu_count = m.get('GpuCount')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        if m.get('GpuSpec') is not None:
            self.gpu_spec = m.get('GpuSpec')
        if m.get('IdleDisconnectDuration') is not None:
            self.idle_disconnect_duration = m.get('IdleDisconnectDuration')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('KeepDuration') is not None:
            self.keep_duration = m.get('KeepDuration')
        if m.get('LoadPolicy') is not None:
            self.load_policy = m.get('LoadPolicy')
        if m.get('MaxDesktopsCount') is not None:
            self.max_desktops_count = m.get('MaxDesktopsCount')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('MinDesktopsCount') is not None:
            self.min_desktops_count = m.get('MinDesktopsCount')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OfficeSiteType') is not None:
            self.office_site_type = m.get('OfficeSiteType')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('OwnBundleId') is not None:
            self.own_bundle_id = m.get('OwnBundleId')
        if m.get('OwnBundleName') is not None:
            self.own_bundle_name = m.get('OwnBundleName')
        if m.get('OwnType') is not None:
            self.own_type = m.get('OwnType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('PolicyGroupName') is not None:
            self.policy_group_name = m.get('PolicyGroupName')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RatioThreshold') is not None:
            self.ratio_threshold = m.get('RatioThreshold')
        if m.get('ResetType') is not None:
            self.reset_type = m.get('ResetType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StopDuration') is not None:
            self.stop_duration = m.get('StopDuration')
        if m.get('SubnetId') is not None:
            self.subnet_id = m.get('SubnetId')
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        return self


class DescribeDesktopGroupsResponseBody(TeaModel):
    def __init__(
        self,
        desktop_groups: List[DescribeDesktopGroupsResponseBodyDesktopGroups] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # Details about desktop groups.
        self.desktop_groups = desktop_groups
        # The returned value of NextToken is a pagination token, which can be used in the next request to retrieve a new page of results.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.desktop_groups:
            for k in self.desktop_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DesktopGroups'] = []
        if self.desktop_groups is not None:
            for k in self.desktop_groups:
                result['DesktopGroups'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.desktop_groups = []
        if m.get('DesktopGroups') is not None:
            for k in m.get('DesktopGroups'):
                temp_model = DescribeDesktopGroupsResponseBodyDesktopGroups()
                self.desktop_groups.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDesktopGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopIdsByVulNamesRequest(TeaModel):
    def __init__(
        self,
        necessity: str = None,
        office_site_id: str = None,
        region_id: str = None,
        type: str = None,
        vul_name: List[str] = None,
    ):
        # The ID of the request.
        self.necessity = necessity
        # The name of vulnerability N.
        self.office_site_id = office_site_id
        # The ID of the workspace.
        self.region_id = region_id
        # The priority to fix the vulnerability or the risk level of the vulnerability. Valid values:
        # 
        # *   asap: high
        # *   later: medium
        # *   nntf: low
        self.type = type
        self.vul_name = vul_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        if self.vul_name is not None:
            result['VulName'] = self.vul_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VulName') is not None:
            self.vul_name = m.get('VulName')
        return self


class DescribeDesktopIdsByVulNamesResponseBodyDesktopItems(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        desktop_name: str = None,
    ):
        self.desktop_id = desktop_id
        self.desktop_name = desktop_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        return self


class DescribeDesktopIdsByVulNamesResponseBody(TeaModel):
    def __init__(
        self,
        desktop_items: List[DescribeDesktopIdsByVulNamesResponseBodyDesktopItems] = None,
        request_id: str = None,
    ):
        # The ID of the cloud desktop.
        self.desktop_items = desktop_items
        # Details about cloud desktops.
        self.request_id = request_id

    def validate(self):
        if self.desktop_items:
            for k in self.desktop_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DesktopItems'] = []
        if self.desktop_items is not None:
            for k in self.desktop_items:
                result['DesktopItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.desktop_items = []
        if m.get('DesktopItems') is not None:
            for k in m.get('DesktopItems'):
                temp_model = DescribeDesktopIdsByVulNamesResponseBodyDesktopItems()
                self.desktop_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDesktopIdsByVulNamesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopIdsByVulNamesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopIdsByVulNamesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopSessionsRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        end_user_id: str = None,
        office_site_id: str = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        session_status: str = None,
        start_time: str = None,
    ):
        self.end_time = end_time
        self.end_user_id = end_user_id
        self.office_site_id = office_site_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.session_status = session_status
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.session_status is not None:
            result['SessionStatus'] = self.session_status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SessionStatus') is not None:
            self.session_status = m.get('SessionStatus')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDesktopSessionsResponseBodySessions(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        client_os: str = None,
        client_version: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        end_user_apply_coordinate_time: int = None,
        end_user_id: str = None,
        latest_connection_time: int = None,
        office_site_id: str = None,
        office_site_name: str = None,
        os_type: str = None,
        protocol_type: str = None,
        session_end_time: str = None,
        session_idle_time: int = None,
        session_start_time: str = None,
        session_status: str = None,
        total_connection_time: int = None,
    ):
        self.client_ip = client_ip
        self.client_os = client_os
        self.client_version = client_version
        self.desktop_id = desktop_id
        self.desktop_name = desktop_name
        self.end_user_apply_coordinate_time = end_user_apply_coordinate_time
        self.end_user_id = end_user_id
        self.latest_connection_time = latest_connection_time
        self.office_site_id = office_site_id
        self.office_site_name = office_site_name
        self.os_type = os_type
        self.protocol_type = protocol_type
        self.session_end_time = session_end_time
        self.session_idle_time = session_idle_time
        self.session_start_time = session_start_time
        self.session_status = session_status
        self.total_connection_time = total_connection_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.client_os is not None:
            result['ClientOS'] = self.client_os
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.end_user_apply_coordinate_time is not None:
            result['EndUserApplyCoordinateTime'] = self.end_user_apply_coordinate_time
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.latest_connection_time is not None:
            result['LatestConnectionTime'] = self.latest_connection_time
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.session_end_time is not None:
            result['SessionEndTime'] = self.session_end_time
        if self.session_idle_time is not None:
            result['SessionIdleTime'] = self.session_idle_time
        if self.session_start_time is not None:
            result['SessionStartTime'] = self.session_start_time
        if self.session_status is not None:
            result['SessionStatus'] = self.session_status
        if self.total_connection_time is not None:
            result['TotalConnectionTime'] = self.total_connection_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('ClientOS') is not None:
            self.client_os = m.get('ClientOS')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('EndUserApplyCoordinateTime') is not None:
            self.end_user_apply_coordinate_time = m.get('EndUserApplyCoordinateTime')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('LatestConnectionTime') is not None:
            self.latest_connection_time = m.get('LatestConnectionTime')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('SessionEndTime') is not None:
            self.session_end_time = m.get('SessionEndTime')
        if m.get('SessionIdleTime') is not None:
            self.session_idle_time = m.get('SessionIdleTime')
        if m.get('SessionStartTime') is not None:
            self.session_start_time = m.get('SessionStartTime')
        if m.get('SessionStatus') is not None:
            self.session_status = m.get('SessionStatus')
        if m.get('TotalConnectionTime') is not None:
            self.total_connection_time = m.get('TotalConnectionTime')
        return self


class DescribeDesktopSessionsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sessions: List[DescribeDesktopSessionsResponseBodySessions] = None,
        total_count: int = None,
    ):
        self.request_id = request_id
        self.sessions = sessions
        self.total_count = total_count

    def validate(self):
        if self.sessions:
            for k in self.sessions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Sessions'] = []
        if self.sessions is not None:
            for k in self.sessions:
                result['Sessions'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.sessions = []
        if m.get('Sessions') is not None:
            for k in m.get('Sessions'):
                temp_model = DescribeDesktopSessionsResponseBodySessions()
                self.sessions.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDesktopSessionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopSessionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopSessionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopTypesRequest(TeaModel):
    def __init__(
        self,
        applied_scope: str = None,
        cpu_count: int = None,
        desktop_group_id_for_modify: str = None,
        desktop_id_for_modify: str = None,
        desktop_type_id: str = None,
        gpu_count: float = None,
        instance_type_family: str = None,
        memory_size: int = None,
        order_type: str = None,
        region_id: str = None,
    ):
        self.applied_scope = applied_scope
        self.cpu_count = cpu_count
        self.desktop_group_id_for_modify = desktop_group_id_for_modify
        self.desktop_id_for_modify = desktop_id_for_modify
        self.desktop_type_id = desktop_type_id
        self.gpu_count = gpu_count
        self.instance_type_family = instance_type_family
        self.memory_size = memory_size
        self.order_type = order_type
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applied_scope is not None:
            result['AppliedScope'] = self.applied_scope
        if self.cpu_count is not None:
            result['CpuCount'] = self.cpu_count
        if self.desktop_group_id_for_modify is not None:
            result['DesktopGroupIdForModify'] = self.desktop_group_id_for_modify
        if self.desktop_id_for_modify is not None:
            result['DesktopIdForModify'] = self.desktop_id_for_modify
        if self.desktop_type_id is not None:
            result['DesktopTypeId'] = self.desktop_type_id
        if self.gpu_count is not None:
            result['GpuCount'] = self.gpu_count
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.memory_size is not None:
            result['MemorySize'] = self.memory_size
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppliedScope') is not None:
            self.applied_scope = m.get('AppliedScope')
        if m.get('CpuCount') is not None:
            self.cpu_count = m.get('CpuCount')
        if m.get('DesktopGroupIdForModify') is not None:
            self.desktop_group_id_for_modify = m.get('DesktopGroupIdForModify')
        if m.get('DesktopIdForModify') is not None:
            self.desktop_id_for_modify = m.get('DesktopIdForModify')
        if m.get('DesktopTypeId') is not None:
            self.desktop_type_id = m.get('DesktopTypeId')
        if m.get('GpuCount') is not None:
            self.gpu_count = m.get('GpuCount')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('MemorySize') is not None:
            self.memory_size = m.get('MemorySize')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDesktopTypesResponseBodyDesktopTypes(TeaModel):
    def __init__(
        self,
        cpu_count: str = None,
        data_disk_size: str = None,
        desktop_type_id: str = None,
        desktop_type_status: str = None,
        gpu_count: float = None,
        gpu_spec: str = None,
        instance_type_family: str = None,
        memory_size: str = None,
        system_disk_size: str = None,
    ):
        self.cpu_count = cpu_count
        self.data_disk_size = data_disk_size
        self.desktop_type_id = desktop_type_id
        self.desktop_type_status = desktop_type_status
        self.gpu_count = gpu_count
        self.gpu_spec = gpu_spec
        self.instance_type_family = instance_type_family
        self.memory_size = memory_size
        self.system_disk_size = system_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_count is not None:
            result['CpuCount'] = self.cpu_count
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.desktop_type_id is not None:
            result['DesktopTypeId'] = self.desktop_type_id
        if self.desktop_type_status is not None:
            result['DesktopTypeStatus'] = self.desktop_type_status
        if self.gpu_count is not None:
            result['GpuCount'] = self.gpu_count
        if self.gpu_spec is not None:
            result['GpuSpec'] = self.gpu_spec
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.memory_size is not None:
            result['MemorySize'] = self.memory_size
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CpuCount') is not None:
            self.cpu_count = m.get('CpuCount')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('DesktopTypeId') is not None:
            self.desktop_type_id = m.get('DesktopTypeId')
        if m.get('DesktopTypeStatus') is not None:
            self.desktop_type_status = m.get('DesktopTypeStatus')
        if m.get('GpuCount') is not None:
            self.gpu_count = m.get('GpuCount')
        if m.get('GpuSpec') is not None:
            self.gpu_spec = m.get('GpuSpec')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('MemorySize') is not None:
            self.memory_size = m.get('MemorySize')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        return self


class DescribeDesktopTypesResponseBody(TeaModel):
    def __init__(
        self,
        desktop_types: List[DescribeDesktopTypesResponseBodyDesktopTypes] = None,
        request_id: str = None,
    ):
        self.desktop_types = desktop_types
        self.request_id = request_id

    def validate(self):
        if self.desktop_types:
            for k in self.desktop_types:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DesktopTypes'] = []
        if self.desktop_types is not None:
            for k in self.desktop_types:
                result['DesktopTypes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.desktop_types = []
        if m.get('DesktopTypes') is not None:
            for k in m.get('DesktopTypes'):
                temp_model = DescribeDesktopTypesResponseBodyDesktopTypes()
                self.desktop_types.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDesktopTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopTypesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopsRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag. If you specify the `Tag` parameter, you must also specify the `Key` parameter. The tag key can be up to 128 characters in length and cannot contain `http://` or `https://`. The tag key cannot start with `aliyun` or `acs:`. You cannot specify an empty string as a tag key.
        self.key = key
        # The value of the tag. The tag value can be up to 128 characters in length and cannot contain `http://` or `https://`. The tag value cannot start with `aliyun` or `acs:`.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDesktopsRequest(TeaModel):
    def __init__(
        self,
        charge_type: str = None,
        desktop_group_id: str = None,
        desktop_id: List[str] = None,
        desktop_name: str = None,
        desktop_status: str = None,
        desktop_status_list: List[str] = None,
        desktop_type: str = None,
        directory_id: str = None,
        end_user_id: List[str] = None,
        excluded_end_user_id: List[str] = None,
        expired_time: str = None,
        filter_desktop_group: bool = None,
        group_id: str = None,
        image_id: List[str] = None,
        management_flag: str = None,
        max_results: int = None,
        next_token: str = None,
        office_site_id: str = None,
        office_site_name: str = None,
        only_desktop_group: bool = None,
        os_types: List[str] = None,
        policy_group_id: str = None,
        protocol_type: str = None,
        query_fota_update: bool = None,
        region_id: str = None,
        snapshot_policy_id: str = None,
        tag: List[DescribeDesktopsRequestTag] = None,
        user_name: str = None,
    ):
        # The billing method of the cloud desktop.
        self.charge_type = charge_type
        # The ID of the desktop group. If you specify the `DesktopId` parameter, ignore the `DesktopGroupId` parameter. If you do not specify the `DesktopId` parameter, specify the `DesktopGroupId` parameter in the call to request all IDs of the cloud desktops in the specified desktop group.``
        self.desktop_group_id = desktop_group_id
        # The IDs of the cloud desktops. You can specify 1 to 100 IDs of cloud desktops.
        self.desktop_id = desktop_id
        # The name of the cloud desktop.
        self.desktop_name = desktop_name
        # The state of the cloud desktop.
        self.desktop_status = desktop_status
        self.desktop_status_list = desktop_status_list
        # The new desktop type. You can call the [DescribeDesktopTypes](~~188882~~) operation to query the IDs of supported desktop types.
        self.desktop_type = desktop_type
        # The ID of the directory. The ID is the same as the workspace ID.
        self.directory_id = directory_id
        # The IDs of the users that are assigned the cloud desktop. You can specify IDs of 1 to 100 users.
        # 
        # > Only one user can use the cloud desktop at a time.
        self.end_user_id = end_user_id
        # The IDs of the users that are excluded from the users that are assigned the cloud desktop. You can specify IDs of 1 to 100 users.
        self.excluded_end_user_id = excluded_end_user_id
        # The time when the subscription cloud desktop expires.
        self.expired_time = expired_time
        # Specifies whether to filter cloud desktops in the desktop group.
        self.filter_desktop_group = filter_desktop_group
        # The ID of the desktop group.
        self.group_id = group_id
        # 镜像ID列表。
        self.image_id = image_id
        # The flag that is used for management.
        self.management_flag = management_flag
        # The maximum number of entries to return on each page.
        # 
        # *   Maximum value: 100
        # *   Default value: 10
        self.max_results = max_results
        # The token that determines the start point of the next query. If this parameter is left empty, all results are returned.
        self.next_token = next_token
        # The ID of the workspace.
        self.office_site_id = office_site_id
        # The name of the workspace.
        self.office_site_name = office_site_name
        # Specifies whether to query cloud desktops in the desktop group.
        self.only_desktop_group = only_desktop_group
        # The types of the OSs.
        self.os_types = os_types
        # The ID of the policy.
        self.policy_group_id = policy_group_id
        # The type of the protocol.
        self.protocol_type = protocol_type
        # Specifies whether to query the information about image version of the cloud desktop.
        self.query_fota_update = query_fota_update
        # The ID of the region. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id
        # The ID of the automatic snapshot policy.
        self.snapshot_policy_id = snapshot_policy_id
        # The tags that you want to add. A tag is a key-value pair that consists of a tag key and a tag value. Tags are used to identify resources. You can use tags to manage cloud desktops by group for easy searching and batch operations. For more information, see [Use tags to manage cloud desktops](~~203781~~).
        self.tag = tag
        # The name of the user.
        self.user_name = user_name

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.desktop_status is not None:
            result['DesktopStatus'] = self.desktop_status
        if self.desktop_status_list is not None:
            result['DesktopStatusList'] = self.desktop_status_list
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.excluded_end_user_id is not None:
            result['ExcludedEndUserId'] = self.excluded_end_user_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.filter_desktop_group is not None:
            result['FilterDesktopGroup'] = self.filter_desktop_group
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.management_flag is not None:
            result['ManagementFlag'] = self.management_flag
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.only_desktop_group is not None:
            result['OnlyDesktopGroup'] = self.only_desktop_group
        if self.os_types is not None:
            result['OsTypes'] = self.os_types
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.query_fota_update is not None:
            result['QueryFotaUpdate'] = self.query_fota_update
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snapshot_policy_id is not None:
            result['SnapshotPolicyId'] = self.snapshot_policy_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DesktopStatus') is not None:
            self.desktop_status = m.get('DesktopStatus')
        if m.get('DesktopStatusList') is not None:
            self.desktop_status_list = m.get('DesktopStatusList')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('ExcludedEndUserId') is not None:
            self.excluded_end_user_id = m.get('ExcludedEndUserId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('FilterDesktopGroup') is not None:
            self.filter_desktop_group = m.get('FilterDesktopGroup')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ManagementFlag') is not None:
            self.management_flag = m.get('ManagementFlag')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OnlyDesktopGroup') is not None:
            self.only_desktop_group = m.get('OnlyDesktopGroup')
        if m.get('OsTypes') is not None:
            self.os_types = m.get('OsTypes')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('QueryFotaUpdate') is not None:
            self.query_fota_update = m.get('QueryFotaUpdate')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnapshotPolicyId') is not None:
            self.snapshot_policy_id = m.get('SnapshotPolicyId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDesktopsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeDesktopsResponseBodyDesktopsDesktopDurationList(TeaModel):
    def __init__(
        self,
        package_creation_time: str = None,
        package_expired_time: str = None,
        package_id: str = None,
        package_status: str = None,
        total_duration: int = None,
        used_duration: int = None,
    ):
        self.package_creation_time = package_creation_time
        self.package_expired_time = package_expired_time
        self.package_id = package_id
        self.package_status = package_status
        self.total_duration = total_duration
        self.used_duration = used_duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.package_creation_time is not None:
            result['PackageCreationTime'] = self.package_creation_time
        if self.package_expired_time is not None:
            result['PackageExpiredTime'] = self.package_expired_time
        if self.package_id is not None:
            result['PackageId'] = self.package_id
        if self.package_status is not None:
            result['PackageStatus'] = self.package_status
        if self.total_duration is not None:
            result['TotalDuration'] = self.total_duration
        if self.used_duration is not None:
            result['UsedDuration'] = self.used_duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PackageCreationTime') is not None:
            self.package_creation_time = m.get('PackageCreationTime')
        if m.get('PackageExpiredTime') is not None:
            self.package_expired_time = m.get('PackageExpiredTime')
        if m.get('PackageId') is not None:
            self.package_id = m.get('PackageId')
        if m.get('PackageStatus') is not None:
            self.package_status = m.get('PackageStatus')
        if m.get('TotalDuration') is not None:
            self.total_duration = m.get('TotalDuration')
        if m.get('UsedDuration') is not None:
            self.used_duration = m.get('UsedDuration')
        return self


class DescribeDesktopsResponseBodyDesktopsDisks(TeaModel):
    def __init__(
        self,
        disk_id: str = None,
        disk_size: int = None,
        disk_type: str = None,
        performance_level: str = None,
    ):
        # The ID of the disk.
        self.disk_id = disk_id
        # The size of the disk. Unit: GiB.
        self.disk_size = disk_size
        # The type of the disk.
        self.disk_type = disk_type
        # The performance level (PL) of the disk that is an enhanced SSD (ESSD). Valid values:
        # 
        # *   PL0
        # *   PL1
        # *   PL2
        # *   PL3
        # 
        # For more information about the differences between disks of different PLs, see [Enhanced SSDs](~~122389~~).
        self.performance_level = performance_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('DiskSize') is not None:
            self.disk_size = m.get('DiskSize')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        return self


class DescribeDesktopsResponseBodyDesktopsFotaUpdate(TeaModel):
    def __init__(
        self,
        current_app_version: str = None,
        new_app_version: str = None,
        release_note: str = None,
        release_note_en: str = None,
        release_note_jp: str = None,
        size: int = None,
    ):
        # The current version of the cloud desktop.
        self.current_app_version = current_app_version
        # The version to which the cloud desktop can be updated.
        self.new_app_version = new_app_version
        # The description of the version to which the cloud desktop can be updated.
        self.release_note = release_note
        self.release_note_en = release_note_en
        self.release_note_jp = release_note_jp
        # The size of the installation package for the version to which the cloud desktop can be updated. Unit: KB.
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_app_version is not None:
            result['CurrentAppVersion'] = self.current_app_version
        if self.new_app_version is not None:
            result['NewAppVersion'] = self.new_app_version
        if self.release_note is not None:
            result['ReleaseNote'] = self.release_note
        if self.release_note_en is not None:
            result['ReleaseNoteEn'] = self.release_note_en
        if self.release_note_jp is not None:
            result['ReleaseNoteJp'] = self.release_note_jp
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentAppVersion') is not None:
            self.current_app_version = m.get('CurrentAppVersion')
        if m.get('NewAppVersion') is not None:
            self.new_app_version = m.get('NewAppVersion')
        if m.get('ReleaseNote') is not None:
            self.release_note = m.get('ReleaseNote')
        if m.get('ReleaseNoteEn') is not None:
            self.release_note_en = m.get('ReleaseNoteEn')
        if m.get('ReleaseNoteJp') is not None:
            self.release_note_jp = m.get('ReleaseNoteJp')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeDesktopsResponseBodyDesktopsSessions(TeaModel):
    def __init__(
        self,
        end_user_id: str = None,
        establishment_time: str = None,
        external_user_name: str = None,
    ):
        # The ID of the user that logged on to the cloud desktop.
        self.end_user_id = end_user_id
        # The time when the desktop session was established.
        self.establishment_time = establishment_time
        # The name of the external user.
        self.external_user_name = external_user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.establishment_time is not None:
            result['EstablishmentTime'] = self.establishment_time
        if self.external_user_name is not None:
            result['ExternalUserName'] = self.external_user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EstablishmentTime') is not None:
            self.establishment_time = m.get('EstablishmentTime')
        if m.get('ExternalUserName') is not None:
            self.external_user_name = m.get('ExternalUserName')
        return self


class DescribeDesktopsResponseBodyDesktopsTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag.
        self.key = key
        # The value of the tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDesktopsResponseBodyDesktops(TeaModel):
    def __init__(
        self,
        bind_amount: int = None,
        bundle_id: str = None,
        bundle_name: str = None,
        charge_type: str = None,
        connection_status: str = None,
        cpu: int = None,
        creation_time: str = None,
        data_disk_category: str = None,
        data_disk_size: str = None,
        desktop_duration_list: List[DescribeDesktopsResponseBodyDesktopsDesktopDurationList] = None,
        desktop_group_id: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        desktop_status: str = None,
        desktop_type: str = None,
        directory_id: str = None,
        directory_type: str = None,
        disks: List[DescribeDesktopsResponseBodyDesktopsDisks] = None,
        downgrade_quota: int = None,
        downgraded_times: int = None,
        end_user_ids: List[str] = None,
        expired_time: str = None,
        fota_update: DescribeDesktopsResponseBodyDesktopsFotaUpdate = None,
        gpu_category: int = None,
        gpu_count: float = None,
        gpu_driver_version: str = None,
        gpu_spec: str = None,
        hibernation_beta: bool = None,
        hibernation_options_configured: bool = None,
        host_name: str = None,
        image_id: str = None,
        management_flag: str = None,
        management_flags: List[str] = None,
        memory: int = None,
        network_interface_id: str = None,
        network_interface_ip: str = None,
        office_site_id: str = None,
        office_site_name: str = None,
        office_site_type: str = None,
        office_site_vpc_type: str = None,
        os_type: str = None,
        platform: str = None,
        policy_group_id: str = None,
        policy_group_id_list: List[str] = None,
        policy_group_name: str = None,
        policy_group_name_list: List[str] = None,
        progress: str = None,
        protocol_type: str = None,
        session_type: str = None,
        sessions: List[DescribeDesktopsResponseBodyDesktopsSessions] = None,
        snapshot_policy_id: str = None,
        snapshot_policy_name: str = None,
        start_time: str = None,
        support_hibernation: bool = None,
        system_disk_category: str = None,
        system_disk_size: int = None,
        tags: List[DescribeDesktopsResponseBodyDesktopsTags] = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
        zone_type: str = None,
    ):
        # The number of sessions allowed for each cloud desktop in the multi-session desktop group.
        self.bind_amount = bind_amount
        # The ID of the desktop template that is used to create the cloud desktop.
        self.bundle_id = bundle_id
        # The name of the desktop template that is used to create the cloud desktop.
        self.bundle_name = bundle_name
        # The billing method of the cloud desktop.
        self.charge_type = charge_type
        # The connection status of the user.
        self.connection_status = connection_status
        # The number of vCPUs.
        self.cpu = cpu
        # The time when the cloud desktop was created.
        self.creation_time = creation_time
        # > This parameter is in invitational preview and is unavailable to the public.
        self.data_disk_category = data_disk_category
        # > This parameter is in invitational preview and is unavailable to the public.
        self.data_disk_size = data_disk_size
        self.desktop_duration_list = desktop_duration_list
        # The ID of the group to which the cloud desktop belongs. Default value: null.
        self.desktop_group_id = desktop_group_id
        # The ID of the cloud desktop.
        self.desktop_id = desktop_id
        # The name of the cloud desktop.
        self.desktop_name = desktop_name
        # The state of the cloud desktop.
        self.desktop_status = desktop_status
        # The desktop type.
        self.desktop_type = desktop_type
        # The ID is the same as the workspace ID that is indicated by the value of the OfficeSiteId parameter.
        self.directory_id = directory_id
        # This parameter is in invitational preview and unavailable for general users.
        self.directory_type = directory_type
        # Details of the disks.
        self.disks = disks
        # The number of times for which the cloud desktop can be downgraded.
        self.downgrade_quota = downgrade_quota
        # The number of times for which the cloud desktop is downgraded.
        self.downgraded_times = downgraded_times
        # The IDs of the users that have the permissions to connect to the cloud desktops.
        self.end_user_ids = end_user_ids
        # The time when the subscription cloud desktop expires.
        self.expired_time = expired_time
        # The information about the image version that the cloud desktop uses.
        self.fota_update = fota_update
        # Indicates whether the cloud desktop is of the GPU-accelerated type.
        self.gpu_category = gpu_category
        # The number of GPUs.
        self.gpu_count = gpu_count
        # The version of the GPU driver with which the cloud desktop is equipped.
        self.gpu_driver_version = gpu_driver_version
        # The GPU model.
        self.gpu_spec = gpu_spec
        self.hibernation_beta = hibernation_beta
        # > This parameter is in invitational preview and is unavailable to the public.
        self.hibernation_options_configured = hibernation_options_configured
        # The hostname of the cloud desktop.
        self.host_name = host_name
        # The ID of the image.
        self.image_id = image_id
        # The flag that is used for management.
        self.management_flag = management_flag
        self.management_flags = management_flags
        # The memory size. Unit: MiB.
        self.memory = memory
        # The ID of the secondary network interface controller (NIC) created by the RAM user or Active Directory (AD) user in EDS. You do not have the permissions to modify this ID.
        self.network_interface_id = network_interface_id
        # The IP address of the secondary NIC that is created by the RAM user or AD user in EDS.
        self.network_interface_ip = network_interface_ip
        # The ID of the workspace.
        self.office_site_id = office_site_id
        # The name of the workspace.
        self.office_site_name = office_site_name
        # The account type of the workspace.
        self.office_site_type = office_site_type
        # The virtual private cloud (VPC) type of the workspace.
        self.office_site_vpc_type = office_site_vpc_type
        # The type of the OS.
        self.os_type = os_type
        # The information about the OS platform. Valid values:
        # 
        # *   CentOS
        # *   Ubuntu
        # *   Windows Server 2016
        # *   Windows Server 2019
        # *   UOS
        self.platform = platform
        # The ID of the policy.
        self.policy_group_id = policy_group_id
        # The IDs of the policies.
        self.policy_group_id_list = policy_group_id_list
        # The name of the policy.
        self.policy_group_name = policy_group_name
        # The names of the policies.
        self.policy_group_name_list = policy_group_name_list
        # The progress when the cloud desktop was created.
        self.progress = progress
        # The type of the protocol.
        self.protocol_type = protocol_type
        # The type of the session.
        self.session_type = session_type
        # Details of the desktop sessions that users hold.
        self.sessions = sessions
        # The ID of the snapshot policy.
        self.snapshot_policy_id = snapshot_policy_id
        # The name of the snapshot policy.
        self.snapshot_policy_name = snapshot_policy_name
        # The first time when the cloud desktop was started.
        self.start_time = start_time
        # Indicates whether hibernation is supported for the cloud desktop.
        self.support_hibernation = support_hibernation
        # > This parameter is in invitational preview and is unavailable to the public.
        self.system_disk_category = system_disk_category
        # > This parameter is in invitational preview and is unavailable to the public.
        self.system_disk_size = system_disk_size
        # Details of the tags.
        self.tags = tags
        # Indicates whether disk encryption is enabled.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that is used when disk encryption is enabled. You can call the [ListKeys](~~28951~~) operation to obtain a list of KMS keys.
        self.volume_encryption_key = volume_encryption_key
        # The type of the zone. Default value: **AvailabilityZone**. This value indicates Alibaba Cloud zones.
        self.zone_type = zone_type

    def validate(self):
        if self.desktop_duration_list:
            for k in self.desktop_duration_list:
                if k:
                    k.validate()
        if self.disks:
            for k in self.disks:
                if k:
                    k.validate()
        if self.fota_update:
            self.fota_update.validate()
        if self.sessions:
            for k in self.sessions:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_amount is not None:
            result['BindAmount'] = self.bind_amount
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.bundle_name is not None:
            result['BundleName'] = self.bundle_name
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.connection_status is not None:
            result['ConnectionStatus'] = self.connection_status
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        result['DesktopDurationList'] = []
        if self.desktop_duration_list is not None:
            for k in self.desktop_duration_list:
                result['DesktopDurationList'].append(k.to_map() if k else None)
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.desktop_status is not None:
            result['DesktopStatus'] = self.desktop_status
        if self.desktop_type is not None:
            result['DesktopType'] = self.desktop_type
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.directory_type is not None:
            result['DirectoryType'] = self.directory_type
        result['Disks'] = []
        if self.disks is not None:
            for k in self.disks:
                result['Disks'].append(k.to_map() if k else None)
        if self.downgrade_quota is not None:
            result['DowngradeQuota'] = self.downgrade_quota
        if self.downgraded_times is not None:
            result['DowngradedTimes'] = self.downgraded_times
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.fota_update is not None:
            result['FotaUpdate'] = self.fota_update.to_map()
        if self.gpu_category is not None:
            result['GpuCategory'] = self.gpu_category
        if self.gpu_count is not None:
            result['GpuCount'] = self.gpu_count
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        if self.gpu_spec is not None:
            result['GpuSpec'] = self.gpu_spec
        if self.hibernation_beta is not None:
            result['HibernationBeta'] = self.hibernation_beta
        if self.hibernation_options_configured is not None:
            result['HibernationOptionsConfigured'] = self.hibernation_options_configured
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.management_flag is not None:
            result['ManagementFlag'] = self.management_flag
        if self.management_flags is not None:
            result['ManagementFlags'] = self.management_flags
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.network_interface_ip is not None:
            result['NetworkInterfaceIp'] = self.network_interface_ip
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.office_site_type is not None:
            result['OfficeSiteType'] = self.office_site_type
        if self.office_site_vpc_type is not None:
            result['OfficeSiteVpcType'] = self.office_site_vpc_type
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.policy_group_id_list is not None:
            result['PolicyGroupIdList'] = self.policy_group_id_list
        if self.policy_group_name is not None:
            result['PolicyGroupName'] = self.policy_group_name
        if self.policy_group_name_list is not None:
            result['PolicyGroupNameList'] = self.policy_group_name_list
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.session_type is not None:
            result['SessionType'] = self.session_type
        result['Sessions'] = []
        if self.sessions is not None:
            for k in self.sessions:
                result['Sessions'].append(k.to_map() if k else None)
        if self.snapshot_policy_id is not None:
            result['SnapshotPolicyId'] = self.snapshot_policy_id
        if self.snapshot_policy_name is not None:
            result['SnapshotPolicyName'] = self.snapshot_policy_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.support_hibernation is not None:
            result['SupportHibernation'] = self.support_hibernation
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        if self.zone_type is not None:
            result['ZoneType'] = self.zone_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindAmount') is not None:
            self.bind_amount = m.get('BindAmount')
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('BundleName') is not None:
            self.bundle_name = m.get('BundleName')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ConnectionStatus') is not None:
            self.connection_status = m.get('ConnectionStatus')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        self.desktop_duration_list = []
        if m.get('DesktopDurationList') is not None:
            for k in m.get('DesktopDurationList'):
                temp_model = DescribeDesktopsResponseBodyDesktopsDesktopDurationList()
                self.desktop_duration_list.append(temp_model.from_map(k))
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DesktopStatus') is not None:
            self.desktop_status = m.get('DesktopStatus')
        if m.get('DesktopType') is not None:
            self.desktop_type = m.get('DesktopType')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('DirectoryType') is not None:
            self.directory_type = m.get('DirectoryType')
        self.disks = []
        if m.get('Disks') is not None:
            for k in m.get('Disks'):
                temp_model = DescribeDesktopsResponseBodyDesktopsDisks()
                self.disks.append(temp_model.from_map(k))
        if m.get('DowngradeQuota') is not None:
            self.downgrade_quota = m.get('DowngradeQuota')
        if m.get('DowngradedTimes') is not None:
            self.downgraded_times = m.get('DowngradedTimes')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('FotaUpdate') is not None:
            temp_model = DescribeDesktopsResponseBodyDesktopsFotaUpdate()
            self.fota_update = temp_model.from_map(m['FotaUpdate'])
        if m.get('GpuCategory') is not None:
            self.gpu_category = m.get('GpuCategory')
        if m.get('GpuCount') is not None:
            self.gpu_count = m.get('GpuCount')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        if m.get('GpuSpec') is not None:
            self.gpu_spec = m.get('GpuSpec')
        if m.get('HibernationBeta') is not None:
            self.hibernation_beta = m.get('HibernationBeta')
        if m.get('HibernationOptionsConfigured') is not None:
            self.hibernation_options_configured = m.get('HibernationOptionsConfigured')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ManagementFlag') is not None:
            self.management_flag = m.get('ManagementFlag')
        if m.get('ManagementFlags') is not None:
            self.management_flags = m.get('ManagementFlags')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('NetworkInterfaceIp') is not None:
            self.network_interface_ip = m.get('NetworkInterfaceIp')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OfficeSiteType') is not None:
            self.office_site_type = m.get('OfficeSiteType')
        if m.get('OfficeSiteVpcType') is not None:
            self.office_site_vpc_type = m.get('OfficeSiteVpcType')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('PolicyGroupIdList') is not None:
            self.policy_group_id_list = m.get('PolicyGroupIdList')
        if m.get('PolicyGroupName') is not None:
            self.policy_group_name = m.get('PolicyGroupName')
        if m.get('PolicyGroupNameList') is not None:
            self.policy_group_name_list = m.get('PolicyGroupNameList')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('SessionType') is not None:
            self.session_type = m.get('SessionType')
        self.sessions = []
        if m.get('Sessions') is not None:
            for k in m.get('Sessions'):
                temp_model = DescribeDesktopsResponseBodyDesktopsSessions()
                self.sessions.append(temp_model.from_map(k))
        if m.get('SnapshotPolicyId') is not None:
            self.snapshot_policy_id = m.get('SnapshotPolicyId')
        if m.get('SnapshotPolicyName') is not None:
            self.snapshot_policy_name = m.get('SnapshotPolicyName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SupportHibernation') is not None:
            self.support_hibernation = m.get('SupportHibernation')
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeDesktopsResponseBodyDesktopsTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        if m.get('ZoneType') is not None:
            self.zone_type = m.get('ZoneType')
        return self


class DescribeDesktopsResponseBody(TeaModel):
    def __init__(
        self,
        desktops: List[DescribeDesktopsResponseBodyDesktops] = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # Details of the cloud desktops.
        self.desktops = desktops
        # The token that is used for the next query. If this parameter is empty, all results are returned.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id
        # The total number of cloud desktops.
        self.total_count = total_count

    def validate(self):
        if self.desktops:
            for k in self.desktops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Desktops'] = []
        if self.desktops is not None:
            for k in self.desktops:
                result['Desktops'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.desktops = []
        if m.get('Desktops') is not None:
            for k in m.get('Desktops'):
                temp_model = DescribeDesktopsResponseBodyDesktops()
                self.desktops.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDesktopsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDesktopsInGroupRequest(TeaModel):
    def __init__(
        self,
        desktop_group_id: str = None,
        ignore_deleted: bool = None,
        max_results: int = None,
        next_token: str = None,
        pay_type: str = None,
        region_id: str = None,
    ):
        # The desktop group ID.
        self.desktop_group_id = desktop_group_id
        # Specifies whether to ignore the deleted cloud desktops.
        self.ignore_deleted = ignore_deleted
        # The number of entries to return on each page. Valid values: 1 to 100. Default value: 10.
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. If the NextToken parameter is empty, no next page exists.
        self.next_token = next_token
        # The billing method of the desktop group.
        self.pay_type = pay_type
        # The region ID.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.ignore_deleted is not None:
            result['IgnoreDeleted'] = self.ignore_deleted
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('IgnoreDeleted') is not None:
            self.ignore_deleted = m.get('IgnoreDeleted')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDesktopsInGroupResponseBodyPaidDesktops(TeaModel):
    def __init__(
        self,
        connection_status: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        desktop_status: str = None,
        disk_type: str = None,
        end_user_id: str = None,
        end_user_ids: List[str] = None,
        end_user_name: str = None,
        end_user_names: List[str] = None,
        fota_version: str = None,
        gpu_driver_version: str = None,
        image_id: str = None,
        image_name: str = None,
        management_flag: str = None,
        management_flags: List[str] = None,
        member_eni_ip: str = None,
        os_type: str = None,
        primary_eni_ip: str = None,
        protocol_type: str = None,
        reset_time: str = None,
        system_disk_size: int = None,
    ):
        # The connection status of the cloud desktop.
        self.connection_status = connection_status
        # The cloud desktop ID.
        self.desktop_id = desktop_id
        # The cloud desktop name.
        self.desktop_name = desktop_name
        # The state of the cloud desktop.
        self.desktop_status = desktop_status
        # The disk type.
        self.disk_type = disk_type
        # The authorized user.
        self.end_user_id = end_user_id
        # The IDs of users that are connected to cloud desktops. If no users are connected, null is returned.
        self.end_user_ids = end_user_ids
        # The username of the authorized user.
        self.end_user_name = end_user_name
        # The usernames of users that are connected to cloud desktops. If no users are connected, null is returned.
        self.end_user_names = end_user_names
        # The image version.
        self.fota_version = fota_version
        # The GPU driver version.
        self.gpu_driver_version = gpu_driver_version
        # The image ID.
        self.image_id = image_id
        # The image name.
        self.image_name = image_name
        # The flag that is used for management.
        self.management_flag = management_flag
        # The flags that are used for management.
        self.management_flags = management_flags
        # The IP address of the member Elastic Network Interface (ENI).
        self.member_eni_ip = member_eni_ip
        # The OS type.
        self.os_type = os_type
        # The IP address of the primary ENI.
        self.primary_eni_ip = primary_eni_ip
        # The protocol. Valid values:
        # 
        # *   ASP
        # *   HDX
        self.protocol_type = protocol_type
        # The point in time when the cloud desktop was reset.
        self.reset_time = reset_time
        # The system disk size. Unit: GiB.
        self.system_disk_size = system_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_status is not None:
            result['ConnectionStatus'] = self.connection_status
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.desktop_status is not None:
            result['DesktopStatus'] = self.desktop_status
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.end_user_name is not None:
            result['EndUserName'] = self.end_user_name
        if self.end_user_names is not None:
            result['EndUserNames'] = self.end_user_names
        if self.fota_version is not None:
            result['FotaVersion'] = self.fota_version
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.management_flag is not None:
            result['ManagementFlag'] = self.management_flag
        if self.management_flags is not None:
            result['ManagementFlags'] = self.management_flags
        if self.member_eni_ip is not None:
            result['MemberEniIp'] = self.member_eni_ip
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.primary_eni_ip is not None:
            result['PrimaryEniIp'] = self.primary_eni_ip
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.reset_time is not None:
            result['ResetTime'] = self.reset_time
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionStatus') is not None:
            self.connection_status = m.get('ConnectionStatus')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DesktopStatus') is not None:
            self.desktop_status = m.get('DesktopStatus')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('EndUserName') is not None:
            self.end_user_name = m.get('EndUserName')
        if m.get('EndUserNames') is not None:
            self.end_user_names = m.get('EndUserNames')
        if m.get('FotaVersion') is not None:
            self.fota_version = m.get('FotaVersion')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ManagementFlag') is not None:
            self.management_flag = m.get('ManagementFlag')
        if m.get('ManagementFlags') is not None:
            self.management_flags = m.get('ManagementFlags')
        if m.get('MemberEniIp') is not None:
            self.member_eni_ip = m.get('MemberEniIp')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('PrimaryEniIp') is not None:
            self.primary_eni_ip = m.get('PrimaryEniIp')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('ResetTime') is not None:
            self.reset_time = m.get('ResetTime')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        return self


class DescribeDesktopsInGroupResponseBodyPostPaidDesktops(TeaModel):
    def __init__(
        self,
        connection_status: str = None,
        create_duration: str = None,
        create_time: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        desktop_status: str = None,
        disk_type: str = None,
        end_user_id: str = None,
        end_user_ids: List[str] = None,
        end_user_name: str = None,
        end_user_names: List[str] = None,
        fota_version: str = None,
        gpu_driver_version: str = None,
        image_id: str = None,
        image_name: str = None,
        management_flag: str = None,
        management_flags: List[str] = None,
        member_eni_ip: str = None,
        os_type: str = None,
        primary_eni_ip: str = None,
        protocol_type: str = None,
        release_time: str = None,
        reset_time: str = None,
        system_disk_size: int = None,
    ):
        # The connection status of the cloud desktop.
        self.connection_status = connection_status
        # The retention period.
        self.create_duration = create_duration
        # The time when the cloud desktop was created.
        self.create_time = create_time
        # The cloud desktop ID.
        self.desktop_id = desktop_id
        # The cloud desktop name.
        self.desktop_name = desktop_name
        # The state of the cloud desktop.
        self.desktop_status = desktop_status
        # The disk type.
        self.disk_type = disk_type
        # The authorized user.
        self.end_user_id = end_user_id
        # The IDs of users that are connected to cloud desktops. If no users are connected, null is returned.
        self.end_user_ids = end_user_ids
        # The username of the authorized user.
        self.end_user_name = end_user_name
        # The usernames of users that are connected to cloud desktops. If no users are connected, null is returned.
        self.end_user_names = end_user_names
        # The image version.
        self.fota_version = fota_version
        # The GPU driver version.
        self.gpu_driver_version = gpu_driver_version
        # The image ID.
        self.image_id = image_id
        # The image name.
        self.image_name = image_name
        # The flag that is used for management.
        self.management_flag = management_flag
        # The flags that are used for management.
        self.management_flags = management_flags
        # The IP address of the member Elastic Network Interface (ENI).
        self.member_eni_ip = member_eni_ip
        # The OS type.
        self.os_type = os_type
        # The IP address of the primary ENI.
        self.primary_eni_ip = primary_eni_ip
        # The protocol. Valid values:
        # 
        # *   ASP
        # *   HDX
        self.protocol_type = protocol_type
        # The time when the cloud desktop was released.
        self.release_time = release_time
        # The point in time when the cloud desktop was reset.
        self.reset_time = reset_time
        # The system disk size. Unit: GiB.
        self.system_disk_size = system_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_status is not None:
            result['ConnectionStatus'] = self.connection_status
        if self.create_duration is not None:
            result['CreateDuration'] = self.create_duration
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.desktop_status is not None:
            result['DesktopStatus'] = self.desktop_status
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.end_user_name is not None:
            result['EndUserName'] = self.end_user_name
        if self.end_user_names is not None:
            result['EndUserNames'] = self.end_user_names
        if self.fota_version is not None:
            result['FotaVersion'] = self.fota_version
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.management_flag is not None:
            result['ManagementFlag'] = self.management_flag
        if self.management_flags is not None:
            result['ManagementFlags'] = self.management_flags
        if self.member_eni_ip is not None:
            result['MemberEniIp'] = self.member_eni_ip
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.primary_eni_ip is not None:
            result['PrimaryEniIp'] = self.primary_eni_ip
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.reset_time is not None:
            result['ResetTime'] = self.reset_time
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionStatus') is not None:
            self.connection_status = m.get('ConnectionStatus')
        if m.get('CreateDuration') is not None:
            self.create_duration = m.get('CreateDuration')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DesktopStatus') is not None:
            self.desktop_status = m.get('DesktopStatus')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('EndUserName') is not None:
            self.end_user_name = m.get('EndUserName')
        if m.get('EndUserNames') is not None:
            self.end_user_names = m.get('EndUserNames')
        if m.get('FotaVersion') is not None:
            self.fota_version = m.get('FotaVersion')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ManagementFlag') is not None:
            self.management_flag = m.get('ManagementFlag')
        if m.get('ManagementFlags') is not None:
            self.management_flags = m.get('ManagementFlags')
        if m.get('MemberEniIp') is not None:
            self.member_eni_ip = m.get('MemberEniIp')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('PrimaryEniIp') is not None:
            self.primary_eni_ip = m.get('PrimaryEniIp')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('ResetTime') is not None:
            self.reset_time = m.get('ResetTime')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        return self


class DescribeDesktopsInGroupResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        online_pre_paid_desktops_count: int = None,
        paid_desktops: List[DescribeDesktopsInGroupResponseBodyPaidDesktops] = None,
        paid_desktops_count: int = None,
        post_paid_desktops: List[DescribeDesktopsInGroupResponseBodyPostPaidDesktops] = None,
        post_paid_desktops_count: int = None,
        post_paid_desktops_total_amount: int = None,
        request_id: str = None,
        running_pre_paid_desktops_count: int = None,
        stoped_pre_paid_desktops_count: int = None,
        stopped_pre_paid_desktops_count: int = None,
    ):
        # The returned value of NextToken is a pagination token, which can be used in the next request to retrieve a new page of results.
        self.next_token = next_token
        # The number of subscription cloud desktops that are connected.
        self.online_pre_paid_desktops_count = online_pre_paid_desktops_count
        # The subscription cloud desktops.
        self.paid_desktops = paid_desktops
        # The total number of subscription cloud desktops.
        self.paid_desktops_count = paid_desktops_count
        # The pay-as-you-go cloud desktops.
        self.post_paid_desktops = post_paid_desktops
        # The total number of pay-as-you-go cloud desktops.
        self.post_paid_desktops_count = post_paid_desktops_count
        # The total bill amount for the pay-as-you-go cloud desktops.
        self.post_paid_desktops_total_amount = post_paid_desktops_total_amount
        # The request ID.
        self.request_id = request_id
        # The number of subscription cloud desktops that are running.
        self.running_pre_paid_desktops_count = running_pre_paid_desktops_count
        # The number of subscription cloud desktops that are stopped.
        self.stoped_pre_paid_desktops_count = stoped_pre_paid_desktops_count
        self.stopped_pre_paid_desktops_count = stopped_pre_paid_desktops_count

    def validate(self):
        if self.paid_desktops:
            for k in self.paid_desktops:
                if k:
                    k.validate()
        if self.post_paid_desktops:
            for k in self.post_paid_desktops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.online_pre_paid_desktops_count is not None:
            result['OnlinePrePaidDesktopsCount'] = self.online_pre_paid_desktops_count
        result['PaidDesktops'] = []
        if self.paid_desktops is not None:
            for k in self.paid_desktops:
                result['PaidDesktops'].append(k.to_map() if k else None)
        if self.paid_desktops_count is not None:
            result['PaidDesktopsCount'] = self.paid_desktops_count
        result['PostPaidDesktops'] = []
        if self.post_paid_desktops is not None:
            for k in self.post_paid_desktops:
                result['PostPaidDesktops'].append(k.to_map() if k else None)
        if self.post_paid_desktops_count is not None:
            result['PostPaidDesktopsCount'] = self.post_paid_desktops_count
        if self.post_paid_desktops_total_amount is not None:
            result['PostPaidDesktopsTotalAmount'] = self.post_paid_desktops_total_amount
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.running_pre_paid_desktops_count is not None:
            result['RunningPrePaidDesktopsCount'] = self.running_pre_paid_desktops_count
        if self.stoped_pre_paid_desktops_count is not None:
            result['StopedPrePaidDesktopsCount'] = self.stoped_pre_paid_desktops_count
        if self.stopped_pre_paid_desktops_count is not None:
            result['StoppedPrePaidDesktopsCount'] = self.stopped_pre_paid_desktops_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OnlinePrePaidDesktopsCount') is not None:
            self.online_pre_paid_desktops_count = m.get('OnlinePrePaidDesktopsCount')
        self.paid_desktops = []
        if m.get('PaidDesktops') is not None:
            for k in m.get('PaidDesktops'):
                temp_model = DescribeDesktopsInGroupResponseBodyPaidDesktops()
                self.paid_desktops.append(temp_model.from_map(k))
        if m.get('PaidDesktopsCount') is not None:
            self.paid_desktops_count = m.get('PaidDesktopsCount')
        self.post_paid_desktops = []
        if m.get('PostPaidDesktops') is not None:
            for k in m.get('PostPaidDesktops'):
                temp_model = DescribeDesktopsInGroupResponseBodyPostPaidDesktops()
                self.post_paid_desktops.append(temp_model.from_map(k))
        if m.get('PostPaidDesktopsCount') is not None:
            self.post_paid_desktops_count = m.get('PostPaidDesktopsCount')
        if m.get('PostPaidDesktopsTotalAmount') is not None:
            self.post_paid_desktops_total_amount = m.get('PostPaidDesktopsTotalAmount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RunningPrePaidDesktopsCount') is not None:
            self.running_pre_paid_desktops_count = m.get('RunningPrePaidDesktopsCount')
        if m.get('StopedPrePaidDesktopsCount') is not None:
            self.stoped_pre_paid_desktops_count = m.get('StopedPrePaidDesktopsCount')
        if m.get('StoppedPrePaidDesktopsCount') is not None:
            self.stopped_pre_paid_desktops_count = m.get('StoppedPrePaidDesktopsCount')
        return self


class DescribeDesktopsInGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDesktopsInGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDesktopsInGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDevicesRequest(TeaModel):
    def __init__(
        self,
        ad_domain: str = None,
        client_type: str = None,
        device_id: str = None,
        directory_id: str = None,
        end_user_id: str = None,
        page_number: int = None,
        page_size: int = None,
        region: str = None,
        user_type: str = None,
    ):
        # The address of the Active Directory (AD) workspace.
        self.ad_domain = ad_domain
        # The type of the Alibaba Cloud Workspace client.
        # 
        # *   1: hardware client.
        # *   2: software client.
        self.client_type = client_type
        # The ID of the device.
        self.device_id = device_id
        # The ID of the workspace.
        self.directory_id = directory_id
        # The ID of the convenience user to whom you want to bind the device.
        self.end_user_id = end_user_id
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        # The ID of the region.
        self.region = region
        # The type of the user account.
        # 
        # *   SIMPLE: convenience account.
        # *   AD: AD account.
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_domain is not None:
            result['AdDomain'] = self.ad_domain
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region is not None:
            result['Region'] = self.region
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdDomain') is not None:
            self.ad_domain = m.get('AdDomain')
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class DescribeDevicesResponseBodyDevicesEndUserList(TeaModel):
    def __init__(
        self,
        ad_domain: str = None,
        directory_id: str = None,
        end_user_id: str = None,
        user_type: str = None,
    ):
        # The address of the AD workspace.
        self.ad_domain = ad_domain
        # The ID of the workspace.
        self.directory_id = directory_id
        # The ID of the user.
        self.end_user_id = end_user_id
        # The type of the account.
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_domain is not None:
            result['AdDomain'] = self.ad_domain
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdDomain') is not None:
            self.ad_domain = m.get('AdDomain')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class DescribeDevicesResponseBodyDevices(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        end_user_list: List[DescribeDevicesResponseBodyDevicesEndUserList] = None,
    ):
        # The ID of the device.
        self.device_id = device_id
        # The users who are bound to the device.
        self.end_user_list = end_user_list

    def validate(self):
        if self.end_user_list:
            for k in self.end_user_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        result['EndUserList'] = []
        if self.end_user_list is not None:
            for k in self.end_user_list:
                result['EndUserList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        self.end_user_list = []
        if m.get('EndUserList') is not None:
            for k in m.get('EndUserList'):
                temp_model = DescribeDevicesResponseBodyDevicesEndUserList()
                self.end_user_list.append(temp_model.from_map(k))
        return self


class DescribeDevicesResponseBody(TeaModel):
    def __init__(
        self,
        devices: List[DescribeDevicesResponseBodyDevices] = None,
        request_id: str = None,
    ):
        # Details of the devices that are returned.
        self.devices = devices
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = DescribeDevicesResponseBodyDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDevicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDirectoriesRequest(TeaModel):
    def __init__(
        self,
        directory_id: List[str] = None,
        directory_status: str = None,
        directory_type: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
        status: str = None,
    ):
        # Details of directory IDs. You can specify one or more directory IDs.
        self.directory_id = directory_id
        # The status of the directory. The value of this parameter is the same as the value of the `Status` parameter.
        self.directory_status = directory_status
        # The type of the directory.
        self.directory_type = directory_type
        # The number of entries to return on each page.
        # 
        # Maximum value: 100.
        # 
        # Default value: 10.
        self.max_results = max_results
        # The token that determines the start point of the next query. If this parameter is empty, all results are returned.
        self.next_token = next_token
        # The ID of the region. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id
        # The status of the workspace.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.directory_status is not None:
            result['DirectoryStatus'] = self.directory_status
        if self.directory_type is not None:
            result['DirectoryType'] = self.directory_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('DirectoryStatus') is not None:
            self.directory_status = m.get('DirectoryStatus')
        if m.get('DirectoryType') is not None:
            self.directory_type = m.get('DirectoryType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDirectoriesResponseBodyDirectoriesADConnectors(TeaModel):
    def __init__(
        self,
        adconnector_address: str = None,
        connector_status: str = None,
        network_interface_id: str = None,
        specification: str = None,
        trust_key: str = None,
        v_switch_id: str = None,
    ):
        # The address of the AD connector.
        self.adconnector_address = adconnector_address
        # The status of the AD connector.
        self.connector_status = connector_status
        # The ID of the network interface controller (NIC) with which the AD connector is associated.
        self.network_interface_id = network_interface_id
        # The type of the AD connector.
        self.specification = specification
        # The trust password of the AD domain controller.
        self.trust_key = trust_key
        # The ID of the vSwitch with which the AD connector is associated.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adconnector_address is not None:
            result['ADConnectorAddress'] = self.adconnector_address
        if self.connector_status is not None:
            result['ConnectorStatus'] = self.connector_status
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.trust_key is not None:
            result['TrustKey'] = self.trust_key
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ADConnectorAddress') is not None:
            self.adconnector_address = m.get('ADConnectorAddress')
        if m.get('ConnectorStatus') is not None:
            self.connector_status = m.get('ConnectorStatus')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('TrustKey') is not None:
            self.trust_key = m.get('TrustKey')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class DescribeDirectoriesResponseBodyDirectoriesLogs(TeaModel):
    def __init__(
        self,
        level: str = None,
        message: str = None,
        step: str = None,
        time_stamp: str = None,
    ):
        # The level of the log entry.
        self.level = level
        # Details of the log entry.
        self.message = message
        # The step that corresponds to the log entry.
        self.step = step
        # The time when the log entry was printed.
        self.time_stamp = time_stamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.step is not None:
            result['Step'] = self.step
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeDirectoriesResponseBodyDirectories(TeaModel):
    def __init__(
        self,
        adconnectors: List[DescribeDirectoriesResponseBodyDirectoriesADConnectors] = None,
        creation_time: str = None,
        custom_security_group_id: str = None,
        desktop_access_type: str = None,
        desktop_vpc_endpoint: str = None,
        directory_id: str = None,
        directory_type: str = None,
        dns_address: List[str] = None,
        dns_user_name: str = None,
        domain_name: str = None,
        domain_password: str = None,
        domain_user_name: str = None,
        enable_admin_access: bool = None,
        enable_cross_desktop_access: bool = None,
        enable_internet_access: bool = None,
        file_system_ids: List[str] = None,
        logs: List[DescribeDirectoriesResponseBodyDirectoriesLogs] = None,
        mfa_enabled: bool = None,
        name: str = None,
        need_verify_login_risk: bool = None,
        ou_name: str = None,
        sso_enabled: bool = None,
        status: str = None,
        sub_dns_address: List[str] = None,
        sub_domain_name: str = None,
        trust_password: str = None,
        v_switch_ids: List[str] = None,
        vpc_id: str = None,
    ):
        # Details of the AD connectors.
        self.adconnectors = adconnectors
        # The time when the directory was created.
        self.creation_time = creation_time
        # The ID of the security group.
        self.custom_security_group_id = custom_security_group_id
        # The method that is used to connect the client to cloud desktops.
        self.desktop_access_type = desktop_access_type
        # The endpoint that is used to connect to cloud desktops over a VPC.
        self.desktop_vpc_endpoint = desktop_vpc_endpoint
        # The ID of the directory.
        self.directory_id = directory_id
        # The type of the directory.
        self.directory_type = directory_type
        # Details of the DNS addresses of the directory.
        self.dns_address = dns_address
        # The username of the Domain Name System (DNS) user.
        self.dns_user_name = dns_user_name
        # The name of the domain.
        self.domain_name = domain_name
        # The password of the domain administrator.
        self.domain_password = domain_password
        # The username of the domain administrator.
        self.domain_user_name = domain_user_name
        # Indicates whether the permissions of the local administrator are granted to the regular user of the cloud desktop.
        self.enable_admin_access = enable_admin_access
        # Indicates whether the desktop communication feature is enabled for cloud desktops in the same workspace.
        # 
        # If the feature is enabled, the cloud desktops in the same workspace can access each other.
        self.enable_cross_desktop_access = enable_cross_desktop_access
        # Indicates whether access over the Internet is allowed.
        # 
        # >  This parameter is unavailable.
        self.enable_internet_access = enable_internet_access
        # Details of the IDs of the Apsara File Storage NAS (NAS) file systems.
        self.file_system_ids = file_system_ids
        # Details of the registration logs.
        self.logs = logs
        # Indicates whether multi-factor authentication (MFA) is enabled.
        self.mfa_enabled = mfa_enabled
        # The name of the directory.
        self.name = name
        # Indicates whether two-factor verification for logons is enabled. This parameter is returned only for workspaces of the convenience account type.\
        # If two-factor verification is enabled, the system checks whether security risks exist within the logon account when a convenience user logs on to the Elastic Desktop Service (EDS) client. If risks are detected, the system sends a verification code to the email address that is associated with the account. Then, the convenience user can log on to the client only after the user enters the correct verification code.
        self.need_verify_login_risk = need_verify_login_risk
        # The name of the organizational unit (OU) that you specified when you add cloud desktops to domains.
        self.ou_name = ou_name
        # Indicates whether single sign-on (SSO) is enabled.
        self.sso_enabled = sso_enabled
        # The status of the AD directory. Valid values:
        # 
        # *   REGISTERING
        # *   REGISTERED
        self.status = status
        # Details of the DNS addresses of the AD subdomain.
        self.sub_dns_address = sub_dns_address
        # The fully qualified domain name (FQDN) of the enterprise AD subdomain. The value must contain the hostname and the subdomain name. Example: child.example.com.
        self.sub_domain_name = sub_domain_name
        # The AD trust password.
        self.trust_password = trust_password
        # Details of vSwitch IDs that are specified when the directory is being created.
        self.v_switch_ids = v_switch_ids
        # The ID of the virtual private cloud (VPC) to which the vSwitch belongs.
        self.vpc_id = vpc_id

    def validate(self):
        if self.adconnectors:
            for k in self.adconnectors:
                if k:
                    k.validate()
        if self.logs:
            for k in self.logs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ADConnectors'] = []
        if self.adconnectors is not None:
            for k in self.adconnectors:
                result['ADConnectors'].append(k.to_map() if k else None)
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.custom_security_group_id is not None:
            result['CustomSecurityGroupId'] = self.custom_security_group_id
        if self.desktop_access_type is not None:
            result['DesktopAccessType'] = self.desktop_access_type
        if self.desktop_vpc_endpoint is not None:
            result['DesktopVpcEndpoint'] = self.desktop_vpc_endpoint
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.directory_type is not None:
            result['DirectoryType'] = self.directory_type
        if self.dns_address is not None:
            result['DnsAddress'] = self.dns_address
        if self.dns_user_name is not None:
            result['DnsUserName'] = self.dns_user_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_password is not None:
            result['DomainPassword'] = self.domain_password
        if self.domain_user_name is not None:
            result['DomainUserName'] = self.domain_user_name
        if self.enable_admin_access is not None:
            result['EnableAdminAccess'] = self.enable_admin_access
        if self.enable_cross_desktop_access is not None:
            result['EnableCrossDesktopAccess'] = self.enable_cross_desktop_access
        if self.enable_internet_access is not None:
            result['EnableInternetAccess'] = self.enable_internet_access
        if self.file_system_ids is not None:
            result['FileSystemIds'] = self.file_system_ids
        result['Logs'] = []
        if self.logs is not None:
            for k in self.logs:
                result['Logs'].append(k.to_map() if k else None)
        if self.mfa_enabled is not None:
            result['MfaEnabled'] = self.mfa_enabled
        if self.name is not None:
            result['Name'] = self.name
        if self.need_verify_login_risk is not None:
            result['NeedVerifyLoginRisk'] = self.need_verify_login_risk
        if self.ou_name is not None:
            result['OuName'] = self.ou_name
        if self.sso_enabled is not None:
            result['SsoEnabled'] = self.sso_enabled
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_dns_address is not None:
            result['SubDnsAddress'] = self.sub_dns_address
        if self.sub_domain_name is not None:
            result['SubDomainName'] = self.sub_domain_name
        if self.trust_password is not None:
            result['TrustPassword'] = self.trust_password
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.adconnectors = []
        if m.get('ADConnectors') is not None:
            for k in m.get('ADConnectors'):
                temp_model = DescribeDirectoriesResponseBodyDirectoriesADConnectors()
                self.adconnectors.append(temp_model.from_map(k))
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('CustomSecurityGroupId') is not None:
            self.custom_security_group_id = m.get('CustomSecurityGroupId')
        if m.get('DesktopAccessType') is not None:
            self.desktop_access_type = m.get('DesktopAccessType')
        if m.get('DesktopVpcEndpoint') is not None:
            self.desktop_vpc_endpoint = m.get('DesktopVpcEndpoint')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('DirectoryType') is not None:
            self.directory_type = m.get('DirectoryType')
        if m.get('DnsAddress') is not None:
            self.dns_address = m.get('DnsAddress')
        if m.get('DnsUserName') is not None:
            self.dns_user_name = m.get('DnsUserName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainPassword') is not None:
            self.domain_password = m.get('DomainPassword')
        if m.get('DomainUserName') is not None:
            self.domain_user_name = m.get('DomainUserName')
        if m.get('EnableAdminAccess') is not None:
            self.enable_admin_access = m.get('EnableAdminAccess')
        if m.get('EnableCrossDesktopAccess') is not None:
            self.enable_cross_desktop_access = m.get('EnableCrossDesktopAccess')
        if m.get('EnableInternetAccess') is not None:
            self.enable_internet_access = m.get('EnableInternetAccess')
        if m.get('FileSystemIds') is not None:
            self.file_system_ids = m.get('FileSystemIds')
        self.logs = []
        if m.get('Logs') is not None:
            for k in m.get('Logs'):
                temp_model = DescribeDirectoriesResponseBodyDirectoriesLogs()
                self.logs.append(temp_model.from_map(k))
        if m.get('MfaEnabled') is not None:
            self.mfa_enabled = m.get('MfaEnabled')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NeedVerifyLoginRisk') is not None:
            self.need_verify_login_risk = m.get('NeedVerifyLoginRisk')
        if m.get('OuName') is not None:
            self.ou_name = m.get('OuName')
        if m.get('SsoEnabled') is not None:
            self.sso_enabled = m.get('SsoEnabled')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubDnsAddress') is not None:
            self.sub_dns_address = m.get('SubDnsAddress')
        if m.get('SubDomainName') is not None:
            self.sub_domain_name = m.get('SubDomainName')
        if m.get('TrustPassword') is not None:
            self.trust_password = m.get('TrustPassword')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeDirectoriesResponseBody(TeaModel):
    def __init__(
        self,
        ad_hostname: str = None,
        directories: List[DescribeDirectoriesResponseBodyDirectories] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # The hostname of the domain controller. The hostname must comply with the hostname naming convention of Windows.
        self.ad_hostname = ad_hostname
        # Details of the directories.
        self.directories = directories
        # The token that is used for the next query. If this parameter is empty, all results are returned.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.directories:
            for k in self.directories:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_hostname is not None:
            result['AdHostname'] = self.ad_hostname
        result['Directories'] = []
        if self.directories is not None:
            for k in self.directories:
                result['Directories'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdHostname') is not None:
            self.ad_hostname = m.get('AdHostname')
        self.directories = []
        if m.get('Directories') is not None:
            for k in m.get('Directories'):
                temp_model = DescribeDirectoriesResponseBodyDirectories()
                self.directories.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDirectoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDirectoriesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDirectoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowMetricRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        instance_id: str = None,
        instance_type: str = None,
        metric_type: str = None,
        period: int = None,
        region_id: str = None,
        start_time: str = None,
    ):
        self.end_time = end_time
        self.instance_id = instance_id
        self.instance_type = instance_type
        self.metric_type = metric_type
        self.period = period
        self.region_id = region_id
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeFlowMetricResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFlowMetricResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFlowMetricResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFlowMetricResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowStatisticRequest(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        office_site_id: str = None,
        page_number: int = None,
        page_size: int = None,
        period: int = None,
        region_id: str = None,
    ):
        # The ID of the cloud desktop.
        self.desktop_id = desktop_id
        # The ID of the workspace.
        self.office_site_id = office_site_id
        # The number of the page to return.\
        # Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        # The interval to query the traffic data. Unit: seconds. Valid values:
        # 
        # *   3600
        # *   10800
        # *   86400
        self.period = period
        # The ID of the region.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowStatisticResponseBodyDesktopFlowStatistic(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        desktop_name: str = None,
        flow_in: str = None,
        flow_rank: int = None,
    ):
        # The ID of the cloud desktop.
        self.desktop_id = desktop_id
        # The name of the cloud desktop.
        self.desktop_name = desktop_name
        # The amount of the traffic. Unit: KB.
        self.flow_in = flow_in
        # The traffic ranking.
        self.flow_rank = flow_rank

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.flow_in is not None:
            result['FlowIn'] = self.flow_in
        if self.flow_rank is not None:
            result['FlowRank'] = self.flow_rank
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('FlowIn') is not None:
            self.flow_in = m.get('FlowIn')
        if m.get('FlowRank') is not None:
            self.flow_rank = m.get('FlowRank')
        return self


class DescribeFlowStatisticResponseBody(TeaModel):
    def __init__(
        self,
        desktop_count: int = None,
        desktop_flow_statistic: List[DescribeFlowStatisticResponseBodyDesktopFlowStatistic] = None,
        request_id: str = None,
    ):
        # The number of available cloud desktops in the workspace.
        self.desktop_count = desktop_count
        # Details of the traffic that is consumed by cloud desktops.
        self.desktop_flow_statistic = desktop_flow_statistic
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.desktop_flow_statistic:
            for k in self.desktop_flow_statistic:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_count is not None:
            result['DesktopCount'] = self.desktop_count
        result['DesktopFlowStatistic'] = []
        if self.desktop_flow_statistic is not None:
            for k in self.desktop_flow_statistic:
                result['DesktopFlowStatistic'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopCount') is not None:
            self.desktop_count = m.get('DesktopCount')
        self.desktop_flow_statistic = []
        if m.get('DesktopFlowStatistic') is not None:
            for k in m.get('DesktopFlowStatistic'):
                temp_model = DescribeFlowStatisticResponseBodyDesktopFlowStatistic()
                self.desktop_flow_statistic.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFlowStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFlowStatisticResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFlowStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFotaPendingDesktopsRequest(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        desktop_name: str = None,
        max_results: int = None,
        next_token: str = None,
        office_site_id: str = None,
        region_id: str = None,
        task_uid: str = None,
    ):
        self.desktop_id = desktop_id
        self.desktop_name = desktop_name
        self.max_results = max_results
        self.next_token = next_token
        self.office_site_id = office_site_id
        self.region_id = region_id
        self.task_uid = task_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_uid is not None:
            result['TaskUid'] = self.task_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskUid') is not None:
            self.task_uid = m.get('TaskUid')
        return self


class DescribeFotaPendingDesktopsResponseBodyFotaPendingDesktopsSessions(TeaModel):
    def __init__(
        self,
        end_user_id: str = None,
    ):
        self.end_user_id = end_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        return self


class DescribeFotaPendingDesktopsResponseBodyFotaPendingDesktops(TeaModel):
    def __init__(
        self,
        current_app_version: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        fota_project: str = None,
        office_site_id: str = None,
        sessions: List[DescribeFotaPendingDesktopsResponseBodyFotaPendingDesktopsSessions] = None,
        status: int = None,
    ):
        self.current_app_version = current_app_version
        self.desktop_id = desktop_id
        self.desktop_name = desktop_name
        self.fota_project = fota_project
        self.office_site_id = office_site_id
        self.sessions = sessions
        self.status = status

    def validate(self):
        if self.sessions:
            for k in self.sessions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_app_version is not None:
            result['CurrentAppVersion'] = self.current_app_version
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.fota_project is not None:
            result['FotaProject'] = self.fota_project
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        result['Sessions'] = []
        if self.sessions is not None:
            for k in self.sessions:
                result['Sessions'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentAppVersion') is not None:
            self.current_app_version = m.get('CurrentAppVersion')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('FotaProject') is not None:
            self.fota_project = m.get('FotaProject')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        self.sessions = []
        if m.get('Sessions') is not None:
            for k in m.get('Sessions'):
                temp_model = DescribeFotaPendingDesktopsResponseBodyFotaPendingDesktopsSessions()
                self.sessions.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeFotaPendingDesktopsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        fota_pending_desktops: List[DescribeFotaPendingDesktopsResponseBodyFotaPendingDesktops] = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.code = code
        self.fota_pending_desktops = fota_pending_desktops
        self.message = message
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.fota_pending_desktops:
            for k in self.fota_pending_desktops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['FotaPendingDesktops'] = []
        if self.fota_pending_desktops is not None:
            for k in self.fota_pending_desktops:
                result['FotaPendingDesktops'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.fota_pending_desktops = []
        if m.get('FotaPendingDesktops') is not None:
            for k in m.get('FotaPendingDesktops'):
                temp_model = DescribeFotaPendingDesktopsResponseBodyFotaPendingDesktops()
                self.fota_pending_desktops.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFotaPendingDesktopsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFotaPendingDesktopsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFotaPendingDesktopsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFotaTasksRequest(TeaModel):
    def __init__(
        self,
        fota_status: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
        task_uid: List[str] = None,
        user_status: str = None,
    ):
        # This parameter is not available.
        self.fota_status = fota_status
        # The number of entries per page.
        # 
        # *   Valid values: 1 to 100
        # *   Default value: 20
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. If the NextToken parameter is empty, no next page exists.
        self.next_token = next_token
        # The region ID. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id
        # The IDs of the image update tasks. You can call the DescribeFotaTasks operation to obtain the value of this parameter.
        self.task_uid = task_uid
        # Specifies whether to automatically push the image update task.
        # 
        # Valid values:
        # 
        # *   Running
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     automatically pushes the image update task.
        # 
        #     <!-- -->
        # 
        # *   Pending
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     does not automatically push the image update task.
        # 
        #     <!-- -->
        self.user_status = user_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fota_status is not None:
            result['FotaStatus'] = self.fota_status
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_uid is not None:
            result['TaskUid'] = self.task_uid
        if self.user_status is not None:
            result['UserStatus'] = self.user_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FotaStatus') is not None:
            self.fota_status = m.get('FotaStatus')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskUid') is not None:
            self.task_uid = m.get('TaskUid')
        if m.get('UserStatus') is not None:
            self.user_status = m.get('UserStatus')
        return self


class DescribeFotaTasksResponseBodyFotaTasks(TeaModel):
    def __init__(
        self,
        app_version: str = None,
        fota_project: str = None,
        pending_custom_image_count: int = None,
        pending_desktop_count: int = None,
        publish_time: str = None,
        release_note: str = None,
        size: int = None,
        status: str = None,
        task_uid: str = None,
    ):
        # The image version. You can call the [DescribeImages](~~188895~~) operation to obtain the value of this parameter.
        self.app_version = app_version
        # This parameter is not available.
        self.fota_project = fota_project
        # The number of custom images that can be updated to this version.
        self.pending_custom_image_count = pending_custom_image_count
        # The number of cloud desktops for which the images can be updated to this version.
        self.pending_desktop_count = pending_desktop_count
        # The time when the image version available for update was published.
        self.publish_time = publish_time
        # The description of the image version available for update.
        self.release_note = release_note
        # The size of the image update package. Unit: KB.
        self.size = size
        # Indicates whether an end user can update the image of the cloud desktop.
        # 
        # Valid values:
        # 
        # *   valid
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     The end user can update the image of the cloud desktop.
        # 
        #     <!-- -->
        # 
        # *   invalid
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     The end user cannot update the image of the cloud desktop.
        # 
        #     <!-- -->
        self.status = status
        # The ID of the image update task.
        self.task_uid = task_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.fota_project is not None:
            result['FotaProject'] = self.fota_project
        if self.pending_custom_image_count is not None:
            result['PendingCustomImageCount'] = self.pending_custom_image_count
        if self.pending_desktop_count is not None:
            result['PendingDesktopCount'] = self.pending_desktop_count
        if self.publish_time is not None:
            result['PublishTime'] = self.publish_time
        if self.release_note is not None:
            result['ReleaseNote'] = self.release_note
        if self.size is not None:
            result['Size'] = self.size
        if self.status is not None:
            result['Status'] = self.status
        if self.task_uid is not None:
            result['TaskUid'] = self.task_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('FotaProject') is not None:
            self.fota_project = m.get('FotaProject')
        if m.get('PendingCustomImageCount') is not None:
            self.pending_custom_image_count = m.get('PendingCustomImageCount')
        if m.get('PendingDesktopCount') is not None:
            self.pending_desktop_count = m.get('PendingDesktopCount')
        if m.get('PublishTime') is not None:
            self.publish_time = m.get('PublishTime')
        if m.get('ReleaseNote') is not None:
            self.release_note = m.get('ReleaseNote')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskUid') is not None:
            self.task_uid = m.get('TaskUid')
        return self


class DescribeFotaTasksResponseBody(TeaModel):
    def __init__(
        self,
        fota_tasks: List[DescribeFotaTasksResponseBodyFotaTasks] = None,
        request_id: str = None,
    ):
        # Details about the image update task.
        self.fota_tasks = fota_tasks
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.fota_tasks:
            for k in self.fota_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FotaTasks'] = []
        if self.fota_tasks is not None:
            for k in self.fota_tasks:
                result['FotaTasks'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fota_tasks = []
        if m.get('FotaTasks') is not None:
            for k in m.get('FotaTasks'):
                temp_model = DescribeFotaTasksResponseBodyFotaTasks()
                self.fota_tasks.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFotaTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFotaTasksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFotaTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFrontVulPatchListRequestVulInfo(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        name: str = None,
        tag: str = None,
    ):
        self.desktop_id = desktop_id
        self.name = name
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class DescribeFrontVulPatchListRequest(TeaModel):
    def __init__(
        self,
        operate_type: str = None,
        region_id: str = None,
        type: str = None,
        vul_info: List[DescribeFrontVulPatchListRequestVulInfo] = None,
    ):
        self.operate_type = operate_type
        self.region_id = region_id
        self.type = type
        self.vul_info = vul_info

    def validate(self):
        if self.vul_info:
            for k in self.vul_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        result['VulInfo'] = []
        if self.vul_info is not None:
            for k in self.vul_info:
                result['VulInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        self.vul_info = []
        if m.get('VulInfo') is not None:
            for k in m.get('VulInfo'):
                temp_model = DescribeFrontVulPatchListRequestVulInfo()
                self.vul_info.append(temp_model.from_map(k))
        return self


class DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        name: str = None,
    ):
        self.alias_name = alias_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeFrontVulPatchListResponseBodyFrontPatchList(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        patch_list: List[DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList] = None,
    ):
        self.desktop_id = desktop_id
        self.patch_list = patch_list

    def validate(self):
        if self.patch_list:
            for k in self.patch_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        result['PatchList'] = []
        if self.patch_list is not None:
            for k in self.patch_list:
                result['PatchList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        self.patch_list = []
        if m.get('PatchList') is not None:
            for k in m.get('PatchList'):
                temp_model = DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList()
                self.patch_list.append(temp_model.from_map(k))
        return self


class DescribeFrontVulPatchListResponseBody(TeaModel):
    def __init__(
        self,
        front_patch_list: List[DescribeFrontVulPatchListResponseBodyFrontPatchList] = None,
        request_id: str = None,
    ):
        self.front_patch_list = front_patch_list
        self.request_id = request_id

    def validate(self):
        if self.front_patch_list:
            for k in self.front_patch_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FrontPatchList'] = []
        if self.front_patch_list is not None:
            for k in self.front_patch_list:
                result['FrontPatchList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.front_patch_list = []
        if m.get('FrontPatchList') is not None:
            for k in m.get('FrontPatchList'):
                temp_model = DescribeFrontVulPatchListResponseBodyFrontPatchList()
                self.front_patch_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFrontVulPatchListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFrontVulPatchListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFrontVulPatchListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedVulRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dealed: str = None,
        lang: str = None,
        necessity: str = None,
        office_site_id: str = None,
        page_size: int = None,
        region_id: str = None,
        type: str = None,
    ):
        # The name of the vulnerability.
        self.current_page = current_page
        # The number of low-risk vulnerabilities.
        self.dealed = dealed
        # The time when the vulnerability was last detected. The timestamp follows the UNIX time format. It is the number of milliseconds that have elapsed since 00:00:00 Thursday, January 1, 1970.
        self.lang = lang
        # The natural language of the request and response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.necessity = necessity
        # The tags of the vulnerability.
        self.office_site_id = office_site_id
        # The type of the vulnerability. Valid values:
        # 
        # *   cve: Linux software vulnerability
        # *   sys: Windows system vulnerability
        self.page_size = page_size
        # The total number of entries returned.
        self.region_id = region_id
        # The maximum number of entries to return on each page.
        # 
        # Default value: 20.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeGroupedVulResponseBodyGroupedVulItems(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        asap_count: int = None,
        gmt_last: str = None,
        handled_count: int = None,
        later_count: int = None,
        name: str = None,
        nntf_count: int = None,
        tags: str = None,
        type: str = None,
    ):
        # The ID of the request.
        self.alias_name = alias_name
        self.asap_count = asap_count
        # The ID of the workspace.
        self.gmt_last = gmt_last
        # The maximum number of entries returned per page.
        self.handled_count = handled_count
        # The page number of the returned page.
        self.later_count = later_count
        self.name = name
        # The type of the vulnerability. Valid values:
        # 
        # *   cve: Linux software vulnerability
        # *   sys: Windows system vulnerability
        self.nntf_count = nntf_count
        # Details about vulnerabilities.
        self.tags = tags
        # The alias of the vulnerability.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.handled_count is not None:
            result['HandledCount'] = self.handled_count
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.name is not None:
            result['Name'] = self.name
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('HandledCount') is not None:
            self.handled_count = m.get('HandledCount')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeGroupedVulResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        grouped_vul_items: List[DescribeGroupedVulResponseBodyGroupedVulItems] = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The number of the page to return.
        # 
        # Pages start from page 1.
        # 
        # Default value: 1.
        self.current_page = current_page
        # The ID of the region.
        self.grouped_vul_items = grouped_vul_items
        # The priority to fix the vulnerability or the risk level of the vulnerability. Valid values:
        # 
        # *   asap: high
        # *   later: medium
        # *   nntf: low
        self.page_size = page_size
        # The operation that you want to perform. Set the value to DescribeGroupedVul.
        self.request_id = request_id
        # The processing status of the vulnerability. Valid values:
        # 
        # *   y: handled
        # *   n: unhandled
        self.total_count = total_count

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeGroupedVulResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedVulResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGroupedVulResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupedVulResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageModifiedRecordsRequest(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
    ):
        self.desktop_id = desktop_id
        self.max_results = max_results
        self.next_token = next_token
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeImageModifiedRecordsResponseBodyImageModifiedRecords(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        image_name: str = None,
        new_image_id: str = None,
        new_image_name: str = None,
        status: int = None,
        update_time: str = None,
    ):
        self.image_id = image_id
        self.image_name = image_name
        self.new_image_id = new_image_id
        self.new_image_name = new_image_name
        self.status = status
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.new_image_id is not None:
            result['NewImageId'] = self.new_image_id
        if self.new_image_name is not None:
            result['NewImageName'] = self.new_image_name
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('NewImageId') is not None:
            self.new_image_id = m.get('NewImageId')
        if m.get('NewImageName') is not None:
            self.new_image_name = m.get('NewImageName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeImageModifiedRecordsResponseBody(TeaModel):
    def __init__(
        self,
        image_modified_records: List[DescribeImageModifiedRecordsResponseBodyImageModifiedRecords] = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.image_modified_records = image_modified_records
        self.next_token = next_token
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.image_modified_records:
            for k in self.image_modified_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageModifiedRecords'] = []
        if self.image_modified_records is not None:
            for k in self.image_modified_records:
                result['ImageModifiedRecords'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image_modified_records = []
        if m.get('ImageModifiedRecords') is not None:
            for k in m.get('ImageModifiedRecords'):
                temp_model = DescribeImageModifiedRecordsResponseBodyImageModifiedRecords()
                self.image_modified_records.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageModifiedRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeImageModifiedRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImageModifiedRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImagePermissionRequest(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        region_id: str = None,
    ):
        self.image_id = image_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeImagePermissionResponseBody(TeaModel):
    def __init__(
        self,
        ali_uids: List[str] = None,
        request_id: str = None,
    ):
        self.ali_uids = ali_uids
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uids is not None:
            result['AliUids'] = self.ali_uids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUids') is not None:
            self.ali_uids = m.get('AliUids')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImagePermissionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeImagePermissionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImagePermissionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImagesRequest(TeaModel):
    def __init__(
        self,
        desktop_instance_type: str = None,
        fota_version: str = None,
        gpu_category: bool = None,
        gpu_driver_version: str = None,
        image_id: List[str] = None,
        image_name: str = None,
        image_status: str = None,
        image_type: str = None,
        language_type: str = None,
        max_results: int = None,
        next_token: str = None,
        os_type: str = None,
        protocol_type: str = None,
        region_id: str = None,
        session_type: str = None,
    ):
        # The cloud desktop type. You can call the [DescribeBundles](~~188884~~) operation to query the available cloud desktop types.
        self.desktop_instance_type = desktop_instance_type
        self.fota_version = fota_version
        # Specifies whether the image is a GPU-accelerated image.
        self.gpu_category = gpu_category
        # The version of the GPU driver.
        self.gpu_driver_version = gpu_driver_version
        # The IDs of the images. You can specify one or more image IDs.
        self.image_id = image_id
        self.image_name = image_name
        # The state of the image.
        self.image_status = image_status
        # The type of the image.
        self.image_type = image_type
        # The language of the OS.
        self.language_type = language_type
        # The maximum number of entries to return on each page.
        # 
        # *   Maximum value: 100.
        # *   Default value: 10.
        self.max_results = max_results
        # The token that determines the start point of the next query. If you do not specify this parameter, all results are returned.
        self.next_token = next_token
        # The type of the OS. Default value: `null`.
        self.os_type = os_type
        # The type of the protocol.
        self.protocol_type = protocol_type
        # The ID of the region. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id
        # The session type.
        self.session_type = session_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_instance_type is not None:
            result['DesktopInstanceType'] = self.desktop_instance_type
        if self.fota_version is not None:
            result['FotaVersion'] = self.fota_version
        if self.gpu_category is not None:
            result['GpuCategory'] = self.gpu_category
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.image_status is not None:
            result['ImageStatus'] = self.image_status
        if self.image_type is not None:
            result['ImageType'] = self.image_type
        if self.language_type is not None:
            result['LanguageType'] = self.language_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.session_type is not None:
            result['SessionType'] = self.session_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopInstanceType') is not None:
            self.desktop_instance_type = m.get('DesktopInstanceType')
        if m.get('FotaVersion') is not None:
            self.fota_version = m.get('FotaVersion')
        if m.get('GpuCategory') is not None:
            self.gpu_category = m.get('GpuCategory')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ImageStatus') is not None:
            self.image_status = m.get('ImageStatus')
        if m.get('ImageType') is not None:
            self.image_type = m.get('ImageType')
        if m.get('LanguageType') is not None:
            self.language_type = m.get('LanguageType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SessionType') is not None:
            self.session_type = m.get('SessionType')
        return self


class DescribeImagesResponseBodyImages(TeaModel):
    def __init__(
        self,
        app_version: str = None,
        creation_time: str = None,
        data_disk_size: int = None,
        description: str = None,
        gpu_category: bool = None,
        gpu_driver_version: str = None,
        image_id: str = None,
        image_type: str = None,
        name: str = None,
        os_type: str = None,
        platform: str = None,
        progress: str = None,
        protocol_type: str = None,
        session_type: str = None,
        shared_count: int = None,
        size: int = None,
        status: str = None,
        supported_languages: List[str] = None,
        update_time: str = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
    ):
        # The version of the image.
        self.app_version = app_version
        # The time when the image was created.
        self.creation_time = creation_time
        # The size of the data disk. Unit: GiB.
        self.data_disk_size = data_disk_size
        # The description of the image.
        self.description = description
        # Indicates whether the image is a GPU-accelerated image.
        self.gpu_category = gpu_category
        # The version of the GPU driver.
        self.gpu_driver_version = gpu_driver_version
        # The ID of the image.
        self.image_id = image_id
        # The type of the image.
        self.image_type = image_type
        # The name of the image.
        self.name = name
        # The OS type of the image.
        self.os_type = os_type
        # The OS type of the image.
        self.platform = platform
        # The progress of image creation. Unit: percentage (%).
        self.progress = progress
        # The type of the protocol.
        self.protocol_type = protocol_type
        # The session type of the image. Valid values:
        # 
        # *   SINGLE_SESSION: single-session images
        # *   MULTIPLE_SESSION: multi-session images
        self.session_type = session_type
        # The number of shared images.
        self.shared_count = shared_count
        # The size of the image. Unit: GiB.
        self.size = size
        # The state of the image.
        self.status = status
        # The languages of the OS.
        self.supported_languages = supported_languages
        # The time when the image was last modified.
        self.update_time = update_time
        # Indicates whether disk encryption is enabled.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that is used when disk encryption is enabled. You can call the [ListKeys](~~28951~~) operation to obtain the list of KMS keys.
        self.volume_encryption_key = volume_encryption_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.description is not None:
            result['Description'] = self.description
        if self.gpu_category is not None:
            result['GpuCategory'] = self.gpu_category
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_type is not None:
            result['ImageType'] = self.image_type
        if self.name is not None:
            result['Name'] = self.name
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.session_type is not None:
            result['SessionType'] = self.session_type
        if self.shared_count is not None:
            result['SharedCount'] = self.shared_count
        if self.size is not None:
            result['Size'] = self.size
        if self.status is not None:
            result['Status'] = self.status
        if self.supported_languages is not None:
            result['SupportedLanguages'] = self.supported_languages
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GpuCategory') is not None:
            self.gpu_category = m.get('GpuCategory')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageType') is not None:
            self.image_type = m.get('ImageType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('SessionType') is not None:
            self.session_type = m.get('SessionType')
        if m.get('SharedCount') is not None:
            self.shared_count = m.get('SharedCount')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SupportedLanguages') is not None:
            self.supported_languages = m.get('SupportedLanguages')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        return self


class DescribeImagesResponseBody(TeaModel):
    def __init__(
        self,
        images: List[DescribeImagesResponseBodyImages] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # The details of the images.
        self.images = images
        # The token that determines the start point of the next query. If this parameter is empty, all results are returned.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.images:
            for k in self.images:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Images'] = []
        if self.images is not None:
            for k in self.images:
                result['Images'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.images = []
        if m.get('Images') is not None:
            for k in m.get('Images'):
                temp_model = DescribeImagesResponseBodyImages()
                self.images.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeImagesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInvocationsRequest(TeaModel):
    def __init__(
        self,
        command_type: str = None,
        content_encoding: str = None,
        desktop_id: str = None,
        desktop_ids: List[str] = None,
        end_user_id: str = None,
        include_output: bool = None,
        invoke_id: str = None,
        invoke_status: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
    ):
        self.command_type = command_type
        self.content_encoding = content_encoding
        self.desktop_id = desktop_id
        self.desktop_ids = desktop_ids
        self.end_user_id = end_user_id
        self.include_output = include_output
        self.invoke_id = invoke_id
        self.invoke_status = invoke_status
        self.max_results = max_results
        self.next_token = next_token
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command_type is not None:
            result['CommandType'] = self.command_type
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_ids is not None:
            result['DesktopIds'] = self.desktop_ids
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.include_output is not None:
            result['IncludeOutput'] = self.include_output
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        if self.invoke_status is not None:
            result['InvokeStatus'] = self.invoke_status
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommandType') is not None:
            self.command_type = m.get('CommandType')
        if m.get('ContentEncoding') is not None:
            self.content_encoding = m.get('ContentEncoding')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopIds') is not None:
            self.desktop_ids = m.get('DesktopIds')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('IncludeOutput') is not None:
            self.include_output = m.get('IncludeOutput')
        if m.get('InvokeId') is not None:
            self.invoke_id = m.get('InvokeId')
        if m.get('InvokeStatus') is not None:
            self.invoke_status = m.get('InvokeStatus')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeInvocationsResponseBodyInvocationsInvokeDesktops(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        dropped: int = None,
        error_code: str = None,
        error_info: str = None,
        exit_code: int = None,
        finish_time: str = None,
        invocation_status: str = None,
        output: str = None,
        repeats: int = None,
        start_time: str = None,
        stop_time: str = None,
        update_time: str = None,
    ):
        self.creation_time = creation_time
        self.desktop_id = desktop_id
        self.desktop_name = desktop_name
        self.dropped = dropped
        self.error_code = error_code
        self.error_info = error_info
        self.exit_code = exit_code
        self.finish_time = finish_time
        self.invocation_status = invocation_status
        self.output = output
        self.repeats = repeats
        self.start_time = start_time
        self.stop_time = stop_time
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.dropped is not None:
            result['Dropped'] = self.dropped
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_info is not None:
            result['ErrorInfo'] = self.error_info
        if self.exit_code is not None:
            result['ExitCode'] = self.exit_code
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.invocation_status is not None:
            result['InvocationStatus'] = self.invocation_status
        if self.output is not None:
            result['Output'] = self.output
        if self.repeats is not None:
            result['Repeats'] = self.repeats
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('Dropped') is not None:
            self.dropped = m.get('Dropped')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorInfo') is not None:
            self.error_info = m.get('ErrorInfo')
        if m.get('ExitCode') is not None:
            self.exit_code = m.get('ExitCode')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('InvocationStatus') is not None:
            self.invocation_status = m.get('InvocationStatus')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('Repeats') is not None:
            self.repeats = m.get('Repeats')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeInvocationsResponseBodyInvocations(TeaModel):
    def __init__(
        self,
        command_content: str = None,
        command_type: str = None,
        creation_time: str = None,
        end_user_id: str = None,
        invocation_status: str = None,
        invoke_desktops: List[DescribeInvocationsResponseBodyInvocationsInvokeDesktops] = None,
        invoke_id: str = None,
    ):
        self.command_content = command_content
        self.command_type = command_type
        self.creation_time = creation_time
        self.end_user_id = end_user_id
        self.invocation_status = invocation_status
        self.invoke_desktops = invoke_desktops
        self.invoke_id = invoke_id

    def validate(self):
        if self.invoke_desktops:
            for k in self.invoke_desktops:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command_content is not None:
            result['CommandContent'] = self.command_content
        if self.command_type is not None:
            result['CommandType'] = self.command_type
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.invocation_status is not None:
            result['InvocationStatus'] = self.invocation_status
        result['InvokeDesktops'] = []
        if self.invoke_desktops is not None:
            for k in self.invoke_desktops:
                result['InvokeDesktops'].append(k.to_map() if k else None)
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommandContent') is not None:
            self.command_content = m.get('CommandContent')
        if m.get('CommandType') is not None:
            self.command_type = m.get('CommandType')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('InvocationStatus') is not None:
            self.invocation_status = m.get('InvocationStatus')
        self.invoke_desktops = []
        if m.get('InvokeDesktops') is not None:
            for k in m.get('InvokeDesktops'):
                temp_model = DescribeInvocationsResponseBodyInvocationsInvokeDesktops()
                self.invoke_desktops.append(temp_model.from_map(k))
        if m.get('InvokeId') is not None:
            self.invoke_id = m.get('InvokeId')
        return self


class DescribeInvocationsResponseBody(TeaModel):
    def __init__(
        self,
        invocations: List[DescribeInvocationsResponseBodyInvocations] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.invocations = invocations
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.invocations:
            for k in self.invocations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Invocations'] = []
        if self.invocations is not None:
            for k in self.invocations:
                result['Invocations'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.invocations = []
        if m.get('Invocations') is not None:
            for k in m.get('Invocations'):
                temp_model = DescribeInvocationsResponseBodyInvocations()
                self.invocations.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInvocationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInvocationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInvocationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeKmsKeysRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeKmsKeysResponseBodyKeys(TeaModel):
    def __init__(
        self,
        alias: str = None,
        arn: str = None,
        key_id: str = None,
        type: str = None,
    ):
        self.alias = alias
        self.arn = arn
        self.key_id = key_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.key_id is not None:
            result['KeyId'] = self.key_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('KeyId') is not None:
            self.key_id = m.get('KeyId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeKmsKeysResponseBody(TeaModel):
    def __init__(
        self,
        authorize_status: str = None,
        keys: List[DescribeKmsKeysResponseBodyKeys] = None,
        kms_service_status: str = None,
        request_id: str = None,
    ):
        self.authorize_status = authorize_status
        self.keys = keys
        self.kms_service_status = kms_service_status
        self.request_id = request_id

    def validate(self):
        if self.keys:
            for k in self.keys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorize_status is not None:
            result['AuthorizeStatus'] = self.authorize_status
        result['Keys'] = []
        if self.keys is not None:
            for k in self.keys:
                result['Keys'].append(k.to_map() if k else None)
        if self.kms_service_status is not None:
            result['KmsServiceStatus'] = self.kms_service_status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthorizeStatus') is not None:
            self.authorize_status = m.get('AuthorizeStatus')
        self.keys = []
        if m.get('Keys') is not None:
            for k in m.get('Keys'):
                temp_model = DescribeKmsKeysResponseBodyKeys()
                self.keys.append(temp_model.from_map(k))
        if m.get('KmsServiceStatus') is not None:
            self.kms_service_status = m.get('KmsServiceStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeKmsKeysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeKmsKeysResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeKmsKeysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNASFileSystemsRequest(TeaModel):
    def __init__(
        self,
        file_system_id: List[str] = None,
        match_compatible_profile: bool = None,
        max_results: int = None,
        next_token: str = None,
        office_site_id: str = None,
        region_id: str = None,
    ):
        self.file_system_id = file_system_id
        self.match_compatible_profile = match_compatible_profile
        self.max_results = max_results
        self.next_token = next_token
        self.office_site_id = office_site_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.match_compatible_profile is not None:
            result['MatchCompatibleProfile'] = self.match_compatible_profile
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('MatchCompatibleProfile') is not None:
            self.match_compatible_profile = m.get('MatchCompatibleProfile')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeNASFileSystemsResponseBodyFileSystemsDesktopGroups(TeaModel):
    def __init__(
        self,
        desktop_group_id: str = None,
        desktop_group_name: str = None,
    ):
        self.desktop_group_id = desktop_group_id
        self.desktop_group_name = desktop_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_group_name is not None:
            result['DesktopGroupName'] = self.desktop_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopGroupName') is not None:
            self.desktop_group_name = m.get('DesktopGroupName')
        return self


class DescribeNASFileSystemsResponseBodyFileSystems(TeaModel):
    def __init__(
        self,
        capacity: int = None,
        create_time: str = None,
        description: str = None,
        desktop_groups: List[DescribeNASFileSystemsResponseBodyFileSystemsDesktopGroups] = None,
        encryption_enabled: bool = None,
        file_system_id: str = None,
        file_system_name: str = None,
        file_system_status: str = None,
        file_system_type: str = None,
        metered_size: int = None,
        mount_target_domain: str = None,
        mount_target_status: str = None,
        office_site_id: str = None,
        office_site_name: str = None,
        profile_compatible: bool = None,
        region_id: str = None,
        storage_type: str = None,
        support_acl: bool = None,
        zone_id: str = None,
    ):
        self.capacity = capacity
        self.create_time = create_time
        self.description = description
        self.desktop_groups = desktop_groups
        self.encryption_enabled = encryption_enabled
        self.file_system_id = file_system_id
        self.file_system_name = file_system_name
        self.file_system_status = file_system_status
        self.file_system_type = file_system_type
        self.metered_size = metered_size
        self.mount_target_domain = mount_target_domain
        self.mount_target_status = mount_target_status
        self.office_site_id = office_site_id
        self.office_site_name = office_site_name
        self.profile_compatible = profile_compatible
        self.region_id = region_id
        self.storage_type = storage_type
        self.support_acl = support_acl
        self.zone_id = zone_id

    def validate(self):
        if self.desktop_groups:
            for k in self.desktop_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity is not None:
            result['Capacity'] = self.capacity
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        result['DesktopGroups'] = []
        if self.desktop_groups is not None:
            for k in self.desktop_groups:
                result['DesktopGroups'].append(k.to_map() if k else None)
        if self.encryption_enabled is not None:
            result['EncryptionEnabled'] = self.encryption_enabled
        if self.file_system_id is not None:
            result['FileSystemId'] = self.file_system_id
        if self.file_system_name is not None:
            result['FileSystemName'] = self.file_system_name
        if self.file_system_status is not None:
            result['FileSystemStatus'] = self.file_system_status
        if self.file_system_type is not None:
            result['FileSystemType'] = self.file_system_type
        if self.metered_size is not None:
            result['MeteredSize'] = self.metered_size
        if self.mount_target_domain is not None:
            result['MountTargetDomain'] = self.mount_target_domain
        if self.mount_target_status is not None:
            result['MountTargetStatus'] = self.mount_target_status
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.profile_compatible is not None:
            result['ProfileCompatible'] = self.profile_compatible
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        if self.support_acl is not None:
            result['SupportAcl'] = self.support_acl
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Capacity') is not None:
            self.capacity = m.get('Capacity')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.desktop_groups = []
        if m.get('DesktopGroups') is not None:
            for k in m.get('DesktopGroups'):
                temp_model = DescribeNASFileSystemsResponseBodyFileSystemsDesktopGroups()
                self.desktop_groups.append(temp_model.from_map(k))
        if m.get('EncryptionEnabled') is not None:
            self.encryption_enabled = m.get('EncryptionEnabled')
        if m.get('FileSystemId') is not None:
            self.file_system_id = m.get('FileSystemId')
        if m.get('FileSystemName') is not None:
            self.file_system_name = m.get('FileSystemName')
        if m.get('FileSystemStatus') is not None:
            self.file_system_status = m.get('FileSystemStatus')
        if m.get('FileSystemType') is not None:
            self.file_system_type = m.get('FileSystemType')
        if m.get('MeteredSize') is not None:
            self.metered_size = m.get('MeteredSize')
        if m.get('MountTargetDomain') is not None:
            self.mount_target_domain = m.get('MountTargetDomain')
        if m.get('MountTargetStatus') is not None:
            self.mount_target_status = m.get('MountTargetStatus')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('ProfileCompatible') is not None:
            self.profile_compatible = m.get('ProfileCompatible')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        if m.get('SupportAcl') is not None:
            self.support_acl = m.get('SupportAcl')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeNASFileSystemsResponseBody(TeaModel):
    def __init__(
        self,
        file_systems: List[DescribeNASFileSystemsResponseBodyFileSystems] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.file_systems = file_systems
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.file_systems:
            for k in self.file_systems:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileSystems'] = []
        if self.file_systems is not None:
            for k in self.file_systems:
                result['FileSystems'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_systems = []
        if m.get('FileSystems') is not None:
            for k in m.get('FileSystems'):
                temp_model = DescribeNASFileSystemsResponseBodyFileSystems()
                self.file_systems.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNASFileSystemsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNASFileSystemsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNASFileSystemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNetworkPackagesRequest(TeaModel):
    def __init__(
        self,
        internet_charge_type: str = None,
        max_results: int = None,
        network_package_id: List[str] = None,
        next_token: str = None,
        region_id: str = None,
    ):
        # The billing method of the Internet access package. Valid values:
        # 
        # *   PayByTraffic: pay-by-data-transfer
        # *   PayByBandwidth: pay-by-bandwidth
        self.internet_charge_type = internet_charge_type
        # The number of entries to return on each page.
        # 
        # *   Maximum value: 100
        # *   Default value: 10
        self.max_results = max_results
        # The IDs of the Internet access packages. You can specify 1 to 100 IDs of Internet access packages.
        self.network_package_id = network_package_id
        # The token that determines the start point of the next query.
        self.next_token = next_token
        # The ID of the region.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.network_package_id is not None:
            result['NetworkPackageId'] = self.network_package_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NetworkPackageId') is not None:
            self.network_package_id = m.get('NetworkPackageId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeNetworkPackagesResponseBodyNetworkPackages(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        create_time: str = None,
        eip_addresses: List[str] = None,
        expired_time: str = None,
        internet_charge_type: str = None,
        network_package_id: str = None,
        network_package_status: str = None,
        office_site_id: str = None,
        office_site_name: str = None,
        office_site_vpc_type: str = None,
        pay_type: str = None,
        reservation_active_time: str = None,
        reservation_bandwidth: int = None,
        reservation_internet_charge_type: str = None,
    ):
        # The maximum public bandwidth of the Internet access package. Unit: Mbit/s.
        self.bandwidth = bandwidth
        # The time when the Internet access package was created.
        self.create_time = create_time
        # The elastic IP addresses (EIPs) of the Internet access package for outbound traffic.
        self.eip_addresses = eip_addresses
        # The time when the Internet access package expires.
        # 
        # *   If the Internet access package is metered on a pay-by-bandwidth basis, the actual expiration time is returned.
        # *   If the Internet access package is metered on a pay-by-data-transfer basis, 2099-12-31T15:59:59Z is returned.
        self.expired_time = expired_time
        # The billing method of the network bandwidth.
        # 
        # *   PayByTraffic: pay-by-data-transfer
        # *   PayByBandwidth: pay-by-bandwidth
        self.internet_charge_type = internet_charge_type
        # The ID of the Internet access package.
        self.network_package_id = network_package_id
        # The state of the Internet access package. Valid values:
        # 
        # *   Creating
        # *   InUse
        # *   Releasing
        # *   Released
        self.network_package_status = network_package_status
        # The ID of the workspace.
        self.office_site_id = office_site_id
        # The name of the workspace.
        self.office_site_name = office_site_name
        # The type of the workspace. Valid values:
        # 
        # *   basic
        # *   standard
        # *   customized
        self.office_site_vpc_type = office_site_vpc_type
        # The billing method for the network.
        # 
        # *   PrePaid: subscription
        # *   PostPaid: pay-as-you-go
        self.pay_type = pay_type
        # The time when the reserved network bandwidth takes effect.
        self.reservation_active_time = reservation_active_time
        # The peak bandwidth of the reserved network bandwidth. Unit: Mbit/s.
        self.reservation_bandwidth = reservation_bandwidth
        # The billing method of the reserved network bandwidth.
        # 
        # *   PayByTraffic: pay-by-data-transfer
        # *   PayByBandwidth: pay-by-bandwidth
        self.reservation_internet_charge_type = reservation_internet_charge_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.eip_addresses is not None:
            result['EipAddresses'] = self.eip_addresses
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.network_package_id is not None:
            result['NetworkPackageId'] = self.network_package_id
        if self.network_package_status is not None:
            result['NetworkPackageStatus'] = self.network_package_status
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.office_site_vpc_type is not None:
            result['OfficeSiteVpcType'] = self.office_site_vpc_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.reservation_active_time is not None:
            result['ReservationActiveTime'] = self.reservation_active_time
        if self.reservation_bandwidth is not None:
            result['ReservationBandwidth'] = self.reservation_bandwidth
        if self.reservation_internet_charge_type is not None:
            result['ReservationInternetChargeType'] = self.reservation_internet_charge_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EipAddresses') is not None:
            self.eip_addresses = m.get('EipAddresses')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('NetworkPackageId') is not None:
            self.network_package_id = m.get('NetworkPackageId')
        if m.get('NetworkPackageStatus') is not None:
            self.network_package_status = m.get('NetworkPackageStatus')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('OfficeSiteVpcType') is not None:
            self.office_site_vpc_type = m.get('OfficeSiteVpcType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('ReservationActiveTime') is not None:
            self.reservation_active_time = m.get('ReservationActiveTime')
        if m.get('ReservationBandwidth') is not None:
            self.reservation_bandwidth = m.get('ReservationBandwidth')
        if m.get('ReservationInternetChargeType') is not None:
            self.reservation_internet_charge_type = m.get('ReservationInternetChargeType')
        return self


class DescribeNetworkPackagesResponseBody(TeaModel):
    def __init__(
        self,
        network_packages: List[DescribeNetworkPackagesResponseBodyNetworkPackages] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # Details of the Internet access packages.
        self.network_packages = network_packages
        # The token that is used to start the next query. If the value of this parameter is empty, all results are returned.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.network_packages:
            for k in self.network_packages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NetworkPackages'] = []
        if self.network_packages is not None:
            for k in self.network_packages:
                result['NetworkPackages'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.network_packages = []
        if m.get('NetworkPackages') is not None:
            for k in m.get('NetworkPackages'):
                temp_model = DescribeNetworkPackagesResponseBodyNetworkPackages()
                self.network_packages.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNetworkPackagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNetworkPackagesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNetworkPackagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOfficeSitesRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        office_site_id: List[str] = None,
        office_site_type: str = None,
        region_id: str = None,
        status: str = None,
    ):
        # The number of entries to return on each page.
        # 
        # *   Maximum value: 100.
        # *   Default value: 10.
        self.max_results = max_results
        # The token that determines the start point of the next query.
        self.next_token = next_token
        # The IDs of the workspaces. You can specify 1 to 100 IDs of workspaces.
        self.office_site_id = office_site_id
        # The account type of the workspace.
        self.office_site_type = office_site_type
        # The ID of the region.
        self.region_id = region_id
        # The state of the workspace.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_type is not None:
            result['OfficeSiteType'] = self.office_site_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteType') is not None:
            self.office_site_type = m.get('OfficeSiteType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeOfficeSitesResponseBodyOfficeSitesADConnectors(TeaModel):
    def __init__(
        self,
        adconnector_address: str = None,
        connector_status: str = None,
        network_interface_id: str = None,
        specification: str = None,
        trust_key: str = None,
        v_switch_id: str = None,
    ):
        # The IP address of the AD connector.
        self.adconnector_address = adconnector_address
        # The state of the AD connector.
        self.connector_status = connector_status
        # The ID of the network interface controller (NIC) that is associated with the AD connector.
        self.network_interface_id = network_interface_id
        # The type of the AD connector.
        self.specification = specification
        # The trust password that is specified when you configured the AD trust relationship.
        self.trust_key = trust_key
        # The ID of the vSwitch that corresponds to the network of the AD connector.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adconnector_address is not None:
            result['ADConnectorAddress'] = self.adconnector_address
        if self.connector_status is not None:
            result['ConnectorStatus'] = self.connector_status
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.trust_key is not None:
            result['TrustKey'] = self.trust_key
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ADConnectorAddress') is not None:
            self.adconnector_address = m.get('ADConnectorAddress')
        if m.get('ConnectorStatus') is not None:
            self.connector_status = m.get('ConnectorStatus')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('TrustKey') is not None:
            self.trust_key = m.get('TrustKey')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class DescribeOfficeSitesResponseBodyOfficeSitesLogs(TeaModel):
    def __init__(
        self,
        level: str = None,
        message: str = None,
        step: str = None,
        time_stamp: str = None,
    ):
        # The log level.
        self.level = level
        # Details of the log entry.
        self.message = message
        # The step that corresponds to the log entry.
        self.step = step
        # The time when the log entry was printed.
        self.time_stamp = time_stamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.step is not None:
            result['Step'] = self.step
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeOfficeSitesResponseBodyOfficeSites(TeaModel):
    def __init__(
        self,
        adconnectors: List[DescribeOfficeSitesResponseBodyOfficeSitesADConnectors] = None,
        ad_hostname: str = None,
        bandwidth: int = None,
        cen_attach_status: str = None,
        cen_id: str = None,
        cidr_block: str = None,
        cloud_box_office_site: bool = None,
        creation_time: str = None,
        custom_security_group_id: str = None,
        desktop_access_type: str = None,
        desktop_count: int = None,
        desktop_vpc_endpoint: str = None,
        dns_address: List[str] = None,
        dns_user_name: str = None,
        domain_name: str = None,
        domain_password: str = None,
        domain_user_name: str = None,
        enable_admin_access: bool = None,
        enable_cross_desktop_access: bool = None,
        enable_internet_access: bool = None,
        file_system_ids: List[str] = None,
        logs: List[DescribeOfficeSitesResponseBodyOfficeSitesLogs] = None,
        mfa_enabled: bool = None,
        name: str = None,
        need_verify_login_risk: bool = None,
        need_verify_zero_device: bool = None,
        network_package_id: str = None,
        office_site_id: str = None,
        office_site_type: str = None,
        ou_name: str = None,
        protocol_type: str = None,
        rds_license_address: str = None,
        rds_license_domain_name: str = None,
        rds_license_status: str = None,
        sso_enabled: bool = None,
        sso_type: str = None,
        status: str = None,
        sub_dns_address: List[str] = None,
        sub_domain_name: str = None,
        total_eds_count: int = None,
        total_eds_count_for_group: int = None,
        trust_password: str = None,
        v_switch_ids: List[str] = None,
        vpc_id: str = None,
        vpc_type: str = None,
    ):
        # Details of the AD connectors.
        self.adconnectors = adconnectors
        # The hostname of the domain controller. The hostname must comply with the naming conventions for hostnames in Windows.
        self.ad_hostname = ad_hostname
        # The maximum public bandwidth of the Internet access package. Valid values: 0 to 1000.\
        # If the value of this parameter is 0, Internet access is disabled.
        self.bandwidth = bandwidth
        self.cen_attach_status = cen_attach_status
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id
        # The IPv4 CIDR block that is included in the secure office network of the workspace.
        self.cidr_block = cidr_block
        # Indicates whether the workspace is created for cloud desktops on a cloud box.
        self.cloud_box_office_site = cloud_box_office_site
        # The time when the workspace was created.
        self.creation_time = creation_time
        # The ID of the security group.
        self.custom_security_group_id = custom_security_group_id
        # The method used to connect the Alibaba Cloud Workspace client to cloud desktops.
        self.desktop_access_type = desktop_access_type
        # The number of cloud desktops that are created.
        self.desktop_count = desktop_count
        # The endpoint that is used to connect to cloud desktops over a VPC.
        self.desktop_vpc_endpoint = desktop_vpc_endpoint
        # The DNS addresses of the AD domains.
        self.dns_address = dns_address
        # The username of the DNS account.
        self.dns_user_name = dns_user_name
        # The domain name of the enterprise Active Directory (AD) system.
        self.domain_name = domain_name
        # The password of the domain administrator.
        self.domain_password = domain_password
        # The username of the domain administrator.
        self.domain_user_name = domain_user_name
        # Indicates whether the permissions of the desktop administrator are granted to the user of the cloud desktop.
        self.enable_admin_access = enable_admin_access
        # Indicates whether the desktop communication feature is enabled for cloud desktops in the same workspace. If the feature is enabled, cloud desktops in the same workspace can access each other.
        self.enable_cross_desktop_access = enable_cross_desktop_access
        # Indicates whether Internet access is enabled.
        self.enable_internet_access = enable_internet_access
        # The IDs of the Apsara File Storage NAS (NAS) file systems.
        self.file_system_ids = file_system_ids
        # Details of the registration logs.
        self.logs = logs
        # Indicates whether multi-factor authentication (MFA) is enabled.
        self.mfa_enabled = mfa_enabled
        # The name of the workspace. The name is unique in the same region.
        self.name = name
        # Indicates whether two-factor verification for logons is enabled. This parameter is returned only for workspaces of the convenience account type.\
        # If two-factor verification is enabled, the system checks whether security risks exist within the logon account when a convenience user logs on to an Alibaba Cloud Workspace client. If risks are detected, the system sends a verification code to the email address that is associated with the account. Then, the convenience user can log on to the client only after the user enters the correct verification code.
        self.need_verify_login_risk = need_verify_login_risk
        # Indicates whether trusted device verification is enabled.
        self.need_verify_zero_device = need_verify_zero_device
        # The ID of the Internet access package.
        self.network_package_id = network_package_id
        # The ID of the workspace.
        self.office_site_id = office_site_id
        # The account type of the workspace.
        self.office_site_type = office_site_type
        # The name of the organizational unit (OU) that is connected to the AD domain.
        self.ou_name = ou_name
        # The type of the protocol.
        self.protocol_type = protocol_type
        self.rds_license_address = rds_license_address
        self.rds_license_domain_name = rds_license_domain_name
        self.rds_license_status = rds_license_status
        # Indicates whether single sign-on (SSO) is enabled.
        self.sso_enabled = sso_enabled
        # The type of SSO.
        self.sso_type = sso_type
        # The state of the workspace.
        self.status = status
        # The DNS addresses of the AD subdomains.
        self.sub_dns_address = sub_dns_address
        # The username of a Domain Name System (DNS) account in the AD subdomain.
        self.sub_domain_name = sub_domain_name
        self.total_eds_count = total_eds_count
        self.total_eds_count_for_group = total_eds_count_for_group
        # > This parameter is unavailable.
        self.trust_password = trust_password
        # The IDs of the vSwitches.
        self.v_switch_ids = v_switch_ids
        # The ID of the secure office network of the workspace. The ID is also the ID of the virtual private cloud (VPC) used by the workspace.
        self.vpc_id = vpc_id
        # The VPC type.
        self.vpc_type = vpc_type

    def validate(self):
        if self.adconnectors:
            for k in self.adconnectors:
                if k:
                    k.validate()
        if self.logs:
            for k in self.logs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ADConnectors'] = []
        if self.adconnectors is not None:
            for k in self.adconnectors:
                result['ADConnectors'].append(k.to_map() if k else None)
        if self.ad_hostname is not None:
            result['AdHostname'] = self.ad_hostname
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.cen_attach_status is not None:
            result['CenAttachStatus'] = self.cen_attach_status
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.cloud_box_office_site is not None:
            result['CloudBoxOfficeSite'] = self.cloud_box_office_site
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.custom_security_group_id is not None:
            result['CustomSecurityGroupId'] = self.custom_security_group_id
        if self.desktop_access_type is not None:
            result['DesktopAccessType'] = self.desktop_access_type
        if self.desktop_count is not None:
            result['DesktopCount'] = self.desktop_count
        if self.desktop_vpc_endpoint is not None:
            result['DesktopVpcEndpoint'] = self.desktop_vpc_endpoint
        if self.dns_address is not None:
            result['DnsAddress'] = self.dns_address
        if self.dns_user_name is not None:
            result['DnsUserName'] = self.dns_user_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_password is not None:
            result['DomainPassword'] = self.domain_password
        if self.domain_user_name is not None:
            result['DomainUserName'] = self.domain_user_name
        if self.enable_admin_access is not None:
            result['EnableAdminAccess'] = self.enable_admin_access
        if self.enable_cross_desktop_access is not None:
            result['EnableCrossDesktopAccess'] = self.enable_cross_desktop_access
        if self.enable_internet_access is not None:
            result['EnableInternetAccess'] = self.enable_internet_access
        if self.file_system_ids is not None:
            result['FileSystemIds'] = self.file_system_ids
        result['Logs'] = []
        if self.logs is not None:
            for k in self.logs:
                result['Logs'].append(k.to_map() if k else None)
        if self.mfa_enabled is not None:
            result['MfaEnabled'] = self.mfa_enabled
        if self.name is not None:
            result['Name'] = self.name
        if self.need_verify_login_risk is not None:
            result['NeedVerifyLoginRisk'] = self.need_verify_login_risk
        if self.need_verify_zero_device is not None:
            result['NeedVerifyZeroDevice'] = self.need_verify_zero_device
        if self.network_package_id is not None:
            result['NetworkPackageId'] = self.network_package_id
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_type is not None:
            result['OfficeSiteType'] = self.office_site_type
        if self.ou_name is not None:
            result['OuName'] = self.ou_name
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.rds_license_address is not None:
            result['RdsLicenseAddress'] = self.rds_license_address
        if self.rds_license_domain_name is not None:
            result['RdsLicenseDomainName'] = self.rds_license_domain_name
        if self.rds_license_status is not None:
            result['RdsLicenseStatus'] = self.rds_license_status
        if self.sso_enabled is not None:
            result['SsoEnabled'] = self.sso_enabled
        if self.sso_type is not None:
            result['SsoType'] = self.sso_type
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_dns_address is not None:
            result['SubDnsAddress'] = self.sub_dns_address
        if self.sub_domain_name is not None:
            result['SubDomainName'] = self.sub_domain_name
        if self.total_eds_count is not None:
            result['TotalEdsCount'] = self.total_eds_count
        if self.total_eds_count_for_group is not None:
            result['TotalEdsCountForGroup'] = self.total_eds_count_for_group
        if self.trust_password is not None:
            result['TrustPassword'] = self.trust_password
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_type is not None:
            result['VpcType'] = self.vpc_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.adconnectors = []
        if m.get('ADConnectors') is not None:
            for k in m.get('ADConnectors'):
                temp_model = DescribeOfficeSitesResponseBodyOfficeSitesADConnectors()
                self.adconnectors.append(temp_model.from_map(k))
        if m.get('AdHostname') is not None:
            self.ad_hostname = m.get('AdHostname')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('CenAttachStatus') is not None:
            self.cen_attach_status = m.get('CenAttachStatus')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('CloudBoxOfficeSite') is not None:
            self.cloud_box_office_site = m.get('CloudBoxOfficeSite')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('CustomSecurityGroupId') is not None:
            self.custom_security_group_id = m.get('CustomSecurityGroupId')
        if m.get('DesktopAccessType') is not None:
            self.desktop_access_type = m.get('DesktopAccessType')
        if m.get('DesktopCount') is not None:
            self.desktop_count = m.get('DesktopCount')
        if m.get('DesktopVpcEndpoint') is not None:
            self.desktop_vpc_endpoint = m.get('DesktopVpcEndpoint')
        if m.get('DnsAddress') is not None:
            self.dns_address = m.get('DnsAddress')
        if m.get('DnsUserName') is not None:
            self.dns_user_name = m.get('DnsUserName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainPassword') is not None:
            self.domain_password = m.get('DomainPassword')
        if m.get('DomainUserName') is not None:
            self.domain_user_name = m.get('DomainUserName')
        if m.get('EnableAdminAccess') is not None:
            self.enable_admin_access = m.get('EnableAdminAccess')
        if m.get('EnableCrossDesktopAccess') is not None:
            self.enable_cross_desktop_access = m.get('EnableCrossDesktopAccess')
        if m.get('EnableInternetAccess') is not None:
            self.enable_internet_access = m.get('EnableInternetAccess')
        if m.get('FileSystemIds') is not None:
            self.file_system_ids = m.get('FileSystemIds')
        self.logs = []
        if m.get('Logs') is not None:
            for k in m.get('Logs'):
                temp_model = DescribeOfficeSitesResponseBodyOfficeSitesLogs()
                self.logs.append(temp_model.from_map(k))
        if m.get('MfaEnabled') is not None:
            self.mfa_enabled = m.get('MfaEnabled')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NeedVerifyLoginRisk') is not None:
            self.need_verify_login_risk = m.get('NeedVerifyLoginRisk')
        if m.get('NeedVerifyZeroDevice') is not None:
            self.need_verify_zero_device = m.get('NeedVerifyZeroDevice')
        if m.get('NetworkPackageId') is not None:
            self.network_package_id = m.get('NetworkPackageId')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteType') is not None:
            self.office_site_type = m.get('OfficeSiteType')
        if m.get('OuName') is not None:
            self.ou_name = m.get('OuName')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RdsLicenseAddress') is not None:
            self.rds_license_address = m.get('RdsLicenseAddress')
        if m.get('RdsLicenseDomainName') is not None:
            self.rds_license_domain_name = m.get('RdsLicenseDomainName')
        if m.get('RdsLicenseStatus') is not None:
            self.rds_license_status = m.get('RdsLicenseStatus')
        if m.get('SsoEnabled') is not None:
            self.sso_enabled = m.get('SsoEnabled')
        if m.get('SsoType') is not None:
            self.sso_type = m.get('SsoType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubDnsAddress') is not None:
            self.sub_dns_address = m.get('SubDnsAddress')
        if m.get('SubDomainName') is not None:
            self.sub_domain_name = m.get('SubDomainName')
        if m.get('TotalEdsCount') is not None:
            self.total_eds_count = m.get('TotalEdsCount')
        if m.get('TotalEdsCountForGroup') is not None:
            self.total_eds_count_for_group = m.get('TotalEdsCountForGroup')
        if m.get('TrustPassword') is not None:
            self.trust_password = m.get('TrustPassword')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcType') is not None:
            self.vpc_type = m.get('VpcType')
        return self


class DescribeOfficeSitesResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        office_sites: List[DescribeOfficeSitesResponseBodyOfficeSites] = None,
        request_id: str = None,
    ):
        # The token that determines the start point of the next query. If this parameter is empty, all results are returned.
        self.next_token = next_token
        # Details of the workspaces.
        self.office_sites = office_sites
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.office_sites:
            for k in self.office_sites:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['OfficeSites'] = []
        if self.office_sites is not None:
            for k in self.office_sites:
                result['OfficeSites'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.office_sites = []
        if m.get('OfficeSites') is not None:
            for k in m.get('OfficeSites'):
                temp_model = DescribeOfficeSitesResponseBodyOfficeSites()
                self.office_sites.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeOfficeSitesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOfficeSitesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOfficeSitesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePolicyGroupsRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        policy_group_id: List[str] = None,
        region_id: str = None,
        scope: str = None,
    ):
        # The number of entries per page.
        # 
        # *   Valid values: 1 to 100
        # *   Default value: 10
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. You do not need to specify this parameter for the first request. You must specify the token that is obtained from the previous query as the value of NextToken.
        self.next_token = next_token
        # The policy IDs. You can specify one or more policy IDs.
        self.policy_group_id = policy_group_id
        # The region ID. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id
        # The effective scope of the policy. Valid values:
        # 
        # *   GLOBAL: The policy takes effect globally.
        # *   IP: The policy takes effect based on the IP address.
        # *   ALL: The policy takes effect without limits.
        # 
        # Default value: GLOBAL.
        self.scope = scope

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scope is not None:
            result['Scope'] = self.scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        return self


class DescribePolicyGroupsResponseBodyDescribePolicyGroupsAuthorizeAccessPolicyRules(TeaModel):
    def __init__(
        self,
        cidr_ip: str = None,
        description: str = None,
    ):
        # The CIDR block that you access from the client. The value is an IPv4 CIDR block.
        self.cidr_ip = cidr_ip
        # The description of the IPv4 CIDR block.
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_ip is not None:
            result['CidrIp'] = self.cidr_ip
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrIp') is not None:
            self.cidr_ip = m.get('CidrIp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class DescribePolicyGroupsResponseBodyDescribePolicyGroupsAuthorizeSecurityPolicyRules(TeaModel):
    def __init__(
        self,
        cidr_ip: str = None,
        description: str = None,
        ip_protocol: str = None,
        policy: str = None,
        port_range: str = None,
        priority: str = None,
        type: str = None,
    ):
        # The IPv4 CIDR block of the security group rule.
        self.cidr_ip = cidr_ip
        # The description of the security group rule.
        self.description = description
        # The protocol type of the security group rule.
        # 
        # Valid values:
        # 
        # *   tcp: Transmission Control Protocol (TCP)
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   udp: User Datagram Protocol (UDP)
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   all: all protocols
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   gre: Generic Routing Encapsulation (GRE)
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   icmp: ICMP (IPv4)
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.ip_protocol = ip_protocol
        # The authorization policy of the security group rule.
        # 
        # Valid values:
        # 
        # *   drop: denies all access requests.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   accept: accepts all access requests.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.policy = policy
        # The port range of the security group rule.
        self.port_range = port_range
        # The priority of the security group rule. A smaller value indicates a higher priority.
        self.priority = priority
        # The direction of the security group rule.
        # 
        # Valid values:
        # 
        # *   outflow: outbound
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   inflow: inbound
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_ip is not None:
            result['CidrIp'] = self.cidr_ip
        if self.description is not None:
            result['Description'] = self.description
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrIp') is not None:
            self.cidr_ip = m.get('CidrIp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribePolicyGroupsResponseBodyDescribePolicyGroupsClientTypes(TeaModel):
    def __init__(
        self,
        client_type: str = None,
        status: str = None,
    ):
        # The client type.
        # 
        # Valid values:
        # 
        # *   html5: web client
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   linux
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     WUYING hardware client
        # 
        #     <!-- -->
        # 
        # *   android
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     Android client
        # 
        #     <!-- -->
        # 
        # *   windows
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     Windows client
        # 
        #     <!-- -->
        # 
        # *   ios
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     iOS client
        # 
        #     <!-- -->
        # 
        # *   macos
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     macOS client
        # 
        #     <!-- -->
        self.client_type = client_type
        # Indicates whether a specific type of client is allowed to connect to the cloud desktop.
        # 
        # Valid values:
        # 
        # *   OFF
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     not allowed
        # 
        #     <!-- -->
        # 
        # *   ON
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     allowed
        # 
        #     <!-- -->
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribePolicyGroupsResponseBodyDescribePolicyGroupsDomainResolveRule(TeaModel):
    def __init__(
        self,
        description: str = None,
        domain: str = None,
        policy: str = None,
    ):
        # The policy description.
        self.description = description
        # The domain name.
        self.domain = domain
        # Indicates whether the resolution feature is allowed.
        # 
        # *   allow: The feature is allowed.
        # *   block: The feature is not allowed.
        self.policy = policy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.policy is not None:
            result['Policy'] = self.policy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        return self


class DescribePolicyGroupsResponseBodyDescribePolicyGroupsNetRedirectRule(TeaModel):
    def __init__(
        self,
        domain: str = None,
        policy: str = None,
        rule_type: str = None,
    ):
        # The content of the rule.
        self.domain = domain
        self.policy = policy
        # The rule type.
        # 
        # Valid values:
        # 
        # *   prc
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     process
        # 
        #     <!-- -->
        # 
        # *   domain
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     domain name
        # 
        #     <!-- -->
        self.rule_type = rule_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        return self


class DescribePolicyGroupsResponseBodyDescribePolicyGroupsUsbSupplyRedirectRule(TeaModel):
    def __init__(
        self,
        description: str = None,
        device_class: str = None,
        device_subclass: str = None,
        product_id: str = None,
        usb_redirect_type: int = None,
        usb_rule_type: int = None,
        vendor_id: str = None,
    ):
        # The rule description.
        self.description = description
        # The device class. If you set `UsbRuleType` to 1, you must specify this parameter. For more information, see [Defined Class Codes](https://www.usb.org/defined-class-codes).
        self.device_class = device_class
        # The device subclass. This parameter is required if `UsbRuleType` is set to 1. For more information, see [Defined Class Codes](https://www.usb.org/defined-class-codes).
        self.device_subclass = device_subclass
        # The product ID.
        self.product_id = product_id
        # The USB redirection type.
        # 
        # Valid values:
        # 
        # *   1: allows USB redirection.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   2: forbids USB redirection.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.usb_redirect_type = usb_redirect_type
        # The type of the USB redirection rule.
        # 
        # Valid values:
        # 
        # *   1: by device class
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   2: by device vendor
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.usb_rule_type = usb_rule_type
        # The vendor ID. For more information, see [Valid USB Vendor IDs (VIDs)](https://www.usb.org/sites/default/files/vendor_ids032322.pdf\_1.pdf).
        self.vendor_id = vendor_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.device_class is not None:
            result['DeviceClass'] = self.device_class
        if self.device_subclass is not None:
            result['DeviceSubclass'] = self.device_subclass
        if self.product_id is not None:
            result['ProductId'] = self.product_id
        if self.usb_redirect_type is not None:
            result['UsbRedirectType'] = self.usb_redirect_type
        if self.usb_rule_type is not None:
            result['UsbRuleType'] = self.usb_rule_type
        if self.vendor_id is not None:
            result['VendorId'] = self.vendor_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceClass') is not None:
            self.device_class = m.get('DeviceClass')
        if m.get('DeviceSubclass') is not None:
            self.device_subclass = m.get('DeviceSubclass')
        if m.get('ProductId') is not None:
            self.product_id = m.get('ProductId')
        if m.get('UsbRedirectType') is not None:
            self.usb_redirect_type = m.get('UsbRedirectType')
        if m.get('UsbRuleType') is not None:
            self.usb_rule_type = m.get('UsbRuleType')
        if m.get('VendorId') is not None:
            self.vendor_id = m.get('VendorId')
        return self


class DescribePolicyGroupsResponseBodyDescribePolicyGroups(TeaModel):
    def __init__(
        self,
        app_content_protection: str = None,
        authorize_access_policy_rules: List[DescribePolicyGroupsResponseBodyDescribePolicyGroupsAuthorizeAccessPolicyRules] = None,
        authorize_security_policy_rules: List[DescribePolicyGroupsResponseBodyDescribePolicyGroupsAuthorizeSecurityPolicyRules] = None,
        camera_redirect: str = None,
        client_types: List[DescribePolicyGroupsResponseBodyDescribePolicyGroupsClientTypes] = None,
        clipboard: str = None,
        cpu_down_grade_duration: int = None,
        cpu_processors: List[str] = None,
        cpu_protected_mode: str = None,
        cpu_rate_limit: int = None,
        cpu_sample_duration: int = None,
        cpu_single_rate_limit: int = None,
        domain_list: str = None,
        domain_resolve_rule: List[DescribePolicyGroupsResponseBodyDescribePolicyGroupsDomainResolveRule] = None,
        domain_resolve_rule_type: str = None,
        eds_count: int = None,
        end_user_apply_admin_coordinate: str = None,
        end_user_group_coordinate: str = None,
        gpu_acceleration: str = None,
        html_5access: str = None,
        html_5file_transfer: str = None,
        internet_communication_protocol: str = None,
        local_drive: str = None,
        memory_down_grade_duration: int = None,
        memory_processors: List[str] = None,
        memory_protected_mode: str = None,
        memory_rate_limit: int = None,
        memory_sample_duration: int = None,
        memory_single_rate_limit: int = None,
        name: str = None,
        net_redirect: str = None,
        net_redirect_rule: List[DescribePolicyGroupsResponseBodyDescribePolicyGroupsNetRedirectRule] = None,
        policy_group_id: str = None,
        policy_group_type: str = None,
        policy_status: str = None,
        preempt_login: str = None,
        preempt_login_users: List[str] = None,
        printer_redirection: str = None,
        record_content: str = None,
        record_content_expires: int = None,
        recording: str = None,
        recording_audio: str = None,
        recording_duration: int = None,
        recording_end_time: str = None,
        recording_expires: int = None,
        recording_fps: int = None,
        recording_start_time: str = None,
        remote_coordinate: str = None,
        scope: str = None,
        scope_value: List[str] = None,
        usb_redirect: str = None,
        usb_supply_redirect_rule: List[DescribePolicyGroupsResponseBodyDescribePolicyGroupsUsbSupplyRedirectRule] = None,
        video_redirect: str = None,
        visual_quality: str = None,
        watermark: str = None,
        watermark_color: int = None,
        watermark_custom_text: str = None,
        watermark_degree: float = None,
        watermark_font_size: int = None,
        watermark_font_style: str = None,
        watermark_row_amount: int = None,
        watermark_transparency: str = None,
        watermark_transparency_value: int = None,
        watermark_type: str = None,
    ):
        # Indicates whether the anti-screenshot feature is enabled. Valid values:
        # 
        # *   on: This feature is enabled.
        # *   off: This feature is disabled.
        # 
        # Default value: off.
        self.app_content_protection = app_content_protection
        # The client CIDR blocks in the whitelist.
        self.authorize_access_policy_rules = authorize_access_policy_rules
        # The security group rules.
        self.authorize_security_policy_rules = authorize_security_policy_rules
        # Indicates whether the webcam redirection feature is enabled.
        # 
        # Valid values:
        # 
        # *   off: The feature is disabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on (default): The feature is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.camera_redirect = camera_redirect
        # The logon methods.
        self.client_types = client_types
        # The permissions on the clipboard.
        # 
        # Valid values:
        # 
        # *   read: One-way transfer is allowed.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   readwrite: Two-way transfer is allowed.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   off: Two-way transfer is not allowed.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.clipboard = clipboard
        self.cpu_down_grade_duration = cpu_down_grade_duration
        self.cpu_processors = cpu_processors
        self.cpu_protected_mode = cpu_protected_mode
        self.cpu_rate_limit = cpu_rate_limit
        self.cpu_sample_duration = cpu_sample_duration
        self.cpu_single_rate_limit = cpu_single_rate_limit
        # The access control for domain names. The domain names can contain the wildcard character (\*). Multiple domain names are separated by commas (,). Valid values:
        # 
        # *   off: This feature is disabled.
        # *   on: This feature is enabled.
        self.domain_list = domain_list
        # The resolution of domain names.
        self.domain_resolve_rule = domain_resolve_rule
        # Indicates whether the switch for domain name resolution is turned on.
        # 
        # Valid values:
        # 
        # *   off
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.domain_resolve_rule_type = domain_resolve_rule_type
        # The number of cloud desktops that are associated with the policy.\
        # This parameter is returned only if PolicyGroupType is set to CUSTOM.
        self.eds_count = eds_count
        # Indicates whether the switch for end users to ask for assistance from the administrator is turned on. Valid values: on off
        self.end_user_apply_admin_coordinate = end_user_apply_admin_coordinate
        # The switch for stream collaboration between end users. Valid values: on off
        self.end_user_group_coordinate = end_user_group_coordinate
        # Indicates whether the image quality policy is enabled for Graphics cloud desktops. If you have high requirements for desktop performance and user experience, we recommend that you enable this feature. For example, you can enable this feature in professional design scenarios.
        # 
        # Valid values:
        # 
        # *   off: The feature is disabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: This feature is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.gpu_acceleration = gpu_acceleration
        # The HTML5 client access feature.
        # 
        # Valid values:
        # 
        # *   off (default)
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     disabled
        # 
        #     <!-- -->
        # 
        # *   on
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     enabled
        # 
        #     <!-- -->
        self.html_5access = html_5access
        # The file transfer feature for the HTML5 client.
        # 
        # Valid values:
        # 
        # *   all: Files can be uploaded and downloaded between your computer and HTML5 clients.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   download: Files on HTML5 clients can be downloaded to your computer.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   upload: Files on your computer can be uploaded to HTML5 clients.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   off (default): File transfer between HTML5 clients and your computer is disabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.html_5file_transfer = html_5file_transfer
        # The protocol that is used for network communication. Valid values:
        # 
        # *   TCP: Only the TCP protocol is used.
        # *   BOTH: The automatic switchover between the TCP protocol and the UDP protocol is supported.
        # 
        # Default value: TCP.
        self.internet_communication_protocol = internet_communication_protocol
        # The permissions on local disk mapping.
        # 
        # Valid values:
        # 
        # *   read: read-only
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   readwrite: read and write
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   off: no permissions
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.local_drive = local_drive
        self.memory_down_grade_duration = memory_down_grade_duration
        self.memory_processors = memory_processors
        self.memory_protected_mode = memory_protected_mode
        self.memory_rate_limit = memory_rate_limit
        self.memory_sample_duration = memory_sample_duration
        self.memory_single_rate_limit = memory_single_rate_limit
        # The policy name.
        self.name = name
        # Indicates whether the network redirection feature is enabled. Valid values:
        # 
        # *   on: This feature is enabled.
        # *   off: The feature is disabled.
        # 
        # Default value: off.
        self.net_redirect = net_redirect
        # The network redirection rules.
        self.net_redirect_rule = net_redirect_rule
        # The policy ID.
        self.policy_group_id = policy_group_id
        # The rule type.
        # 
        # Valid values:
        # 
        # *   SYSTEM
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   CUSTOM
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.policy_group_type = policy_group_type
        # The state of the policy.
        # 
        # Valid values:
        # 
        # *   AVAILABLE
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   CREATING
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.policy_status = policy_status
        # Indicates whether user preemption is allowed. The value is fixed to `off`, which indicates that user preemption is not allowed.
        self.preempt_login = preempt_login
        # The names of the users that are allowed to connect to the cloud desktop to which another user is logged on.
        self.preempt_login_users = preempt_login_users
        # The printer redirection feature.
        # 
        # Valid values:
        # 
        # *   off
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     The feature is disabled
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   on
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     The feature is enabled
        # 
        #     <!-- -->
        # 
        #     .
        self.printer_redirection = printer_redirection
        # Indicates whether the custom screen recording feature is enabled. Valid values:
        # 
        # *   on: This feature is enabled.
        # *   off: This feature is disabled.
        # 
        # Default value: off.
        self.record_content = record_content
        # The duration in which the custom screen recording is valid. Default value: 30. Unit: days.
        self.record_content_expires = record_content_expires
        # Indicates whether screen recording is enabled.
        # 
        # Valid values:
        # 
        # *   ALLTIME: All operations that are performed by end users on cloud desktops are recorded. The recording starts immediately when end users connect to cloud desktops and ends after the end users disconnect from the cloud desktops.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   PERIOD: The operations that are performed by end users on cloud desktops during a specified period of time are recorded. You must specify the start time and the end time of the recording.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   OFF: Screen recording is disabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.recording = recording
        # Indicates whether the sound that is generated on the cloud desktop is recorded during screen recording. Valid values:
        # 
        # *   on: records audio and video data.
        # *   off: records only video data.
        self.recording_audio = recording_audio
        # This parameter is used together with Recording. After the specified period of the recording reaches, a screen recording file is generated.
        self.recording_duration = recording_duration
        # The time when the screen recording ended. The value is in the HH:MM:SS format. The value of this parameter is valid only if Recording is set to PERIOD.
        self.recording_end_time = recording_end_time
        # The period in which the screen recording audit is valid. Valid values: 15 to 180. Unit: days.
        self.recording_expires = recording_expires
        # The frame rate of screen recording. Unit: fps. Valid values:
        # 
        # *   2
        # *   5
        # *   10
        # *   15
        self.recording_fps = recording_fps
        # The time when the screen recording was started. The value is in the HH:MM:SS format. The value of this parameter is valid only if Recording is set to PERIOD.
        self.recording_start_time = recording_start_time
        # The permissions on the keyboard and mouse to control the cloud desktop during remote assistance. Valid values:
        # 
        # *   fullControl: The keyboard and mouse are fully controlled.
        # *   optionalControl: By default, you do not have the permissions on the keyboard or mouse to control the cloud desktop during remote assistance. You can apply for the permissions.
        # *   disableControl: The keyboard and mouse are not controlled.
        self.remote_coordinate = remote_coordinate
        # The effective scope of the policy. Valid values:
        # 
        # *   GLOBAL: The policy takes effect globally.
        # *   IP: The policy takes effect based on the IP address.
        self.scope = scope
        # This parameter is specified if Scope is set to IP.
        self.scope_value = scope_value
        # Indicates whether the USB redirection feature is enabled.
        # 
        # Valid values:
        # 
        # *   off: The feature is disabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: This feature is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.usb_redirect = usb_redirect
        # The USB redirection rules.
        self.usb_supply_redirect_rule = usb_supply_redirect_rule
        # Indicates whether the multimedia redirection feature is enabled. Valid values: on: The feature is enabled. off: The feature is disabled.
        self.video_redirect = video_redirect
        # The image display quality feature.
        # 
        # Valid values:
        # 
        # *   high
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     high-definition (HD)
        # 
        #     <!-- -->
        # 
        # *   low
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     fluent
        # 
        #     <!-- -->
        # 
        # *   medium (default)
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     adaptive
        # 
        #     <!-- -->
        # 
        # *   lossless
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     no quality loss
        # 
        #     <!-- -->
        self.visual_quality = visual_quality
        # Indicates whether the watermark feature is enabled.
        # 
        # Valid values:
        # 
        # *   off: The feature is disabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   on: This feature is enabled.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.watermark = watermark
        # The font color of the watermark. Valid values: 0 to 16777215.
        self.watermark_color = watermark_color
        # This parameter is unavailable for public use.
        self.watermark_custom_text = watermark_custom_text
        # The inclination angle of the watermark. Valid values: -10 to -30.
        self.watermark_degree = watermark_degree
        # The font size of the watermark. Valid values: 10 to 20.
        self.watermark_font_size = watermark_font_size
        # The font style of the watermark. Valid values:
        # 
        # *   plain
        # *   bold
        self.watermark_font_style = watermark_font_style
        # The number of watermark rows. This parameter is now invalid.
        self.watermark_row_amount = watermark_row_amount
        # The watermark transparency.
        # 
        # Valid values:
        # 
        # *   LIGHT
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   DARK
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   MIDDLE
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.watermark_transparency = watermark_transparency
        # The watermark transparency. A larger value indicates that the watermark is less transparent. Valid values: 10 to 100.
        self.watermark_transparency_value = watermark_transparency_value
        # The watermark type.
        # 
        # Valid values:
        # 
        # *   HostName,EndUserId: The watermark is displayed in the following format: Rightmost 15 characters of the cloud desktop ID,Username.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   EndUserId: The username is displayed.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   EndUserId,HostName: The watermark is displayed in the following format: Username,Rightmost 15 characters of the cloud desktop ID.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   HostName: The rightmost 15 characters of the cloud desktop ID are displayed.
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.watermark_type = watermark_type

    def validate(self):
        if self.authorize_access_policy_rules:
            for k in self.authorize_access_policy_rules:
                if k:
                    k.validate()
        if self.authorize_security_policy_rules:
            for k in self.authorize_security_policy_rules:
                if k:
                    k.validate()
        if self.client_types:
            for k in self.client_types:
                if k:
                    k.validate()
        if self.domain_resolve_rule:
            for k in self.domain_resolve_rule:
                if k:
                    k.validate()
        if self.net_redirect_rule:
            for k in self.net_redirect_rule:
                if k:
                    k.validate()
        if self.usb_supply_redirect_rule:
            for k in self.usb_supply_redirect_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_content_protection is not None:
            result['AppContentProtection'] = self.app_content_protection
        result['AuthorizeAccessPolicyRules'] = []
        if self.authorize_access_policy_rules is not None:
            for k in self.authorize_access_policy_rules:
                result['AuthorizeAccessPolicyRules'].append(k.to_map() if k else None)
        result['AuthorizeSecurityPolicyRules'] = []
        if self.authorize_security_policy_rules is not None:
            for k in self.authorize_security_policy_rules:
                result['AuthorizeSecurityPolicyRules'].append(k.to_map() if k else None)
        if self.camera_redirect is not None:
            result['CameraRedirect'] = self.camera_redirect
        result['ClientTypes'] = []
        if self.client_types is not None:
            for k in self.client_types:
                result['ClientTypes'].append(k.to_map() if k else None)
        if self.clipboard is not None:
            result['Clipboard'] = self.clipboard
        if self.cpu_down_grade_duration is not None:
            result['CpuDownGradeDuration'] = self.cpu_down_grade_duration
        if self.cpu_processors is not None:
            result['CpuProcessors'] = self.cpu_processors
        if self.cpu_protected_mode is not None:
            result['CpuProtectedMode'] = self.cpu_protected_mode
        if self.cpu_rate_limit is not None:
            result['CpuRateLimit'] = self.cpu_rate_limit
        if self.cpu_sample_duration is not None:
            result['CpuSampleDuration'] = self.cpu_sample_duration
        if self.cpu_single_rate_limit is not None:
            result['CpuSingleRateLimit'] = self.cpu_single_rate_limit
        if self.domain_list is not None:
            result['DomainList'] = self.domain_list
        result['DomainResolveRule'] = []
        if self.domain_resolve_rule is not None:
            for k in self.domain_resolve_rule:
                result['DomainResolveRule'].append(k.to_map() if k else None)
        if self.domain_resolve_rule_type is not None:
            result['DomainResolveRuleType'] = self.domain_resolve_rule_type
        if self.eds_count is not None:
            result['EdsCount'] = self.eds_count
        if self.end_user_apply_admin_coordinate is not None:
            result['EndUserApplyAdminCoordinate'] = self.end_user_apply_admin_coordinate
        if self.end_user_group_coordinate is not None:
            result['EndUserGroupCoordinate'] = self.end_user_group_coordinate
        if self.gpu_acceleration is not None:
            result['GpuAcceleration'] = self.gpu_acceleration
        if self.html_5access is not None:
            result['Html5Access'] = self.html_5access
        if self.html_5file_transfer is not None:
            result['Html5FileTransfer'] = self.html_5file_transfer
        if self.internet_communication_protocol is not None:
            result['InternetCommunicationProtocol'] = self.internet_communication_protocol
        if self.local_drive is not None:
            result['LocalDrive'] = self.local_drive
        if self.memory_down_grade_duration is not None:
            result['MemoryDownGradeDuration'] = self.memory_down_grade_duration
        if self.memory_processors is not None:
            result['MemoryProcessors'] = self.memory_processors
        if self.memory_protected_mode is not None:
            result['MemoryProtectedMode'] = self.memory_protected_mode
        if self.memory_rate_limit is not None:
            result['MemoryRateLimit'] = self.memory_rate_limit
        if self.memory_sample_duration is not None:
            result['MemorySampleDuration'] = self.memory_sample_duration
        if self.memory_single_rate_limit is not None:
            result['MemorySingleRateLimit'] = self.memory_single_rate_limit
        if self.name is not None:
            result['Name'] = self.name
        if self.net_redirect is not None:
            result['NetRedirect'] = self.net_redirect
        result['NetRedirectRule'] = []
        if self.net_redirect_rule is not None:
            for k in self.net_redirect_rule:
                result['NetRedirectRule'].append(k.to_map() if k else None)
        if self.policy_group_id is not None:
            result['PolicyGroupId'] = self.policy_group_id
        if self.policy_group_type is not None:
            result['PolicyGroupType'] = self.policy_group_type
        if self.policy_status is not None:
            result['PolicyStatus'] = self.policy_status
        if self.preempt_login is not None:
            result['PreemptLogin'] = self.preempt_login
        if self.preempt_login_users is not None:
            result['PreemptLoginUsers'] = self.preempt_login_users
        if self.printer_redirection is not None:
            result['PrinterRedirection'] = self.printer_redirection
        if self.record_content is not None:
            result['RecordContent'] = self.record_content
        if self.record_content_expires is not None:
            result['RecordContentExpires'] = self.record_content_expires
        if self.recording is not None:
            result['Recording'] = self.recording
        if self.recording_audio is not None:
            result['RecordingAudio'] = self.recording_audio
        if self.recording_duration is not None:
            result['RecordingDuration'] = self.recording_duration
        if self.recording_end_time is not None:
            result['RecordingEndTime'] = self.recording_end_time
        if self.recording_expires is not None:
            result['RecordingExpires'] = self.recording_expires
        if self.recording_fps is not None:
            result['RecordingFps'] = self.recording_fps
        if self.recording_start_time is not None:
            result['RecordingStartTime'] = self.recording_start_time
        if self.remote_coordinate is not None:
            result['RemoteCoordinate'] = self.remote_coordinate
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.scope_value is not None:
            result['ScopeValue'] = self.scope_value
        if self.usb_redirect is not None:
            result['UsbRedirect'] = self.usb_redirect
        result['UsbSupplyRedirectRule'] = []
        if self.usb_supply_redirect_rule is not None:
            for k in self.usb_supply_redirect_rule:
                result['UsbSupplyRedirectRule'].append(k.to_map() if k else None)
        if self.video_redirect is not None:
            result['VideoRedirect'] = self.video_redirect
        if self.visual_quality is not None:
            result['VisualQuality'] = self.visual_quality
        if self.watermark is not None:
            result['Watermark'] = self.watermark
        if self.watermark_color is not None:
            result['WatermarkColor'] = self.watermark_color
        if self.watermark_custom_text is not None:
            result['WatermarkCustomText'] = self.watermark_custom_text
        if self.watermark_degree is not None:
            result['WatermarkDegree'] = self.watermark_degree
        if self.watermark_font_size is not None:
            result['WatermarkFontSize'] = self.watermark_font_size
        if self.watermark_font_style is not None:
            result['WatermarkFontStyle'] = self.watermark_font_style
        if self.watermark_row_amount is not None:
            result['WatermarkRowAmount'] = self.watermark_row_amount
        if self.watermark_transparency is not None:
            result['WatermarkTransparency'] = self.watermark_transparency
        if self.watermark_transparency_value is not None:
            result['WatermarkTransparencyValue'] = self.watermark_transparency_value
        if self.watermark_type is not None:
            result['WatermarkType'] = self.watermark_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppContentProtection') is not None:
            self.app_content_protection = m.get('AppContentProtection')
        self.authorize_access_policy_rules = []
        if m.get('AuthorizeAccessPolicyRules') is not None:
            for k in m.get('AuthorizeAccessPolicyRules'):
                temp_model = DescribePolicyGroupsResponseBodyDescribePolicyGroupsAuthorizeAccessPolicyRules()
                self.authorize_access_policy_rules.append(temp_model.from_map(k))
        self.authorize_security_policy_rules = []
        if m.get('AuthorizeSecurityPolicyRules') is not None:
            for k in m.get('AuthorizeSecurityPolicyRules'):
                temp_model = DescribePolicyGroupsResponseBodyDescribePolicyGroupsAuthorizeSecurityPolicyRules()
                self.authorize_security_policy_rules.append(temp_model.from_map(k))
        if m.get('CameraRedirect') is not None:
            self.camera_redirect = m.get('CameraRedirect')
        self.client_types = []
        if m.get('ClientTypes') is not None:
            for k in m.get('ClientTypes'):
                temp_model = DescribePolicyGroupsResponseBodyDescribePolicyGroupsClientTypes()
                self.client_types.append(temp_model.from_map(k))
        if m.get('Clipboard') is not None:
            self.clipboard = m.get('Clipboard')
        if m.get('CpuDownGradeDuration') is not None:
            self.cpu_down_grade_duration = m.get('CpuDownGradeDuration')
        if m.get('CpuProcessors') is not None:
            self.cpu_processors = m.get('CpuProcessors')
        if m.get('CpuProtectedMode') is not None:
            self.cpu_protected_mode = m.get('CpuProtectedMode')
        if m.get('CpuRateLimit') is not None:
            self.cpu_rate_limit = m.get('CpuRateLimit')
        if m.get('CpuSampleDuration') is not None:
            self.cpu_sample_duration = m.get('CpuSampleDuration')
        if m.get('CpuSingleRateLimit') is not None:
            self.cpu_single_rate_limit = m.get('CpuSingleRateLimit')
        if m.get('DomainList') is not None:
            self.domain_list = m.get('DomainList')
        self.domain_resolve_rule = []
        if m.get('DomainResolveRule') is not None:
            for k in m.get('DomainResolveRule'):
                temp_model = DescribePolicyGroupsResponseBodyDescribePolicyGroupsDomainResolveRule()
                self.domain_resolve_rule.append(temp_model.from_map(k))
        if m.get('DomainResolveRuleType') is not None:
            self.domain_resolve_rule_type = m.get('DomainResolveRuleType')
        if m.get('EdsCount') is not None:
            self.eds_count = m.get('EdsCount')
        if m.get('EndUserApplyAdminCoordinate') is not None:
            self.end_user_apply_admin_coordinate = m.get('EndUserApplyAdminCoordinate')
        if m.get('EndUserGroupCoordinate') is not None:
            self.end_user_group_coordinate = m.get('EndUserGroupCoordinate')
        if m.get('GpuAcceleration') is not None:
            self.gpu_acceleration = m.get('GpuAcceleration')
        if m.get('Html5Access') is not None:
            self.html_5access = m.get('Html5Access')
        if m.get('Html5FileTransfer') is not None:
            self.html_5file_transfer = m.get('Html5FileTransfer')
        if m.get('InternetCommunicationProtocol') is not None:
            self.internet_communication_protocol = m.get('InternetCommunicationProtocol')
        if m.get('LocalDrive') is not None:
            self.local_drive = m.get('LocalDrive')
        if m.get('MemoryDownGradeDuration') is not None:
            self.memory_down_grade_duration = m.get('MemoryDownGradeDuration')
        if m.get('MemoryProcessors') is not None:
            self.memory_processors = m.get('MemoryProcessors')
        if m.get('MemoryProtectedMode') is not None:
            self.memory_protected_mode = m.get('MemoryProtectedMode')
        if m.get('MemoryRateLimit') is not None:
            self.memory_rate_limit = m.get('MemoryRateLimit')
        if m.get('MemorySampleDuration') is not None:
            self.memory_sample_duration = m.get('MemorySampleDuration')
        if m.get('MemorySingleRateLimit') is not None:
            self.memory_single_rate_limit = m.get('MemorySingleRateLimit')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetRedirect') is not None:
            self.net_redirect = m.get('NetRedirect')
        self.net_redirect_rule = []
        if m.get('NetRedirectRule') is not None:
            for k in m.get('NetRedirectRule'):
                temp_model = DescribePolicyGroupsResponseBodyDescribePolicyGroupsNetRedirectRule()
                self.net_redirect_rule.append(temp_model.from_map(k))
        if m.get('PolicyGroupId') is not None:
            self.policy_group_id = m.get('PolicyGroupId')
        if m.get('PolicyGroupType') is not None:
            self.policy_group_type = m.get('PolicyGroupType')
        if m.get('PolicyStatus') is not None:
            self.policy_status = m.get('PolicyStatus')
        if m.get('PreemptLogin') is not None:
            self.preempt_login = m.get('PreemptLogin')
        if m.get('PreemptLoginUsers') is not None:
            self.preempt_login_users = m.get('PreemptLoginUsers')
        if m.get('PrinterRedirection') is not None:
            self.printer_redirection = m.get('PrinterRedirection')
        if m.get('RecordContent') is not None:
            self.record_content = m.get('RecordContent')
        if m.get('RecordContentExpires') is not None:
            self.record_content_expires = m.get('RecordContentExpires')
        if m.get('Recording') is not None:
            self.recording = m.get('Recording')
        if m.get('RecordingAudio') is not None:
            self.recording_audio = m.get('RecordingAudio')
        if m.get('RecordingDuration') is not None:
            self.recording_duration = m.get('RecordingDuration')
        if m.get('RecordingEndTime') is not None:
            self.recording_end_time = m.get('RecordingEndTime')
        if m.get('RecordingExpires') is not None:
            self.recording_expires = m.get('RecordingExpires')
        if m.get('RecordingFps') is not None:
            self.recording_fps = m.get('RecordingFps')
        if m.get('RecordingStartTime') is not None:
            self.recording_start_time = m.get('RecordingStartTime')
        if m.get('RemoteCoordinate') is not None:
            self.remote_coordinate = m.get('RemoteCoordinate')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('ScopeValue') is not None:
            self.scope_value = m.get('ScopeValue')
        if m.get('UsbRedirect') is not None:
            self.usb_redirect = m.get('UsbRedirect')
        self.usb_supply_redirect_rule = []
        if m.get('UsbSupplyRedirectRule') is not None:
            for k in m.get('UsbSupplyRedirectRule'):
                temp_model = DescribePolicyGroupsResponseBodyDescribePolicyGroupsUsbSupplyRedirectRule()
                self.usb_supply_redirect_rule.append(temp_model.from_map(k))
        if m.get('VideoRedirect') is not None:
            self.video_redirect = m.get('VideoRedirect')
        if m.get('VisualQuality') is not None:
            self.visual_quality = m.get('VisualQuality')
        if m.get('Watermark') is not None:
            self.watermark = m.get('Watermark')
        if m.get('WatermarkColor') is not None:
            self.watermark_color = m.get('WatermarkColor')
        if m.get('WatermarkCustomText') is not None:
            self.watermark_custom_text = m.get('WatermarkCustomText')
        if m.get('WatermarkDegree') is not None:
            self.watermark_degree = m.get('WatermarkDegree')
        if m.get('WatermarkFontSize') is not None:
            self.watermark_font_size = m.get('WatermarkFontSize')
        if m.get('WatermarkFontStyle') is not None:
            self.watermark_font_style = m.get('WatermarkFontStyle')
        if m.get('WatermarkRowAmount') is not None:
            self.watermark_row_amount = m.get('WatermarkRowAmount')
        if m.get('WatermarkTransparency') is not None:
            self.watermark_transparency = m.get('WatermarkTransparency')
        if m.get('WatermarkTransparencyValue') is not None:
            self.watermark_transparency_value = m.get('WatermarkTransparencyValue')
        if m.get('WatermarkType') is not None:
            self.watermark_type = m.get('WatermarkType')
        return self


class DescribePolicyGroupsResponseBody(TeaModel):
    def __init__(
        self,
        describe_policy_groups: List[DescribePolicyGroupsResponseBodyDescribePolicyGroups] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        # Details of the policies.
        self.describe_policy_groups = describe_policy_groups
        # A pagination token. It can be used in the next request to retrieve a new page of results. If NextToken is empty, no next page exists.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.describe_policy_groups:
            for k in self.describe_policy_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DescribePolicyGroups'] = []
        if self.describe_policy_groups is not None:
            for k in self.describe_policy_groups:
                result['DescribePolicyGroups'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.describe_policy_groups = []
        if m.get('DescribePolicyGroups') is not None:
            for k in m.get('DescribePolicyGroups'):
                temp_model = DescribePolicyGroupsResponseBodyDescribePolicyGroups()
                self.describe_policy_groups.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePolicyGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePolicyGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePolicyGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePriceRequestBundleModels(TeaModel):
    def __init__(
        self,
        amount: int = None,
        bundle_id: str = None,
        duration: int = None,
    ):
        self.amount = amount
        self.bundle_id = bundle_id
        self.duration = duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.duration is not None:
            result['Duration'] = self.duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        return self


class DescribePriceRequest(TeaModel):
    def __init__(
        self,
        amount: int = None,
        bandwidth: int = None,
        bundle_models: List[DescribePriceRequestBundleModels] = None,
        edu_cds_size: int = None,
        edu_committed_time: int = None,
        edu_desktop_bundle_id: str = None,
        edu_desktop_num: int = None,
        edu_room_classify: str = None,
        edu_student_bundle_id: str = None,
        edu_student_num: int = None,
        edu_teacher_bundle_id: str = None,
        edu_teacher_num: int = None,
        group_desktop_count: int = None,
        hardware_version: str = None,
        instance_type: str = None,
        internet_charge_type: str = None,
        os_type: str = None,
        package_size: int = None,
        period: int = None,
        period_unit: str = None,
        promotion_id: str = None,
        region_id: str = None,
        resource_type: str = None,
        root_disk_performance_level: str = None,
        root_disk_size_gib: int = None,
        sp_period_info: str = None,
        sp_price: bool = None,
        sp_type: str = None,
        user_disk_performance_level: str = None,
        user_disk_size_gib: int = None,
    ):
        # The number of the resources. Default value: 1.
        self.amount = amount
        # The maximum public bandwidth. Unit: Mbit/s.
        # 
        # *   Valid values if the PayByTraffic parameter is set to PayByBandwidth: 10 to 1000
        # *   Valid values if the PayByTraffic parameter is set to PayByTraffic: 10 to 200
        self.bandwidth = bandwidth
        self.bundle_models = bundle_models
        self.edu_cds_size = edu_cds_size
        self.edu_committed_time = edu_committed_time
        self.edu_desktop_bundle_id = edu_desktop_bundle_id
        self.edu_desktop_num = edu_desktop_num
        self.edu_room_classify = edu_room_classify
        self.edu_student_bundle_id = edu_student_bundle_id
        self.edu_student_num = edu_student_num
        self.edu_teacher_bundle_id = edu_teacher_bundle_id
        self.edu_teacher_num = edu_teacher_num
        self.group_desktop_count = group_desktop_count
        # The model of the WUYING hardware client.
        self.hardware_version = hardware_version
        # The resource specifications.
        # 
        # *   If you set ResourceType to Desktop, set this parameter to one of the following values:
        # 
        #     *   ecd.basic.small
        #     *   ecd.basic.large
        #     *   ecd.advanced.large
        #     *   ecd.advanced.xlarge
        #     *   ecd.performance.2xlarge
        #     *   ecd.graphics.xlarge
        #     *   ecd.graphics.2xlarge
        #     *   ecd.advanced.xlarge_s8d2
        #     *   ecd.advanced.xlarge_s8d7
        #     *   ecd.graphics.1g72c
        #     *   eds.general.2c2g
        #     *   eds.general.2c4g
        #     *   eds.general.2c8g
        #     *   eds.general.4c8g
        #     *   eds.general.4c16g
        #     *   eds.general.8c16g
        #     *   eds.general.8c32g
        #     *   eds.general.16c32g
        # 
        # *   If you set ResourceType to OfficeSite, set this parameter to large.
        # 
        # *   If you set ResourceType to Bandwidth, leave this parameter empty.
        self.instance_type = instance_type
        # The metering method of the Internet access package. Valid values:
        # 
        # *   PayByBandwidth: pay-by-bandwidth
        # *   PayByTraffic: pay-by-data-transfer
        self.internet_charge_type = internet_charge_type
        # The OS. Valid values:
        # 
        # *   Windows
        # *   Linux
        # 
        # Default value: Windows.
        self.os_type = os_type
        self.package_size = package_size
        # The subscription duration. Default value: 1.
        self.period = period
        # The unit of the billing cycle. Valid values:
        # 
        # *   Hour
        # *   Month
        # *   Year
        # 
        # Default value: Hour.
        self.period_unit = period_unit
        # The promotion ID.
        self.promotion_id = promotion_id
        # The region ID.
        self.region_id = region_id
        # The resource type. Valid values:
        # 
        # *   Desktop: cloud desktop
        # *   OfficeSite: workspace
        # *   Bandwidth: network bandwidth
        # 
        # Default value: Desktop.
        self.resource_type = resource_type
        # The performance level (PL) of the system disk. Valid values:
        # 
        # *   PL0
        # *   PL1
        # *   PL2
        # *   PL3
        self.root_disk_performance_level = root_disk_performance_level
        # The system disk size. Unit: GiB.
        self.root_disk_size_gib = root_disk_size_gib
        self.sp_period_info = sp_period_info
        self.sp_price = sp_price
        self.sp_type = sp_type
        # The PL of the data disk. Valid values:
        # 
        # *   PL0
        # *   PL1
        # *   PL2
        # *   PL3
        self.user_disk_performance_level = user_disk_performance_level
        # The data disk size. Unit: GiB.
        self.user_disk_size_gib = user_disk_size_gib

    def validate(self):
        if self.bundle_models:
            for k in self.bundle_models:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        result['BundleModels'] = []
        if self.bundle_models is not None:
            for k in self.bundle_models:
                result['BundleModels'].append(k.to_map() if k else None)
        if self.edu_cds_size is not None:
            result['EduCdsSize'] = self.edu_cds_size
        if self.edu_committed_time is not None:
            result['EduCommittedTime'] = self.edu_committed_time
        if self.edu_desktop_bundle_id is not None:
            result['EduDesktopBundleId'] = self.edu_desktop_bundle_id
        if self.edu_desktop_num is not None:
            result['EduDesktopNum'] = self.edu_desktop_num
        if self.edu_room_classify is not None:
            result['EduRoomClassify'] = self.edu_room_classify
        if self.edu_student_bundle_id is not None:
            result['EduStudentBundleId'] = self.edu_student_bundle_id
        if self.edu_student_num is not None:
            result['EduStudentNum'] = self.edu_student_num
        if self.edu_teacher_bundle_id is not None:
            result['EduTeacherBundleId'] = self.edu_teacher_bundle_id
        if self.edu_teacher_num is not None:
            result['EduTeacherNum'] = self.edu_teacher_num
        if self.group_desktop_count is not None:
            result['GroupDesktopCount'] = self.group_desktop_count
        if self.hardware_version is not None:
            result['HardwareVersion'] = self.hardware_version
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.package_size is not None:
            result['PackageSize'] = self.package_size
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.promotion_id is not None:
            result['PromotionId'] = self.promotion_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.root_disk_performance_level is not None:
            result['RootDiskPerformanceLevel'] = self.root_disk_performance_level
        if self.root_disk_size_gib is not None:
            result['RootDiskSizeGib'] = self.root_disk_size_gib
        if self.sp_period_info is not None:
            result['SpPeriodInfo'] = self.sp_period_info
        if self.sp_price is not None:
            result['SpPrice'] = self.sp_price
        if self.sp_type is not None:
            result['SpType'] = self.sp_type
        if self.user_disk_performance_level is not None:
            result['UserDiskPerformanceLevel'] = self.user_disk_performance_level
        if self.user_disk_size_gib is not None:
            result['UserDiskSizeGib'] = self.user_disk_size_gib
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        self.bundle_models = []
        if m.get('BundleModels') is not None:
            for k in m.get('BundleModels'):
                temp_model = DescribePriceRequestBundleModels()
                self.bundle_models.append(temp_model.from_map(k))
        if m.get('EduCdsSize') is not None:
            self.edu_cds_size = m.get('EduCdsSize')
        if m.get('EduCommittedTime') is not None:
            self.edu_committed_time = m.get('EduCommittedTime')
        if m.get('EduDesktopBundleId') is not None:
            self.edu_desktop_bundle_id = m.get('EduDesktopBundleId')
        if m.get('EduDesktopNum') is not None:
            self.edu_desktop_num = m.get('EduDesktopNum')
        if m.get('EduRoomClassify') is not None:
            self.edu_room_classify = m.get('EduRoomClassify')
        if m.get('EduStudentBundleId') is not None:
            self.edu_student_bundle_id = m.get('EduStudentBundleId')
        if m.get('EduStudentNum') is not None:
            self.edu_student_num = m.get('EduStudentNum')
        if m.get('EduTeacherBundleId') is not None:
            self.edu_teacher_bundle_id = m.get('EduTeacherBundleId')
        if m.get('EduTeacherNum') is not None:
            self.edu_teacher_num = m.get('EduTeacherNum')
        if m.get('GroupDesktopCount') is not None:
            self.group_desktop_count = m.get('GroupDesktopCount')
        if m.get('HardwareVersion') is not None:
            self.hardware_version = m.get('HardwareVersion')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('PackageSize') is not None:
            self.package_size = m.get('PackageSize')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PromotionId') is not None:
            self.promotion_id = m.get('PromotionId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('RootDiskPerformanceLevel') is not None:
            self.root_disk_performance_level = m.get('RootDiskPerformanceLevel')
        if m.get('RootDiskSizeGib') is not None:
            self.root_disk_size_gib = m.get('RootDiskSizeGib')
        if m.get('SpPeriodInfo') is not None:
            self.sp_period_info = m.get('SpPeriodInfo')
        if m.get('SpPrice') is not None:
            self.sp_price = m.get('SpPrice')
        if m.get('SpType') is not None:
            self.sp_type = m.get('SpType')
        if m.get('UserDiskPerformanceLevel') is not None:
            self.user_disk_performance_level = m.get('UserDiskPerformanceLevel')
        if m.get('UserDiskSizeGib') is not None:
            self.user_disk_size_gib = m.get('UserDiskSizeGib')
        return self


class DescribePriceResponseBodyPriceInfoPricePromotions(TeaModel):
    def __init__(
        self,
        option_code: str = None,
        promotion_desc: str = None,
        promotion_id: str = None,
        promotion_name: str = None,
        selected: bool = None,
    ):
        # The description of the promotion rule.
        self.option_code = option_code
        # The description of the promotion.
        self.promotion_desc = promotion_desc
        # The promotion ID.
        self.promotion_id = promotion_id
        # The promotion name.
        self.promotion_name = promotion_name
        # Indicates whether an item is selected.
        self.selected = selected

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.option_code is not None:
            result['OptionCode'] = self.option_code
        if self.promotion_desc is not None:
            result['PromotionDesc'] = self.promotion_desc
        if self.promotion_id is not None:
            result['PromotionId'] = self.promotion_id
        if self.promotion_name is not None:
            result['PromotionName'] = self.promotion_name
        if self.selected is not None:
            result['Selected'] = self.selected
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OptionCode') is not None:
            self.option_code = m.get('OptionCode')
        if m.get('PromotionDesc') is not None:
            self.promotion_desc = m.get('PromotionDesc')
        if m.get('PromotionId') is not None:
            self.promotion_id = m.get('PromotionId')
        if m.get('PromotionName') is not None:
            self.promotion_name = m.get('PromotionName')
        if m.get('Selected') is not None:
            self.selected = m.get('Selected')
        return self


class DescribePriceResponseBodyPriceInfoPrice(TeaModel):
    def __init__(
        self,
        currency: str = None,
        discount_price: float = None,
        order_lines: Dict[str, str] = None,
        original_price: float = None,
        promotions: List[DescribePriceResponseBodyPriceInfoPricePromotions] = None,
        sp_price: int = None,
        trade_price: float = None,
    ):
        # The unit of the currency.
        self.currency = currency
        # The discounted price.
        self.discount_price = discount_price
        self.order_lines = order_lines
        # The original price.
        self.original_price = original_price
        # The details of the promotion.
        self.promotions = promotions
        self.sp_price = sp_price
        # The actual price that is paid. The original price minus the discounted part equals the actual price.
        self.trade_price = trade_price

    def validate(self):
        if self.promotions:
            for k in self.promotions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.discount_price is not None:
            result['DiscountPrice'] = self.discount_price
        if self.order_lines is not None:
            result['OrderLines'] = self.order_lines
        if self.original_price is not None:
            result['OriginalPrice'] = self.original_price
        result['Promotions'] = []
        if self.promotions is not None:
            for k in self.promotions:
                result['Promotions'].append(k.to_map() if k else None)
        if self.sp_price is not None:
            result['SpPrice'] = self.sp_price
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DiscountPrice') is not None:
            self.discount_price = m.get('DiscountPrice')
        if m.get('OrderLines') is not None:
            self.order_lines = m.get('OrderLines')
        if m.get('OriginalPrice') is not None:
            self.original_price = m.get('OriginalPrice')
        self.promotions = []
        if m.get('Promotions') is not None:
            for k in m.get('Promotions'):
                temp_model = DescribePriceResponseBodyPriceInfoPricePromotions()
                self.promotions.append(temp_model.from_map(k))
        if m.get('SpPrice') is not None:
            self.sp_price = m.get('SpPrice')
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class DescribePriceResponseBodyPriceInfoRules(TeaModel):
    def __init__(
        self,
        description: str = None,
        rule_id: int = None,
    ):
        # The description of the rule.
        self.description = description
        # The rule ID.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribePriceResponseBodyPriceInfo(TeaModel):
    def __init__(
        self,
        free_cds_quota: bool = None,
        free_cds_size: int = None,
        price: DescribePriceResponseBodyPriceInfoPrice = None,
        rules: List[DescribePriceResponseBodyPriceInfoRules] = None,
    ):
        self.free_cds_quota = free_cds_quota
        self.free_cds_size = free_cds_size
        # The information about the price.
        self.price = price
        # The details of the promotion rules.
        self.rules = rules

    def validate(self):
        if self.price:
            self.price.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.free_cds_quota is not None:
            result['FreeCdsQuota'] = self.free_cds_quota
        if self.free_cds_size is not None:
            result['FreeCdsSize'] = self.free_cds_size
        if self.price is not None:
            result['Price'] = self.price.to_map()
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FreeCdsQuota') is not None:
            self.free_cds_quota = m.get('FreeCdsQuota')
        if m.get('FreeCdsSize') is not None:
            self.free_cds_size = m.get('FreeCdsSize')
        if m.get('Price') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoPrice()
            self.price = temp_model.from_map(m['Price'])
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribePriceResponseBodyPriceInfoRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribePriceResponseBody(TeaModel):
    def __init__(
        self,
        price_info: DescribePriceResponseBodyPriceInfo = None,
        request_id: str = None,
    ):
        # The price details.
        self.price_info = price_info
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.price_info:
            self.price_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.price_info is not None:
            result['PriceInfo'] = self.price_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PriceInfo') is not None:
            temp_model = DescribePriceResponseBodyPriceInfo()
            self.price_info = temp_model.from_map(m['PriceInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePriceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePriceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRegionsRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        region_id: str = None,
    ):
        # The ID of the region.
        self.accept_language = accept_language
        # The list of regions.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRegionsResponseBodyRegions(TeaModel):
    def __init__(
        self,
        local_name: str = None,
        region_endpoint: str = None,
        region_id: str = None,
    ):
        self.local_name = local_name
        self.region_endpoint = region_endpoint
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.local_name is not None:
            result['LocalName'] = self.local_name
        if self.region_endpoint is not None:
            result['RegionEndpoint'] = self.region_endpoint
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocalName') is not None:
            self.local_name = m.get('LocalName')
        if m.get('RegionEndpoint') is not None:
            self.region_endpoint = m.get('RegionEndpoint')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRegionsResponseBody(TeaModel):
    def __init__(
        self,
        regions: List[DescribeRegionsResponseBodyRegions] = None,
        request_id: str = None,
    ):
        # DescribeRegions
        self.regions = regions
        # The operation that you want to perform. Set the value to DescribeRegions.
        self.request_id = request_id

    def validate(self):
        if self.regions:
            for k in self.regions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Regions'] = []
        if self.regions is not None:
            for k in self.regions:
                result['Regions'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.regions = []
        if m.get('Regions') is not None:
            for k in m.get('Regions'):
                temp_model = DescribeRegionsResponseBodyRegions()
                self.regions.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRegionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScanTaskProgressRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        task_id: int = None,
    ):
        # The ID of the virus scan task. If this parameter is not specified, the status of the latest scan task is queried by default.
        # 
        # You can call the [StartVirusScanTask](~~217908~~) operation to query the ID of a virus scan task.
        self.region_id = region_id
        # The ID of the request.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeScanTaskProgressResponseBody(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        request_id: str = None,
        task_status: str = None,
    ):
        self.create_time = create_time
        # The operation that you want to perform. Set the value to DescribeScanTaskProgress.
        self.request_id = request_id
        self.task_status = task_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class DescribeScanTaskProgressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeScanTaskProgressResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeScanTaskProgressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityEventOperationStatusRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        security_event_id: List[str] = None,
        task_id: int = None,
    ):
        # The ID of the task to handle the alerts.
        self.region_id = region_id
        self.security_event_id = security_event_id
        # The ID of the alert.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatuses(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        security_event_id: int = None,
        status: str = None,
    ):
        self.error_code = error_code
        self.security_event_id = security_event_id
        # The operation that you want to perform. Set the value to DescribeSecurityEventOperationStatus.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSecurityEventOperationStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_event_operation_statuses: List[DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatuses] = None,
        task_status: str = None,
    ):
        # The processing status of the alert. Valid values:
        # 
        # *   Processing: The alert is being processed.
        # *   Success: The alert is processed.
        # *   Failed: The alert failed to be processed.
        self.request_id = request_id
        # The ID of the request.
        self.security_event_operation_statuses = security_event_operation_statuses
        # The code that indicates the processing result of the alert.
        self.task_status = task_status

    def validate(self):
        if self.security_event_operation_statuses:
            for k in self.security_event_operation_statuses:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SecurityEventOperationStatuses'] = []
        if self.security_event_operation_statuses is not None:
            for k in self.security_event_operation_statuses:
                result['SecurityEventOperationStatuses'].append(k.to_map() if k else None)
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.security_event_operation_statuses = []
        if m.get('SecurityEventOperationStatuses') is not None:
            for k in m.get('SecurityEventOperationStatuses'):
                temp_model = DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatuses()
                self.security_event_operation_statuses.append(temp_model.from_map(k))
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class DescribeSecurityEventOperationStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSecurityEventOperationStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSecurityEventOperationStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityEventOperationsRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        security_event_id: int = None,
    ):
        # The ID of the region.
        self.region_id = region_id
        # The code of the operation performed on the alert. Valid values:
        # 
        # *   mark_mis_info: adds the alert to the whitelist without configuring rules. This operation is triggered by adding multiple alerts to the whitelist at a time.
        # *   advance_mark_mis_inf: adds the alert to the whitelist by configuring advanced rules.
        # *   defense_mark_mis_info: adds the alert to the whitelist by configuring precise defense rules.
        # *   rm_mark_mis_info: removes the alert from the whitelist.
        # *   rm_defense_mark_mis_info: removes the alert from the whitelist configured with precise defense rules.
        # *   manual_handled: manually handles the alert.
        # *   ignore: ignores the alert.
        # *   quara: quarantines the source file of the malicious process.
        # *   block_ip: blocks access from the source IP address.
        # *   kill_and_quara: terminates the malicious process and quarantines the source file.
        self.security_event_id = security_event_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        return self


class DescribeSecurityEventOperationsResponseBodySecurityEventOperations(TeaModel):
    def __init__(
        self,
        operation_code: str = None,
        operation_params: str = None,
        user_can_operate: bool = None,
    ):
        self.operation_code = operation_code
        # The operation that you want to perform. Set the value to DescribeSecurityEventOperations.
        self.operation_params = operation_params
        self.user_can_operate = user_can_operate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_params is not None:
            result['OperationParams'] = self.operation_params
        if self.user_can_operate is not None:
            result['UserCanOperate'] = self.user_can_operate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationParams') is not None:
            self.operation_params = m.get('OperationParams')
        if m.get('UserCanOperate') is not None:
            self.user_can_operate = m.get('UserCanOperate')
        return self


class DescribeSecurityEventOperationsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_event_operations: List[DescribeSecurityEventOperationsResponseBodySecurityEventOperations] = None,
    ):
        # The ID of the alert.
        self.request_id = request_id
        # The ID of the request.
        self.security_event_operations = security_event_operations

    def validate(self):
        if self.security_event_operations:
            for k in self.security_event_operations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SecurityEventOperations'] = []
        if self.security_event_operations is not None:
            for k in self.security_event_operations:
                result['SecurityEventOperations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.security_event_operations = []
        if m.get('SecurityEventOperations') is not None:
            for k in m.get('SecurityEventOperations'):
                temp_model = DescribeSecurityEventOperationsResponseBodySecurityEventOperations()
                self.security_event_operations.append(temp_model.from_map(k))
        return self


class DescribeSecurityEventOperationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSecurityEventOperationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSecurityEventOperationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSessionStatisticRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        office_site_id: str = None,
        period: int = None,
        region_id: str = None,
        search_region_id: str = None,
        start_time: str = None,
    ):
        self.end_time = end_time
        self.office_site_id = office_site_id
        self.period = period
        self.region_id = region_id
        self.search_region_id = search_region_id
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_region_id is not None:
            result['SearchRegionId'] = self.search_region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchRegionId') is not None:
            self.search_region_id = m.get('SearchRegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeSessionStatisticResponseBodyStatistic(TeaModel):
    def __init__(
        self,
        count: int = None,
        time_point: int = None,
    ):
        self.count = count
        self.time_point = time_point

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class DescribeSessionStatisticResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        statistic: List[DescribeSessionStatisticResponseBodyStatistic] = None,
        total_count: str = None,
    ):
        self.request_id = request_id
        self.statistic = statistic
        self.total_count = total_count

    def validate(self):
        if self.statistic:
            for k in self.statistic:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Statistic'] = []
        if self.statistic is not None:
            for k in self.statistic:
                result['Statistic'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistic = []
        if m.get('Statistic') is not None:
            for k in m.get('Statistic'):
                temp_model = DescribeSessionStatisticResponseBodyStatistic()
                self.statistic.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSessionStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSessionStatisticResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSessionStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSnapshotsRequest(TeaModel):
    def __init__(
        self,
        creator: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        end_time: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
        snapshot_id: str = None,
        snapshot_name: str = None,
        snapshot_type: str = None,
        source_disk_type: str = None,
        start_time: str = None,
    ):
        self.creator = creator
        # The cloud desktop ID.
        self.desktop_id = desktop_id
        # The cloud desktop name.
        self.desktop_name = desktop_name
        # The end of the time range to query. The query is performed based on the time when the system stopped creating a snapshot. Specify the time in the [ISO 8601](~~25696~~) standard in the yyyy-mm-ddthh:mm:ssz format. The time must be in UTC.
        self.end_time = end_time
        # The maximum number of entries to return on each page.
        # 
        # *   Valid values: 1 to 100
        # *   Default value: 10
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. You must specify the token that is obtained from the previous query as the value of NextToken.
        self.next_token = next_token
        # The region ID. You can call the [DescribeRegions](~~196646~~) operation to query the most recent region list.
        self.region_id = region_id
        # The snapshot ID.
        self.snapshot_id = snapshot_id
        # The snapshot name. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (\_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        # 
        # The name cannot start with `auto` because snapshots whose names start with auto are recognized as automatic snapshots.
        self.snapshot_name = snapshot_name
        # The snapshot type.
        # 
        # Valid values:
        # 
        # *   auto: automatic snapshot
        # *   user: manual snapshot
        # *   all (default): all types of snapshots
        self.snapshot_type = snapshot_type
        # The type of the source disk of which you want to query snapshots. Valid values:
        # 
        # *   System: system disk
        # *   Data: data disk
        # 
        # > The value of this parameter is not case-sensitive.
        self.source_disk_type = source_disk_type
        # The beginning of the time range to query. The query is performed based on the time when the system created a snapshot. Specify the time in the [ISO 8601](~~25696~~) standard in the yyyy-mm-ddthh:mm:ssz format. The time must be in UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.snapshot_name is not None:
            result['SnapshotName'] = self.snapshot_name
        if self.snapshot_type is not None:
            result['SnapshotType'] = self.snapshot_type
        if self.source_disk_type is not None:
            result['SourceDiskType'] = self.source_disk_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('SnapshotName') is not None:
            self.snapshot_name = m.get('SnapshotName')
        if m.get('SnapshotType') is not None:
            self.snapshot_type = m.get('SnapshotType')
        if m.get('SourceDiskType') is not None:
            self.source_disk_type = m.get('SourceDiskType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeSnapshotsResponseBodySnapshots(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        creator: str = None,
        deletion_time: str = None,
        description: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        desktop_status: str = None,
        progress: str = None,
        protocol_type: str = None,
        remain_time: int = None,
        snapshot_id: str = None,
        snapshot_name: str = None,
        snapshot_type: str = None,
        source_disk_size: str = None,
        source_disk_type: str = None,
        status: str = None,
        volume_encryption_enabled: bool = None,
        volume_encryption_key: str = None,
    ):
        # The time when the snapshot was created. The time follows the [ISO 8601](~~25696~~) standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.creation_time = creation_time
        # The user that creates the cloud desktop.
        self.creator = creator
        # The time when the snapshot was deleted. The time follows the [ISO 8601](~~25696~~) standard in the yyyy-mm-ddthh:mm:ssz format. The time is displayed in UTC.
        self.deletion_time = deletion_time
        # The snapshot description.
        self.description = description
        # The ID of the cloud desktop to which the snapshot belongs.
        self.desktop_id = desktop_id
        # The cloud desktop name.
        self.desktop_name = desktop_name
        # The cloud desktop state. Valid values:
        # 
        # *   Pending: The cloud desktop is pending.
        # *   Starting: The cloud desktop is being started.
        # *   Running: The cloud desktop is running.
        # *   Stopping: The cloud desktop is being stopped.
        # *   Rebuilding: The cloud desktop is being recreated.
        # *   Stopped: The cloud desktop is stopped.
        # *   Expired: The cloud desktop expired.
        # *   Deleted: The cloud desktop is deleted.
        self.desktop_status = desktop_status
        # The progress of creating the snapshot. Unit: percentage (%).
        self.progress = progress
        # The protocol. Valid values:
        # 
        # *   ASP
        # *   HDX
        self.protocol_type = protocol_type
        # The remaining time required to create the snapshot. Unit: seconds.
        # 
        # > If the value of the `Status` parameter is `PROGRESSING` and the value of the `RemainTime` parameter is `-1`, the system is calculating the remaining time required to create the snapshot.
        self.remain_time = remain_time
        # The snapshot ID.
        self.snapshot_id = snapshot_id
        # The snapshot name.
        self.snapshot_name = snapshot_name
        # The snapshot type. Valid values:
        # 
        # *   AUTO: automatic snapshot
        # *   USER: manual snapshot
        self.snapshot_type = snapshot_type
        # The size of the source disk. Unit: GiB.
        self.source_disk_size = source_disk_size
        # The type of the source disk. Valid values:
        # 
        # *   SYSTEM: system disk
        # *   DATA: data disk
        self.source_disk_type = source_disk_type
        # The state of the snapshot. Valid values:
        # 
        # *   PROGRESSING: The snapshot is being created.
        # *   FAILED: The snapshot failed to be created.
        # *   ACCOMPLISHED: The snapshot is created.
        self.status = status
        # Indicates whether disk encryption is enabled.
        self.volume_encryption_enabled = volume_encryption_enabled
        # The ID of the Key Management Service (KMS) key that is used when disk encryption is enabled. You can call the [ListKeys](~~28951~~) operation to obtain a list of KMS keys.
        self.volume_encryption_key = volume_encryption_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.deletion_time is not None:
            result['DeletionTime'] = self.deletion_time
        if self.description is not None:
            result['Description'] = self.description
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.desktop_status is not None:
            result['DesktopStatus'] = self.desktop_status
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.remain_time is not None:
            result['RemainTime'] = self.remain_time
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.snapshot_name is not None:
            result['SnapshotName'] = self.snapshot_name
        if self.snapshot_type is not None:
            result['SnapshotType'] = self.snapshot_type
        if self.source_disk_size is not None:
            result['SourceDiskSize'] = self.source_disk_size
        if self.source_disk_type is not None:
            result['SourceDiskType'] = self.source_disk_type
        if self.status is not None:
            result['Status'] = self.status
        if self.volume_encryption_enabled is not None:
            result['VolumeEncryptionEnabled'] = self.volume_encryption_enabled
        if self.volume_encryption_key is not None:
            result['VolumeEncryptionKey'] = self.volume_encryption_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('DeletionTime') is not None:
            self.deletion_time = m.get('DeletionTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DesktopStatus') is not None:
            self.desktop_status = m.get('DesktopStatus')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RemainTime') is not None:
            self.remain_time = m.get('RemainTime')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('SnapshotName') is not None:
            self.snapshot_name = m.get('SnapshotName')
        if m.get('SnapshotType') is not None:
            self.snapshot_type = m.get('SnapshotType')
        if m.get('SourceDiskSize') is not None:
            self.source_disk_size = m.get('SourceDiskSize')
        if m.get('SourceDiskType') is not None:
            self.source_disk_type = m.get('SourceDiskType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VolumeEncryptionEnabled') is not None:
            self.volume_encryption_enabled = m.get('VolumeEncryptionEnabled')
        if m.get('VolumeEncryptionKey') is not None:
            self.volume_encryption_key = m.get('VolumeEncryptionKey')
        return self


class DescribeSnapshotsResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        request_id: str = None,
        snapshots: List[DescribeSnapshotsResponseBodySnapshots] = None,
    ):
        # If the NextToken parameter is empty, no next page exists.
        self.next_token = next_token
        # The request ID.
        self.request_id = request_id
        # The queried snapshots.
        self.snapshots = snapshots

    def validate(self):
        if self.snapshots:
            for k in self.snapshots:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Snapshots'] = []
        if self.snapshots is not None:
            for k in self.snapshots:
                result['Snapshots'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.snapshots = []
        if m.get('Snapshots') is not None:
            for k in m.get('Snapshots'):
                temp_model = DescribeSnapshotsResponseBodySnapshots()
                self.snapshots.append(temp_model.from_map(k))
        return self


class DescribeSnapshotsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSnapshotsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSnapshotsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspEventOverviewRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        # The ID of the request.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeSuspEventOverviewResponseBody(TeaModel):
    def __init__(
        self,
        remind_count: int = None,
        request_id: str = None,
        serious_count: int = None,
        suspicious_count: int = None,
    ):
        self.remind_count = remind_count
        self.request_id = request_id
        self.serious_count = serious_count
        # DescribeSuspEventOverview
        self.suspicious_count = suspicious_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_count is not None:
            result['RemindCount'] = self.remind_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.serious_count is not None:
            result['SeriousCount'] = self.serious_count
        if self.suspicious_count is not None:
            result['SuspiciousCount'] = self.suspicious_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemindCount') is not None:
            self.remind_count = m.get('RemindCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SeriousCount') is not None:
            self.serious_count = m.get('SeriousCount')
        if m.get('SuspiciousCount') is not None:
            self.suspicious_count = m.get('SuspiciousCount')
        return self


class DescribeSuspEventOverviewResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSuspEventOverviewResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSuspEventOverviewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspEventQuaraFilesRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        office_site_id: str = None,
        page_size: int = None,
        region_id: str = None,
        status: str = None,
    ):
        # The operation that you want to perform. Set the value to DescribeSuspEventQuaraFiles.
        self.current_page = current_page
        # The type of the alert.
        self.office_site_id = office_site_id
        # The name of the cloud desktop.
        self.page_size = page_size
        # The ID of the workspace.
        self.region_id = region_id
        # The time when the quarantined file was updated.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSuspEventQuaraFilesResponseBodyQuaraFiles(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        desktop_name: str = None,
        event_name: str = None,
        event_type: str = None,
        id: int = None,
        md_5: str = None,
        modify_time: str = None,
        path: str = None,
        status: str = None,
        tag: str = None,
    ):
        self.desktop_id = desktop_id
        # The ID of the request.
        self.desktop_name = desktop_name
        # The number of the page to return.
        # 
        # Pages start from page 1.
        # 
        # Default value: 1.
        self.event_name = event_name
        # The maximum number of entries returned per page.
        self.event_type = event_type
        self.id = id
        # DescribeSuspEventQuaraFiles
        self.md_5 = md_5
        self.modify_time = modify_time
        # The tag of the alert.
        self.path = path
        # The ID of the quarantined file.
        self.status = status
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.id is not None:
            result['Id'] = self.id
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.path is not None:
            result['Path'] = self.path
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class DescribeSuspEventQuaraFilesResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        quara_files: List[DescribeSuspEventQuaraFilesResponseBodyQuaraFiles] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The ID of the cloud desktop.
        self.current_page = current_page
        # The name of the alert.
        self.page_size = page_size
        # The ID of the region.
        self.quara_files = quara_files
        # The quarantined files.
        self.request_id = request_id
        # The status of the quarantined file. Valid values:
        # 
        # *   quaraFailed: The file failed to be quarantined.
        # *   quaraDone: The file is quarantined.
        # *   quaraing: The file is being quarantined.
        # *   rollbackFailed: Quarantine for the file failed to be canceled.
        # *   rollbackDone: Quarantine for the file is canceled.
        # *   rollbacking: Quarantine for the file is being canceled.
        self.total_count = total_count

    def validate(self):
        if self.quara_files:
            for k in self.quara_files:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QuaraFiles'] = []
        if self.quara_files is not None:
            for k in self.quara_files:
                result['QuaraFiles'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.quara_files = []
        if m.get('QuaraFiles') is not None:
            for k in m.get('QuaraFiles'):
                temp_model = DescribeSuspEventQuaraFilesResponseBodyQuaraFiles()
                self.quara_files.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSuspEventQuaraFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSuspEventQuaraFilesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSuspEventQuaraFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspEventsRequest(TeaModel):
    def __init__(
        self,
        alarm_unique_info: str = None,
        current_page: int = None,
        dealed: str = None,
        lang: str = None,
        levels: str = None,
        office_site_id: str = None,
        page_size: int = None,
        parent_event_type: str = None,
        region_id: str = None,
    ):
        self.alarm_unique_info = alarm_unique_info
        self.current_page = current_page
        self.dealed = dealed
        self.lang = lang
        self.levels = levels
        self.office_site_id = office_site_id
        self.page_size = page_size
        self.parent_event_type = parent_event_type
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.parent_event_type is not None:
            result['ParentEventType'] = self.parent_event_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ParentEventType') is not None:
            self.parent_event_type = m.get('ParentEventType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeSuspEventsResponseBodySuspEventsDetails(TeaModel):
    def __init__(
        self,
        name: str = None,
        name_display: str = None,
        type: str = None,
        value: str = None,
        value_display: str = None,
    ):
        self.name = name
        self.name_display = name_display
        self.type = type
        self.value = value
        self.value_display = value_display

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.name_display is not None:
            result['NameDisplay'] = self.name_display
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        if self.value_display is not None:
            result['ValueDisplay'] = self.value_display
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NameDisplay') is not None:
            self.name_display = m.get('NameDisplay')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ValueDisplay') is not None:
            self.value_display = m.get('ValueDisplay')
        return self


class DescribeSuspEventsResponseBodySuspEvents(TeaModel):
    def __init__(
        self,
        alarm_event_name: str = None,
        alarm_event_name_display: str = None,
        alarm_event_type: str = None,
        alarm_event_type_display: str = None,
        alarm_unique_info: str = None,
        can_be_deal_on_line: str = None,
        can_cancel_fault: bool = None,
        data_source: str = None,
        desc: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        details: List[DescribeSuspEventsResponseBodySuspEventsDetails] = None,
        event_status: int = None,
        event_sub_type: str = None,
        id: int = None,
        last_time: str = None,
        level: str = None,
        name: str = None,
        occurrence_time: str = None,
        operate_error_code: str = None,
        operate_msg: str = None,
        unique_info: str = None,
    ):
        self.alarm_event_name = alarm_event_name
        self.alarm_event_name_display = alarm_event_name_display
        self.alarm_event_type = alarm_event_type
        self.alarm_event_type_display = alarm_event_type_display
        self.alarm_unique_info = alarm_unique_info
        self.can_be_deal_on_line = can_be_deal_on_line
        self.can_cancel_fault = can_cancel_fault
        self.data_source = data_source
        self.desc = desc
        self.desktop_id = desktop_id
        self.desktop_name = desktop_name
        self.details = details
        self.event_status = event_status
        self.event_sub_type = event_sub_type
        self.id = id
        self.last_time = last_time
        self.level = level
        self.name = name
        self.occurrence_time = occurrence_time
        self.operate_error_code = operate_error_code
        self.operate_msg = operate_msg
        self.unique_info = unique_info

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_event_name is not None:
            result['AlarmEventName'] = self.alarm_event_name
        if self.alarm_event_name_display is not None:
            result['AlarmEventNameDisplay'] = self.alarm_event_name_display
        if self.alarm_event_type is not None:
            result['AlarmEventType'] = self.alarm_event_type
        if self.alarm_event_type_display is not None:
            result['AlarmEventTypeDisplay'] = self.alarm_event_type_display
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        result['Details'] = []
        if self.details is not None:
            for k in self.details:
                result['Details'].append(k.to_map() if k else None)
        if self.event_status is not None:
            result['EventStatus'] = self.event_status
        if self.event_sub_type is not None:
            result['EventSubType'] = self.event_sub_type
        if self.id is not None:
            result['Id'] = self.id
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.occurrence_time is not None:
            result['OccurrenceTime'] = self.occurrence_time
        if self.operate_error_code is not None:
            result['OperateErrorCode'] = self.operate_error_code
        if self.operate_msg is not None:
            result['OperateMsg'] = self.operate_msg
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmEventName') is not None:
            self.alarm_event_name = m.get('AlarmEventName')
        if m.get('AlarmEventNameDisplay') is not None:
            self.alarm_event_name_display = m.get('AlarmEventNameDisplay')
        if m.get('AlarmEventType') is not None:
            self.alarm_event_type = m.get('AlarmEventType')
        if m.get('AlarmEventTypeDisplay') is not None:
            self.alarm_event_type_display = m.get('AlarmEventTypeDisplay')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        self.details = []
        if m.get('Details') is not None:
            for k in m.get('Details'):
                temp_model = DescribeSuspEventsResponseBodySuspEventsDetails()
                self.details.append(temp_model.from_map(k))
        if m.get('EventStatus') is not None:
            self.event_status = m.get('EventStatus')
        if m.get('EventSubType') is not None:
            self.event_sub_type = m.get('EventSubType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OccurrenceTime') is not None:
            self.occurrence_time = m.get('OccurrenceTime')
        if m.get('OperateErrorCode') is not None:
            self.operate_error_code = m.get('OperateErrorCode')
        if m.get('OperateMsg') is not None:
            self.operate_msg = m.get('OperateMsg')
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        return self


class DescribeSuspEventsResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: str = None,
        request_id: str = None,
        susp_events: List[DescribeSuspEventsResponseBodySuspEvents] = None,
        total_count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.susp_events = susp_events
        self.total_count = total_count

    def validate(self):
        if self.susp_events:
            for k in self.susp_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SuspEvents'] = []
        if self.susp_events is not None:
            for k in self.susp_events:
                result['SuspEvents'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.susp_events = []
        if m.get('SuspEvents') is not None:
            for k in m.get('SuspEvents'):
                temp_model = DescribeSuspEventsResponseBodySuspEvents()
                self.susp_events.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSuspEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSuspEventsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSuspEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserConnectionRecordsRequest(TeaModel):
    def __init__(
        self,
        connect_duration_from: int = None,
        connect_duration_to: int = None,
        connect_end_time_from: int = None,
        connect_end_time_to: int = None,
        connect_start_time_from: int = None,
        connect_start_time_to: int = None,
        desktop_group_id: str = None,
        desktop_id: str = None,
        end_user_id: str = None,
        end_user_type: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
    ):
        self.connect_duration_from = connect_duration_from
        self.connect_duration_to = connect_duration_to
        self.connect_end_time_from = connect_end_time_from
        self.connect_end_time_to = connect_end_time_to
        self.connect_start_time_from = connect_start_time_from
        self.connect_start_time_to = connect_start_time_to
        self.desktop_group_id = desktop_group_id
        self.desktop_id = desktop_id
        self.end_user_id = end_user_id
        self.end_user_type = end_user_type
        self.max_results = max_results
        self.next_token = next_token
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connect_duration_from is not None:
            result['ConnectDurationFrom'] = self.connect_duration_from
        if self.connect_duration_to is not None:
            result['ConnectDurationTo'] = self.connect_duration_to
        if self.connect_end_time_from is not None:
            result['ConnectEndTimeFrom'] = self.connect_end_time_from
        if self.connect_end_time_to is not None:
            result['ConnectEndTimeTo'] = self.connect_end_time_to
        if self.connect_start_time_from is not None:
            result['ConnectStartTimeFrom'] = self.connect_start_time_from
        if self.connect_start_time_to is not None:
            result['ConnectStartTimeTo'] = self.connect_start_time_to
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.end_user_type is not None:
            result['EndUserType'] = self.end_user_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectDurationFrom') is not None:
            self.connect_duration_from = m.get('ConnectDurationFrom')
        if m.get('ConnectDurationTo') is not None:
            self.connect_duration_to = m.get('ConnectDurationTo')
        if m.get('ConnectEndTimeFrom') is not None:
            self.connect_end_time_from = m.get('ConnectEndTimeFrom')
        if m.get('ConnectEndTimeTo') is not None:
            self.connect_end_time_to = m.get('ConnectEndTimeTo')
        if m.get('ConnectStartTimeFrom') is not None:
            self.connect_start_time_from = m.get('ConnectStartTimeFrom')
        if m.get('ConnectStartTimeTo') is not None:
            self.connect_start_time_to = m.get('ConnectStartTimeTo')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EndUserType') is not None:
            self.end_user_type = m.get('EndUserType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeUserConnectionRecordsResponseBodyConnectionRecords(TeaModel):
    def __init__(
        self,
        connect_duration: str = None,
        connect_end_time: str = None,
        connect_start_time: str = None,
        connection_record_id: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
    ):
        self.connect_duration = connect_duration
        self.connect_end_time = connect_end_time
        self.connect_start_time = connect_start_time
        self.connection_record_id = connection_record_id
        self.desktop_id = desktop_id
        self.desktop_name = desktop_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connect_duration is not None:
            result['ConnectDuration'] = self.connect_duration
        if self.connect_end_time is not None:
            result['ConnectEndTime'] = self.connect_end_time
        if self.connect_start_time is not None:
            result['ConnectStartTime'] = self.connect_start_time
        if self.connection_record_id is not None:
            result['ConnectionRecordId'] = self.connection_record_id
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectDuration') is not None:
            self.connect_duration = m.get('ConnectDuration')
        if m.get('ConnectEndTime') is not None:
            self.connect_end_time = m.get('ConnectEndTime')
        if m.get('ConnectStartTime') is not None:
            self.connect_start_time = m.get('ConnectStartTime')
        if m.get('ConnectionRecordId') is not None:
            self.connection_record_id = m.get('ConnectionRecordId')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        return self


class DescribeUserConnectionRecordsResponseBody(TeaModel):
    def __init__(
        self,
        connection_records: List[DescribeUserConnectionRecordsResponseBodyConnectionRecords] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.connection_records = connection_records
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.connection_records:
            for k in self.connection_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConnectionRecords'] = []
        if self.connection_records is not None:
            for k in self.connection_records:
                result['ConnectionRecords'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.connection_records = []
        if m.get('ConnectionRecords') is not None:
            for k in m.get('ConnectionRecords'):
                temp_model = DescribeUserConnectionRecordsResponseBodyConnectionRecords()
                self.connection_records.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeUserConnectionRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeUserConnectionRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeUserConnectionRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserProfilePathRulesRequest(TeaModel):
    def __init__(
        self,
        desktop_group_id: str = None,
        region_id: str = None,
        rule_type: str = None,
    ):
        # The desktop group ID. This parameter is required when you set RuleType parameter to DesktopGroup.
        self.desktop_group_id = desktop_group_id
        # The region ID.
        self.region_id = region_id
        # The rule type that you want to configure for the directory.
        # 
        # Valid values:
        # 
        # *   DesktopGroup
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Default
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.rule_type = rule_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        return self


class DescribeUserProfilePathRulesResponseBodyUserProfilePathRuleRulesBlackPath(TeaModel):
    def __init__(
        self,
        path: str = None,
        type: str = None,
    ):
        # The path.
        self.path = path
        # The path type.
        # 
        # Valid values:
        # 
        # *   file
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   folder
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeUserProfilePathRulesResponseBodyUserProfilePathRuleRulesWhitePaths(TeaModel):
    def __init__(
        self,
        path: str = None,
        type: str = None,
    ):
        # The path.
        self.path = path
        # The path type.
        # 
        # Valid values:
        # 
        # *   file
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   folder
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeUserProfilePathRulesResponseBodyUserProfilePathRuleRules(TeaModel):
    def __init__(
        self,
        black_path: DescribeUserProfilePathRulesResponseBodyUserProfilePathRuleRulesBlackPath = None,
        white_paths: List[DescribeUserProfilePathRulesResponseBodyUserProfilePathRuleRulesWhitePaths] = None,
    ):
        # The blacklist that is configured.
        self.black_path = black_path
        # The directories in the whitelist.
        self.white_paths = white_paths

    def validate(self):
        if self.black_path:
            self.black_path.validate()
        if self.white_paths:
            for k in self.white_paths:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.black_path is not None:
            result['BlackPath'] = self.black_path.to_map()
        result['WhitePaths'] = []
        if self.white_paths is not None:
            for k in self.white_paths:
                result['WhitePaths'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlackPath') is not None:
            temp_model = DescribeUserProfilePathRulesResponseBodyUserProfilePathRuleRulesBlackPath()
            self.black_path = temp_model.from_map(m['BlackPath'])
        self.white_paths = []
        if m.get('WhitePaths') is not None:
            for k in m.get('WhitePaths'):
                temp_model = DescribeUserProfilePathRulesResponseBodyUserProfilePathRuleRulesWhitePaths()
                self.white_paths.append(temp_model.from_map(k))
        return self


class DescribeUserProfilePathRulesResponseBodyUserProfilePathRule(TeaModel):
    def __init__(
        self,
        desktop_group_id: str = None,
        rules: List[DescribeUserProfilePathRulesResponseBodyUserProfilePathRuleRules] = None,
        user_profile_rule_type: str = None,
    ):
        # The desktop group ID.
        self.desktop_group_id = desktop_group_id
        # The directory rules.
        self.rules = rules
        # The directory type that is configured for the directory.
        # 
        # Valid values:
        # 
        # *   DesktopGroup
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        # *   Default
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        # 
        #     <!-- -->
        self.user_profile_rule_type = user_profile_rule_type

    def validate(self):
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        if self.user_profile_rule_type is not None:
            result['UserProfileRuleType'] = self.user_profile_rule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeUserProfilePathRulesResponseBodyUserProfilePathRuleRules()
                self.rules.append(temp_model.from_map(k))
        if m.get('UserProfileRuleType') is not None:
            self.user_profile_rule_type = m.get('UserProfileRuleType')
        return self


class DescribeUserProfilePathRulesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_profile_path_rule: DescribeUserProfilePathRulesResponseBodyUserProfilePathRule = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The directory blacklist and whitelist.
        self.user_profile_path_rule = user_profile_path_rule

    def validate(self):
        if self.user_profile_path_rule:
            self.user_profile_path_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_profile_path_rule is not None:
            result['UserProfilePathRule'] = self.user_profile_path_rule.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserProfilePathRule') is not None:
            temp_model = DescribeUserProfilePathRulesResponseBodyUserProfilePathRule()
            self.user_profile_path_rule = temp_model.from_map(m['UserProfilePathRule'])
        return self


class DescribeUserProfilePathRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeUserProfilePathRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeUserProfilePathRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUsersInGroupRequest(TeaModel):
    def __init__(
        self,
        connect_state: int = None,
        desktop_group_id: str = None,
        end_user_id: str = None,
        end_user_ids: List[str] = None,
        filter: str = None,
        max_results: int = None,
        next_token: str = None,
        org_id: str = None,
        query_user_detail: bool = None,
        region_id: str = None,
    ):
        self.connect_state = connect_state
        self.desktop_group_id = desktop_group_id
        self.end_user_id = end_user_id
        self.end_user_ids = end_user_ids
        self.filter = filter
        self.max_results = max_results
        self.next_token = next_token
        self.org_id = org_id
        self.query_user_detail = query_user_detail
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connect_state is not None:
            result['ConnectState'] = self.connect_state
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.end_user_ids is not None:
            result['EndUserIds'] = self.end_user_ids
        if self.filter is not None:
            result['Filter'] = self.filter
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.org_id is not None:
            result['OrgId'] = self.org_id
        if self.query_user_detail is not None:
            result['QueryUserDetail'] = self.query_user_detail
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectState') is not None:
            self.connect_state = m.get('ConnectState')
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EndUserIds') is not None:
            self.end_user_ids = m.get('EndUserIds')
        if m.get('Filter') is not None:
            self.filter = m.get('Filter')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OrgId') is not None:
            self.org_id = m.get('OrgId')
        if m.get('QueryUserDetail') is not None:
            self.query_user_detail = m.get('QueryUserDetail')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeUsersInGroupResponseBodyEndUsersExternalInfo(TeaModel):
    def __init__(
        self,
        external_name: str = None,
        job_number: str = None,
    ):
        self.external_name = external_name
        self.job_number = job_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_name is not None:
            result['ExternalName'] = self.external_name
        if self.job_number is not None:
            result['JobNumber'] = self.job_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalName') is not None:
            self.external_name = m.get('ExternalName')
        if m.get('JobNumber') is not None:
            self.job_number = m.get('JobNumber')
        return self


class DescribeUsersInGroupResponseBodyEndUsersUserSetPropertiesModelsPropertyValues(TeaModel):
    def __init__(
        self,
        property_value: str = None,
        property_value_id: int = None,
    ):
        self.property_value = property_value
        self.property_value_id = property_value_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.property_value is not None:
            result['PropertyValue'] = self.property_value
        if self.property_value_id is not None:
            result['PropertyValueId'] = self.property_value_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PropertyValue') is not None:
            self.property_value = m.get('PropertyValue')
        if m.get('PropertyValueId') is not None:
            self.property_value_id = m.get('PropertyValueId')
        return self


class DescribeUsersInGroupResponseBodyEndUsersUserSetPropertiesModels(TeaModel):
    def __init__(
        self,
        property_id: int = None,
        property_key: str = None,
        property_type: int = None,
        property_values: List[DescribeUsersInGroupResponseBodyEndUsersUserSetPropertiesModelsPropertyValues] = None,
        user_id: int = None,
        user_name: str = None,
    ):
        self.property_id = property_id
        self.property_key = property_key
        self.property_type = property_type
        self.property_values = property_values
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        if self.property_values:
            for k in self.property_values:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.property_id is not None:
            result['PropertyId'] = self.property_id
        if self.property_key is not None:
            result['PropertyKey'] = self.property_key
        if self.property_type is not None:
            result['PropertyType'] = self.property_type
        result['PropertyValues'] = []
        if self.property_values is not None:
            for k in self.property_values:
                result['PropertyValues'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PropertyId') is not None:
            self.property_id = m.get('PropertyId')
        if m.get('PropertyKey') is not None:
            self.property_key = m.get('PropertyKey')
        if m.get('PropertyType') is not None:
            self.property_type = m.get('PropertyType')
        self.property_values = []
        if m.get('PropertyValues') is not None:
            for k in m.get('PropertyValues'):
                temp_model = DescribeUsersInGroupResponseBodyEndUsersUserSetPropertiesModelsPropertyValues()
                self.property_values.append(temp_model.from_map(k))
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeUsersInGroupResponseBodyEndUsers(TeaModel):
    def __init__(
        self,
        connection_status: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        display_name: str = None,
        end_user_email: str = None,
        end_user_id: str = None,
        end_user_name: str = None,
        end_user_phone: str = None,
        end_user_remark: str = None,
        end_user_type: str = None,
        external_info: DescribeUsersInGroupResponseBodyEndUsersExternalInfo = None,
        user_desktop_id: str = None,
        user_set_properties_models: List[DescribeUsersInGroupResponseBodyEndUsersUserSetPropertiesModels] = None,
    ):
        self.connection_status = connection_status
        self.desktop_id = desktop_id
        self.desktop_name = desktop_name
        self.display_name = display_name
        self.end_user_email = end_user_email
        self.end_user_id = end_user_id
        self.end_user_name = end_user_name
        self.end_user_phone = end_user_phone
        self.end_user_remark = end_user_remark
        self.end_user_type = end_user_type
        self.external_info = external_info
        self.user_desktop_id = user_desktop_id
        self.user_set_properties_models = user_set_properties_models

    def validate(self):
        if self.external_info:
            self.external_info.validate()
        if self.user_set_properties_models:
            for k in self.user_set_properties_models:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_status is not None:
            result['ConnectionStatus'] = self.connection_status
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.end_user_email is not None:
            result['EndUserEmail'] = self.end_user_email
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.end_user_name is not None:
            result['EndUserName'] = self.end_user_name
        if self.end_user_phone is not None:
            result['EndUserPhone'] = self.end_user_phone
        if self.end_user_remark is not None:
            result['EndUserRemark'] = self.end_user_remark
        if self.end_user_type is not None:
            result['EndUserType'] = self.end_user_type
        if self.external_info is not None:
            result['ExternalInfo'] = self.external_info.to_map()
        if self.user_desktop_id is not None:
            result['UserDesktopId'] = self.user_desktop_id
        result['UserSetPropertiesModels'] = []
        if self.user_set_properties_models is not None:
            for k in self.user_set_properties_models:
                result['UserSetPropertiesModels'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionStatus') is not None:
            self.connection_status = m.get('ConnectionStatus')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('EndUserEmail') is not None:
            self.end_user_email = m.get('EndUserEmail')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EndUserName') is not None:
            self.end_user_name = m.get('EndUserName')
        if m.get('EndUserPhone') is not None:
            self.end_user_phone = m.get('EndUserPhone')
        if m.get('EndUserRemark') is not None:
            self.end_user_remark = m.get('EndUserRemark')
        if m.get('EndUserType') is not None:
            self.end_user_type = m.get('EndUserType')
        if m.get('ExternalInfo') is not None:
            temp_model = DescribeUsersInGroupResponseBodyEndUsersExternalInfo()
            self.external_info = temp_model.from_map(m['ExternalInfo'])
        if m.get('UserDesktopId') is not None:
            self.user_desktop_id = m.get('UserDesktopId')
        self.user_set_properties_models = []
        if m.get('UserSetPropertiesModels') is not None:
            for k in m.get('UserSetPropertiesModels'):
                temp_model = DescribeUsersInGroupResponseBodyEndUsersUserSetPropertiesModels()
                self.user_set_properties_models.append(temp_model.from_map(k))
        return self


class DescribeUsersInGroupResponseBody(TeaModel):
    def __init__(
        self,
        end_users: List[DescribeUsersInGroupResponseBodyEndUsers] = None,
        next_token: str = None,
        online_users_count: int = None,
        request_id: str = None,
        users_count: int = None,
    ):
        self.end_users = end_users
        self.next_token = next_token
        self.online_users_count = online_users_count
        self.request_id = request_id
        self.users_count = users_count

    def validate(self):
        if self.end_users:
            for k in self.end_users:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EndUsers'] = []
        if self.end_users is not None:
            for k in self.end_users:
                result['EndUsers'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.online_users_count is not None:
            result['OnlineUsersCount'] = self.online_users_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.users_count is not None:
            result['UsersCount'] = self.users_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.end_users = []
        if m.get('EndUsers') is not None:
            for k in m.get('EndUsers'):
                temp_model = DescribeUsersInGroupResponseBodyEndUsers()
                self.end_users.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OnlineUsersCount') is not None:
            self.online_users_count = m.get('OnlineUsersCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UsersCount') is not None:
            self.users_count = m.get('UsersCount')
        return self


class DescribeUsersInGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeUsersInGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeUsersInGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUsersPasswordRequest(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        region_id: str = None,
    ):
        # The ID of the cloud desktop.
        self.desktop_id = desktop_id
        # The ID of the region.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeUsersPasswordResponseBodyDesktopUsers(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        end_user_id: str = None,
        password: str = None,
    ):
        # The display name of the user.
        self.display_name = display_name
        # The ID of the end user.
        self.end_user_id = end_user_id
        # The password of the user.
        self.password = password

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.password is not None:
            result['Password'] = self.password
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        return self


class DescribeUsersPasswordResponseBody(TeaModel):
    def __init__(
        self,
        desktop_users: List[DescribeUsersPasswordResponseBodyDesktopUsers] = None,
        request_id: str = None,
    ):
        # The users that are associated with cloud desktop.
        self.desktop_users = desktop_users
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.desktop_users:
            for k in self.desktop_users:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DesktopUsers'] = []
        if self.desktop_users is not None:
            for k in self.desktop_users:
                result['DesktopUsers'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.desktop_users = []
        if m.get('DesktopUsers') is not None:
            for k in m.get('DesktopUsers'):
                temp_model = DescribeUsersPasswordResponseBodyDesktopUsers()
                self.desktop_users.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeUsersPasswordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeUsersPasswordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeUsersPasswordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVirtualMFADevicesRequest(TeaModel):
    def __init__(
        self,
        end_user_id: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        office_site_id: str = None,
        region_id: str = None,
    ):
        # >  This parameter is in invitational preview and unavailable for public use.
        self.end_user_id = end_user_id
        # The number of consecutive failures to bind the virtual MFA device, or the number of MFA failures based on the virtual MFA device.
        self.max_results = max_results
        # The name of the AD user.
        self.next_token = next_token
        # The operation that you want to perform. Set the value to DescribeVirtualMFADevices.
        self.office_site_id = office_site_id
        # The token that determines the start point of the query. Set the value to the NextToken value returned in the last call.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeVirtualMFADevicesResponseBodyVirtualMFADevices(TeaModel):
    def __init__(
        self,
        consecutive_fails: int = None,
        directory_id: str = None,
        end_user_id: str = None,
        gmt_enabled: str = None,
        gmt_unlock: str = None,
        office_site_id: str = None,
        serial_number: str = None,
        status: str = None,
    ):
        # The time when the virtual MFA device is automatically unlocked after being locked. The time follows the [ISO 8601 standard](~~25696~~) in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.consecutive_fails = consecutive_fails
        self.directory_id = directory_id
        # The status of the virtual MFA device. The valid values include:
        # 
        # *   UNBOUND: The virtual MFA device is not bound.
        # *   NORMAL: The virtual MFA device is normal.
        # *   LOCKED: The virtual MFA device is locked.
        self.end_user_id = end_user_id
        self.gmt_enabled = gmt_enabled
        # The ID of the workspace.
        self.gmt_unlock = gmt_unlock
        # The ID of the request.
        self.office_site_id = office_site_id
        # The serial number of the virtual MFA device, which is a unique identifier.
        self.serial_number = serial_number
        # DescribeVirtualMFADevices
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consecutive_fails is not None:
            result['ConsecutiveFails'] = self.consecutive_fails
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.gmt_enabled is not None:
            result['GmtEnabled'] = self.gmt_enabled
        if self.gmt_unlock is not None:
            result['GmtUnlock'] = self.gmt_unlock
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsecutiveFails') is not None:
            self.consecutive_fails = m.get('ConsecutiveFails')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('GmtEnabled') is not None:
            self.gmt_enabled = m.get('GmtEnabled')
        if m.get('GmtUnlock') is not None:
            self.gmt_unlock = m.get('GmtUnlock')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class DescribeVirtualMFADevicesResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        request_id: str = None,
        virtual_mfadevices: List[DescribeVirtualMFADevicesResponseBodyVirtualMFADevices] = None,
    ):
        # The name of the AD user who uses the virtual MFA device.
        self.next_token = next_token
        # The ID of the workspace.
        self.request_id = request_id
        # The ID of the region.
        self.virtual_mfadevices = virtual_mfadevices

    def validate(self):
        if self.virtual_mfadevices:
            for k in self.virtual_mfadevices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['VirtualMFADevices'] = []
        if self.virtual_mfadevices is not None:
            for k in self.virtual_mfadevices:
                result['VirtualMFADevices'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.virtual_mfadevices = []
        if m.get('VirtualMFADevices') is not None:
            for k in m.get('VirtualMFADevices'):
                temp_model = DescribeVirtualMFADevicesResponseBodyVirtualMFADevices()
                self.virtual_mfadevices.append(temp_model.from_map(k))
        return self


class DescribeVirtualMFADevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeVirtualMFADevicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVirtualMFADevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulDetailsRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        lang: str = None,
        name: str = None,
        region_id: str = None,
        type: str = None,
    ):
        # Details about the vulnerability.
        self.alias_name = alias_name
        # The Common Vulnerability Scoring System (CVSS) score of the vulnerability, which indicates the severity of the vulnerability. A larger value indicates a higher severity. Valid values: 0 to 10.
        self.lang = lang
        # The alias of the vulnerability.
        self.name = name
        # The ID of the vulnerability.
        self.region_id = region_id
        # The operation that you want to perform. Set the value to DescribeVulDetails.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeVulDetailsResponseBodyCves(TeaModel):
    def __init__(
        self,
        cve_id: str = None,
        cvss_score: str = None,
        summary: str = None,
        title: str = None,
    ):
        # The name of the Redhat Package Manager (RPM) package.
        # 
        # You can call the [DescribeVulList](~~223907~~) operation to obtain the names of RPM packages.
        self.cve_id = cve_id
        self.cvss_score = cvss_score
        # The ID of the request.
        self.summary = summary
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cve_id is not None:
            result['CveId'] = self.cve_id
        if self.cvss_score is not None:
            result['CvssScore'] = self.cvss_score
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CveId') is not None:
            self.cve_id = m.get('CveId')
        if m.get('CvssScore') is not None:
            self.cvss_score = m.get('CvssScore')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class DescribeVulDetailsResponseBody(TeaModel):
    def __init__(
        self,
        cves: List[DescribeVulDetailsResponseBodyCves] = None,
        request_id: str = None,
    ):
        # The name of the vulnerability.
        self.cves = cves
        # The ID of the region.
        self.request_id = request_id

    def validate(self):
        if self.cves:
            for k in self.cves:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Cves'] = []
        if self.cves is not None:
            for k in self.cves:
                result['Cves'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cves = []
        if m.get('Cves') is not None:
            for k in m.get('Cves'):
                temp_model = DescribeVulDetailsResponseBodyCves()
                self.cves.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVulDetailsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeVulDetailsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVulDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulListRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        current_page: int = None,
        dealed: str = None,
        lang: str = None,
        name: str = None,
        necessity: str = None,
        office_site_id: str = None,
        page_size: int = None,
        region_id: str = None,
        type: str = None,
    ):
        self.alias_name = alias_name
        self.current_page = current_page
        self.dealed = dealed
        self.lang = lang
        self.name = name
        self.necessity = necessity
        self.office_site_id = office_site_id
        self.page_size = page_size
        self.region_id = region_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList(TeaModel):
    def __init__(
        self,
        full_version: str = None,
        match_detail: str = None,
        name: str = None,
        path: str = None,
        update_cmd: str = None,
    ):
        self.full_version = full_version
        self.match_detail = match_detail
        self.name = name
        self.path = path
        self.update_cmd = update_cmd

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.full_version is not None:
            result['FullVersion'] = self.full_version
        if self.match_detail is not None:
            result['MatchDetail'] = self.match_detail
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.update_cmd is not None:
            result['UpdateCmd'] = self.update_cmd
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FullVersion') is not None:
            self.full_version = m.get('FullVersion')
        if m.get('MatchDetail') is not None:
            self.match_detail = m.get('MatchDetail')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('UpdateCmd') is not None:
            self.update_cmd = m.get('UpdateCmd')
        return self


class DescribeVulListResponseBodyVulRecordsExtendContentJson(TeaModel):
    def __init__(
        self,
        rpm_entity_list: List[DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList] = None,
    ):
        self.rpm_entity_list = rpm_entity_list

    def validate(self):
        if self.rpm_entity_list:
            for k in self.rpm_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RpmEntityList'] = []
        if self.rpm_entity_list is not None:
            for k in self.rpm_entity_list:
                result['RpmEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rpm_entity_list = []
        if m.get('RpmEntityList') is not None:
            for k in m.get('RpmEntityList'):
                temp_model = DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList()
                self.rpm_entity_list.append(temp_model.from_map(k))
        return self


class DescribeVulListResponseBodyVulRecords(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        desktop_id: str = None,
        desktop_name: str = None,
        extend_content_json: DescribeVulListResponseBodyVulRecordsExtendContentJson = None,
        first_ts: int = None,
        last_ts: int = None,
        modify_ts: int = None,
        name: str = None,
        necessity: str = None,
        online: bool = None,
        os_version: str = None,
        related: str = None,
        repair_ts: int = None,
        result_code: str = None,
        result_message: str = None,
        status: int = None,
        tag: str = None,
        type: str = None,
    ):
        self.alias_name = alias_name
        self.desktop_id = desktop_id
        self.desktop_name = desktop_name
        self.extend_content_json = extend_content_json
        self.first_ts = first_ts
        self.last_ts = last_ts
        self.modify_ts = modify_ts
        self.name = name
        self.necessity = necessity
        self.online = online
        self.os_version = os_version
        self.related = related
        self.repair_ts = repair_ts
        self.result_code = result_code
        self.result_message = result_message
        self.status = status
        self.tag = tag
        self.type = type

    def validate(self):
        if self.extend_content_json:
            self.extend_content_json.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.extend_content_json is not None:
            result['ExtendContentJson'] = self.extend_content_json.to_map()
        if self.first_ts is not None:
            result['FirstTs'] = self.first_ts
        if self.last_ts is not None:
            result['LastTs'] = self.last_ts
        if self.modify_ts is not None:
            result['ModifyTs'] = self.modify_ts
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.online is not None:
            result['Online'] = self.online
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.related is not None:
            result['Related'] = self.related
        if self.repair_ts is not None:
            result['RepairTs'] = self.repair_ts
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        if self.result_message is not None:
            result['ResultMessage'] = self.result_message
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('ExtendContentJson') is not None:
            temp_model = DescribeVulListResponseBodyVulRecordsExtendContentJson()
            self.extend_content_json = temp_model.from_map(m['ExtendContentJson'])
        if m.get('FirstTs') is not None:
            self.first_ts = m.get('FirstTs')
        if m.get('LastTs') is not None:
            self.last_ts = m.get('LastTs')
        if m.get('ModifyTs') is not None:
            self.modify_ts = m.get('ModifyTs')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Online') is not None:
            self.online = m.get('Online')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('Related') is not None:
            self.related = m.get('Related')
        if m.get('RepairTs') is not None:
            self.repair_ts = m.get('RepairTs')
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        if m.get('ResultMessage') is not None:
            self.result_message = m.get('ResultMessage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeVulListResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        vul_records: List[DescribeVulListResponseBodyVulRecords] = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.vul_records = vul_records

    def validate(self):
        if self.vul_records:
            for k in self.vul_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VulRecords'] = []
        if self.vul_records is not None:
            for k in self.vul_records:
                result['VulRecords'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.vul_records = []
        if m.get('VulRecords') is not None:
            for k in m.get('VulRecords'):
                temp_model = DescribeVulListResponseBodyVulRecords()
                self.vul_records.append(temp_model.from_map(k))
        return self


class DescribeVulListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeVulListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVulListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulOverviewRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        # The number of medium-risk vulnerabilities.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeVulOverviewResponseBody(TeaModel):
    def __init__(
        self,
        asap_count: int = None,
        later_count: int = None,
        nntf_count: int = None,
        request_id: str = None,
    ):
        self.asap_count = asap_count
        # The operation that you want to perform. Set the value to DescribeVulOverview.
        self.later_count = later_count
        # The ID of the request.
        self.nntf_count = nntf_count
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVulOverviewResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeVulOverviewResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeVulOverviewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeZonesRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        zone_type: str = None,
    ):
        # The ID of the request.
        self.region_id = region_id
        # The operation that you want to perform. Set the value to **DescribeZones**.
        self.zone_type = zone_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_type is not None:
            result['ZoneType'] = self.zone_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneType') is not None:
            self.zone_type = m.get('ZoneType')
        return self


class DescribeZonesResponseBodyZones(TeaModel):
    def __init__(
        self,
        zone_id: str = None,
    ):
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeZonesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        zones: List[DescribeZonesResponseBodyZones] = None,
    ):
        # DescribeZones
        self.request_id = request_id
        self.zones = zones

    def validate(self):
        if self.zones:
            for k in self.zones:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Zones'] = []
        if self.zones is not None:
            for k in self.zones:
                result['Zones'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.zones = []
        if m.get('Zones') is not None:
            for k in m.get('Zones'):
                temp_model = DescribeZonesResponseBodyZones()
                self.zones.append(temp_model.from_map(k))
        return self


class DescribeZonesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeZonesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeZonesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachCenRequest(TeaModel):
    def __init__(
        self,
        office_site_id: str = None,
        region_id: str = None,
    ):
        self.office_site_id = office_site_id
        # The ID of the workspace.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DetachCenResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DetachCenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DetachCenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DetachCenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachEndUserRequest(TeaModel):
    def __init__(
        self,
        ad_domain: str = None,
        client_type: str = None,
        device_id: str = None,
        directory_id: str = None,
        end_user_id: str = None,
        region: str = None,
    ):
        # The address of the Active Directory (AD) workspace.
        self.ad_domain = ad_domain
        # The type of the Alibaba Cloud Workspace client. 1: the hardware client 2: the software client
        self.client_type = client_type
        # The ID of the device.
        self.device_id = device_id
        # The ID of the workspace.
        self.directory_id = directory_id
        # The ID of the user that is bound to the client.
        self.end_user_id = end_user_id
        # The ID of the region.
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_domain is not None:
            result['AdDomain'] = self.ad_domain
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.directory_id is not None:
            result['DirectoryId'] = self.directory_id
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdDomain') is not None:
            self.ad_domain = m.get('AdDomain')
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DirectoryId') is not None:
            self.directory_id = m.get('DirectoryId')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DetachEndUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DetachEndUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DetachEndUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DetachEndUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableDesktopsInGroupRequest(TeaModel):
    def __init__(
        self,
        desktop_group_id: str = None,
        desktop_ids: List[str] = None,
        region_id: str = None,
    ):
        # The ID of the desktop group.
        self.desktop_group_id = desktop_group_id
        # DisableDesktopsInGroup
        self.desktop_ids = desktop_ids
        # The ID of the request.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_group_id is not None:
            result['DesktopGroupId'] = self.desktop_group_id
        if self.desktop_ids is not None:
            result['DesktopIds'] = self.desktop_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopGroupId') is not None:
            self.desktop_group_id = m.get('DesktopGroupId')
        if m.get('DesktopIds') is not None:
            self.desktop_ids = m.get('DesktopIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DisableDesktopsInGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableDesktopsInGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableDesktopsInGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableDesktopsInGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DissociateNetworkPackageRequest(TeaModel):
    def __init__(
        self,
        network_package_id: str = None,
        region_id: str = None,
    ):
        self.network_package_id = network_package_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_package_id is not None:
            result['NetworkPackageId'] = self.network_package_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkPackageId') is not None:
            self.network_package_id = m.get('NetworkPackageId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DissociateNetworkPackageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DissociateNetworkPackageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DissociateNetworkPackageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DissociateNetworkPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportClientEventsRequest(TeaModel):
    def __init__(
        self,
        desktop_id: str = None,
        desktop_name: str = None,
        end_time: str = None,
        end_user_id: str = None,
        event_type: str = None,
        event_types: List[str] = None,
        lang_type: str = None,
        max_results: int = None,
        office_site_id: str = None,
        office_site_name: str = None,
        region_id: str = None,
        start_time: str = None,
    ):
        self.desktop_id = desktop_id
        self.desktop_name = desktop_name
        self.end_time = end_time
        self.end_user_id = end_user_id
        self.event_type = event_type
        self.event_types = event_types
        self.lang_type = lang_type
        self.max_results = max_results
        self.office_site_id = office_site_id
        self.office_site_name = office_site_name
        self.region_id = region_id
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desktop_id is not None:
            result['DesktopId'] = self.desktop_id
        if self.desktop_name is not None:
            result['DesktopName'] = self.desktop_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_user_id is not None:
            result['EndUserId'] = self.end_user_id
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.event_types is not None:
            result['EventTypes'] = self.event_types
        if self.lang_type is not None:
            result['LangType'] = self.lang_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.office_site_id is not None:
            result['OfficeSiteId'] = self.office_site_id
        if self.office_site_name is not None:
            result['OfficeSiteName'] = self.office_site_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesktopId') is not None:
            self.desktop_id = m.get('DesktopId')
        if m.get('DesktopName') is not None:
            self.desktop_name = m.get('DesktopName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndUserId') is not None:
            self.end_user_id = m.get('EndUserId')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('EventTypes') is not None:
            self.event_types = m.get('EventTypes')
        if m.get('LangType') is not None:
            self.lang_type = m.get('LangType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('OfficeSiteId') is not None:
            self.office_site_id = m.get('OfficeSiteId')
        if m.get('OfficeSiteName') is not None:
            self.office_site_name = m.get('OfficeSiteName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ExportClientEventsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        url: str = None,
    ):
        self.request_id = request_id
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ExportClientEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExportClientEventsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.