# MIT License
#
# Copyright (c) 2025 ericsmacedo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""Rounding method constants for use with Numba-optimized functions."""

# Integer codes (for Numba performance)
TRUNC = 0
CEIL = 1
TO_ZERO = 2
AWAY = 3
HALF_UP = 4
HALF_DOWN = 5
HALF_EVEN = 6
HALF_ZERO = 7
HALF_AWAY = 8

WRAP = 0
SAT = 1
ERROR = 2

rounding_modes = {
    "TRUNC": TRUNC,
    "CEIL": CEIL,
    "TO_ZERO": TO_ZERO,
    "AWAY": AWAY,
    "HALF_UP": HALF_UP,
    "HALF_DOWN": HALF_DOWN,
    "HALF_EVEN": HALF_EVEN,
    "HALF_ZERO": HALF_ZERO,
    "HALF_AWAY": HALF_AWAY,
}

overflow_modes = {
    "WRAP": WRAP,
    "SAT": SAT,
    "ERROR": ERROR,
}

rounding_modes_inv = {v: k for k, v in rounding_modes.items()}
overflow_modes_inv = {v: k for k, v in overflow_modes.items()}
