#
# Copyright © 2012–2022 Michal Čihař <michal@cihar.com>
#
# This file is part of Weblate <https://weblate.org/>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#


from django.apps import AppConfig
from django.core.checks import Warning, register

from weblate.utils.checks import weblate_check


def check_formats(app_configs, **kwargs):
    from weblate.formats.models import FILE_FORMATS

    message = "Failure in loading handler for {} file format: {}"
    return [
        weblate_check(
            f"weblate.W025.{key}", message.format(key, value.strip()), Warning
        )
        for key, value in FILE_FORMATS.errors.items()
    ]


class FormatsConfig(AppConfig):
    name = "weblate.formats"
    label = "formats"
    verbose_name = "Formats"

    def ready(self):
        super().ready()
        register(check_formats)
