# Generated by Django 4.1a1 on 2022-05-18 13:14

from django.db import migrations
from weblate_language_data.population import POPULATION


def fill_population(apps, schema_editor):
    Language = apps.get_model("lang", "Language")

    languages = Language.objects.using(schema_editor.connection.alias).all()

    updates = []

    for language in languages:
        if language.code not in POPULATION:
            continue
        language.population = POPULATION[language.code]
        updates.append(language)

        Language.objects.using(schema_editor.connection.alias).bulk_update(
            updates, ["population"]
        )


class Migration(migrations.Migration):

    dependencies = [
        ("lang", "0014_language_population"),
    ]

    operations = [
        migrations.RunPython(fill_population, migrations.RunPython.noop, elidable=True)
    ]
