# Generated by Django 3.1.4 on 2021-01-15 09:30

from django.db import migrations


def move_mailing(apps, schema_editor):
    Project = apps.get_model("trans", "Project")
    db_alias = schema_editor.connection.alias

    for project in Project.objects.using(db_alias).exclude(mail="").iterator():
        project.instructions += f"\nMailing list for translators: <{project.mail}\n"
        project.save(update_fields=["instructions"])


class Migration(migrations.Migration):

    dependencies = [
        ("trans", "0107_component_links"),
    ]

    operations = [migrations.RunPython(move_mailing, elidable=True)]
