# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ComputeAclArgs', 'ComputeAcl']

@pulumi.input_type
class ComputeAclArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ComputeAcl resource.
        :param pulumi.Input[_builtins.str] name: A unique name to identify the Compute ACL. It is important to note that changing this attribute will delete and recreate the Compute ACL, and discard the current entries. You MUST first delete the associated resource_link block from your service before modifying this field.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique name to identify the Compute ACL. It is important to note that changing this attribute will delete and recreate the Compute ACL, and discard the current entries. You MUST first delete the associated resource_link block from your service before modifying this field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ComputeAclState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ComputeAcl resources.
        :param pulumi.Input[_builtins.str] name: A unique name to identify the Compute ACL. It is important to note that changing this attribute will delete and recreate the Compute ACL, and discard the current entries. You MUST first delete the associated resource_link block from your service before modifying this field.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique name to identify the Compute ACL. It is important to note that changing this attribute will delete and recreate the Compute ACL, and discard the current entries. You MUST first delete the associated resource_link block from your service before modifying this field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("fastly:index/computeAcl:ComputeAcl")
class ComputeAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Compute Access Control List (ACL) that defines CIDR-based access rules (e.g., allow/block IP ranges) and is accessible to Compute services during request processing.

        In order for a Compute ACL (`ComputeAcl`) to be accessible to a [Compute](https://developer.fastly.com/learning/compute/) service you'll first need to define a Compute service (`ServiceCompute`) in your configuration, and then create a link to the ACL from within the service using the `resource_link` block (shown in the below examples).

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        # IMPORTANT: Deleting a Compute ACL requires first deleting its resource_link.
        # This requires a two-step `pulumi up` because we can't guarantee deletion order.
        example_compute_acl = fastly.ComputeAcl("example", name="my_compute_acl")
        example = fastly.get_package_hash(filename="package.tar.gz")
        example_service_compute = fastly.ServiceCompute("example",
            name="my_compute_service",
            domains=[{
                "name": "demo.example.com",
            }],
            package={
                "filename": "package.tar.gz",
                "source_code_hash": example.hash,
            },
            resource_links=[{
                "name": "my_acl_link",
                "resource_id": example_compute_acl.id,
            }],
            force_destroy=True)
        ```

        ## Import

        Fastly Compute ACLs can be imported using their ACL ID, e.g.

        ```sh
        $ pulumi import fastly:index/computeAcl:ComputeAcl example <compute_acl_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: A unique name to identify the Compute ACL. It is important to note that changing this attribute will delete and recreate the Compute ACL, and discard the current entries. You MUST first delete the associated resource_link block from your service before modifying this field.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ComputeAclArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Compute Access Control List (ACL) that defines CIDR-based access rules (e.g., allow/block IP ranges) and is accessible to Compute services during request processing.

        In order for a Compute ACL (`ComputeAcl`) to be accessible to a [Compute](https://developer.fastly.com/learning/compute/) service you'll first need to define a Compute service (`ServiceCompute`) in your configuration, and then create a link to the ACL from within the service using the `resource_link` block (shown in the below examples).

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        # IMPORTANT: Deleting a Compute ACL requires first deleting its resource_link.
        # This requires a two-step `pulumi up` because we can't guarantee deletion order.
        example_compute_acl = fastly.ComputeAcl("example", name="my_compute_acl")
        example = fastly.get_package_hash(filename="package.tar.gz")
        example_service_compute = fastly.ServiceCompute("example",
            name="my_compute_service",
            domains=[{
                "name": "demo.example.com",
            }],
            package={
                "filename": "package.tar.gz",
                "source_code_hash": example.hash,
            },
            resource_links=[{
                "name": "my_acl_link",
                "resource_id": example_compute_acl.id,
            }],
            force_destroy=True)
        ```

        ## Import

        Fastly Compute ACLs can be imported using their ACL ID, e.g.

        ```sh
        $ pulumi import fastly:index/computeAcl:ComputeAcl example <compute_acl_id>
        ```

        :param str resource_name: The name of the resource.
        :param ComputeAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeAclArgs.__new__(ComputeAclArgs)

            __props__.__dict__["name"] = name
        super(ComputeAcl, __self__).__init__(
            'fastly:index/computeAcl:ComputeAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ComputeAcl':
        """
        Get an existing ComputeAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: A unique name to identify the Compute ACL. It is important to note that changing this attribute will delete and recreate the Compute ACL, and discard the current entries. You MUST first delete the associated resource_link block from your service before modifying this field.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeAclState.__new__(_ComputeAclState)

        __props__.__dict__["name"] = name
        return ComputeAcl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A unique name to identify the Compute ACL. It is important to note that changing this attribute will delete and recreate the Compute ACL, and discard the current entries. You MUST first delete the associated resource_link block from your service before modifying this field.
        """
        return pulumi.get(self, "name")

