# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ComputeAclEntriesArgs', 'ComputeAclEntries']

@pulumi.input_type
class ComputeAclEntriesArgs:
    def __init__(__self__, *,
                 compute_acl_id: pulumi.Input[_builtins.str],
                 entries: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 manage_entries: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ComputeAclEntries resource.
        :param pulumi.Input[_builtins.str] compute_acl_id: Manages entries for a Fastly Compute Access Control List (ACL). To import, use the format \\n\\n/entries.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entries: A map representing the entries in the Compute ACL, where the keys are the prefixes and the values are the actions (ALLOW or BLOCK).
        """
        pulumi.set(__self__, "compute_acl_id", compute_acl_id)
        pulumi.set(__self__, "entries", entries)
        if manage_entries is not None:
            pulumi.set(__self__, "manage_entries", manage_entries)

    @_builtins.property
    @pulumi.getter(name="computeAclId")
    def compute_acl_id(self) -> pulumi.Input[_builtins.str]:
        """
        Manages entries for a Fastly Compute Access Control List (ACL). To import, use the format \\n\\n/entries.
        """
        return pulumi.get(self, "compute_acl_id")

    @compute_acl_id.setter
    def compute_acl_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_acl_id", value)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        A map representing the entries in the Compute ACL, where the keys are the prefixes and the values are the actions (ALLOW or BLOCK).
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter(name="manageEntries")
    def manage_entries(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "manage_entries")

    @manage_entries.setter
    def manage_entries(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "manage_entries", value)


@pulumi.input_type
class _ComputeAclEntriesState:
    def __init__(__self__, *,
                 compute_acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 manage_entries: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ComputeAclEntries resources.
        :param pulumi.Input[_builtins.str] compute_acl_id: Manages entries for a Fastly Compute Access Control List (ACL). To import, use the format \\n\\n/entries.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entries: A map representing the entries in the Compute ACL, where the keys are the prefixes and the values are the actions (ALLOW or BLOCK).
        """
        if compute_acl_id is not None:
            pulumi.set(__self__, "compute_acl_id", compute_acl_id)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if manage_entries is not None:
            pulumi.set(__self__, "manage_entries", manage_entries)

    @_builtins.property
    @pulumi.getter(name="computeAclId")
    def compute_acl_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Manages entries for a Fastly Compute Access Control List (ACL). To import, use the format \\n\\n/entries.
        """
        return pulumi.get(self, "compute_acl_id")

    @compute_acl_id.setter
    def compute_acl_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_acl_id", value)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map representing the entries in the Compute ACL, where the keys are the prefixes and the values are the actions (ALLOW or BLOCK).
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter(name="manageEntries")
    def manage_entries(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "manage_entries")

    @manage_entries.setter
    def manage_entries(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "manage_entries", value)


@pulumi.type_token("fastly:index/computeAclEntries:ComputeAclEntries")
class ComputeAclEntries(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 manage_entries: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Import

        Fastly Compute ACL entries can be imported using the format `<compute_acl_id>/entries`, e.g.

        ```sh
        $ pulumi import fastly:index/computeAclEntries:ComputeAclEntries example <compute_acl_id>/entries
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compute_acl_id: Manages entries for a Fastly Compute Access Control List (ACL). To import, use the format \\n\\n/entries.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entries: A map representing the entries in the Compute ACL, where the keys are the prefixes and the values are the actions (ALLOW or BLOCK).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeAclEntriesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Fastly Compute ACL entries can be imported using the format `<compute_acl_id>/entries`, e.g.

        ```sh
        $ pulumi import fastly:index/computeAclEntries:ComputeAclEntries example <compute_acl_id>/entries
        ```

        :param str resource_name: The name of the resource.
        :param ComputeAclEntriesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeAclEntriesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 manage_entries: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeAclEntriesArgs.__new__(ComputeAclEntriesArgs)

            if compute_acl_id is None and not opts.urn:
                raise TypeError("Missing required property 'compute_acl_id'")
            __props__.__dict__["compute_acl_id"] = compute_acl_id
            if entries is None and not opts.urn:
                raise TypeError("Missing required property 'entries'")
            __props__.__dict__["entries"] = entries
            __props__.__dict__["manage_entries"] = manage_entries
        super(ComputeAclEntries, __self__).__init__(
            'fastly:index/computeAclEntries:ComputeAclEntries',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compute_acl_id: Optional[pulumi.Input[_builtins.str]] = None,
            entries: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            manage_entries: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ComputeAclEntries':
        """
        Get an existing ComputeAclEntries resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compute_acl_id: Manages entries for a Fastly Compute Access Control List (ACL). To import, use the format \\n\\n/entries.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entries: A map representing the entries in the Compute ACL, where the keys are the prefixes and the values are the actions (ALLOW or BLOCK).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeAclEntriesState.__new__(_ComputeAclEntriesState)

        __props__.__dict__["compute_acl_id"] = compute_acl_id
        __props__.__dict__["entries"] = entries
        __props__.__dict__["manage_entries"] = manage_entries
        return ComputeAclEntries(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="computeAclId")
    def compute_acl_id(self) -> pulumi.Output[_builtins.str]:
        """
        Manages entries for a Fastly Compute Access Control List (ACL). To import, use the format \\n\\n/entries.
        """
        return pulumi.get(self, "compute_acl_id")

    @_builtins.property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map representing the entries in the Compute ACL, where the keys are the prefixes and the values are the actions (ALLOW or BLOCK).
        """
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter(name="manageEntries")
    def manage_entries(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "manage_entries")

