# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDomainsV1Result',
    'AwaitableGetDomainsV1Result',
    'get_domains_v1',
    'get_domains_v1_output',
]

@pulumi.output_type
class GetDomainsV1Result:
    """
    A collection of values returned by getDomainsV1.
    """
    def __init__(__self__, domains=None, id=None, total=None):
        if domains and not isinstance(domains, list):
            raise TypeError("Expected argument 'domains' to be a list")
        pulumi.set(__self__, "domains", domains)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if total and not isinstance(total, int):
            raise TypeError("Expected argument 'total' to be a int")
        pulumi.set(__self__, "total", total)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Sequence['outputs.GetDomainsV1DomainResult']:
        """
        A domain represents the domain name through which visitors will retrieve content. There can be multiple domains for a service.
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def total(self) -> _builtins.int:
        """
        The total number of domains returned.
        """
        return pulumi.get(self, "total")


class AwaitableGetDomainsV1Result(GetDomainsV1Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainsV1Result(
            domains=self.domains,
            id=self.id,
            total=self.total)


def get_domains_v1(total: Optional[_builtins.int] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainsV1Result:
    """
    Use this data source to get information about versionless domains.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    example = fastly.get_domains_v1()
    pulumi.export("allDomains", example.domains)
    pulumi.export("totalDomains", example.total)
    ```

    [1]: https://www.fastly.com/documentation/reference/api/domain-management/domains/


    :param _builtins.int total: The total number of domains returned.
    """
    __args__ = dict()
    __args__['total'] = total
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('fastly:index/getDomainsV1:getDomainsV1', __args__, opts=opts, typ=GetDomainsV1Result).value

    return AwaitableGetDomainsV1Result(
        domains=pulumi.get(__ret__, 'domains'),
        id=pulumi.get(__ret__, 'id'),
        total=pulumi.get(__ret__, 'total'))
def get_domains_v1_output(total: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainsV1Result]:
    """
    Use this data source to get information about versionless domains.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    example = fastly.get_domains_v1()
    pulumi.export("allDomains", example.domains)
    pulumi.export("totalDomains", example.total)
    ```

    [1]: https://www.fastly.com/documentation/reference/api/domain-management/domains/


    :param _builtins.int total: The total number of domains returned.
    """
    __args__ = dict()
    __args__['total'] = total
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('fastly:index/getDomainsV1:getDomainsV1', __args__, opts=opts, typ=GetDomainsV1Result)
    return __ret__.apply(lambda __response__: GetDomainsV1Result(
        domains=pulumi.get(__response__, 'domains'),
        id=pulumi.get(__response__, 'id'),
        total=pulumi.get(__response__, 'total')))
