# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NgwafThresholdsArgs', 'NgwafThresholds']

@pulumi.input_type
class NgwafThresholdsArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 dont_notify: pulumi.Input[_builtins.bool],
                 enabled: pulumi.Input[_builtins.bool],
                 interval: pulumi.Input[_builtins.int],
                 limit: pulumi.Input[_builtins.int],
                 signal: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NgwafThresholds resource.
        :param pulumi.Input[_builtins.str] action: Action to take when threshold is exceeded.
        :param pulumi.Input[_builtins.bool] dont_notify: Whether to silence notifications when action is taken.
        :param pulumi.Input[_builtins.bool] enabled: Whether this threshold is active.
        :param pulumi.Input[_builtins.int] interval: Threshold interval in seconds. Accepted values are `60`, `600`, and `3600`.
        :param pulumi.Input[_builtins.int] limit: Threshold limit. Minimum 1 and maximum 10,000.
        :param pulumi.Input[_builtins.str] signal: The name of the signal this threshold is acting on.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        :param pulumi.Input[_builtins.int] duration: Duration the action is in place, in seconds. Minimum 1 and maximum 31,556,900.
        :param pulumi.Input[_builtins.str] name: The name of the threshold.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "dont_notify", dont_notify)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "limit", limit)
        pulumi.set(__self__, "signal", signal)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Action to take when threshold is exceeded.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="dontNotify")
    def dont_notify(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to silence notifications when action is taken.
        """
        return pulumi.get(self, "dont_notify")

    @dont_notify.setter
    def dont_notify(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "dont_notify", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether this threshold is active.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Input[_builtins.int]:
        """
        Threshold interval in seconds. Accepted values are `60`, `600`, and `3600`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def limit(self) -> pulumi.Input[_builtins.int]:
        """
        Threshold limit. Minimum 1 and maximum 10,000.
        """
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "limit", value)

    @_builtins.property
    @pulumi.getter
    def signal(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the signal this threshold is acting on.
        """
        return pulumi.get(self, "signal")

    @signal.setter
    def signal(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "signal", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration the action is in place, in seconds. Minimum 1 and maximum 31,556,900.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the threshold.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NgwafThresholdsState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 dont_notify: Optional[pulumi.Input[_builtins.bool]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 limit: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signal: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgwafThresholds resources.
        :param pulumi.Input[_builtins.str] action: Action to take when threshold is exceeded.
        :param pulumi.Input[_builtins.bool] dont_notify: Whether to silence notifications when action is taken.
        :param pulumi.Input[_builtins.int] duration: Duration the action is in place, in seconds. Minimum 1 and maximum 31,556,900.
        :param pulumi.Input[_builtins.bool] enabled: Whether this threshold is active.
        :param pulumi.Input[_builtins.int] interval: Threshold interval in seconds. Accepted values are `60`, `600`, and `3600`.
        :param pulumi.Input[_builtins.int] limit: Threshold limit. Minimum 1 and maximum 10,000.
        :param pulumi.Input[_builtins.str] name: The name of the threshold.
        :param pulumi.Input[_builtins.str] signal: The name of the signal this threshold is acting on.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if dont_notify is not None:
            pulumi.set(__self__, "dont_notify", dont_notify)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if signal is not None:
            pulumi.set(__self__, "signal", signal)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to take when threshold is exceeded.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="dontNotify")
    def dont_notify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to silence notifications when action is taken.
        """
        return pulumi.get(self, "dont_notify")

    @dont_notify.setter
    def dont_notify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dont_notify", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration the action is in place, in seconds. Minimum 1 and maximum 31,556,900.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this threshold is active.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Threshold interval in seconds. Accepted values are `60`, `600`, and `3600`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Threshold limit. Minimum 1 and maximum 10,000.
        """
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "limit", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the threshold.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def signal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the signal this threshold is acting on.
        """
        return pulumi.get(self, "signal")

    @signal.setter
    def signal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signal", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("fastly:index/ngwafThresholds:NgwafThresholds")
class NgwafThresholds(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 dont_notify: Optional[pulumi.Input[_builtins.bool]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 limit: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signal: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Fastly Next-Gen WAF Threshold.  Operations related to managing workspace thresholds.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo = fastly.NgwafThresholds("demo",
            action="block",
            dont_notify=False,
            duration=86400,
            enabled=True,
            interval=3600,
            limit=10,
            name="%s",
            signal="SQLI",
            workspace_id=example["id"])
        ```

        ## Import

        Fastly Next-Gen WAF Thresholds can be imported using their workspace and Threshold ID, e.g.

        ```sh
        $ pulumi import fastly:index/ngwafThresholds:NgwafThresholds example <workspace_id>/<threshold_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Action to take when threshold is exceeded.
        :param pulumi.Input[_builtins.bool] dont_notify: Whether to silence notifications when action is taken.
        :param pulumi.Input[_builtins.int] duration: Duration the action is in place, in seconds. Minimum 1 and maximum 31,556,900.
        :param pulumi.Input[_builtins.bool] enabled: Whether this threshold is active.
        :param pulumi.Input[_builtins.int] interval: Threshold interval in seconds. Accepted values are `60`, `600`, and `3600`.
        :param pulumi.Input[_builtins.int] limit: Threshold limit. Minimum 1 and maximum 10,000.
        :param pulumi.Input[_builtins.str] name: The name of the threshold.
        :param pulumi.Input[_builtins.str] signal: The name of the signal this threshold is acting on.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgwafThresholdsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Fastly Next-Gen WAF Threshold.  Operations related to managing workspace thresholds.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo = fastly.NgwafThresholds("demo",
            action="block",
            dont_notify=False,
            duration=86400,
            enabled=True,
            interval=3600,
            limit=10,
            name="%s",
            signal="SQLI",
            workspace_id=example["id"])
        ```

        ## Import

        Fastly Next-Gen WAF Thresholds can be imported using their workspace and Threshold ID, e.g.

        ```sh
        $ pulumi import fastly:index/ngwafThresholds:NgwafThresholds example <workspace_id>/<threshold_id>
        ```

        :param str resource_name: The name of the resource.
        :param NgwafThresholdsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgwafThresholdsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 dont_notify: Optional[pulumi.Input[_builtins.bool]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 limit: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signal: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgwafThresholdsArgs.__new__(NgwafThresholdsArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if dont_notify is None and not opts.urn:
                raise TypeError("Missing required property 'dont_notify'")
            __props__.__dict__["dont_notify"] = dont_notify
            __props__.__dict__["duration"] = duration
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if interval is None and not opts.urn:
                raise TypeError("Missing required property 'interval'")
            __props__.__dict__["interval"] = interval
            if limit is None and not opts.urn:
                raise TypeError("Missing required property 'limit'")
            __props__.__dict__["limit"] = limit
            __props__.__dict__["name"] = name
            if signal is None and not opts.urn:
                raise TypeError("Missing required property 'signal'")
            __props__.__dict__["signal"] = signal
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(NgwafThresholds, __self__).__init__(
            'fastly:index/ngwafThresholds:NgwafThresholds',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            dont_notify: Optional[pulumi.Input[_builtins.bool]] = None,
            duration: Optional[pulumi.Input[_builtins.int]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            interval: Optional[pulumi.Input[_builtins.int]] = None,
            limit: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            signal: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgwafThresholds':
        """
        Get an existing NgwafThresholds resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Action to take when threshold is exceeded.
        :param pulumi.Input[_builtins.bool] dont_notify: Whether to silence notifications when action is taken.
        :param pulumi.Input[_builtins.int] duration: Duration the action is in place, in seconds. Minimum 1 and maximum 31,556,900.
        :param pulumi.Input[_builtins.bool] enabled: Whether this threshold is active.
        :param pulumi.Input[_builtins.int] interval: Threshold interval in seconds. Accepted values are `60`, `600`, and `3600`.
        :param pulumi.Input[_builtins.int] limit: Threshold limit. Minimum 1 and maximum 10,000.
        :param pulumi.Input[_builtins.str] name: The name of the threshold.
        :param pulumi.Input[_builtins.str] signal: The name of the signal this threshold is acting on.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgwafThresholdsState.__new__(_NgwafThresholdsState)

        __props__.__dict__["action"] = action
        __props__.__dict__["dont_notify"] = dont_notify
        __props__.__dict__["duration"] = duration
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["interval"] = interval
        __props__.__dict__["limit"] = limit
        __props__.__dict__["name"] = name
        __props__.__dict__["signal"] = signal
        __props__.__dict__["workspace_id"] = workspace_id
        return NgwafThresholds(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        Action to take when threshold is exceeded.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="dontNotify")
    def dont_notify(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to silence notifications when action is taken.
        """
        return pulumi.get(self, "dont_notify")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Duration the action is in place, in seconds. Minimum 1 and maximum 31,556,900.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this threshold is active.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Output[_builtins.int]:
        """
        Threshold interval in seconds. Accepted values are `60`, `600`, and `3600`.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> pulumi.Output[_builtins.int]:
        """
        Threshold limit. Minimum 1 and maximum 10,000.
        """
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the threshold.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def signal(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the signal this threshold is acting on.
        """
        return pulumi.get(self, "signal")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

