# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NgwafWorkspaceArgs', 'NgwafWorkspace']

@pulumi.input_type
class NgwafWorkspaceArgs:
    def __init__(__self__, *,
                 attack_signal_thresholds: pulumi.Input['NgwafWorkspaceAttackSignalThresholdsArgs'],
                 description: pulumi.Input[_builtins.str],
                 mode: pulumi.Input[_builtins.str],
                 client_ip_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_blocking_response_code: Optional[pulumi.Input[_builtins.int]] = None,
                 default_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_anonymization: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NgwafWorkspace resource.
        :param pulumi.Input['NgwafWorkspaceAttackSignalThresholdsArgs'] attack_signal_thresholds: Attack threshold parameters for system site alerts. Each threshold value is the number of attack signals per IP address that must be detected during the interval before the related IP address is flagged. If no values are set then the default value for each field will be applied
        :param pulumi.Input[_builtins.str] description: The description of the workspace
        :param pulumi.Input[_builtins.str] mode: The operation mode of the workspace. Accepted values are `off`, `block`, and `log`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_ip_headers: Specifies the request headers containing the client IP address. Maximum of 10 header names.
        :param pulumi.Input[_builtins.int] default_blocking_response_code: The status code returned when a request is blocked. This configuration is applied at the workspace but can be overwritten in rules. Accepted values are [`301`, `302`, `400..599`]. Default value `406`.
        :param pulumi.Input[_builtins.str] default_redirect_url: The redirect URL used if default*blocking*response_code is `301` or `302`.
        :param pulumi.Input[_builtins.str] ip_anonymization: Agents will anonymize IP addresses according to the option selected. Accepted value is `hashed`.
        :param pulumi.Input[_builtins.str] name: The display name of the workspace.
        """
        pulumi.set(__self__, "attack_signal_thresholds", attack_signal_thresholds)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "mode", mode)
        if client_ip_headers is not None:
            pulumi.set(__self__, "client_ip_headers", client_ip_headers)
        if default_blocking_response_code is not None:
            pulumi.set(__self__, "default_blocking_response_code", default_blocking_response_code)
        if default_redirect_url is not None:
            pulumi.set(__self__, "default_redirect_url", default_redirect_url)
        if ip_anonymization is not None:
            pulumi.set(__self__, "ip_anonymization", ip_anonymization)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="attackSignalThresholds")
    def attack_signal_thresholds(self) -> pulumi.Input['NgwafWorkspaceAttackSignalThresholdsArgs']:
        """
        Attack threshold parameters for system site alerts. Each threshold value is the number of attack signals per IP address that must be detected during the interval before the related IP address is flagged. If no values are set then the default value for each field will be applied
        """
        return pulumi.get(self, "attack_signal_thresholds")

    @attack_signal_thresholds.setter
    def attack_signal_thresholds(self, value: pulumi.Input['NgwafWorkspaceAttackSignalThresholdsArgs']):
        pulumi.set(self, "attack_signal_thresholds", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the workspace
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Input[_builtins.str]:
        """
        The operation mode of the workspace. Accepted values are `off`, `block`, and `log`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="clientIpHeaders")
    def client_ip_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the request headers containing the client IP address. Maximum of 10 header names.
        """
        return pulumi.get(self, "client_ip_headers")

    @client_ip_headers.setter
    def client_ip_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "client_ip_headers", value)

    @_builtins.property
    @pulumi.getter(name="defaultBlockingResponseCode")
    def default_blocking_response_code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The status code returned when a request is blocked. This configuration is applied at the workspace but can be overwritten in rules. Accepted values are [`301`, `302`, `400..599`]. Default value `406`.
        """
        return pulumi.get(self, "default_blocking_response_code")

    @default_blocking_response_code.setter
    def default_blocking_response_code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_blocking_response_code", value)

    @_builtins.property
    @pulumi.getter(name="defaultRedirectUrl")
    def default_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The redirect URL used if default*blocking*response_code is `301` or `302`.
        """
        return pulumi.get(self, "default_redirect_url")

    @default_redirect_url.setter
    def default_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="ipAnonymization")
    def ip_anonymization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Agents will anonymize IP addresses according to the option selected. Accepted value is `hashed`.
        """
        return pulumi.get(self, "ip_anonymization")

    @ip_anonymization.setter
    def ip_anonymization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_anonymization", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the workspace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NgwafWorkspaceState:
    def __init__(__self__, *,
                 attack_signal_thresholds: Optional[pulumi.Input['NgwafWorkspaceAttackSignalThresholdsArgs']] = None,
                 client_ip_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_blocking_response_code: Optional[pulumi.Input[_builtins.int]] = None,
                 default_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_anonymization: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgwafWorkspace resources.
        :param pulumi.Input['NgwafWorkspaceAttackSignalThresholdsArgs'] attack_signal_thresholds: Attack threshold parameters for system site alerts. Each threshold value is the number of attack signals per IP address that must be detected during the interval before the related IP address is flagged. If no values are set then the default value for each field will be applied
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_ip_headers: Specifies the request headers containing the client IP address. Maximum of 10 header names.
        :param pulumi.Input[_builtins.int] default_blocking_response_code: The status code returned when a request is blocked. This configuration is applied at the workspace but can be overwritten in rules. Accepted values are [`301`, `302`, `400..599`]. Default value `406`.
        :param pulumi.Input[_builtins.str] default_redirect_url: The redirect URL used if default*blocking*response_code is `301` or `302`.
        :param pulumi.Input[_builtins.str] description: The description of the workspace
        :param pulumi.Input[_builtins.str] ip_anonymization: Agents will anonymize IP addresses according to the option selected. Accepted value is `hashed`.
        :param pulumi.Input[_builtins.str] mode: The operation mode of the workspace. Accepted values are `off`, `block`, and `log`.
        :param pulumi.Input[_builtins.str] name: The display name of the workspace.
        """
        if attack_signal_thresholds is not None:
            pulumi.set(__self__, "attack_signal_thresholds", attack_signal_thresholds)
        if client_ip_headers is not None:
            pulumi.set(__self__, "client_ip_headers", client_ip_headers)
        if default_blocking_response_code is not None:
            pulumi.set(__self__, "default_blocking_response_code", default_blocking_response_code)
        if default_redirect_url is not None:
            pulumi.set(__self__, "default_redirect_url", default_redirect_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_anonymization is not None:
            pulumi.set(__self__, "ip_anonymization", ip_anonymization)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="attackSignalThresholds")
    def attack_signal_thresholds(self) -> Optional[pulumi.Input['NgwafWorkspaceAttackSignalThresholdsArgs']]:
        """
        Attack threshold parameters for system site alerts. Each threshold value is the number of attack signals per IP address that must be detected during the interval before the related IP address is flagged. If no values are set then the default value for each field will be applied
        """
        return pulumi.get(self, "attack_signal_thresholds")

    @attack_signal_thresholds.setter
    def attack_signal_thresholds(self, value: Optional[pulumi.Input['NgwafWorkspaceAttackSignalThresholdsArgs']]):
        pulumi.set(self, "attack_signal_thresholds", value)

    @_builtins.property
    @pulumi.getter(name="clientIpHeaders")
    def client_ip_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the request headers containing the client IP address. Maximum of 10 header names.
        """
        return pulumi.get(self, "client_ip_headers")

    @client_ip_headers.setter
    def client_ip_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "client_ip_headers", value)

    @_builtins.property
    @pulumi.getter(name="defaultBlockingResponseCode")
    def default_blocking_response_code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The status code returned when a request is blocked. This configuration is applied at the workspace but can be overwritten in rules. Accepted values are [`301`, `302`, `400..599`]. Default value `406`.
        """
        return pulumi.get(self, "default_blocking_response_code")

    @default_blocking_response_code.setter
    def default_blocking_response_code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_blocking_response_code", value)

    @_builtins.property
    @pulumi.getter(name="defaultRedirectUrl")
    def default_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The redirect URL used if default*blocking*response_code is `301` or `302`.
        """
        return pulumi.get(self, "default_redirect_url")

    @default_redirect_url.setter
    def default_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_redirect_url", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the workspace
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ipAnonymization")
    def ip_anonymization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Agents will anonymize IP addresses according to the option selected. Accepted value is `hashed`.
        """
        return pulumi.get(self, "ip_anonymization")

    @ip_anonymization.setter
    def ip_anonymization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_anonymization", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation mode of the workspace. Accepted values are `off`, `block`, and `log`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the workspace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("fastly:index/ngwafWorkspace:NgwafWorkspace")
class NgwafWorkspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attack_signal_thresholds: Optional[pulumi.Input[Union['NgwafWorkspaceAttackSignalThresholdsArgs', 'NgwafWorkspaceAttackSignalThresholdsArgsDict']]] = None,
                 client_ip_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_blocking_response_code: Optional[pulumi.Input[_builtins.int]] = None,
                 default_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_anonymization: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Fastly Next-Gen WAF Workspace, representing a container for
        rules, signals, and various other resources that are offered by the
        Next-Gen WAF product.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo = fastly.NgwafWorkspace("demo",
            name="Demo",
            description="Testing",
            mode="block",
            attack_signal_thresholds={
                "one_minute": 100,
                "ten_minutes": 500,
                "one_hour": 1000,
                "immediate": True,
            })
        ```

        ## Import

        Fastly Next-Gen WAF Workspaces can be imported using their workspace ID, e.g.

        ```sh
        $ pulumi import fastly:index/ngwafWorkspace:NgwafWorkspace demo xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NgwafWorkspaceAttackSignalThresholdsArgs', 'NgwafWorkspaceAttackSignalThresholdsArgsDict']] attack_signal_thresholds: Attack threshold parameters for system site alerts. Each threshold value is the number of attack signals per IP address that must be detected during the interval before the related IP address is flagged. If no values are set then the default value for each field will be applied
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_ip_headers: Specifies the request headers containing the client IP address. Maximum of 10 header names.
        :param pulumi.Input[_builtins.int] default_blocking_response_code: The status code returned when a request is blocked. This configuration is applied at the workspace but can be overwritten in rules. Accepted values are [`301`, `302`, `400..599`]. Default value `406`.
        :param pulumi.Input[_builtins.str] default_redirect_url: The redirect URL used if default*blocking*response_code is `301` or `302`.
        :param pulumi.Input[_builtins.str] description: The description of the workspace
        :param pulumi.Input[_builtins.str] ip_anonymization: Agents will anonymize IP addresses according to the option selected. Accepted value is `hashed`.
        :param pulumi.Input[_builtins.str] mode: The operation mode of the workspace. Accepted values are `off`, `block`, and `log`.
        :param pulumi.Input[_builtins.str] name: The display name of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgwafWorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Fastly Next-Gen WAF Workspace, representing a container for
        rules, signals, and various other resources that are offered by the
        Next-Gen WAF product.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo = fastly.NgwafWorkspace("demo",
            name="Demo",
            description="Testing",
            mode="block",
            attack_signal_thresholds={
                "one_minute": 100,
                "ten_minutes": 500,
                "one_hour": 1000,
                "immediate": True,
            })
        ```

        ## Import

        Fastly Next-Gen WAF Workspaces can be imported using their workspace ID, e.g.

        ```sh
        $ pulumi import fastly:index/ngwafWorkspace:NgwafWorkspace demo xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param NgwafWorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgwafWorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attack_signal_thresholds: Optional[pulumi.Input[Union['NgwafWorkspaceAttackSignalThresholdsArgs', 'NgwafWorkspaceAttackSignalThresholdsArgsDict']]] = None,
                 client_ip_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_blocking_response_code: Optional[pulumi.Input[_builtins.int]] = None,
                 default_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_anonymization: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgwafWorkspaceArgs.__new__(NgwafWorkspaceArgs)

            if attack_signal_thresholds is None and not opts.urn:
                raise TypeError("Missing required property 'attack_signal_thresholds'")
            __props__.__dict__["attack_signal_thresholds"] = attack_signal_thresholds
            __props__.__dict__["client_ip_headers"] = client_ip_headers
            __props__.__dict__["default_blocking_response_code"] = default_blocking_response_code
            __props__.__dict__["default_redirect_url"] = default_redirect_url
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["ip_anonymization"] = ip_anonymization
            if mode is None and not opts.urn:
                raise TypeError("Missing required property 'mode'")
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
        super(NgwafWorkspace, __self__).__init__(
            'fastly:index/ngwafWorkspace:NgwafWorkspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attack_signal_thresholds: Optional[pulumi.Input[Union['NgwafWorkspaceAttackSignalThresholdsArgs', 'NgwafWorkspaceAttackSignalThresholdsArgsDict']]] = None,
            client_ip_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            default_blocking_response_code: Optional[pulumi.Input[_builtins.int]] = None,
            default_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ip_anonymization: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgwafWorkspace':
        """
        Get an existing NgwafWorkspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NgwafWorkspaceAttackSignalThresholdsArgs', 'NgwafWorkspaceAttackSignalThresholdsArgsDict']] attack_signal_thresholds: Attack threshold parameters for system site alerts. Each threshold value is the number of attack signals per IP address that must be detected during the interval before the related IP address is flagged. If no values are set then the default value for each field will be applied
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_ip_headers: Specifies the request headers containing the client IP address. Maximum of 10 header names.
        :param pulumi.Input[_builtins.int] default_blocking_response_code: The status code returned when a request is blocked. This configuration is applied at the workspace but can be overwritten in rules. Accepted values are [`301`, `302`, `400..599`]. Default value `406`.
        :param pulumi.Input[_builtins.str] default_redirect_url: The redirect URL used if default*blocking*response_code is `301` or `302`.
        :param pulumi.Input[_builtins.str] description: The description of the workspace
        :param pulumi.Input[_builtins.str] ip_anonymization: Agents will anonymize IP addresses according to the option selected. Accepted value is `hashed`.
        :param pulumi.Input[_builtins.str] mode: The operation mode of the workspace. Accepted values are `off`, `block`, and `log`.
        :param pulumi.Input[_builtins.str] name: The display name of the workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgwafWorkspaceState.__new__(_NgwafWorkspaceState)

        __props__.__dict__["attack_signal_thresholds"] = attack_signal_thresholds
        __props__.__dict__["client_ip_headers"] = client_ip_headers
        __props__.__dict__["default_blocking_response_code"] = default_blocking_response_code
        __props__.__dict__["default_redirect_url"] = default_redirect_url
        __props__.__dict__["description"] = description
        __props__.__dict__["ip_anonymization"] = ip_anonymization
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        return NgwafWorkspace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attackSignalThresholds")
    def attack_signal_thresholds(self) -> pulumi.Output['outputs.NgwafWorkspaceAttackSignalThresholds']:
        """
        Attack threshold parameters for system site alerts. Each threshold value is the number of attack signals per IP address that must be detected during the interval before the related IP address is flagged. If no values are set then the default value for each field will be applied
        """
        return pulumi.get(self, "attack_signal_thresholds")

    @_builtins.property
    @pulumi.getter(name="clientIpHeaders")
    def client_ip_headers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the request headers containing the client IP address. Maximum of 10 header names.
        """
        return pulumi.get(self, "client_ip_headers")

    @_builtins.property
    @pulumi.getter(name="defaultBlockingResponseCode")
    def default_blocking_response_code(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The status code returned when a request is blocked. This configuration is applied at the workspace but can be overwritten in rules. Accepted values are [`301`, `302`, `400..599`]. Default value `406`.
        """
        return pulumi.get(self, "default_blocking_response_code")

    @_builtins.property
    @pulumi.getter(name="defaultRedirectUrl")
    def default_redirect_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The redirect URL used if default*blocking*response_code is `301` or `302`.
        """
        return pulumi.get(self, "default_redirect_url")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the workspace
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ipAnonymization")
    def ip_anonymization(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Agents will anonymize IP addresses according to the option selected. Accepted value is `hashed`.
        """
        return pulumi.get(self, "ip_anonymization")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        The operation mode of the workspace. Accepted values are `off`, `block`, and `log`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the workspace.
        """
        return pulumi.get(self, "name")

