# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TlsSubscriptionArgs', 'TlsSubscription']

@pulumi.input_type
class TlsSubscriptionArgs:
    def __init__(__self__, *,
                 certificate_authority: pulumi.Input[_builtins.str],
                 domains: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a TlsSubscription resource.
        :param pulumi.Input[_builtins.str] certificate_authority: The entity that issues and certifies the TLS certificates for your subscription. Valid values are `lets-encrypt`, `globalsign` or `certainly`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domains: List of domains on which to enable TLS.
        :param pulumi.Input[_builtins.str] common_name: The common name associated with the subscription generated by Fastly TLS. If you do not pass a common name on create, we will default to the first TLS domain included. If provided, the domain chosen as the common name must be included in TLS domains.
        :param pulumi.Input[_builtins.str] configuration_id: The ID of the set of TLS configuration options that apply to the enabled domains on this subscription.
        :param pulumi.Input[_builtins.bool] force_destroy: Force delete the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly. Defaults to false.
        :param pulumi.Input[_builtins.bool] force_update: Force update the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly.
        """
        pulumi.set(__self__, "certificate_authority", certificate_authority)
        pulumi.set(__self__, "domains", domains)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Input[_builtins.str]:
        """
        The entity that issues and certifies the TLS certificates for your subscription. Valid values are `lets-encrypt`, `globalsign` or `certainly`.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_authority", value)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of domains on which to enable TLS.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "domains", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The common name associated with the subscription generated by Fastly TLS. If you do not pass a common name on create, we will default to the first TLS domain included. If provided, the domain chosen as the common name must be included in TLS domains.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the set of TLS configuration options that apply to the enabled domains on this subscription.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force delete the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force update the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_update", value)


@pulumi.input_type
class _TlsSubscriptionState:
    def __init__(__self__, *,
                 certificate_authority: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_dns_challenge: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 managed_dns_challenges: Optional[pulumi.Input[Sequence[pulumi.Input['TlsSubscriptionManagedDnsChallengeArgs']]]] = None,
                 managed_http_challenges: Optional[pulumi.Input[Sequence[pulumi.Input['TlsSubscriptionManagedHttpChallengeArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TlsSubscription resources.
        :param pulumi.Input[_builtins.str] certificate_authority: The entity that issues and certifies the TLS certificates for your subscription. Valid values are `lets-encrypt`, `globalsign` or `certainly`.
        :param pulumi.Input[_builtins.str] certificate_id: The certificate ID associated with the subscription.
        :param pulumi.Input[_builtins.str] common_name: The common name associated with the subscription generated by Fastly TLS. If you do not pass a common name on create, we will default to the first TLS domain included. If provided, the domain chosen as the common name must be included in TLS domains.
        :param pulumi.Input[_builtins.str] configuration_id: The ID of the set of TLS configuration options that apply to the enabled domains on this subscription.
        :param pulumi.Input[_builtins.str] created_at: Timestamp (GMT) when the subscription was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domains: List of domains on which to enable TLS.
        :param pulumi.Input[_builtins.bool] force_destroy: Force delete the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly. Defaults to false.
        :param pulumi.Input[_builtins.bool] force_update: Force update the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] managed_dns_challenge: The details required to configure DNS to respond to ACME DNS challenge in order to verify domain ownership.
        :param pulumi.Input[Sequence[pulumi.Input['TlsSubscriptionManagedDnsChallengeArgs']]] managed_dns_challenges: A list of options for configuring DNS to respond to ACME DNS challenge in order to verify domain ownership.
        :param pulumi.Input[Sequence[pulumi.Input['TlsSubscriptionManagedHttpChallengeArgs']]] managed_http_challenges: A list of options for configuring DNS to respond to ACME HTTP challenge in order to verify domain ownership. Best accessed through a `for` expression to filter the relevant record.
        :param pulumi.Input[_builtins.str] state: The current state of the subscription. The list of possible states are: `pending`, `processing`, `issued`, and `renewing`.
        :param pulumi.Input[_builtins.str] updated_at: Timestamp (GMT) when the subscription was updated.
        """
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if managed_dns_challenge is not None:
            warnings.warn("""Use 'managed_dns_challenges' attribute instead""", DeprecationWarning)
            pulumi.log.warn("""managed_dns_challenge is deprecated: Use 'managed_dns_challenges' attribute instead""")
        if managed_dns_challenge is not None:
            pulumi.set(__self__, "managed_dns_challenge", managed_dns_challenge)
        if managed_dns_challenges is not None:
            pulumi.set(__self__, "managed_dns_challenges", managed_dns_challenges)
        if managed_http_challenges is not None:
            pulumi.set(__self__, "managed_http_challenges", managed_http_challenges)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The entity that issues and certifies the TLS certificates for your subscription. Valid values are `lets-encrypt`, `globalsign` or `certainly`.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate ID associated with the subscription.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The common name associated with the subscription generated by Fastly TLS. If you do not pass a common name on create, we will default to the first TLS domain included. If provided, the domain chosen as the common name must be included in TLS domains.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the set of TLS configuration options that apply to the enabled domains on this subscription.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp (GMT) when the subscription was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of domains on which to enable TLS.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "domains", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force delete the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force update the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_update", value)

    @_builtins.property
    @pulumi.getter(name="managedDnsChallenge")
    @_utilities.deprecated("""Use 'managed_dns_challenges' attribute instead""")
    def managed_dns_challenge(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The details required to configure DNS to respond to ACME DNS challenge in order to verify domain ownership.
        """
        return pulumi.get(self, "managed_dns_challenge")

    @managed_dns_challenge.setter
    def managed_dns_challenge(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "managed_dns_challenge", value)

    @_builtins.property
    @pulumi.getter(name="managedDnsChallenges")
    def managed_dns_challenges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TlsSubscriptionManagedDnsChallengeArgs']]]]:
        """
        A list of options for configuring DNS to respond to ACME DNS challenge in order to verify domain ownership.
        """
        return pulumi.get(self, "managed_dns_challenges")

    @managed_dns_challenges.setter
    def managed_dns_challenges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TlsSubscriptionManagedDnsChallengeArgs']]]]):
        pulumi.set(self, "managed_dns_challenges", value)

    @_builtins.property
    @pulumi.getter(name="managedHttpChallenges")
    def managed_http_challenges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TlsSubscriptionManagedHttpChallengeArgs']]]]:
        """
        A list of options for configuring DNS to respond to ACME HTTP challenge in order to verify domain ownership. Best accessed through a `for` expression to filter the relevant record.
        """
        return pulumi.get(self, "managed_http_challenges")

    @managed_http_challenges.setter
    def managed_http_challenges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TlsSubscriptionManagedHttpChallengeArgs']]]]):
        pulumi.set(self, "managed_http_challenges", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the subscription. The list of possible states are: `pending`, `processing`, `issued`, and `renewing`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp (GMT) when the subscription was updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("fastly:index/tlsSubscription:TlsSubscription")
class TlsSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Enables TLS on a domain using a certificate managed by Fastly.

        DNS records need to be modified on the domain being secured, in order to respond to the ACME domain ownership challenge.

        There are two options for doing this: the `managed_dns_challenges`, which is the default method; and the `managed_http_challenges`, which points production traffic to Fastly.

        > See the [Fastly documentation](https://docs.fastly.com/en/guides/serving-https-traffic-using-fastly-managed-certificates#verifying-domain-ownership) for more information on verifying domain ownership.

        The examples below demonstrate usage with AWS Route53 to configure DNS, and the `TlsSubscriptionValidation` resource to wait for validation to complete.

        ## Example Usage

        **Basic usage:**

        The following example demonstrates how to configure two subdomains (e.g. `a.example.com`, `b.example.com`).

        The workflow configures a `TlsSubscription` resource, then a `aws_route53_record` resource for handling the creation of the 'challenge' DNS records (e.g. `_acme-challenge.a.example.com` and `_acme-challenge.b.example.com`).

        We configure the `TlsSubscriptionValidation` resource, which blocks other resources until the challenge DNS records have been validated by Fastly.

        Once the validation has been successful, the configured `get_tls_configuration` data source will filter the available results looking for an appropriate TLS configuration object. If that filtering process is successful, then the subsequent `aws_route53_record` resources (for configuring the subdomains) will be executed using the returned TLS configuration data.

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_fastly as fastly
        import pulumi_std as std

        # NOTE: Creating a hosted zone will automatically create SOA/NS records.
        production = aws.index.Route53Zone("production", name=example.com)
        example = aws.index.Route53domainsRegisteredDomain("example",
            name_server=[{
                name: entry.value,
            } for entry in [{"key": k, "value": v} for k, v in production.name_servers]],
            domain_name=example.com)
        subdomains = [
            "a.example.com",
            "b.example.com",
        ]
        example_service_vcl = fastly.ServiceVcl("example",
            domains=[{
                "name": entry["value"],
            } for entry in [{"key": k, "value": v} for k, v in subdomains]],
            name="example-service",
            backends=[{
                "address": "127.0.0.1",
                "name": "localhost",
            }],
            force_destroy=True)
        example_tls_subscription = fastly.TlsSubscription("example",
            domains=example_service_vcl.domains.apply(lambda domains: [domain.name for domain in domains]),
            certificate_authority="lets-encrypt")
        domain_validation = []
        def create_domain_validation(range_body):
            for range in [{"key": k, "value": v} for [k, v] in enumerate(range_body)]:
                domain_validation.append(aws.index.Route53Record(f"domain_validation-{range['key']}",
                    name=range.value.record_name,
                    type=range.value.record_type,
                    zone_id=production.zone_id,
                    allow_overwrite=True,
                    records=[range.value.record_value],
                    ttl=60,
                    opts = pulumi.ResourceOptions(depends_on=[example_tls_subscription])))

        example_tls_subscription.domains.apply(lambda resolved_outputs: create_domain_validation({domain: example_tls_subscription.managed_dns_challenges.apply(lambda managed_dns_challenges: [obj for obj in managed_dns_challenges if obj.record_name == f"_acme-challenge.{domain}"])[0] for domain in resolved_outputs['domains']}))
        # This is a resource that other resources can depend on if they require the certificate to be issued.
        # NOTE: Internally the resource keeps retrying `GetTLSSubscription` until no error is returned (or the configured timeout is reached).
        example_tls_subscription_validation = fastly.TlsSubscriptionValidation("example", subscription_id=example_tls_subscription.id,
        opts = pulumi.ResourceOptions(depends_on=[domain_validation]))
        # This data source lists all available configuration objects.
        # It uses a `default` attribute to narrow down the list to just one configuration object.
        # If the filtered list has a length that is not exactly one element, you'll see an error returned.
        # The single TLS configuration is then returned and can be referenced by other resources (see aws_route53_record below).
        #
        # IMPORTANT: Not all customers will have a 'default' configuration.
        # If you have issues filtering with `default = true`, then you may need another attribute.
        # Refer to the fastly_tls_configuration documentation for available attributes:
        # https://registry.terraform.io/providers/fastly/fastly/latest/docs/data-sources/tls_configuration#optional
        default_tls = fastly.get_tls_configuration(default=True)
        # Once validation is complete and we've retrieved the TLS configuration data, we can create multiple subdomain records.
        subdomain = []
        for range in [{"value": i} for i in range(0, std.index.toset(input=subdomains).result)]:
            subdomain.append(aws.index.Route53Record(f"subdomain-{range['value']}",
                name=range.value,
                records=[record.record_value for record in default_tls.dns_records if record.record_type == CNAME],
                ttl=300,
                type=CNAME,
                zone_id=production.zone_id))
        ```

        **Configuring an apex and a wildcard domain:**

        The following example is similar to the above but differs by demonstrating how to handle configuring an apex domain (e.g. `example.com`) and a wildcard domain (e.g. `*.example.com`) so you can support multiple subdomains to your service.

        The difference in the workflow is with how to handle the Fastly API returning a single 'challenge' for both domains (e.g. `_acme-challenge.example.com`). This is done by normalising the wildcard (i.e. replacing `*.example.com` with `example.com`) and then working around the issue of the returned object having two identical keys.

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_fastly as fastly
        import pulumi_std as std

        # NOTE: Creating a hosted zone will automatically create SOA/NS records.
        production = aws.index.Route53Zone("production", name=example.com)
        example = aws.index.Route53domainsRegisteredDomain("example",
            name_server=[{
                name: entry.value,
            } for entry in [{"key": k, "value": v} for k, v in production.name_servers]],
            domain_name=example.com)
        domains = [
            "example.com",
            "*.example.com",
        ]
        example_service_vcl = fastly.ServiceVcl("example",
            domains=[{
                "name": entry["value"],
            } for entry in [{"key": k, "value": v} for k, v in domains]],
            name="example-service",
            backends=[{
                "address": "127.0.0.1",
                "name": "localhost",
            }],
            force_destroy=True)
        example_tls_subscription = fastly.TlsSubscription("example",
            domains=example_service_vcl.domains.apply(lambda domains: [domain.name for domain in domains]),
            certificate_authority="lets-encrypt")
        domain_validation = []
        def create_domain_validation(range_body):
            for range in [{"key": k, "value": v} for [k, v] in enumerate(range_body)]:
                domain_validation.append(aws.index.Route53Record(f"domain_validation-{range['key']}",
                    name=range.value[0].record_name,
                    type=range.value[0].record_type,
                    zone_id=production.zone_id,
                    allow_overwrite=True,
                    records=[range.value[0].record_value],
                    ttl=60,
                    opts = pulumi.ResourceOptions(depends_on=[example_tls_subscription])))

        example_tls_subscription.domains.apply(lambda resolved_outputs: create_domain_validation({std.index.replace(text=domain,
            search="*.",
            replace="")["result"]: example_tls_subscription.managed_dns_challenges.apply(lambda managed_dns_challenges: [obj for obj in managed_dns_challenges if obj.record_name == f"_acme-challenge.{std.index.replace(text=domain,
            search='*.',
            replace='')['result']}"])[0] for domain in resolved_outputs['domains']}))
        # This is a resource that other resources can depend on if they require the certificate to be issued.
        # NOTE: Internally the resource keeps retrying `GetTLSSubscription` until no error is returned (or the configured timeout is reached).
        example_tls_subscription_validation = fastly.TlsSubscriptionValidation("example", subscription_id=example_tls_subscription.id,
        opts = pulumi.ResourceOptions(depends_on=[domain_validation]))
        # This data source lists all available configuration objects.
        # It uses a `default` attribute to narrow down the list to just one configuration object.
        # If the filtered list has a length that is not exactly one element, you'll see an error returned.
        # The single TLS configuration is then returned and can be referenced by other resources (see aws_route53_record below).
        #
        # IMPORTANT: Not all customers will have a 'default' configuration.
        # If you have issues filtering with `default = true`, then you may need another attribute.
        # Refer to the fastly_tls_configuration documentation for available attributes:
        # https://registry.terraform.io/providers/fastly/fastly/latest/docs/data-sources/tls_configuration#optional
        default_tls = fastly.get_tls_configuration(default=True)
        # Once validation is complete and we've retrieved the TLS configuration data, we can create multiple records...
        apex = aws.index.Route53Record("apex",
            name=example.com,
            records=[record.record_value for record in default_tls.dns_records if record.record_type == A],
            ttl=300,
            type=A,
            zone_id=production.zone_id)
        # NOTE: This subdomain matches our Fastly service because of the wildcard domain (`*.example.com`) that was added to the service.
        subdomain = aws.index.Route53Record("subdomain",
            name=test.example.com,
            records=[record.record_value for record in default_tls.dns_records if record.record_type == CNAME],
            ttl=300,
            type=CNAME,
            zone_id=production.zone_id)
        ```

        ## Import

        A subscription can be imported using its Fastly subscription ID, e.g.

        ```sh
        $ pulumi import fastly:index/tlsSubscription:TlsSubscription demo xxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_authority: The entity that issues and certifies the TLS certificates for your subscription. Valid values are `lets-encrypt`, `globalsign` or `certainly`.
        :param pulumi.Input[_builtins.str] common_name: The common name associated with the subscription generated by Fastly TLS. If you do not pass a common name on create, we will default to the first TLS domain included. If provided, the domain chosen as the common name must be included in TLS domains.
        :param pulumi.Input[_builtins.str] configuration_id: The ID of the set of TLS configuration options that apply to the enabled domains on this subscription.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domains: List of domains on which to enable TLS.
        :param pulumi.Input[_builtins.bool] force_destroy: Force delete the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly. Defaults to false.
        :param pulumi.Input[_builtins.bool] force_update: Force update the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TlsSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Enables TLS on a domain using a certificate managed by Fastly.

        DNS records need to be modified on the domain being secured, in order to respond to the ACME domain ownership challenge.

        There are two options for doing this: the `managed_dns_challenges`, which is the default method; and the `managed_http_challenges`, which points production traffic to Fastly.

        > See the [Fastly documentation](https://docs.fastly.com/en/guides/serving-https-traffic-using-fastly-managed-certificates#verifying-domain-ownership) for more information on verifying domain ownership.

        The examples below demonstrate usage with AWS Route53 to configure DNS, and the `TlsSubscriptionValidation` resource to wait for validation to complete.

        ## Example Usage

        **Basic usage:**

        The following example demonstrates how to configure two subdomains (e.g. `a.example.com`, `b.example.com`).

        The workflow configures a `TlsSubscription` resource, then a `aws_route53_record` resource for handling the creation of the 'challenge' DNS records (e.g. `_acme-challenge.a.example.com` and `_acme-challenge.b.example.com`).

        We configure the `TlsSubscriptionValidation` resource, which blocks other resources until the challenge DNS records have been validated by Fastly.

        Once the validation has been successful, the configured `get_tls_configuration` data source will filter the available results looking for an appropriate TLS configuration object. If that filtering process is successful, then the subsequent `aws_route53_record` resources (for configuring the subdomains) will be executed using the returned TLS configuration data.

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_fastly as fastly
        import pulumi_std as std

        # NOTE: Creating a hosted zone will automatically create SOA/NS records.
        production = aws.index.Route53Zone("production", name=example.com)
        example = aws.index.Route53domainsRegisteredDomain("example",
            name_server=[{
                name: entry.value,
            } for entry in [{"key": k, "value": v} for k, v in production.name_servers]],
            domain_name=example.com)
        subdomains = [
            "a.example.com",
            "b.example.com",
        ]
        example_service_vcl = fastly.ServiceVcl("example",
            domains=[{
                "name": entry["value"],
            } for entry in [{"key": k, "value": v} for k, v in subdomains]],
            name="example-service",
            backends=[{
                "address": "127.0.0.1",
                "name": "localhost",
            }],
            force_destroy=True)
        example_tls_subscription = fastly.TlsSubscription("example",
            domains=example_service_vcl.domains.apply(lambda domains: [domain.name for domain in domains]),
            certificate_authority="lets-encrypt")
        domain_validation = []
        def create_domain_validation(range_body):
            for range in [{"key": k, "value": v} for [k, v] in enumerate(range_body)]:
                domain_validation.append(aws.index.Route53Record(f"domain_validation-{range['key']}",
                    name=range.value.record_name,
                    type=range.value.record_type,
                    zone_id=production.zone_id,
                    allow_overwrite=True,
                    records=[range.value.record_value],
                    ttl=60,
                    opts = pulumi.ResourceOptions(depends_on=[example_tls_subscription])))

        example_tls_subscription.domains.apply(lambda resolved_outputs: create_domain_validation({domain: example_tls_subscription.managed_dns_challenges.apply(lambda managed_dns_challenges: [obj for obj in managed_dns_challenges if obj.record_name == f"_acme-challenge.{domain}"])[0] for domain in resolved_outputs['domains']}))
        # This is a resource that other resources can depend on if they require the certificate to be issued.
        # NOTE: Internally the resource keeps retrying `GetTLSSubscription` until no error is returned (or the configured timeout is reached).
        example_tls_subscription_validation = fastly.TlsSubscriptionValidation("example", subscription_id=example_tls_subscription.id,
        opts = pulumi.ResourceOptions(depends_on=[domain_validation]))
        # This data source lists all available configuration objects.
        # It uses a `default` attribute to narrow down the list to just one configuration object.
        # If the filtered list has a length that is not exactly one element, you'll see an error returned.
        # The single TLS configuration is then returned and can be referenced by other resources (see aws_route53_record below).
        #
        # IMPORTANT: Not all customers will have a 'default' configuration.
        # If you have issues filtering with `default = true`, then you may need another attribute.
        # Refer to the fastly_tls_configuration documentation for available attributes:
        # https://registry.terraform.io/providers/fastly/fastly/latest/docs/data-sources/tls_configuration#optional
        default_tls = fastly.get_tls_configuration(default=True)
        # Once validation is complete and we've retrieved the TLS configuration data, we can create multiple subdomain records.
        subdomain = []
        for range in [{"value": i} for i in range(0, std.index.toset(input=subdomains).result)]:
            subdomain.append(aws.index.Route53Record(f"subdomain-{range['value']}",
                name=range.value,
                records=[record.record_value for record in default_tls.dns_records if record.record_type == CNAME],
                ttl=300,
                type=CNAME,
                zone_id=production.zone_id))
        ```

        **Configuring an apex and a wildcard domain:**

        The following example is similar to the above but differs by demonstrating how to handle configuring an apex domain (e.g. `example.com`) and a wildcard domain (e.g. `*.example.com`) so you can support multiple subdomains to your service.

        The difference in the workflow is with how to handle the Fastly API returning a single 'challenge' for both domains (e.g. `_acme-challenge.example.com`). This is done by normalising the wildcard (i.e. replacing `*.example.com` with `example.com`) and then working around the issue of the returned object having two identical keys.

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_fastly as fastly
        import pulumi_std as std

        # NOTE: Creating a hosted zone will automatically create SOA/NS records.
        production = aws.index.Route53Zone("production", name=example.com)
        example = aws.index.Route53domainsRegisteredDomain("example",
            name_server=[{
                name: entry.value,
            } for entry in [{"key": k, "value": v} for k, v in production.name_servers]],
            domain_name=example.com)
        domains = [
            "example.com",
            "*.example.com",
        ]
        example_service_vcl = fastly.ServiceVcl("example",
            domains=[{
                "name": entry["value"],
            } for entry in [{"key": k, "value": v} for k, v in domains]],
            name="example-service",
            backends=[{
                "address": "127.0.0.1",
                "name": "localhost",
            }],
            force_destroy=True)
        example_tls_subscription = fastly.TlsSubscription("example",
            domains=example_service_vcl.domains.apply(lambda domains: [domain.name for domain in domains]),
            certificate_authority="lets-encrypt")
        domain_validation = []
        def create_domain_validation(range_body):
            for range in [{"key": k, "value": v} for [k, v] in enumerate(range_body)]:
                domain_validation.append(aws.index.Route53Record(f"domain_validation-{range['key']}",
                    name=range.value[0].record_name,
                    type=range.value[0].record_type,
                    zone_id=production.zone_id,
                    allow_overwrite=True,
                    records=[range.value[0].record_value],
                    ttl=60,
                    opts = pulumi.ResourceOptions(depends_on=[example_tls_subscription])))

        example_tls_subscription.domains.apply(lambda resolved_outputs: create_domain_validation({std.index.replace(text=domain,
            search="*.",
            replace="")["result"]: example_tls_subscription.managed_dns_challenges.apply(lambda managed_dns_challenges: [obj for obj in managed_dns_challenges if obj.record_name == f"_acme-challenge.{std.index.replace(text=domain,
            search='*.',
            replace='')['result']}"])[0] for domain in resolved_outputs['domains']}))
        # This is a resource that other resources can depend on if they require the certificate to be issued.
        # NOTE: Internally the resource keeps retrying `GetTLSSubscription` until no error is returned (or the configured timeout is reached).
        example_tls_subscription_validation = fastly.TlsSubscriptionValidation("example", subscription_id=example_tls_subscription.id,
        opts = pulumi.ResourceOptions(depends_on=[domain_validation]))
        # This data source lists all available configuration objects.
        # It uses a `default` attribute to narrow down the list to just one configuration object.
        # If the filtered list has a length that is not exactly one element, you'll see an error returned.
        # The single TLS configuration is then returned and can be referenced by other resources (see aws_route53_record below).
        #
        # IMPORTANT: Not all customers will have a 'default' configuration.
        # If you have issues filtering with `default = true`, then you may need another attribute.
        # Refer to the fastly_tls_configuration documentation for available attributes:
        # https://registry.terraform.io/providers/fastly/fastly/latest/docs/data-sources/tls_configuration#optional
        default_tls = fastly.get_tls_configuration(default=True)
        # Once validation is complete and we've retrieved the TLS configuration data, we can create multiple records...
        apex = aws.index.Route53Record("apex",
            name=example.com,
            records=[record.record_value for record in default_tls.dns_records if record.record_type == A],
            ttl=300,
            type=A,
            zone_id=production.zone_id)
        # NOTE: This subdomain matches our Fastly service because of the wildcard domain (`*.example.com`) that was added to the service.
        subdomain = aws.index.Route53Record("subdomain",
            name=test.example.com,
            records=[record.record_value for record in default_tls.dns_records if record.record_type == CNAME],
            ttl=300,
            type=CNAME,
            zone_id=production.zone_id)
        ```

        ## Import

        A subscription can be imported using its Fastly subscription ID, e.g.

        ```sh
        $ pulumi import fastly:index/tlsSubscription:TlsSubscription demo xxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param TlsSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TlsSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TlsSubscriptionArgs.__new__(TlsSubscriptionArgs)

            if certificate_authority is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_authority'")
            __props__.__dict__["certificate_authority"] = certificate_authority
            __props__.__dict__["common_name"] = common_name
            __props__.__dict__["configuration_id"] = configuration_id
            if domains is None and not opts.urn:
                raise TypeError("Missing required property 'domains'")
            __props__.__dict__["domains"] = domains
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["force_update"] = force_update
            __props__.__dict__["certificate_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["managed_dns_challenge"] = None
            __props__.__dict__["managed_dns_challenges"] = None
            __props__.__dict__["managed_http_challenges"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["updated_at"] = None
        super(TlsSubscription, __self__).__init__(
            'fastly:index/tlsSubscription:TlsSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_authority: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            common_name: Optional[pulumi.Input[_builtins.str]] = None,
            configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            force_update: Optional[pulumi.Input[_builtins.bool]] = None,
            managed_dns_challenge: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            managed_dns_challenges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TlsSubscriptionManagedDnsChallengeArgs', 'TlsSubscriptionManagedDnsChallengeArgsDict']]]]] = None,
            managed_http_challenges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TlsSubscriptionManagedHttpChallengeArgs', 'TlsSubscriptionManagedHttpChallengeArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'TlsSubscription':
        """
        Get an existing TlsSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_authority: The entity that issues and certifies the TLS certificates for your subscription. Valid values are `lets-encrypt`, `globalsign` or `certainly`.
        :param pulumi.Input[_builtins.str] certificate_id: The certificate ID associated with the subscription.
        :param pulumi.Input[_builtins.str] common_name: The common name associated with the subscription generated by Fastly TLS. If you do not pass a common name on create, we will default to the first TLS domain included. If provided, the domain chosen as the common name must be included in TLS domains.
        :param pulumi.Input[_builtins.str] configuration_id: The ID of the set of TLS configuration options that apply to the enabled domains on this subscription.
        :param pulumi.Input[_builtins.str] created_at: Timestamp (GMT) when the subscription was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domains: List of domains on which to enable TLS.
        :param pulumi.Input[_builtins.bool] force_destroy: Force delete the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly. Defaults to false.
        :param pulumi.Input[_builtins.bool] force_update: Force update the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] managed_dns_challenge: The details required to configure DNS to respond to ACME DNS challenge in order to verify domain ownership.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TlsSubscriptionManagedDnsChallengeArgs', 'TlsSubscriptionManagedDnsChallengeArgsDict']]]] managed_dns_challenges: A list of options for configuring DNS to respond to ACME DNS challenge in order to verify domain ownership.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TlsSubscriptionManagedHttpChallengeArgs', 'TlsSubscriptionManagedHttpChallengeArgsDict']]]] managed_http_challenges: A list of options for configuring DNS to respond to ACME HTTP challenge in order to verify domain ownership. Best accessed through a `for` expression to filter the relevant record.
        :param pulumi.Input[_builtins.str] state: The current state of the subscription. The list of possible states are: `pending`, `processing`, `issued`, and `renewing`.
        :param pulumi.Input[_builtins.str] updated_at: Timestamp (GMT) when the subscription was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TlsSubscriptionState.__new__(_TlsSubscriptionState)

        __props__.__dict__["certificate_authority"] = certificate_authority
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["configuration_id"] = configuration_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["domains"] = domains
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["force_update"] = force_update
        __props__.__dict__["managed_dns_challenge"] = managed_dns_challenge
        __props__.__dict__["managed_dns_challenges"] = managed_dns_challenges
        __props__.__dict__["managed_http_challenges"] = managed_http_challenges
        __props__.__dict__["state"] = state
        __props__.__dict__["updated_at"] = updated_at
        return TlsSubscription(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Output[_builtins.str]:
        """
        The entity that issues and certifies the TLS certificates for your subscription. Valid values are `lets-encrypt`, `globalsign` or `certainly`.
        """
        return pulumi.get(self, "certificate_authority")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate ID associated with the subscription.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[_builtins.str]:
        """
        The common name associated with the subscription generated by Fastly TLS. If you do not pass a common name on create, we will default to the first TLS domain included. If provided, the domain chosen as the common name must be included in TLS domains.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the set of TLS configuration options that apply to the enabled domains on this subscription.
        """
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp (GMT) when the subscription was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def domains(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of domains on which to enable TLS.
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Force delete the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Force update the subscription even if it has active domains. Warning: this can disable production traffic if used incorrectly.
        """
        return pulumi.get(self, "force_update")

    @_builtins.property
    @pulumi.getter(name="managedDnsChallenge")
    @_utilities.deprecated("""Use 'managed_dns_challenges' attribute instead""")
    def managed_dns_challenge(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The details required to configure DNS to respond to ACME DNS challenge in order to verify domain ownership.
        """
        return pulumi.get(self, "managed_dns_challenge")

    @_builtins.property
    @pulumi.getter(name="managedDnsChallenges")
    def managed_dns_challenges(self) -> pulumi.Output[Sequence['outputs.TlsSubscriptionManagedDnsChallenge']]:
        """
        A list of options for configuring DNS to respond to ACME DNS challenge in order to verify domain ownership.
        """
        return pulumi.get(self, "managed_dns_challenges")

    @_builtins.property
    @pulumi.getter(name="managedHttpChallenges")
    def managed_http_challenges(self) -> pulumi.Output[Sequence['outputs.TlsSubscriptionManagedHttpChallenge']]:
        """
        A list of options for configuring DNS to respond to ACME HTTP challenge in order to verify domain ownership. Best accessed through a `for` expression to filter the relevant record.
        """
        return pulumi.get(self, "managed_http_challenges")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the subscription. The list of possible states are: `pending`, `processing`, `issued`, and `renewing`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp (GMT) when the subscription was updated.
        """
        return pulumi.get(self, "updated_at")

