# CHANGELOG

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

### Added
- Session ID tracking in OTEL traces: The `veris.session_id` attribute is now automatically added to all spans when a session ID is present
  - Session IDs from FastAPI MCP bearer tokens are automatically embedded in traces
  - Manual session management via `veris.set_session_id()` and `veris.clear_session_id()` 
  - Enables filtering and correlation of traces by user session in Jaeger
- New test suite for session ID tracing functionality

### Changed
- `AgentsOTELBridgeProcessor` now imports and uses `_session_id_context` from `tool_mock`
- Trace and span creation now includes session ID attributes when available


## v0.2.1 (2025-04-18)

### Bug Fixes

- Fixes to type conversion for outputs
  ([`b8e8e3b`](https://github.com/veris-ai/veris-python-sdk/commit/b8e8e3bbd606654ae3c342f07f7d27c8c9fefa6d))

- Update some comment for testing
  ([`bf204e7`](https://github.com/veris-ai/veris-python-sdk/commit/bf204e711c6c54da613d2f59a64f8d90e2ba7659))

### Continuous Integration

- Separate release and publish workflows
  ([`0a2ea8b`](https://github.com/veris-ai/veris-python-sdk/commit/0a2ea8bbb393fda6ef60161ff290f37df0a2faa5))

- Update ci and warnings for semantic-release
  ([`fcbe2cc`](https://github.com/veris-ai/veris-python-sdk/commit/fcbe2cccd22821cf5760126abb6174aa1f63082f))


## v0.2.0 (2025-04-18)

### Chores

- Update changelog for 0.1.1
  ([`24d7139`](https://github.com/veris-ai/veris-python-sdk/commit/24d713943737abcea6394258e5129ae0a55cb869))

- Update semantic release config
  ([`6f745e0`](https://github.com/veris-ai/veris-python-sdk/commit/6f745e09263703cfe034ba688b96e4da50759889))

### Continuous Integration

- Add workflows for release ([#3](https://github.com/veris-ai/veris-python-sdk/pull/3),
  [`3c160e7`](https://github.com/veris-ai/veris-python-sdk/commit/3c160e7e928ed1efb42825b767084df5d451edb5))

- Fix publish ci workflow ([#4](https://github.com/veris-ai/veris-python-sdk/pull/4),
  [`47f23e1`](https://github.com/veris-ai/veris-python-sdk/commit/47f23e19cd04b60ab0ae087b6d70b4748350393c))

### Features

- Remove dependencies and use linter ([#2](https://github.com/veris-ai/veris-python-sdk/pull/2),
  [`4b8c43b`](https://github.com/veris-ai/veris-python-sdk/commit/4b8c43b551265ff9c994f53d29a7ef185b7e3286))


## v0.1.1 (2025-04-17)

### Features

- Updates to package for publishing ([#1](https://github.com/veris-ai/veris-python-sdk/pull/1),
  [`c6f460e`](https://github.com/veris-ai/veris-python-sdk/commit/c6f460ea6e2f8472c120370a14f67f1d8c28626c))
