"""Jaeger interface for searching and retrieving traces.

This sub-package provides a thin synchronous wrapper around the Jaeger
Query Service HTTP API.

Typical usage example::

    from veris_ai.jaeger_interface import JaegerClient, SearchQuery

    client = JaegerClient("http://localhost:16686")

    traces = client.search(
        SearchQuery(service="veris-agent", limit=20)
    )

    trace = client.get_trace(traces.data[0].traceID)

The implementation uses *requests* under the hood and all public functions
are fully typed using *pydantic* models so that IDEs can provide proper
autocomplete and type checking.
"""

from .client import JaegerClient
from .models import SearchQuery

__all__ = ["JaegerClient", "SearchQuery"]
