# pote


<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

``` sh
pip install pote
```

A collection of battle-tested (well, by me in my projects) Python
utilities extracted from real projects. These are practical helpers that
solve common problems across data manipulation, callbacks,
configuration, display, and widgets.

## What is pote?

`pote` provides utilities that don’t justify their own library but are
too useful to keep copying between projects. Each module is focused,
well-tested, and designed for immediate use.

## Modules

### Core Utilities

- **[basic](basic.html)** - Fundamental Python utilities: nested data
  access ([`val_at`](https://civvic.github.io/pote/basic.html#val_at),
  [`vals_at`](https://civvic.github.io/pote/basic.html#vals_at)), dict
  helpers, string utilities, type checking, and more
- **[test](test.html)** - Testing helpers beyond fastcore:
  [`test_raises`](https://civvic.github.io/pote/test.html#test_raises),
  [`test_afail`](https://civvic.github.io/pote/test.html#test_afail),
  [`test_is_not`](https://civvic.github.io/pote/test.html#test_is_not)
- **[project](project.html)** - Project setup utilities: global console
  configuration with Rich theme support

### Advanced Features

- **[callback](callback.html)** - Callback system for augmenting objects
  with side-effects, plus
  [`CollBack`](https://civvic.github.io/pote/callback.html#collback) for
  tracking iteration with callbacks
- **[config](config.html)** - Simple namespace for configuration with
  context manager for temporary changes
- **[display](display.html)** - Jupyter display enhancements: Rich
  integration, collapsible JSON rendering, CSS generation
- **[widgets](widgets.html)** - ipywidgets utilities: widget cleanup,
  async support, blocking input helpers

## Quick Start

``` python
from pote.basic import val_at, AD, shorten
from pote.callback import CollBack

# Access nested data with dot notation
data = {'user': {'name': 'Alice', 'scores': [10, 20, 30]}}
val_at(data, 'user.scores.1')  # 20

# Dict with attribute access
config = AD(debug=True, timeout=30)
config.debug  # True

# Track iteration with callbacks
for item in CollBack(range(100)):
    process(item)
    # Progress tracked automatically
```

## Installation

``` sh
pip install pote
```

## Development

These utilities are developed with notebooks using
[nbdev](https://nbdev.fast.ai/). Browse the
[notebooks](https://github.com/yourusername/pote/tree/main/nbs) to see
implementation and examples.

## Philosophy

- **Copy-friendly**: See something useful? Copy it with my blessing
- **Battle-tested**: Extracted from production projects
- **Documented through tests**: Examples serve as both tests and
  documentation
- **Minimal dependencies**: Builds on fastcore, ipywidgets, and Rich
  where appropriate
