"""Global console configuration for consistent output across projects"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_project.ipynb.

# %% ../nbs/00_project.ipynb 1
from __future__ import annotations

# %% auto 0
__all__ = ['get_console', 'setup_console']

# %% ../nbs/00_project.ipynb
import pathlib
from typing import Callable

import fastcore.all as FC
from rich.console import Console


# %% ../nbs/00_project.ipynb
# _console = Console(width=107, tab_size= 4, theme=dark_theme, force_jupyter=True if FC.IN_NOTEBOOK else None)
_CONSOLE: Console = None  # type: ignore

def get_theme(theme:str | object | None):
    if isinstance(theme, str):
        try:
            from rich_theme_manager import ThemeManager  # type: ignore
            theme_dir = pathlib.Path("~/.rich_theme_manager/themes").expanduser()
            theme_manager = ThemeManager(theme_dir=theme_dir.absolute().as_posix())
            try: theme = theme_manager.get(theme)
            except ValueError: theme = None
        except ImportError:
            theme = None
    # return theme or Theme('default', styles={"repr.tag_contents": "white"})
    return theme


# %% ../nbs/00_project.ipynb
def get_console() -> Console:
    "Globally configured console"
    global _CONSOLE
    return _CONSOLE

def setup_console(
        width: int = 140,
        theme: str | object | None = None,
        clear=False,
        rule=None
) -> tuple[Console, Callable[..., None]]:
    global _CONSOLE
    theme = get_theme(theme)
    params = dict(width=width, tab_size=4, theme=theme, force_jupyter=True if FC.IN_IPYTHON else None)
    _CONSOLE = Console(**params)  # type: ignore
    if clear: _CONSOLE.clear()
    if rule:_CONSOLE.rule(rule)
    return _CONSOLE, _CONSOLE.print

setup_console();
