"""Additional test utilities complementing `fastcore.test`"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/05_test.ipynb.

# %% ../nbs/05_test.ipynb 1
from __future__ import annotations

# %% auto 0
__all__ = ['test_raises', 'test_afail', 'test_is_not']

# %% ../nbs/05_test.ipynb
import operator
from contextlib import contextmanager
from typing import Type


# %% ../nbs/05_test.ipynb
@contextmanager
def test_raises(expected: Type[Exception], contains:str|None=None):
    ex = None
    try:
        yield 1
    except Exception as e:
        ex = e
    finally:
        if type(ex) != expected:
            assert 0, f"Expected exception `{expected.__name__}` not raised, got `{type(ex).__name__}`"
        if contains is not None:
            assert contains in str(ex), f'Exception does not contain "{contains}"'

# %% ../nbs/05_test.ipynb
async def test_afail(f, msg='', contains='', args=None, kwargs=None):
    args, kwargs = args or [], kwargs or {}
    "Fails with `msg` unless `f()` raises an exception and (optionally) has `contains` in `e.args`"
    try:
        await f(*args, **kwargs)
    except Exception as e:
        assert not contains or contains in str(e)
        return
    assert False, f"Expected exception but none raised. {msg}"

# %% ../nbs/05_test.ipynb
def test_is_not(a,b):
    "`test` that `a is not b`"
    assert operator.is_not(a,b), f"is not:\n{a}\n{b}"
