# Generated by Django 2.2.20 on 2021-04-12 02:41

from django.db import migrations
from django.db.models import F


def copy_course_id_values_to_course_key(apps, schema_editor):
    """
    Copy values of `course_id` column in `CourseSkills` table to `course_key`.
    """
    CourseSkills = apps.get_model('taxonomy', 'CourseSkills')
    CourseSkills.objects.all().update(course_key=F('course_id'))


class Migration(migrations.Migration):

    dependencies = [
        ('taxonomy', '0010_auto_20210409_0256'),
    ]

    operations = [
        migrations.RunPython(copy_course_id_values_to_course_key)
    ]
