# Generated by Django 3.2.8 on 2022-01-31 11:55

import django.utils.timezone
from django.db import migrations, models

import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('taxonomy', '0015_auto_20211022_1138'),
    ]

    operations = [
        migrations.CreateModel(
            name='Translation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('source_model_name', models.CharField(help_text='The name of the model to which the source belongs e:g Course.', max_length=255)),
                ('source_model_field', models.CharField(help_text='The name of the source field to be translated e:g course description.', max_length=255)),
                ('source_record_identifier', models.CharField(help_text='The identifier of the source record e:g course key.', max_length=255)),
                ('source_text', models.TextField(blank=True, help_text='The source text to be translated.', null=True)),
                ('source_language', models.CharField(blank=True, help_text='The original language of the source text before translation e:g Spanish.', max_length=8, null=True)),
                ('translated_text', models.TextField(blank=True, help_text='The translated source text.', null=True)),
                ('translated_text_language', models.CharField(blank=True, help_text='The language of the source text to which it is translated e:g English.', max_length=8, null=True)),
            ],
            options={
                'ordering': ('created',),
                'unique_together': {('source_record_identifier', 'source_model_name', 'source_model_field')},
            },
        ),
    ]
