# Generated by Django 3.2.12 on 2022-08-12 11:50

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('taxonomy', '0020_programskill'),
    ]

    operations = [
        migrations.DeleteModel(
            name='ProgramSkill',
        ),
        migrations.CreateModel(
            name='ProgramSkill',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('program_uuid', models.UUIDField(default=uuid.uuid4, editable=False, help_text='The uuid of the program whose title would be used for skill(s) extraction.', serialize=False)),
                ('confidence', models.FloatField(help_text='The extraction confidence threshold used for the skills extraction.')),
                ('is_blacklisted', models.BooleanField(default=False, help_text='Blacklist this program skill, useful to handle false positives.')),
                ('skill', models.ForeignKey(help_text='The ID of the skill extracted for the program.', on_delete=django.db.models.deletion.CASCADE, to='taxonomy.skill')),
            ],
            options={
                'verbose_name': 'Program Skill',
                'verbose_name_plural': 'Program Skills',
                'ordering': ('created',),
                'unique_together': {('program_uuid', 'skill')},
            },
        ),
    ]
