# Generated by Django 3.2.15 on 2022-08-25 02:06

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('taxonomy', '0021_recreate_programskill'),
    ]

    operations = [
        migrations.AlterField(
            model_name='programskill',
            name='program_uuid',
            field=models.UUIDField(default=uuid.uuid4, editable=False, help_text='The uuid of the program whose title would be used for skill(s) extraction.'),
        ),
        migrations.CreateModel(
            name='SkillsQuiz',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('username', models.CharField(max_length=150, verbose_name='username')),
                ('goal', models.CharField(choices=[('change_careers', 'I want to change careers'), ('get_promoted', 'I want to get promoted'), ('improve_current_role', 'I want to improve at my current role'), ('other', 'Other')], max_length=64)),
                ('current_job', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='current_job_skills_quiz', to='taxonomy.job')),
                ('future_jobs', models.ManyToManyField(blank=True, related_name='future_jobs_skills_quiz', to='taxonomy.Job')),
                ('skills', models.ManyToManyField(to='taxonomy.Skill')),
            ],
            options={
                'verbose_name': 'Skill Quiz',
                'verbose_name_plural': 'Skill Quizzes',
                'ordering': ('id',),
            },
        ),
    ]
