# Generated by Django 3.2.15 on 2022-10-17 06:41

from django.db import migrations, models
from taxonomy.constants import NAICS2_CODES


def add_industry_data(apps, schema_editor):
    """
    Add industry data from NAICS2 codes added in the constants.
    """
    Industry = apps.get_model('taxonomy', 'Industry')
    Industry.objects.bulk_create(
        [Industry(code=code, name=industry_name) for code, industry_name in NAICS2_CODES.items()]
    )


def do_nothing(apps, schema_editor):
    """
    Do nothing.
    """


class Migration(migrations.Migration):

    dependencies = [
        ('taxonomy', '0024_alter_refreshprogramskillsconfig_options'),
    ]

    operations = [
        migrations.CreateModel(
            name='Industry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, verbose_name='Industry Name')),
                ('code', models.IntegerField()),
            ],
            options={
                'verbose_name': 'Industry',
                'verbose_name_plural': 'Industries',
                'ordering': ('id',),
            },
        ),
        migrations.RunPython(add_industry_data, do_nothing)
    ]
