# Generated by Django 3.2.16 on 2022-11-17 07:46

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('taxonomy', '0026_auto_20221101_0936'),
    ]

    operations = [
        migrations.AlterUniqueTogether(
            name='jobskills',
            unique_together={('job', 'skill')},
        ),
        migrations.RemoveField(
            model_name='jobskills',
            name='industry',
        ),
        migrations.CreateModel(
            name='IndustryJobSkill',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('significance', models.FloatField(help_text='The significance of skill for the job.')),
                ('unique_postings', models.FloatField(help_text='The unique_postings threshold of skill for the job.')),
                ('industry', models.ForeignKey(help_text='Industry associated with the job-skill.', on_delete=django.db.models.deletion.CASCADE, to='taxonomy.industry')),
                ('job', models.ForeignKey(help_text='Job associated with the job-skill.', on_delete=django.db.models.deletion.CASCADE, to='taxonomy.job')),
                ('skill', models.ForeignKey(help_text='Skill associated with the job-skill.', on_delete=django.db.models.deletion.CASCADE, to='taxonomy.skill')),
            ],
            options={
                'verbose_name': 'Industry Job Skill',
                'verbose_name_plural': 'Industry Job Skills',
                'ordering': ('created',),
                'unique_together': {('industry', 'job', 'skill')},
            },
        ),
    ]
