# Generated by Django 3.2.16 on 2022-11-28 01:41

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('taxonomy', '0027_auto_20221117_0746'),
    ]

    operations = [
        migrations.CreateModel(
            name='XBlockSkillData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('verified_count', models.IntegerField(blank=True, default=0, help_text='Number of times learners verified this skill', null=True)),
                ('ignored_count', models.IntegerField(blank=True, default=0, help_text='Number of times learners ignored giving feedback for this skill', null=True)),
                ('verified', models.BooleanField(default=False, help_text='Indicates that this skill has been finalized for this block')),
                ('confidence', models.FloatField(help_text='The extraction confidence threshold used for the skills extraction.')),
                ('is_blacklisted', models.BooleanField(default=False, help_text='Blacklist this xblock skill, useful to handle false positives.')),
                ('skill', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='taxonomy.skill')),
            ],
            options={
                'verbose_name': 'Xblock Skill data',
                'verbose_name_plural': 'Xblock Skill data',
                'ordering': ('created',),
            },
        ),
        migrations.CreateModel(
            name='XBlockSkills',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('usage_key', models.CharField(help_text='The key of the xblock whose text was used for skills extraction.', max_length=255, unique=True)),
                ('requires_verification', models.BooleanField(default=True, help_text='Indicates whether skills applied to this block requires verification from users')),
                ('auto_processed', models.BooleanField(default=False, help_text='Indicates whether the text from this block was already processed')),
                ('hash_content', models.CharField(blank=True, help_text='Hashed text content useful for checking if content has changed', max_length=255, null=True)),
                ('skills', models.ManyToManyField(help_text='The ID of the skill extracted for the xblock.', through='taxonomy.XBlockSkillData', to='taxonomy.Skill')),
            ],
            options={
                'verbose_name': 'XBlock Skills',
                'verbose_name_plural': 'XBlock Skills',
                'ordering': ('created',),
            },
        ),
        migrations.AddField(
            model_name='xblockskilldata',
            name='xblock',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='taxonomy.xblockskills'),
        ),
        migrations.AlterUniqueTogether(
            name='xblockskilldata',
            unique_together={('xblock', 'skill')},
        ),
    ]
