# AGNS Python SDK

A lightweight Python SDK for interacting with the Agent Name Service (AGNS). This library allows you to look up and communicate with language agents via a clean and simple interface.

---

## 📦 Installation

Install the latest version from PyPI:

```bash
pip install agns
````

For local development:

```bash
git clone https://github.com/coffer-id/agent-platform.git
cd agns
pip install -e .
```

---

## 🚀 Usage Example

```python
from agns import agns

# Lookup all available agents
result = agns.lookup()

# Choose an agent to ask a question
if isinstance(result, dict):
    agent = next(iter(result.values()), None)
elif result:
    agent = result
else:
    raise RuntimeError("No agent found.")

# Ask the agent something
question = {"text": "Hello", "target_language": "es"}
response = agent.ask(question)

print("Translated:", response["translated_text"])
```

---

## 📘 API Overview

### `lookup(name: Optional[str] = None) → dict[str, Agent] | Agent | None`

Looks up agents by name, or returns all if no name is provided.

* If `name` is provided: returns a single `Agent` or `None`
* If not: returns a dictionary of agents keyed by name

---

## 🧪 Running Tests

Install development dependencies:

```bash
pip install -r requirements-dev.txt
```

Run tests using `pytest`:

```bash
pytest
```

---

## 🗂 Project Structure

```
src/
  agns/
    __init__.py
    client.py
    agent.py
    agent_card.py
tests/
  test_integration.py
pyproject.toml
README.md
```

---

## 📜 License

MIT License. See [`LICENSE`](LICENSE) for details.

---

## 🤝 Contributing

Contributions are welcome! Please:

1. Fork this repository
2. Create a feature branch
3. Commit your changes
4. Open a pull request

---