# How the documentation is structured

```{include} ../README.md
:end-before: <!-- README only content
```

Documentation is split into [four categories](https://diataxis.fr), also accessible from links in the top bar.

- Tutorials - Tutorials for installation and typical usage. New users start here.
- How-To-s - Practical step-by-step guides for the more experienced user.
- Explanations - Explanations of how it works and why it works that way.
- Reference - Technical reference material including APIs and release notes.
<!-- https://sphinx-design.readthedocs.io/en/latest/grids.html -->

::::{grid} 2
:gutter: 4

:::{grid-item-card} {material-regular}`directions_walk;2em`

```{toctree}
:maxdepth: 2
tutorials
```

+++
Tutorials for installation and typical usage. New users start here.
:::

:::{grid-item-card} {material-regular}`directions;2em`

```{toctree}
:maxdepth: 2
how-to
```

+++
Practical step-by-step guides for the more experienced user.
:::

:::{grid-item-card} {material-regular}`info;2em`

```{toctree}
:maxdepth: 2
explanations
```

+++
Explanations of how it works and why it works that way.
:::

:::{grid-item-card} {material-regular}`menu_book;2em`

```{toctree}
:maxdepth: 2
reference
```

+++
Technical reference material including APIs and release notes.
:::

::::
