# coding: utf-8

# flake8: noqa

"""
    Blackman AI API

    A transparent AI API proxy that optimizes token usage to reduce costs.  ## Authentication  Blackman AI supports two authentication methods:  ### 1. API Key (Recommended for integrations)  Use the API key created from your dashboard:  ```bash curl -X POST https://ap.useblackman.ai/v1/completions \\   -H \"Authorization: Bearer sk_your_api_key_here\" \\   -H \"Content-Type: application/json\" \\   -d '{\"provider\": \"OpenAI\", \"model\": \"gpt-4\", \"messages\": [{\"role\": \"user\", \"content\": \"Hello!\"}]}' ```  ### 2. JWT Token (For web UI)  Obtain a JWT token by logging in:  ```bash curl -X POST https://ap.useblackman.ai/v1/auth/login \\   -H \"Content-Type: application/json\" \\   -d '{\"email\": \"user@example.com\", \"password\": \"yourpassword\"}' ```  Then use the token:  ```bash curl -X POST https://ap.useblackman.ai/v1/completions \\   -H \"Authorization: Bearer your_jwt_token\" \\   -H \"Content-Type: application/json\" \\   -d '{...}' ```  ### Provider API Keys (Optional)  You can optionally provide your own LLM provider API key via the `X-Provider-Api-Key` header, or store it in your account settings.  ## Client SDKs  Auto-generated SDKs are available for 10 languages:  - **TypeScript**: [View Docs](/v1/sdks/typescript) - **Python**: [View Docs](/v1/sdks/python) - **Go**: [View Docs](/v1/sdks/go) - **Java**: [View Docs](/v1/sdks/java) - **Ruby**: [View Docs](/v1/sdks/ruby) - **PHP**: [View Docs](/v1/sdks/php) - **C#**: [View Docs](/v1/sdks/csharp) - **Rust**: [View Docs](/v1/sdks/rust) - **Swift**: [View Docs](/v1/sdks/swift) - **Kotlin**: [View Docs](/v1/sdks/kotlin)  All SDKs are generated from this OpenAPI spec using [openapi-generator](https://openapi-generator.tech).  ## Quick Start  ```python # Python example with API key import blackman_client from blackman_client import CompletionRequest  configuration = blackman_client.Configuration(     host=\"http://localhost:8080\",     access_token=\"sk_your_api_key_here\"  # Your Blackman API key )  with blackman_client.ApiClient(configuration) as api_client:     api = blackman_client.CompletionsApi(api_client)     response = api.completions(         CompletionRequest(             provider=\"OpenAI\",             model=\"gpt-4o\",             messages=[{\"role\": \"user\", \"content\": \"Hello!\"}]         )     ) ```

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "0.0.5"

# Define package exports
__all__ = [
    "CompletionsApi",
    "FeedbackApi",
    "SemanticCacheApi",
    "ApiResponse",
    "ApiClient",
    "Configuration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "Choice",
    "CompletionOptions",
    "CompletionRequest",
    "CompletionResponse",
    "InvalidateResponse",
    "Message",
    "Provider",
    "SemanticCacheConfig",
    "SemanticCacheStats",
    "SubmitFeedbackRequest",
    "SubmitFeedbackResponse",
    "Usage",
]

# import apis into sdk package
from blackman_client.api.completions_api import CompletionsApi as CompletionsApi
from blackman_client.api.feedback_api import FeedbackApi as FeedbackApi
from blackman_client.api.semantic_cache_api import SemanticCacheApi as SemanticCacheApi

# import ApiClient
from blackman_client.api_response import ApiResponse as ApiResponse
from blackman_client.api_client import ApiClient as ApiClient
from blackman_client.configuration import Configuration as Configuration
from blackman_client.exceptions import OpenApiException as OpenApiException
from blackman_client.exceptions import ApiTypeError as ApiTypeError
from blackman_client.exceptions import ApiValueError as ApiValueError
from blackman_client.exceptions import ApiKeyError as ApiKeyError
from blackman_client.exceptions import ApiAttributeError as ApiAttributeError
from blackman_client.exceptions import ApiException as ApiException

# import models into sdk package
from blackman_client.models.choice import Choice as Choice
from blackman_client.models.completion_options import CompletionOptions as CompletionOptions
from blackman_client.models.completion_request import CompletionRequest as CompletionRequest
from blackman_client.models.completion_response import CompletionResponse as CompletionResponse
from blackman_client.models.invalidate_response import InvalidateResponse as InvalidateResponse
from blackman_client.models.message import Message as Message
from blackman_client.models.provider import Provider as Provider
from blackman_client.models.semantic_cache_config import SemanticCacheConfig as SemanticCacheConfig
from blackman_client.models.semantic_cache_stats import SemanticCacheStats as SemanticCacheStats
from blackman_client.models.submit_feedback_request import SubmitFeedbackRequest as SubmitFeedbackRequest
from blackman_client.models.submit_feedback_response import SubmitFeedbackResponse as SubmitFeedbackResponse
from blackman_client.models.usage import Usage as Usage
