# -*- coding: utf-8 -*-
from __future__ import unicode_literals


class GeneratedCheckResponse(object):
    """
    Represents a check response that has been generated by
    the session
    """

    def __init__(self, data=None):
        """
        :param data: the data to parse
        :type data: dict or None
        """
        if data is None:
            data = dict()

        self.__id = data.get("id", None)
        self.__type = data.get("type", None)

    @property
    def id(self):
        """
        The id of the generated check

        :return: the id
        :rtype: str or None
        """
        return self.__id

    @property
    def type(self):
        """
        Returns the type of the generated check

        :return: the type
        :rtype: str or None
        """
        return self.__type


class GeneratedTextDataCheckResponse(GeneratedCheckResponse):
    """
    Represents a generated Text Data check response
    """

    pass


class GeneratedSupplementaryDocumentTextDataCheckResponse(GeneratedCheckResponse):
    """
    Represents a generated Supplementary Document Text Data check response
    """

    pass
