# -*- coding: utf-8 -*-
from __future__ import unicode_literals


class GeneratedMedia(object):
    """
    Represents media that has been generated by the session
    """

    def __init__(self, data=None):
        """
        :param data: the data to parse
        :type data: dict or None
        """
        if data is None:
            data = dict()

        self.__id = data.get("id", None)
        self.__type = data.get("type", None)

    @property
    def id(self):
        """
        The ID of the generated media

        :return: the ID
        :rtype: str or None
        """
        return self.__id

    @property
    def type(self):
        """
        The type of the generated media, e.g. "JSON"

        :return: the type
        :rtype: str or None
        """
        return self.__type
