from typing import List

# dependencies for the generated Python class


# class definition for the ROS message
class CameraCaptureImageRequest:
    """
    ROS message: drone_srv_msgs/CameraCaptureImageRequest
    Generated by hakoniwa-ros2pdu.
    """

    drone_name: str
    image_type: str

    def __init__(self):
        self.drone_name = ""
        self.image_type = ""

    def __str__(self):
        return f"CameraCaptureImageRequest(" + ", ".join([
            f"drone_name={self.drone_name}"
            f"image_type={self.image_type}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'drone_name'
        field_val = self.drone_name
        if isinstance(field_val, bytearray):
            d['drone_name'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['drone_name'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['drone_name'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['drone_name'] = field_val
        # handle field 'image_type'
        field_val = self.image_type
        if isinstance(field_val, bytearray):
            d['image_type'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['image_type'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['image_type'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['image_type'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'drone_name'
        if 'drone_name' in d:
            field_type = cls.__annotations__.get('drone_name')
            value = d['drone_name']
            
            if field_type is bytearray:
                obj.drone_name = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.drone_name = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.drone_name = value
            elif hasattr(field_type, 'from_dict'):
                obj.drone_name = field_type.from_dict(value)
            else:
                obj.drone_name = value
        # handle field 'image_type'
        if 'image_type' in d:
            field_type = cls.__annotations__.get('image_type')
            value = d['image_type']
            
            if field_type is bytearray:
                obj.image_type = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.image_type = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.image_type = value
            elif hasattr(field_type, 'from_dict'):
                obj.image_type = field_type.from_dict(value)
            else:
                obj.image_type = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
