from typing import List

# dependencies for the generated Python class
from ..hako_msgs.pdu_pytype_HakoBatteryStatus import HakoBatteryStatus
from ..geometry_msgs.pdu_pytype_Point import Point
from ..geometry_msgs.pdu_pytype_Pose import Pose
from ..geometry_msgs.pdu_pytype_Quaternion import Quaternion


# class definition for the ROS message
class DroneGetStateResponse:
    """
    ROS message: drone_srv_msgs/DroneGetStateResponse
    Generated by hakoniwa-ros2pdu.
    """

    ok: bool
    is_ready: bool
    current_pose: Pose
    battery_status: HakoBatteryStatus
    mode: str
    message: str

    def __init__(self):
        self.ok = False
        self.is_ready = False
        self.current_pose = Pose()
        self.battery_status = HakoBatteryStatus()
        self.mode = ""
        self.message = ""

    def __str__(self):
        return f"DroneGetStateResponse(" + ", ".join([
            f"ok={self.ok}"
            f"is_ready={self.is_ready}"
            f"current_pose={self.current_pose}"
            f"battery_status={self.battery_status}"
            f"mode={self.mode}"
            f"message={self.message}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'ok'
        field_val = self.ok
        if isinstance(field_val, bytearray):
            d['ok'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['ok'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['ok'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['ok'] = field_val
        # handle field 'is_ready'
        field_val = self.is_ready
        if isinstance(field_val, bytearray):
            d['is_ready'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['is_ready'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['is_ready'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['is_ready'] = field_val
        # handle field 'current_pose'
        field_val = self.current_pose
        if isinstance(field_val, bytearray):
            d['current_pose'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['current_pose'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['current_pose'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['current_pose'] = field_val
        # handle field 'battery_status'
        field_val = self.battery_status
        if isinstance(field_val, bytearray):
            d['battery_status'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['battery_status'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['battery_status'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['battery_status'] = field_val
        # handle field 'mode'
        field_val = self.mode
        if isinstance(field_val, bytearray):
            d['mode'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['mode'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['mode'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['mode'] = field_val
        # handle field 'message'
        field_val = self.message
        if isinstance(field_val, bytearray):
            d['message'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['message'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['message'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['message'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'ok'
        if 'ok' in d:
            field_type = cls.__annotations__.get('ok')
            value = d['ok']
            
            if field_type is bytearray:
                obj.ok = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.ok = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.ok = value
            elif hasattr(field_type, 'from_dict'):
                obj.ok = field_type.from_dict(value)
            else:
                obj.ok = value
        # handle field 'is_ready'
        if 'is_ready' in d:
            field_type = cls.__annotations__.get('is_ready')
            value = d['is_ready']
            
            if field_type is bytearray:
                obj.is_ready = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.is_ready = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.is_ready = value
            elif hasattr(field_type, 'from_dict'):
                obj.is_ready = field_type.from_dict(value)
            else:
                obj.is_ready = value
        # handle field 'current_pose'
        if 'current_pose' in d:
            field_type = cls.__annotations__.get('current_pose')
            value = d['current_pose']
            
            if field_type is bytearray:
                obj.current_pose = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.current_pose = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.current_pose = value
            elif hasattr(field_type, 'from_dict'):
                obj.current_pose = field_type.from_dict(value)
            else:
                obj.current_pose = value
        # handle field 'battery_status'
        if 'battery_status' in d:
            field_type = cls.__annotations__.get('battery_status')
            value = d['battery_status']
            
            if field_type is bytearray:
                obj.battery_status = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.battery_status = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.battery_status = value
            elif hasattr(field_type, 'from_dict'):
                obj.battery_status = field_type.from_dict(value)
            else:
                obj.battery_status = value
        # handle field 'mode'
        if 'mode' in d:
            field_type = cls.__annotations__.get('mode')
            value = d['mode']
            
            if field_type is bytearray:
                obj.mode = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.mode = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.mode = value
            elif hasattr(field_type, 'from_dict'):
                obj.mode = field_type.from_dict(value)
            else:
                obj.mode = value
        # handle field 'message'
        if 'message' in d:
            field_type = cls.__annotations__.get('message')
            value = d['message']
            
            if field_type is bytearray:
                obj.message = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.message = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.message = value
            elif hasattr(field_type, 'from_dict'):
                obj.message = field_type.from_dict(value)
            else:
                obj.message = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
