from typing import List

# dependencies for the generated Python class
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class DroneGoToRequest:
    """
    ROS message: drone_srv_msgs/DroneGoToRequest
    Generated by hakoniwa-ros2pdu.
    """

    drone_name: str
    target_pose: Vector3
    speed_m_s: float
    yaw_deg: float
    tolerance_m: float
    timeout_sec: float

    def __init__(self):
        self.drone_name = ""
        self.target_pose = Vector3()
        self.speed_m_s = 0.0
        self.yaw_deg = 0.0
        self.tolerance_m = 0.0
        self.timeout_sec = 0.0

    def __str__(self):
        return f"DroneGoToRequest(" + ", ".join([
            f"drone_name={self.drone_name}"
            f"target_pose={self.target_pose}"
            f"speed_m_s={self.speed_m_s}"
            f"yaw_deg={self.yaw_deg}"
            f"tolerance_m={self.tolerance_m}"
            f"timeout_sec={self.timeout_sec}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'drone_name'
        field_val = self.drone_name
        if isinstance(field_val, bytearray):
            d['drone_name'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['drone_name'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['drone_name'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['drone_name'] = field_val
        # handle field 'target_pose'
        field_val = self.target_pose
        if isinstance(field_val, bytearray):
            d['target_pose'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['target_pose'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['target_pose'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['target_pose'] = field_val
        # handle field 'speed_m_s'
        field_val = self.speed_m_s
        if isinstance(field_val, bytearray):
            d['speed_m_s'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['speed_m_s'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['speed_m_s'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['speed_m_s'] = field_val
        # handle field 'yaw_deg'
        field_val = self.yaw_deg
        if isinstance(field_val, bytearray):
            d['yaw_deg'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['yaw_deg'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['yaw_deg'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['yaw_deg'] = field_val
        # handle field 'tolerance_m'
        field_val = self.tolerance_m
        if isinstance(field_val, bytearray):
            d['tolerance_m'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['tolerance_m'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['tolerance_m'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['tolerance_m'] = field_val
        # handle field 'timeout_sec'
        field_val = self.timeout_sec
        if isinstance(field_val, bytearray):
            d['timeout_sec'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['timeout_sec'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['timeout_sec'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['timeout_sec'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'drone_name'
        if 'drone_name' in d:
            field_type = cls.__annotations__.get('drone_name')
            value = d['drone_name']
            
            if field_type is bytearray:
                obj.drone_name = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.drone_name = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.drone_name = value
            elif hasattr(field_type, 'from_dict'):
                obj.drone_name = field_type.from_dict(value)
            else:
                obj.drone_name = value
        # handle field 'target_pose'
        if 'target_pose' in d:
            field_type = cls.__annotations__.get('target_pose')
            value = d['target_pose']
            
            if field_type is bytearray:
                obj.target_pose = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.target_pose = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.target_pose = value
            elif hasattr(field_type, 'from_dict'):
                obj.target_pose = field_type.from_dict(value)
            else:
                obj.target_pose = value
        # handle field 'speed_m_s'
        if 'speed_m_s' in d:
            field_type = cls.__annotations__.get('speed_m_s')
            value = d['speed_m_s']
            
            if field_type is bytearray:
                obj.speed_m_s = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.speed_m_s = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.speed_m_s = value
            elif hasattr(field_type, 'from_dict'):
                obj.speed_m_s = field_type.from_dict(value)
            else:
                obj.speed_m_s = value
        # handle field 'yaw_deg'
        if 'yaw_deg' in d:
            field_type = cls.__annotations__.get('yaw_deg')
            value = d['yaw_deg']
            
            if field_type is bytearray:
                obj.yaw_deg = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.yaw_deg = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.yaw_deg = value
            elif hasattr(field_type, 'from_dict'):
                obj.yaw_deg = field_type.from_dict(value)
            else:
                obj.yaw_deg = value
        # handle field 'tolerance_m'
        if 'tolerance_m' in d:
            field_type = cls.__annotations__.get('tolerance_m')
            value = d['tolerance_m']
            
            if field_type is bytearray:
                obj.tolerance_m = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.tolerance_m = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.tolerance_m = value
            elif hasattr(field_type, 'from_dict'):
                obj.tolerance_m = field_type.from_dict(value)
            else:
                obj.tolerance_m = value
        # handle field 'timeout_sec'
        if 'timeout_sec' in d:
            field_type = cls.__annotations__.get('timeout_sec')
            value = d['timeout_sec']
            
            if field_type is bytearray:
                obj.timeout_sec = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.timeout_sec = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.timeout_sec = value
            elif hasattr(field_type, 'from_dict'):
                obj.timeout_sec = field_type.from_dict(value)
            else:
                obj.timeout_sec = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
