from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_Header import Header
from ..geometry_msgs.pdu_pytype_Point import Point
from ..sensor_msgs.pdu_pytype_PointCloud2 import PointCloud2
from ..sensor_msgs.pdu_pytype_PointField import PointField
from ..geometry_msgs.pdu_pytype_Pose import Pose
from ..geometry_msgs.pdu_pytype_Quaternion import Quaternion
from ..builtin_interfaces.pdu_pytype_Time import Time


# class definition for the ROS message
class LiDARScanResponse:
    """
    ROS message: drone_srv_msgs/LiDARScanResponse
    Generated by hakoniwa-ros2pdu.
    """

    ok: bool
    point_cloud: PointCloud2
    lidar_pose: Pose
    message: str

    def __init__(self):
        self.ok = False
        self.point_cloud = PointCloud2()
        self.lidar_pose = Pose()
        self.message = ""

    def __str__(self):
        return f"LiDARScanResponse(" + ", ".join([
            f"ok={self.ok}"
            f"point_cloud={self.point_cloud}"
            f"lidar_pose={self.lidar_pose}"
            f"message={self.message}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'ok'
        field_val = self.ok
        if isinstance(field_val, bytearray):
            d['ok'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['ok'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['ok'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['ok'] = field_val
        # handle field 'point_cloud'
        field_val = self.point_cloud
        if isinstance(field_val, bytearray):
            d['point_cloud'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['point_cloud'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['point_cloud'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['point_cloud'] = field_val
        # handle field 'lidar_pose'
        field_val = self.lidar_pose
        if isinstance(field_val, bytearray):
            d['lidar_pose'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['lidar_pose'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['lidar_pose'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['lidar_pose'] = field_val
        # handle field 'message'
        field_val = self.message
        if isinstance(field_val, bytearray):
            d['message'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['message'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['message'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['message'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'ok'
        if 'ok' in d:
            field_type = cls.__annotations__.get('ok')
            value = d['ok']
            
            if field_type is bytearray:
                obj.ok = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.ok = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.ok = value
            elif hasattr(field_type, 'from_dict'):
                obj.ok = field_type.from_dict(value)
            else:
                obj.ok = value
        # handle field 'point_cloud'
        if 'point_cloud' in d:
            field_type = cls.__annotations__.get('point_cloud')
            value = d['point_cloud']
            
            if field_type is bytearray:
                obj.point_cloud = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.point_cloud = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.point_cloud = value
            elif hasattr(field_type, 'from_dict'):
                obj.point_cloud = field_type.from_dict(value)
            else:
                obj.point_cloud = value
        # handle field 'lidar_pose'
        if 'lidar_pose' in d:
            field_type = cls.__annotations__.get('lidar_pose')
            value = d['lidar_pose']
            
            if field_type is bytearray:
                obj.lidar_pose = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.lidar_pose = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.lidar_pose = value
            elif hasattr(field_type, 'from_dict'):
                obj.lidar_pose = field_type.from_dict(value)
            else:
                obj.lidar_pose = value
        # handle field 'message'
        if 'message' in d:
            field_type = cls.__annotations__.get('message')
            value = d['message']
            
            if field_type is bytearray:
                obj.message = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.message = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.message = value
            elif hasattr(field_type, 'from_dict'):
                obj.message = field_type.from_dict(value)
            else:
                obj.message = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
