from typing import List

# dependencies for the generated Python class
from ..geometry_msgs.pdu_pytype_Point import Point
from ..geometry_msgs.pdu_pytype_Pose import Pose
from ..geometry_msgs.pdu_pytype_Quaternion import Quaternion


# class definition for the ROS message
class PoseWithCovariance:
    """
    ROS message: geometry_msgs/PoseWithCovariance
    Generated by hakoniwa-ros2pdu.
    """

    pose: Pose
    covariance: List[float]

    def __init__(self):
        self.pose = Pose()
        self.covariance = []

    def __str__(self):
        return f"PoseWithCovariance(" + ", ".join([
            f"pose={self.pose}"
            f"covariance={self.covariance}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'pose'
        field_val = self.pose
        if isinstance(field_val, bytearray):
            d['pose'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['pose'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['pose'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['pose'] = field_val
        # handle field 'covariance'
        field_val = self.covariance
        if isinstance(field_val, bytearray):
            d['covariance'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['covariance'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['covariance'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['covariance'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'pose'
        if 'pose' in d:
            field_type = cls.__annotations__.get('pose')
            value = d['pose']
            
            if field_type is bytearray:
                obj.pose = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.pose = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.pose = value
            elif hasattr(field_type, 'from_dict'):
                obj.pose = field_type.from_dict(value)
            else:
                obj.pose = value
        # handle field 'covariance'
        if 'covariance' in d:
            field_type = cls.__annotations__.get('covariance')
            value = d['covariance']
            
            if field_type is bytearray:
                obj.covariance = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.covariance = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.covariance = value
            elif hasattr(field_type, 'from_dict'):
                obj.covariance = field_type.from_dict(value)
            else:
                obj.covariance = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
