from typing import List

# dependencies for the generated Python class
from ..geometry_msgs.pdu_pytype_Twist import Twist
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class TwistWithCovariance:
    """
    ROS message: geometry_msgs/TwistWithCovariance
    Generated by hakoniwa-ros2pdu.
    """

    twist: Twist
    covariance: List[float]

    def __init__(self):
        self.twist = Twist()
        self.covariance = []

    def __str__(self):
        return f"TwistWithCovariance(" + ", ".join([
            f"twist={self.twist}"
            f"covariance={self.covariance}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'twist'
        field_val = self.twist
        if isinstance(field_val, bytearray):
            d['twist'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['twist'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['twist'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['twist'] = field_val
        # handle field 'covariance'
        field_val = self.covariance
        if isinstance(field_val, bytearray):
            d['covariance'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['covariance'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['covariance'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['covariance'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'twist'
        if 'twist' in d:
            field_type = cls.__annotations__.get('twist')
            value = d['twist']
            
            if field_type is bytearray:
                obj.twist = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.twist = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.twist = value
            elif hasattr(field_type, 'from_dict'):
                obj.twist = field_type.from_dict(value)
            else:
                obj.twist = value
        # handle field 'covariance'
        if 'covariance' in d:
            field_type = cls.__annotations__.get('covariance')
            value = d['covariance']
            
            if field_type is bytearray:
                obj.covariance = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.covariance = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.covariance = value
            elif hasattr(field_type, 'from_dict'):
                obj.covariance = field_type.from_dict(value)
            else:
                obj.covariance = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
