from typing import List

# dependencies for the generated Python class


# class definition for the ROS message
class HakoHilStateQuaternion:
    """
    ROS message: hako_mavlink_msgs/HakoHilStateQuaternion
    Generated by hakoniwa-ros2pdu.
    """

    time_usec: int
    attitude_quaternion: List[float]
    rollspeed: float
    pitchspeed: float
    yawspeed: float
    lat: int
    lon: int
    alt: int
    vx: int
    vy: int
    vz: int
    ind_airspeed: int
    true_airspeed: int
    xacc: int
    yacc: int
    zacc: int

    def __init__(self):
        self.time_usec = 0
        self.attitude_quaternion = []
        self.rollspeed = 0.0
        self.pitchspeed = 0.0
        self.yawspeed = 0.0
        self.lat = 0
        self.lon = 0
        self.alt = 0
        self.vx = 0
        self.vy = 0
        self.vz = 0
        self.ind_airspeed = 0
        self.true_airspeed = 0
        self.xacc = 0
        self.yacc = 0
        self.zacc = 0

    def __str__(self):
        return f"HakoHilStateQuaternion(" + ", ".join([
            f"time_usec={self.time_usec}"
            f"attitude_quaternion={self.attitude_quaternion}"
            f"rollspeed={self.rollspeed}"
            f"pitchspeed={self.pitchspeed}"
            f"yawspeed={self.yawspeed}"
            f"lat={self.lat}"
            f"lon={self.lon}"
            f"alt={self.alt}"
            f"vx={self.vx}"
            f"vy={self.vy}"
            f"vz={self.vz}"
            f"ind_airspeed={self.ind_airspeed}"
            f"true_airspeed={self.true_airspeed}"
            f"xacc={self.xacc}"
            f"yacc={self.yacc}"
            f"zacc={self.zacc}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'time_usec'
        field_val = self.time_usec
        if isinstance(field_val, bytearray):
            d['time_usec'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['time_usec'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['time_usec'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['time_usec'] = field_val
        # handle field 'attitude_quaternion'
        field_val = self.attitude_quaternion
        if isinstance(field_val, bytearray):
            d['attitude_quaternion'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['attitude_quaternion'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['attitude_quaternion'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['attitude_quaternion'] = field_val
        # handle field 'rollspeed'
        field_val = self.rollspeed
        if isinstance(field_val, bytearray):
            d['rollspeed'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['rollspeed'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['rollspeed'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['rollspeed'] = field_val
        # handle field 'pitchspeed'
        field_val = self.pitchspeed
        if isinstance(field_val, bytearray):
            d['pitchspeed'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['pitchspeed'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['pitchspeed'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['pitchspeed'] = field_val
        # handle field 'yawspeed'
        field_val = self.yawspeed
        if isinstance(field_val, bytearray):
            d['yawspeed'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['yawspeed'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['yawspeed'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['yawspeed'] = field_val
        # handle field 'lat'
        field_val = self.lat
        if isinstance(field_val, bytearray):
            d['lat'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['lat'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['lat'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['lat'] = field_val
        # handle field 'lon'
        field_val = self.lon
        if isinstance(field_val, bytearray):
            d['lon'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['lon'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['lon'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['lon'] = field_val
        # handle field 'alt'
        field_val = self.alt
        if isinstance(field_val, bytearray):
            d['alt'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['alt'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['alt'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['alt'] = field_val
        # handle field 'vx'
        field_val = self.vx
        if isinstance(field_val, bytearray):
            d['vx'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['vx'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['vx'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['vx'] = field_val
        # handle field 'vy'
        field_val = self.vy
        if isinstance(field_val, bytearray):
            d['vy'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['vy'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['vy'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['vy'] = field_val
        # handle field 'vz'
        field_val = self.vz
        if isinstance(field_val, bytearray):
            d['vz'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['vz'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['vz'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['vz'] = field_val
        # handle field 'ind_airspeed'
        field_val = self.ind_airspeed
        if isinstance(field_val, bytearray):
            d['ind_airspeed'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['ind_airspeed'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['ind_airspeed'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['ind_airspeed'] = field_val
        # handle field 'true_airspeed'
        field_val = self.true_airspeed
        if isinstance(field_val, bytearray):
            d['true_airspeed'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['true_airspeed'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['true_airspeed'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['true_airspeed'] = field_val
        # handle field 'xacc'
        field_val = self.xacc
        if isinstance(field_val, bytearray):
            d['xacc'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['xacc'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['xacc'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['xacc'] = field_val
        # handle field 'yacc'
        field_val = self.yacc
        if isinstance(field_val, bytearray):
            d['yacc'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['yacc'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['yacc'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['yacc'] = field_val
        # handle field 'zacc'
        field_val = self.zacc
        if isinstance(field_val, bytearray):
            d['zacc'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['zacc'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['zacc'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['zacc'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'time_usec'
        if 'time_usec' in d:
            field_type = cls.__annotations__.get('time_usec')
            value = d['time_usec']
            
            if field_type is bytearray:
                obj.time_usec = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.time_usec = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.time_usec = value
            elif hasattr(field_type, 'from_dict'):
                obj.time_usec = field_type.from_dict(value)
            else:
                obj.time_usec = value
        # handle field 'attitude_quaternion'
        if 'attitude_quaternion' in d:
            field_type = cls.__annotations__.get('attitude_quaternion')
            value = d['attitude_quaternion']
            
            if field_type is bytearray:
                obj.attitude_quaternion = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.attitude_quaternion = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.attitude_quaternion = value
            elif hasattr(field_type, 'from_dict'):
                obj.attitude_quaternion = field_type.from_dict(value)
            else:
                obj.attitude_quaternion = value
        # handle field 'rollspeed'
        if 'rollspeed' in d:
            field_type = cls.__annotations__.get('rollspeed')
            value = d['rollspeed']
            
            if field_type is bytearray:
                obj.rollspeed = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.rollspeed = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.rollspeed = value
            elif hasattr(field_type, 'from_dict'):
                obj.rollspeed = field_type.from_dict(value)
            else:
                obj.rollspeed = value
        # handle field 'pitchspeed'
        if 'pitchspeed' in d:
            field_type = cls.__annotations__.get('pitchspeed')
            value = d['pitchspeed']
            
            if field_type is bytearray:
                obj.pitchspeed = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.pitchspeed = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.pitchspeed = value
            elif hasattr(field_type, 'from_dict'):
                obj.pitchspeed = field_type.from_dict(value)
            else:
                obj.pitchspeed = value
        # handle field 'yawspeed'
        if 'yawspeed' in d:
            field_type = cls.__annotations__.get('yawspeed')
            value = d['yawspeed']
            
            if field_type is bytearray:
                obj.yawspeed = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.yawspeed = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.yawspeed = value
            elif hasattr(field_type, 'from_dict'):
                obj.yawspeed = field_type.from_dict(value)
            else:
                obj.yawspeed = value
        # handle field 'lat'
        if 'lat' in d:
            field_type = cls.__annotations__.get('lat')
            value = d['lat']
            
            if field_type is bytearray:
                obj.lat = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.lat = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.lat = value
            elif hasattr(field_type, 'from_dict'):
                obj.lat = field_type.from_dict(value)
            else:
                obj.lat = value
        # handle field 'lon'
        if 'lon' in d:
            field_type = cls.__annotations__.get('lon')
            value = d['lon']
            
            if field_type is bytearray:
                obj.lon = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.lon = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.lon = value
            elif hasattr(field_type, 'from_dict'):
                obj.lon = field_type.from_dict(value)
            else:
                obj.lon = value
        # handle field 'alt'
        if 'alt' in d:
            field_type = cls.__annotations__.get('alt')
            value = d['alt']
            
            if field_type is bytearray:
                obj.alt = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.alt = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.alt = value
            elif hasattr(field_type, 'from_dict'):
                obj.alt = field_type.from_dict(value)
            else:
                obj.alt = value
        # handle field 'vx'
        if 'vx' in d:
            field_type = cls.__annotations__.get('vx')
            value = d['vx']
            
            if field_type is bytearray:
                obj.vx = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.vx = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.vx = value
            elif hasattr(field_type, 'from_dict'):
                obj.vx = field_type.from_dict(value)
            else:
                obj.vx = value
        # handle field 'vy'
        if 'vy' in d:
            field_type = cls.__annotations__.get('vy')
            value = d['vy']
            
            if field_type is bytearray:
                obj.vy = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.vy = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.vy = value
            elif hasattr(field_type, 'from_dict'):
                obj.vy = field_type.from_dict(value)
            else:
                obj.vy = value
        # handle field 'vz'
        if 'vz' in d:
            field_type = cls.__annotations__.get('vz')
            value = d['vz']
            
            if field_type is bytearray:
                obj.vz = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.vz = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.vz = value
            elif hasattr(field_type, 'from_dict'):
                obj.vz = field_type.from_dict(value)
            else:
                obj.vz = value
        # handle field 'ind_airspeed'
        if 'ind_airspeed' in d:
            field_type = cls.__annotations__.get('ind_airspeed')
            value = d['ind_airspeed']
            
            if field_type is bytearray:
                obj.ind_airspeed = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.ind_airspeed = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.ind_airspeed = value
            elif hasattr(field_type, 'from_dict'):
                obj.ind_airspeed = field_type.from_dict(value)
            else:
                obj.ind_airspeed = value
        # handle field 'true_airspeed'
        if 'true_airspeed' in d:
            field_type = cls.__annotations__.get('true_airspeed')
            value = d['true_airspeed']
            
            if field_type is bytearray:
                obj.true_airspeed = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.true_airspeed = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.true_airspeed = value
            elif hasattr(field_type, 'from_dict'):
                obj.true_airspeed = field_type.from_dict(value)
            else:
                obj.true_airspeed = value
        # handle field 'xacc'
        if 'xacc' in d:
            field_type = cls.__annotations__.get('xacc')
            value = d['xacc']
            
            if field_type is bytearray:
                obj.xacc = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.xacc = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.xacc = value
            elif hasattr(field_type, 'from_dict'):
                obj.xacc = field_type.from_dict(value)
            else:
                obj.xacc = value
        # handle field 'yacc'
        if 'yacc' in d:
            field_type = cls.__annotations__.get('yacc')
            value = d['yacc']
            
            if field_type is bytearray:
                obj.yacc = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.yacc = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.yacc = value
            elif hasattr(field_type, 'from_dict'):
                obj.yacc = field_type.from_dict(value)
            else:
                obj.yacc = value
        # handle field 'zacc'
        if 'zacc' in d:
            field_type = cls.__annotations__.get('zacc')
            value = d['zacc']
            
            if field_type is bytearray:
                obj.zacc = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.zacc = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.zacc = value
            elif hasattr(field_type, 'from_dict'):
                obj.zacc = field_type.from_dict(value)
            else:
                obj.zacc = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
