from typing import List

# dependencies for the generated Python class
from ..geometry_msgs.pdu_pytype_Point import Point
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class ImpulseCollision:
    """
    ROS message: hako_msgs/ImpulseCollision
    Generated by hakoniwa-ros2pdu.
    """

    collision: bool
    is_target_static: bool
    restitution_coefficient: float
    self_contact_vector: Point
    normal: Vector3
    target_contact_vector: Point
    target_velocity: Vector3
    target_angular_velocity: Vector3
    target_euler: Vector3
    target_inertia: Vector3
    target_mass: float

    def __init__(self):
        self.collision = False
        self.is_target_static = False
        self.restitution_coefficient = 0.0
        self.self_contact_vector = Point()
        self.normal = Vector3()
        self.target_contact_vector = Point()
        self.target_velocity = Vector3()
        self.target_angular_velocity = Vector3()
        self.target_euler = Vector3()
        self.target_inertia = Vector3()
        self.target_mass = 0.0

    def __str__(self):
        return f"ImpulseCollision(" + ", ".join([
            f"collision={self.collision}"
            f"is_target_static={self.is_target_static}"
            f"restitution_coefficient={self.restitution_coefficient}"
            f"self_contact_vector={self.self_contact_vector}"
            f"normal={self.normal}"
            f"target_contact_vector={self.target_contact_vector}"
            f"target_velocity={self.target_velocity}"
            f"target_angular_velocity={self.target_angular_velocity}"
            f"target_euler={self.target_euler}"
            f"target_inertia={self.target_inertia}"
            f"target_mass={self.target_mass}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'collision'
        field_val = self.collision
        if isinstance(field_val, bytearray):
            d['collision'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['collision'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['collision'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['collision'] = field_val
        # handle field 'is_target_static'
        field_val = self.is_target_static
        if isinstance(field_val, bytearray):
            d['is_target_static'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['is_target_static'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['is_target_static'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['is_target_static'] = field_val
        # handle field 'restitution_coefficient'
        field_val = self.restitution_coefficient
        if isinstance(field_val, bytearray):
            d['restitution_coefficient'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['restitution_coefficient'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['restitution_coefficient'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['restitution_coefficient'] = field_val
        # handle field 'self_contact_vector'
        field_val = self.self_contact_vector
        if isinstance(field_val, bytearray):
            d['self_contact_vector'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['self_contact_vector'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['self_contact_vector'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['self_contact_vector'] = field_val
        # handle field 'normal'
        field_val = self.normal
        if isinstance(field_val, bytearray):
            d['normal'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['normal'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['normal'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['normal'] = field_val
        # handle field 'target_contact_vector'
        field_val = self.target_contact_vector
        if isinstance(field_val, bytearray):
            d['target_contact_vector'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['target_contact_vector'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['target_contact_vector'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['target_contact_vector'] = field_val
        # handle field 'target_velocity'
        field_val = self.target_velocity
        if isinstance(field_val, bytearray):
            d['target_velocity'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['target_velocity'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['target_velocity'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['target_velocity'] = field_val
        # handle field 'target_angular_velocity'
        field_val = self.target_angular_velocity
        if isinstance(field_val, bytearray):
            d['target_angular_velocity'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['target_angular_velocity'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['target_angular_velocity'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['target_angular_velocity'] = field_val
        # handle field 'target_euler'
        field_val = self.target_euler
        if isinstance(field_val, bytearray):
            d['target_euler'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['target_euler'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['target_euler'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['target_euler'] = field_val
        # handle field 'target_inertia'
        field_val = self.target_inertia
        if isinstance(field_val, bytearray):
            d['target_inertia'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['target_inertia'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['target_inertia'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['target_inertia'] = field_val
        # handle field 'target_mass'
        field_val = self.target_mass
        if isinstance(field_val, bytearray):
            d['target_mass'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['target_mass'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['target_mass'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['target_mass'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'collision'
        if 'collision' in d:
            field_type = cls.__annotations__.get('collision')
            value = d['collision']
            
            if field_type is bytearray:
                obj.collision = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.collision = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.collision = value
            elif hasattr(field_type, 'from_dict'):
                obj.collision = field_type.from_dict(value)
            else:
                obj.collision = value
        # handle field 'is_target_static'
        if 'is_target_static' in d:
            field_type = cls.__annotations__.get('is_target_static')
            value = d['is_target_static']
            
            if field_type is bytearray:
                obj.is_target_static = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.is_target_static = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.is_target_static = value
            elif hasattr(field_type, 'from_dict'):
                obj.is_target_static = field_type.from_dict(value)
            else:
                obj.is_target_static = value
        # handle field 'restitution_coefficient'
        if 'restitution_coefficient' in d:
            field_type = cls.__annotations__.get('restitution_coefficient')
            value = d['restitution_coefficient']
            
            if field_type is bytearray:
                obj.restitution_coefficient = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.restitution_coefficient = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.restitution_coefficient = value
            elif hasattr(field_type, 'from_dict'):
                obj.restitution_coefficient = field_type.from_dict(value)
            else:
                obj.restitution_coefficient = value
        # handle field 'self_contact_vector'
        if 'self_contact_vector' in d:
            field_type = cls.__annotations__.get('self_contact_vector')
            value = d['self_contact_vector']
            
            if field_type is bytearray:
                obj.self_contact_vector = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.self_contact_vector = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.self_contact_vector = value
            elif hasattr(field_type, 'from_dict'):
                obj.self_contact_vector = field_type.from_dict(value)
            else:
                obj.self_contact_vector = value
        # handle field 'normal'
        if 'normal' in d:
            field_type = cls.__annotations__.get('normal')
            value = d['normal']
            
            if field_type is bytearray:
                obj.normal = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.normal = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.normal = value
            elif hasattr(field_type, 'from_dict'):
                obj.normal = field_type.from_dict(value)
            else:
                obj.normal = value
        # handle field 'target_contact_vector'
        if 'target_contact_vector' in d:
            field_type = cls.__annotations__.get('target_contact_vector')
            value = d['target_contact_vector']
            
            if field_type is bytearray:
                obj.target_contact_vector = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.target_contact_vector = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.target_contact_vector = value
            elif hasattr(field_type, 'from_dict'):
                obj.target_contact_vector = field_type.from_dict(value)
            else:
                obj.target_contact_vector = value
        # handle field 'target_velocity'
        if 'target_velocity' in d:
            field_type = cls.__annotations__.get('target_velocity')
            value = d['target_velocity']
            
            if field_type is bytearray:
                obj.target_velocity = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.target_velocity = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.target_velocity = value
            elif hasattr(field_type, 'from_dict'):
                obj.target_velocity = field_type.from_dict(value)
            else:
                obj.target_velocity = value
        # handle field 'target_angular_velocity'
        if 'target_angular_velocity' in d:
            field_type = cls.__annotations__.get('target_angular_velocity')
            value = d['target_angular_velocity']
            
            if field_type is bytearray:
                obj.target_angular_velocity = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.target_angular_velocity = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.target_angular_velocity = value
            elif hasattr(field_type, 'from_dict'):
                obj.target_angular_velocity = field_type.from_dict(value)
            else:
                obj.target_angular_velocity = value
        # handle field 'target_euler'
        if 'target_euler' in d:
            field_type = cls.__annotations__.get('target_euler')
            value = d['target_euler']
            
            if field_type is bytearray:
                obj.target_euler = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.target_euler = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.target_euler = value
            elif hasattr(field_type, 'from_dict'):
                obj.target_euler = field_type.from_dict(value)
            else:
                obj.target_euler = value
        # handle field 'target_inertia'
        if 'target_inertia' in d:
            field_type = cls.__annotations__.get('target_inertia')
            value = d['target_inertia']
            
            if field_type is bytearray:
                obj.target_inertia = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.target_inertia = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.target_inertia = value
            elif hasattr(field_type, 'from_dict'):
                obj.target_inertia = field_type.from_dict(value)
            else:
                obj.target_inertia = value
        # handle field 'target_mass'
        if 'target_mass' in d:
            field_type = cls.__annotations__.get('target_mass')
            value = d['target_mass']
            
            if field_type is bytearray:
                obj.target_mass = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.target_mass = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.target_mass = value
            elif hasattr(field_type, 'from_dict'):
                obj.target_mass = field_type.from_dict(value)
            else:
                obj.target_mass = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
