from typing import List

# dependencies for the generated Python class


# class definition for the ROS message
class ServiceRequestHeader:
    """
    ROS message: hako_srv_msgs/ServiceRequestHeader
    Generated by hakoniwa-ros2pdu.
    """

    request_id: int
    service_name: str
    client_name: str
    opcode: int
    status_poll_interval_msec: int

    def __init__(self):
        self.request_id = 0
        self.service_name = ""
        self.client_name = ""
        self.opcode = 0
        self.status_poll_interval_msec = 0

    def __str__(self):
        return f"ServiceRequestHeader(" + ", ".join([
            f"request_id={self.request_id}"
            f"service_name={self.service_name}"
            f"client_name={self.client_name}"
            f"opcode={self.opcode}"
            f"status_poll_interval_msec={self.status_poll_interval_msec}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'request_id'
        field_val = self.request_id
        if isinstance(field_val, bytearray):
            d['request_id'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['request_id'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['request_id'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['request_id'] = field_val
        # handle field 'service_name'
        field_val = self.service_name
        if isinstance(field_val, bytearray):
            d['service_name'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['service_name'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['service_name'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['service_name'] = field_val
        # handle field 'client_name'
        field_val = self.client_name
        if isinstance(field_val, bytearray):
            d['client_name'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['client_name'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['client_name'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['client_name'] = field_val
        # handle field 'opcode'
        field_val = self.opcode
        if isinstance(field_val, bytearray):
            d['opcode'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['opcode'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['opcode'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['opcode'] = field_val
        # handle field 'status_poll_interval_msec'
        field_val = self.status_poll_interval_msec
        if isinstance(field_val, bytearray):
            d['status_poll_interval_msec'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['status_poll_interval_msec'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['status_poll_interval_msec'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['status_poll_interval_msec'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'request_id'
        if 'request_id' in d:
            field_type = cls.__annotations__.get('request_id')
            value = d['request_id']
            
            if field_type is bytearray:
                obj.request_id = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.request_id = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.request_id = value
            elif hasattr(field_type, 'from_dict'):
                obj.request_id = field_type.from_dict(value)
            else:
                obj.request_id = value
        # handle field 'service_name'
        if 'service_name' in d:
            field_type = cls.__annotations__.get('service_name')
            value = d['service_name']
            
            if field_type is bytearray:
                obj.service_name = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.service_name = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.service_name = value
            elif hasattr(field_type, 'from_dict'):
                obj.service_name = field_type.from_dict(value)
            else:
                obj.service_name = value
        # handle field 'client_name'
        if 'client_name' in d:
            field_type = cls.__annotations__.get('client_name')
            value = d['client_name']
            
            if field_type is bytearray:
                obj.client_name = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.client_name = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.client_name = value
            elif hasattr(field_type, 'from_dict'):
                obj.client_name = field_type.from_dict(value)
            else:
                obj.client_name = value
        # handle field 'opcode'
        if 'opcode' in d:
            field_type = cls.__annotations__.get('opcode')
            value = d['opcode']
            
            if field_type is bytearray:
                obj.opcode = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.opcode = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.opcode = value
            elif hasattr(field_type, 'from_dict'):
                obj.opcode = field_type.from_dict(value)
            else:
                obj.opcode = value
        # handle field 'status_poll_interval_msec'
        if 'status_poll_interval_msec' in d:
            field_type = cls.__annotations__.get('status_poll_interval_msec')
            value = d['status_poll_interval_msec']
            
            if field_type is bytearray:
                obj.status_poll_interval_msec = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.status_poll_interval_msec = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.status_poll_interval_msec = value
            elif hasattr(field_type, 'from_dict'):
                obj.status_poll_interval_msec = field_type.from_dict(value)
            else:
                obj.status_poll_interval_msec = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
